/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.util;

import com.sun.tools.internal.ws.processor.model.AbstractType;
import com.sun.tools.internal.ws.processor.model.Block;
import com.sun.tools.internal.ws.processor.model.ExtendedModelVisitor;
import com.sun.tools.internal.ws.processor.model.Fault;
import com.sun.tools.internal.ws.processor.model.Model;
import com.sun.tools.internal.ws.processor.model.Parameter;
import com.sun.tools.internal.ws.processor.model.Port;
import com.sun.tools.internal.ws.processor.model.Service;
import com.sun.tools.internal.ws.processor.model.jaxb.JAXBType;
import com.sun.tools.internal.ws.processor.model.jaxb.JAXBTypeVisitor;
import com.sun.tools.internal.ws.processor.model.jaxb.RpcLitStructure;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassNameCollector
extends ExtendedModelVisitor
implements JAXBTypeVisitor {
    private Set<String> _seiClassNames;
    private Set<String> _jaxbGeneratedClassNames;
    private Set<String> _exceptionClassNames;
    boolean doneVisitingJAXBModel = false;
    private Set _allClassNames;
    private Set _exceptions;
    private Set _wsdlBindingNames;
    private Set _conflictingClassNames;
    private Set<QName> _portTypeNames;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Model model) {
        try {
            this._allClassNames = new HashSet();
            this._exceptions = new HashSet();
            this._wsdlBindingNames = new HashSet();
            this._conflictingClassNames = new HashSet();
            this._seiClassNames = new HashSet<String>();
            this._jaxbGeneratedClassNames = new HashSet<String>();
            this._exceptionClassNames = new HashSet<String>();
            this._portTypeNames = new HashSet<QName>();
            this.visit(model);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this._allClassNames = null;
            this._exceptions = null;
        }
    }

    public Set getConflictingClassNames() {
        return this._conflictingClassNames;
    }

    @Override
    protected void postVisit(Model model) throws Exception {
        Iterator iterator = model.getExtraTypes();
        while (iterator.hasNext()) {
            this.visitType((AbstractType)iterator.next());
        }
    }

    @Override
    protected void preVisit(Service service) throws Exception {
        this.registerClassName(service.getJavaInterface().getName());
        this.registerClassName(service.getJavaInterface().getImpl());
    }

    protected void processPort11x(Port port) {
        QName qName = (QName)port.getProperty("com.sun.xml.internal.ws.processor.model.WSDLBindingName");
        if (!this._wsdlBindingNames.contains(qName)) {
            this.registerClassName(port.getJavaInterface().getName());
        }
        this.registerClassName((String)port.getProperty("com.sun.xml.internal.ws.processor.model.StubClassName"));
        this.registerClassName((String)port.getProperty("com.sun.xml.internal.ws.processor.model.TieClassName"));
    }

    @Override
    protected void preVisit(Port port) throws Exception {
        QName qName = (QName)port.getProperty("com.sun.xml.internal.ws.processor.model.WSDLPortTypeName");
        if (this._portTypeNames.contains(qName)) {
            return;
        }
        this.addSEIClassName(port.getJavaInterface().getName());
    }

    private void addSEIClassName(String string) {
        this._seiClassNames.add(string);
        this.registerClassName(string);
    }

    @Override
    protected void postVisit(Port port) throws Exception {
        QName qName;
        QName qName2 = (QName)port.getProperty("com.sun.xml.internal.ws.processor.model.WSDLBindingName");
        if (!this._wsdlBindingNames.contains(qName2)) {
            this._wsdlBindingNames.add(qName2);
        }
        if (!this._portTypeNames.contains(qName = (QName)port.getProperty("com.sun.xml.internal.ws.processor.model.WSDLPortTypeName"))) {
            this._portTypeNames.add(qName);
        }
    }

    @Override
    protected boolean shouldVisit(Port port) {
        QName qName = (QName)port.getProperty("com.sun.xml.internal.ws.processor.model.WSDLBindingName");
        return !this._wsdlBindingNames.contains(qName);
    }

    @Override
    protected void preVisit(Fault fault) throws Exception {
        if (!this._exceptions.contains(fault.getJavaException())) {
            this._exceptions.add(fault.getJavaException());
            this.addExceptionClassName(fault.getJavaException().getName());
            if (fault.getParentFault() != null) {
                this.preVisit(fault.getParentFault());
            }
            Iterator iterator = fault.getSubfaults();
            while (iterator != null && iterator.hasNext()) {
                Fault fault2 = (Fault)iterator.next();
                this.preVisit(fault2);
            }
        }
    }

    private void addExceptionClassName(String string) {
        if (this._allClassNames.contains(string)) {
            this._exceptionClassNames.add(string);
        }
        this.registerClassName(string);
    }

    @Override
    protected void visitBodyBlock(Block block) throws Exception {
        this.visitBlock(block);
    }

    @Override
    protected void visitHeaderBlock(Block block) throws Exception {
        this.visitBlock(block);
    }

    @Override
    protected void visitFaultBlock(Block block) throws Exception {
    }

    protected void visitBlock(Block block) throws Exception {
        this.visitType(block.getType());
    }

    @Override
    protected void visit(Parameter parameter) throws Exception {
        this.visitType(parameter.getType());
    }

    private void visitType(AbstractType abstractType) throws Exception {
        if (abstractType != null) {
            if (abstractType instanceof JAXBType) {
                this.visitType((JAXBType)abstractType);
            } else if (abstractType instanceof RpcLitStructure) {
                this.visitType((RpcLitStructure)abstractType);
            }
        }
    }

    private void visitType(JAXBType jAXBType) throws Exception {
        jAXBType.accept(this);
    }

    private void visitType(RpcLitStructure rpcLitStructure) throws Exception {
        rpcLitStructure.accept(this);
    }

    private void registerClassName(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        if (this._allClassNames.contains(string)) {
            this._conflictingClassNames.add(string);
        } else {
            this._allClassNames.add(string);
        }
    }

    public Set<String> getSeiClassNames() {
        return this._seiClassNames;
    }

    public Set<String> getJaxbGeneratedClassNames() {
        return this._jaxbGeneratedClassNames;
    }

    public Set<String> getExceptionClassNames() {
        return this._exceptionClassNames;
    }

    @Override
    public void visit(JAXBType jAXBType) throws Exception {
        if (!this.doneVisitingJAXBModel) {
            Set<String> set = jAXBType.getJaxbModel().getGeneratedClassNames();
            for (String string : set) {
                this.addJAXBGeneratedClassName(string);
            }
            this.doneVisitingJAXBModel = true;
        }
    }

    @Override
    public void visit(RpcLitStructure rpcLitStructure) throws Exception {
        if (!this.doneVisitingJAXBModel) {
            Set<String> set = rpcLitStructure.getJaxbModel().getGeneratedClassNames();
            for (String string : set) {
                this.addJAXBGeneratedClassName(string);
            }
            this.doneVisitingJAXBModel = true;
        }
    }

    private void addJAXBGeneratedClassName(String string) {
        this._jaxbGeneratedClassNames.add(string);
        this.registerClassName(string);
    }
}

