/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.server;

import com.sun.tools.hat.internal.model.JavaClass;
import com.sun.tools.hat.internal.model.JavaField;
import com.sun.tools.hat.internal.model.JavaHeapObject;
import com.sun.tools.hat.internal.model.JavaStatic;
import com.sun.tools.hat.internal.server.QueryHandler;
import com.sun.tools.hat.internal.util.ArraySorter;
import com.sun.tools.hat.internal.util.Comparer;
import java.util.Enumeration;

class ClassQuery
extends QueryHandler {
    public void run() {
        this.startHtml("Class " + this.query);
        JavaClass javaClass = this.snapshot.findClass(this.query);
        if (javaClass == null) {
            this.error("class not found: " + this.query);
        } else {
            this.printFullClass(javaClass);
        }
        this.endHtml();
    }

    protected void printFullClass(JavaClass javaClass) {
        this.out.print("<h1>");
        this.print(javaClass.toString());
        this.out.println("</h1>");
        this.out.println("<h2>Superclass:</h2>");
        this.printClass(javaClass.getSuperclass());
        this.out.println("<h2>Loader Details</h2>");
        this.out.println("<h3>ClassLoader:</h3>");
        this.printThing(javaClass.getLoader());
        this.out.println("<h3>Signers:</h3>");
        this.printThing(javaClass.getSigners());
        this.out.println("<h3>Protection Domain:</h3>");
        this.printThing(javaClass.getProtectionDomain());
        this.out.println("<h2>Subclasses:</h2>");
        JavaClass[] javaClassArray = javaClass.getSubclasses();
        for (int i = 0; i < javaClassArray.length; ++i) {
            this.out.print("    ");
            this.printClass(javaClassArray[i]);
            this.out.println("<br>");
        }
        this.out.println("<h2>Instance Data Members:</h2>");
        Object[] objectArray = javaClass.getFields();
        objectArray = (JavaField[])objectArray.clone();
        ArraySorter.sort(objectArray, new Comparer(){

            public int compare(Object object, Object object2) {
                JavaField javaField = (JavaField)object;
                JavaField javaField2 = (JavaField)object2;
                return javaField.getName().compareTo(javaField2.getName());
            }
        });
        for (int i = 0; i < objectArray.length; ++i) {
            this.out.print("    ");
            this.printField((JavaField)objectArray[i]);
            this.out.println("<br>");
        }
        this.out.println("<h2>Static Data Members:</h2>");
        JavaStatic[] javaStaticArray = javaClass.getStatics();
        for (int i = 0; i < javaStaticArray.length; ++i) {
            this.printStatic(javaStaticArray[i]);
            this.out.println("<br>");
        }
        this.out.println("<h2>Instances</h2>");
        this.printAnchorStart();
        this.out.print("instances/" + this.encodeForURL(javaClass));
        this.out.print("\">");
        this.out.println("Exclude subclasses</a><br>");
        this.printAnchorStart();
        this.out.print("allInstances/" + this.encodeForURL(javaClass));
        this.out.print("\">");
        this.out.println("Include subclasses</a><br>");
        if (this.snapshot.getHasNewSet()) {
            this.out.println("<h2>New Instances</h2>");
            this.printAnchorStart();
            this.out.print("newInstances/" + this.encodeForURL(javaClass));
            this.out.print("\">");
            this.out.println("Exclude subclasses</a><br>");
            this.printAnchorStart();
            this.out.print("allNewInstances/" + this.encodeForURL(javaClass));
            this.out.print("\">");
            this.out.println("Include subclasses</a><br>");
        }
        this.out.println("<h2>References summary by Type</h2>");
        this.printAnchorStart();
        this.out.print("refsByType/" + this.encodeForURL(javaClass));
        this.out.print("\">");
        this.out.println("References summary by type</a>");
        this.printReferencesTo(javaClass);
    }

    protected void printReferencesTo(JavaHeapObject javaHeapObject) {
        if (javaHeapObject.getId() == -1L) {
            return;
        }
        this.out.println("<h2>References to this object:</h2>");
        this.out.flush();
        Enumeration enumeration = javaHeapObject.getReferers();
        while (enumeration.hasMoreElements()) {
            JavaHeapObject javaHeapObject2 = (JavaHeapObject)enumeration.nextElement();
            this.printThing(javaHeapObject2);
            this.print(" : " + javaHeapObject2.describeReferenceTo(javaHeapObject, this.snapshot));
            this.out.println("<br>");
        }
        this.out.println("<h2>Other Queries</h2>");
        this.out.println("Reference Chains from Rootset");
        long l = javaHeapObject.getId();
        this.out.print("<ul><li>");
        this.printAnchorStart();
        this.out.print("roots/");
        this.printHex(l);
        this.out.print("\">");
        this.out.println("Exclude weak refs</a>");
        this.out.print("<li>");
        this.printAnchorStart();
        this.out.print("allRoots/");
        this.printHex(l);
        this.out.print("\">");
        this.out.println("Include weak refs</a></ul>");
        this.printAnchorStart();
        this.out.print("reachableFrom/");
        this.printHex(l);
        this.out.print("\">");
        this.out.println("Objects reachable from here</a><br>");
    }
}

