/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.model;

import com.sun.tools.hat.internal.model.AbstractJavaHeapObjectVisitor;
import com.sun.tools.hat.internal.model.JavaClass;
import com.sun.tools.hat.internal.model.JavaField;
import com.sun.tools.hat.internal.model.JavaHeapObject;
import com.sun.tools.hat.internal.model.JavaThing;
import com.sun.tools.hat.internal.model.ReachableExcludes;
import com.sun.tools.hat.internal.util.ArraySorter;
import com.sun.tools.hat.internal.util.Comparer;
import java.util.Enumeration;
import java.util.Hashtable;

public class ReachableObjects {
    private JavaHeapObject root;
    private JavaThing[] reachables;
    private String[] excludedFields;
    private String[] usedFields;
    private long totalSize;

    public ReachableObjects(JavaHeapObject javaHeapObject, final ReachableExcludes reachableExcludes) {
        this.root = javaHeapObject;
        final Hashtable hashtable = new Hashtable();
        final Hashtable hashtable2 = new Hashtable();
        final Hashtable hashtable3 = new Hashtable();
        AbstractJavaHeapObjectVisitor abstractJavaHeapObjectVisitor = new AbstractJavaHeapObjectVisitor(){

            public void visit(JavaHeapObject javaHeapObject) {
                if (javaHeapObject != null && javaHeapObject.getSize() > 0 && hashtable.get(javaHeapObject) == null) {
                    hashtable.put(javaHeapObject, javaHeapObject);
                    javaHeapObject.visitReferencedObjects(this);
                }
            }

            public boolean mightExclude() {
                return reachableExcludes != null;
            }

            public boolean exclude(JavaClass javaClass, JavaField javaField) {
                if (reachableExcludes == null) {
                    return false;
                }
                String string = javaClass.getName() + "." + javaField.getName();
                if (reachableExcludes.isExcluded(string)) {
                    hashtable2.put(string, string);
                    return true;
                }
                hashtable3.put(string, string);
                return false;
            }
        };
        abstractJavaHeapObjectVisitor.visit(javaHeapObject);
        hashtable.remove(javaHeapObject);
        Object[] objectArray = new JavaThing[hashtable.size()];
        int n = 0;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            objectArray[n++] = (JavaThing)enumeration.nextElement();
        }
        ArraySorter.sort(objectArray, new Comparer(){

            public int compare(Object object, Object object2) {
                JavaThing javaThing = (JavaThing)object;
                JavaThing javaThing2 = (JavaThing)object2;
                int n = javaThing2.getSize() - javaThing.getSize();
                if (n != 0) {
                    return n;
                }
                return javaThing.compareTo(javaThing2);
            }
        });
        this.reachables = objectArray;
        this.totalSize = javaHeapObject.getSize();
        for (n = 0; n < objectArray.length; ++n) {
            this.totalSize += (long)((JavaThing)objectArray[n]).getSize();
        }
        this.excludedFields = this.getElements(hashtable2);
        this.usedFields = this.getElements(hashtable3);
    }

    public JavaHeapObject getRoot() {
        return this.root;
    }

    public JavaThing[] getReachables() {
        return this.reachables;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public String[] getExcludedFields() {
        return this.excludedFields;
    }

    public String[] getUsedFields() {
        return this.usedFields;
    }

    private String[] getElements(Hashtable hashtable) {
        Object[] objectArray = hashtable.keySet().toArray();
        int n = objectArray.length;
        Object[] objectArray2 = new String[n];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        ArraySorter.sortArrayOfStrings(objectArray2);
        return objectArray2;
    }
}

