/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.apt.main;

import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.tools.apt.comp.Apt;
import com.sun.tools.apt.util.Bark;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.parser.DocCommentScanner;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JavacFileManager;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCompiler
extends com.sun.tools.javac.main.JavaCompiler {
    protected static final Context.Key<JavaCompiler> compilerKey = new Context.Key();
    Set<String> genSourceFileNames;
    Set<String> genClassFileNames;
    Set<File> aggregateGenFiles = Collections.emptySet();
    Bark bark;
    Log log;
    Apt apt;
    public boolean classOutput;
    public boolean print;
    public boolean nocompile;
    public boolean classesAsDecls;
    private boolean hasBeenUsed = false;

    public static JavaCompiler instance(Context context) {
        JavaCompiler javaCompiler = context.get(compilerKey);
        if (javaCompiler == null) {
            javaCompiler = new JavaCompiler(context);
        }
        return javaCompiler;
    }

    public Set<String> getSourceFileNames() {
        return this.genSourceFileNames;
    }

    public Set<String> getClassFileNames() {
        return this.genClassFileNames;
    }

    public Set<File> getAggregateGenFiles() {
        return this.aggregateGenFiles;
    }

    private static Context preRegister(Context context) {
        Bark.preRegister(context);
        DocCommentScanner.Factory.preRegister(context);
        if (context.get(JavaFileManager.class) == null) {
            JavacFileManager.preRegister(context);
        }
        return context;
    }

    public JavaCompiler(Context context) {
        super(JavaCompiler.preRegister(context));
        context.put(compilerKey, this);
        this.apt = Apt.instance(context);
        ClassReader classReader = ClassReader.instance(context);
        classReader.preferSource = true;
        this.log = Log.instance(context);
        this.bark = Bark.instance(context);
        Options options = Options.instance(context);
        this.classOutput = options.get("-retrofit") == null;
        this.nocompile = options.get("-nocompile") != null;
        this.print = options.get("-print") != null;
        this.classesAsDecls = options.get("-XclassesAsDecls") != null;
        this.genSourceFileNames = new LinkedHashSet<String>();
        this.genClassFileNames = new LinkedHashSet<String>();
        this.lineDebugInfo = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence readSource(JavaFileObject javaFileObject) {
        CharSequence charSequence;
        this.inputFiles.add(javaFileObject);
        boolean bl = this.bark.setDiagnosticsIgnored(true);
        try {
            charSequence = javaFileObject.getCharContent(false);
            this.bark.setDiagnosticsIgnored(bl);
        }
        catch (Throwable throwable) {
            try {
                this.bark.setDiagnosticsIgnored(bl);
                throw throwable;
            }
            catch (IOException iOException) {
                this.bark.error(-1, "cant.read.file", javaFileObject);
                return null;
            }
        }
        return charSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JCTree.JCCompilationUnit parse(JavaFileObject javaFileObject, CharSequence charSequence) {
        boolean bl = this.bark.setDiagnosticsIgnored(true);
        try {
            JCTree.JCCompilationUnit jCCompilationUnit = super.parse(javaFileObject, charSequence);
            return jCCompilationUnit;
        }
        finally {
            this.bark.setDiagnosticsIgnored(bl);
        }
    }

    @Override
    protected boolean keepComments() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Symbol.ClassSymbol> compile(List<String> list, Map<String, String> map, ClassLoader classLoader, AnnotationProcessorFactory annotationProcessorFactory, Set<Class<? extends AnnotationProcessorFactory>> set, Set<File> set2) throws Throwable {
        assert (!this.hasBeenUsed) : "attempt to reuse JavaCompiler";
        this.hasBeenUsed = true;
        this.aggregateGenFiles = set2;
        long l = System.currentTimeMillis();
        ListBuffer<Symbol.ClassSymbol> listBuffer = new ListBuffer<Symbol.ClassSymbol>();
        try {
            ListBuffer<JCTree.JCCompilationUnit> listBuffer2 = new ListBuffer<JCTree.JCCompilationUnit>();
            List<String> list2 = list;
            while (list2.nonEmpty()) {
                block14: {
                    if (this.classesAsDecls && !((String)list2.head).endsWith(".java")) {
                        Symbol.ClassSymbol classSymbol = this.reader.enterClass(this.names.fromString((CharSequence)list2.head));
                        try {
                            classSymbol.complete();
                        }
                        catch (Symbol.CompletionFailure completionFailure) {
                            this.bark.aptError("CantFindClass", list2);
                            break block14;
                        }
                        listBuffer.append(classSymbol);
                    } else {
                        listBuffer2.append(this.parse((String)list2.head));
                    }
                }
                list2 = list2.tail;
            }
            list2 = listBuffer2.toList();
            if (this.errorCount() == 0) {
                boolean bl = this.bark.setDiagnosticsIgnored(true);
                try {
                    this.enter.main(list2);
                }
                finally {
                    this.bark.setDiagnosticsIgnored(bl);
                }
            }
            if (this.errorCount() == 0) {
                this.apt.main(list2, listBuffer, map, classLoader, annotationProcessorFactory, set);
                this.genSourceFileNames.addAll(this.apt.getSourceFileNames());
                this.genClassFileNames.addAll(this.apt.getClassFileNames());
            }
        }
        catch (Abort abort) {
            // empty catch block
        }
        if (this.verbose) {
            this.printVerbose("total", Long.toString(System.currentTimeMillis() - l));
        }
        this.chk.reportDeferredDiagnostics();
        this.printCount("error", this.errorCount());
        this.printCount("warn", this.warningCount());
        return listBuffer.toList();
    }
}

