/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import com.sun.net.ssl.internal.ssl.X509ExtendedTrustManager;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.ssl.Alerts;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.DHClientKeyExchange;
import sun.security.ssl.DHCrypt;
import sun.security.ssl.Debug;
import sun.security.ssl.ECDHClientKeyExchange;
import sun.security.ssl.ECDHCrypt;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.Handshaker;
import sun.security.ssl.HelloExtension;
import sun.security.ssl.JsseJce;
import sun.security.ssl.KerberosClientKeyExchange;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.RSAClientKeyExchange;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLSessionContextImpl;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SSLSocketImpl;
import sun.security.ssl.SupportedEllipticCurvesExtension;

final class ClientHandshaker
extends Handshaker {
    private PublicKey serverKey;
    private PublicKey ephemeralServerKey;
    private BigInteger serverDH;
    private DHCrypt dh;
    private ECDHCrypt ecdh;
    private HandshakeMessage.CertificateRequest certRequest;
    private boolean serverKeyExchangeReceived;
    private ProtocolVersion maxProtocolVersion;

    ClientHandshaker(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList) {
        super(sSLSocketImpl, sSLContextImpl, protocolList, true, true);
    }

    ClientHandshaker(SSLEngineImpl sSLEngineImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList) {
        super(sSLEngineImpl, sSLContextImpl, protocolList, true, true);
    }

    void processMessage(byte by, int n) throws IOException {
        if (this.state > by && by != 0 && this.state != 1) {
            throw new SSLProtocolException("Handshake message sequence violation, " + by);
        }
        block3 : switch (by) {
            case 0: {
                this.serverHelloRequest(new HandshakeMessage.HelloRequest(this.input));
                break;
            }
            case 2: {
                this.serverHello(new HandshakeMessage.ServerHello(this.input, n));
                break;
            }
            case 11: {
                if (this.keyExchange == CipherSuite.KeyExchange.K_DH_ANON || this.keyExchange == CipherSuite.KeyExchange.K_ECDH_ANON || this.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
                    this.fatalSE((byte)10, "unexpected server cert chain");
                }
                this.serverCertificate(new HandshakeMessage.CertificateMsg(this.input));
                this.serverKey = this.session.getPeerCertificates()[0].getPublicKey();
                break;
            }
            case 12: {
                this.serverKeyExchangeReceived = true;
                switch (this.keyExchange) {
                    case K_RSA: 
                    case K_RSA_EXPORT: {
                        try {
                            this.serverKeyExchange(new HandshakeMessage.RSA_ServerKeyExchange(this.input));
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            ClientHandshaker.throwSSLException("Server key", generalSecurityException);
                        }
                        break block3;
                    }
                    case K_DH_ANON: {
                        this.serverKeyExchange(new HandshakeMessage.DH_ServerKeyExchange(this.input));
                        break block3;
                    }
                    case K_DHE_DSS: 
                    case K_DHE_RSA: {
                        try {
                            this.serverKeyExchange(new HandshakeMessage.DH_ServerKeyExchange(this.input, this.serverKey, this.clnt_random.random_bytes, this.svr_random.random_bytes, n));
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            ClientHandshaker.throwSSLException("Server key", generalSecurityException);
                        }
                        break block3;
                    }
                    case K_ECDHE_ECDSA: 
                    case K_ECDHE_RSA: 
                    case K_ECDH_ANON: {
                        try {
                            this.serverKeyExchange(new HandshakeMessage.ECDH_ServerKeyExchange(this.input, this.serverKey, this.clnt_random.random_bytes, this.svr_random.random_bytes));
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            ClientHandshaker.throwSSLException("Server key", generalSecurityException);
                        }
                        break block3;
                    }
                    case K_ECDH_ECDSA: 
                    case K_ECDH_RSA: {
                        throw new SSLProtocolException("Protocol violation: server sent a server key exchange message for key exchange " + (Object)((Object)this.keyExchange));
                    }
                    case K_KRB5: 
                    case K_KRB5_EXPORT: {
                        throw new SSLProtocolException("unexpected receipt of server key exchange algorithm");
                    }
                }
                throw new SSLProtocolException("unsupported key exchange algorithm = " + (Object)((Object)this.keyExchange));
            }
            case 13: {
                if (this.keyExchange == CipherSuite.KeyExchange.K_DH_ANON || this.keyExchange == CipherSuite.KeyExchange.K_ECDH_ANON) {
                    throw new SSLHandshakeException("Client authentication requested for anonymous cipher suite.");
                }
                if (this.keyExchange == CipherSuite.KeyExchange.K_KRB5 || this.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
                    throw new SSLHandshakeException("Client certificate requested for kerberos cipher suite.");
                }
                this.certRequest = new HandshakeMessage.CertificateRequest(this.input);
                if (debug == null || !Debug.isOn("handshake")) break;
                this.certRequest.print(System.out);
                break;
            }
            case 14: {
                this.serverHelloDone(new HandshakeMessage.ServerHelloDone(this.input));
                break;
            }
            case 20: {
                this.serverFinished(new HandshakeMessage.Finished(this.protocolVersion, this.input));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal client handshake msg, " + by);
            }
        }
        if (this.state < by) {
            this.state = by;
        }
    }

    private void serverHelloRequest(HandshakeMessage.HelloRequest helloRequest) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            helloRequest.print(System.out);
        }
        if (this.state < 1) {
            this.kickstart();
        }
    }

    private void serverHello(HandshakeMessage.ServerHello serverHello) throws IOException {
        ProtocolVersion protocolVersion;
        this.serverKeyExchangeReceived = false;
        if (debug != null && Debug.isOn("handshake")) {
            serverHello.print(System.out);
        }
        if (!this.enabledProtocols.contains(protocolVersion = serverHello.protocolVersion)) {
            throw new SSLHandshakeException("Server chose unsupported or disabled protocol: " + protocolVersion);
        }
        this.setVersion(protocolVersion);
        this.svr_random = serverHello.svr_random;
        if (!this.isEnabled(serverHello.cipherSuite)) {
            this.fatalSE((byte)47, "Server selected disabled ciphersuite " + this.cipherSuite);
        }
        this.setCipherSuite(serverHello.cipherSuite);
        if (serverHello.compression_method != 0) {
            this.fatalSE((byte)47, "compression type not supported, " + serverHello.compression_method);
        }
        if (this.session != null) {
            if (this.session.getSessionId().equals(serverHello.sessionId)) {
                CipherSuite cipherSuite = this.session.getSuite();
                if (this.cipherSuite != cipherSuite) {
                    throw new SSLProtocolException("Server returned wrong cipher suite for session");
                }
                ProtocolVersion protocolVersion2 = this.session.getProtocolVersion();
                if (this.protocolVersion != protocolVersion2) {
                    throw new SSLProtocolException("Server resumed session with wrong protocol version");
                }
                if (cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5 || cipherSuite.keyExchange == CipherSuite.KeyExchange.K_KRB5_EXPORT) {
                    Subject subject;
                    Principal principal;
                    block20: {
                        principal = this.session.getLocalPrincipal();
                        subject = null;
                        try {
                            subject = AccessController.doPrivileged(new PrivilegedExceptionAction<Subject>(){

                                @Override
                                public Subject run() throws Exception {
                                    return Krb5Util.getSubject((int)3, (AccessControlContext)ClientHandshaker.this.getAccSE());
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            subject = null;
                            if (debug == null || !Debug.isOn("session")) break block20;
                            System.out.println("Attempt to obtain subject failed!");
                        }
                    }
                    if (subject != null) {
                        Set<KerberosPrincipal> set = subject.getPrincipals(KerberosPrincipal.class);
                        if (!set.contains(principal)) {
                            throw new SSLProtocolException("Server resumed session with wrong subject identity");
                        }
                        if (debug != null && Debug.isOn("session")) {
                            System.out.println("Subject identity is same");
                        }
                    } else {
                        if (debug != null && Debug.isOn("session")) {
                            System.out.println("Kerberos credentials are not present in the current Subject; check if  javax.security.auth.useSubjectAsCreds system property has been set to false");
                        }
                        throw new SSLProtocolException("Server resumed session with no subject");
                    }
                }
                this.resumingSession = true;
                this.state = 19;
                this.calculateConnectionKeys(this.session.getMasterSecret());
                if (debug != null && Debug.isOn("session")) {
                    System.out.println("%% Server resumed " + this.session);
                }
                return;
            }
            this.session = null;
            if (!this.enableNewSession) {
                throw new SSLException("New session creation is disabled");
            }
        }
        for (HelloExtension helloExtension : serverHello.extensions.list()) {
            ExtensionType extensionType = helloExtension.type;
            if (extensionType == ExtensionType.EXT_ELLIPTIC_CURVES || extensionType == ExtensionType.EXT_EC_POINT_FORMATS) continue;
            this.fatalSE((byte)110, "Server sent an unsupported extension: " + extensionType);
        }
        this.session = new SSLSessionImpl(this.protocolVersion, this.cipherSuite, serverHello.sessionId, this.getHostSE(), this.getPortSE());
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("** " + this.cipherSuite);
        }
    }

    private void serverKeyExchange(HandshakeMessage.RSA_ServerKeyExchange rSA_ServerKeyExchange) throws IOException, GeneralSecurityException {
        if (debug != null && Debug.isOn("handshake")) {
            rSA_ServerKeyExchange.print(System.out);
        }
        if (!rSA_ServerKeyExchange.verify(this.serverKey, this.clnt_random, this.svr_random)) {
            this.fatalSE((byte)40, "server key exchange invalid");
        }
        this.ephemeralServerKey = rSA_ServerKeyExchange.getPublicKey();
    }

    private void serverKeyExchange(HandshakeMessage.DH_ServerKeyExchange dH_ServerKeyExchange) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            dH_ServerKeyExchange.print(System.out);
        }
        this.dh = new DHCrypt(dH_ServerKeyExchange.getModulus(), dH_ServerKeyExchange.getBase(), this.sslContext.getSecureRandom());
        this.serverDH = dH_ServerKeyExchange.getServerPublicKey();
    }

    private void serverKeyExchange(HandshakeMessage.ECDH_ServerKeyExchange eCDH_ServerKeyExchange) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            eCDH_ServerKeyExchange.print(System.out);
        }
        ECPublicKey eCPublicKey = eCDH_ServerKeyExchange.getPublicKey();
        this.ecdh = new ECDHCrypt(eCPublicKey.getParams(), this.sslContext.getSecureRandom());
        this.ephemeralServerKey = eCPublicKey;
    }

    private void serverHelloDone(HandshakeMessage.ServerHelloDone serverHelloDone) throws IOException {
        Object object;
        Object object2;
        Serializable serializable;
        String[] stringArray;
        if (debug != null && Debug.isOn("handshake")) {
            serverHelloDone.print(System.out);
        }
        this.input.digestNow();
        PrivateKey privateKey = null;
        if (this.certRequest != null) {
            X509Certificate[] x509CertificateArray;
            stringArray = this.sslContext.getX509KeyManager();
            serializable = new ArrayList(4);
            for (int i = 0; i < this.certRequest.types.length; ++i) {
                String string;
                switch (this.certRequest.types[i]) {
                    case 1: {
                        string = "RSA";
                        break;
                    }
                    case 2: {
                        string = "DSA";
                        break;
                    }
                    case 64: {
                        string = JsseJce.isEcAvailable() ? "EC" : null;
                        break;
                    }
                    default: {
                        string = null;
                    }
                }
                if (string == null || ((ArrayList)serializable).contains(string)) continue;
                ((ArrayList)serializable).add(string);
            }
            object2 = null;
            int n = ((ArrayList)serializable).size();
            if (n != 0) {
                object = ((ArrayList)serializable).toArray(new String[n]);
                object2 = this.conn != null ? stringArray.chooseClientAlias((String[])object, this.certRequest.getAuthorities(), this.conn) : stringArray.chooseEngineClientAlias((String[])object, this.certRequest.getAuthorities(), this.engine);
            }
            object = null;
            if (object2 != null && (x509CertificateArray = stringArray.getCertificateChain((String)object2)) != null && x509CertificateArray.length != 0) {
                ECParameterSpec eCParameterSpec;
                int n2;
                PublicKey publicKey = x509CertificateArray[0].getPublicKey();
                if (publicKey instanceof ECPublicKey && !SupportedEllipticCurvesExtension.isSupported(n2 = SupportedEllipticCurvesExtension.getCurveIndex(eCParameterSpec = ((ECPublicKey)publicKey).getParams()))) {
                    publicKey = null;
                }
                if (publicKey != null) {
                    object = new HandshakeMessage.CertificateMsg(x509CertificateArray);
                    privateKey = stringArray.getPrivateKey((String)object2);
                    this.session.setLocalPrivateKey(privateKey);
                    this.session.setLocalCertificates(x509CertificateArray);
                }
            }
            if (object == null) {
                if (this.protocolVersion.v >= ProtocolVersion.TLS10.v) {
                    object = new HandshakeMessage.CertificateMsg(new X509Certificate[0]);
                } else {
                    this.warningSE((byte)41);
                }
            }
            if (object != null) {
                if (debug != null && Debug.isOn("handshake")) {
                    object.print(System.out);
                }
                object.write(this.output);
            }
        }
        switch (this.keyExchange) {
            case K_RSA: 
            case K_RSA_EXPORT: {
                serializable = this.keyExchange == CipherSuite.KeyExchange.K_RSA ? this.serverKey : this.ephemeralServerKey;
                stringArray = new RSAClientKeyExchange(this.protocolVersion, this.maxProtocolVersion, this.sslContext.getSecureRandom(), (PublicKey)serializable);
                break;
            }
            case K_DH_RSA: 
            case K_DH_DSS: {
                stringArray = new DHClientKeyExchange();
                break;
            }
            case K_DH_ANON: 
            case K_DHE_DSS: 
            case K_DHE_RSA: {
                if (this.dh == null) {
                    throw new SSLProtocolException("Server did not send a DH Server Key Exchange message");
                }
                stringArray = new DHClientKeyExchange(this.dh.getPublicKey());
                break;
            }
            case K_ECDHE_ECDSA: 
            case K_ECDHE_RSA: 
            case K_ECDH_ANON: {
                if (this.ecdh == null) {
                    throw new SSLProtocolException("Server did not send a ECDH Server Key Exchange message");
                }
                stringArray = new ECDHClientKeyExchange(this.ecdh.getPublicKey());
                break;
            }
            case K_ECDH_ECDSA: 
            case K_ECDH_RSA: {
                if (this.serverKey == null) {
                    throw new SSLProtocolException("Server did not send certificate message");
                }
                if (!(this.serverKey instanceof ECPublicKey)) {
                    throw new SSLProtocolException("Server certificate does not include an EC key");
                }
                object2 = ((ECPublicKey)this.serverKey).getParams();
                this.ecdh = new ECDHCrypt((ECParameterSpec)object2, this.sslContext.getSecureRandom());
                stringArray = new ECDHClientKeyExchange(this.ecdh.getPublicKey());
                break;
            }
            case K_KRB5: 
            case K_KRB5_EXPORT: {
                String string = this.getHostSE();
                if (string == null) {
                    throw new IOException("Hostname is required to use Kerberos cipher suites");
                }
                object = new KerberosClientKeyExchange(string, this.isLoopbackSE(), this.getAccSE(), this.protocolVersion, this.sslContext.getSecureRandom());
                this.session.setPeerPrincipal(object.getPeerPrincipal());
                this.session.setLocalPrincipal(object.getLocalPrincipal());
                stringArray = object;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported key exchange: " + (Object)((Object)this.keyExchange));
            }
        }
        if (debug != null && Debug.isOn("handshake")) {
            stringArray.print(System.out);
        }
        stringArray.write(this.output);
        this.output.doHashes();
        this.output.flush();
        switch (this.keyExchange) {
            case K_RSA: 
            case K_RSA_EXPORT: {
                serializable = ((RSAClientKeyExchange)stringArray).preMaster;
                break;
            }
            case K_KRB5: 
            case K_KRB5_EXPORT: {
                object2 = ((KerberosClientKeyExchange)stringArray).getPreMasterSecret().getUnencrypted();
                serializable = new SecretKeySpec((byte[])object2, "TlsPremasterSecret");
                break;
            }
            case K_DH_ANON: 
            case K_DHE_DSS: 
            case K_DHE_RSA: {
                serializable = this.dh.getAgreedSecret(this.serverDH);
                break;
            }
            case K_ECDHE_ECDSA: 
            case K_ECDHE_RSA: 
            case K_ECDH_ANON: {
                serializable = this.ecdh.getAgreedSecret(this.ephemeralServerKey);
                break;
            }
            case K_ECDH_ECDSA: 
            case K_ECDH_RSA: {
                serializable = this.ecdh.getAgreedSecret(this.serverKey);
                break;
            }
            default: {
                throw new IOException("Internal error: unknown key exchange " + (Object)((Object)this.keyExchange));
            }
        }
        this.calculateKeys((SecretKey)serializable, null);
        if (privateKey != null) {
            try {
                object2 = new HandshakeMessage.CertificateVerify(this.protocolVersion, this.handshakeHash, privateKey, this.session.getMasterSecret(), this.sslContext.getSecureRandom());
            }
            catch (GeneralSecurityException generalSecurityException) {
                this.fatalSE((byte)40, "Error signing certificate verify", generalSecurityException);
                object2 = null;
            }
            if (debug != null && Debug.isOn("handshake")) {
                ((HandshakeMessage.CertificateVerify)object2).print(System.out);
            }
            ((HandshakeMessage)object2).write(this.output);
            this.output.doHashes();
        }
        this.sendChangeCipherAndFinish(false);
    }

    private void serverFinished(HandshakeMessage.Finished finished) throws IOException {
        boolean bl;
        if (debug != null && Debug.isOn("handshake")) {
            finished.print(System.out);
        }
        if (!(bl = finished.verify(this.protocolVersion, this.handshakeHash, 2, this.session.getMasterSecret()))) {
            this.fatalSE((byte)47, "server 'finished' message doesn't verify");
        }
        if (this.resumingSession) {
            this.input.digestNow();
            this.sendChangeCipherAndFinish(true);
        }
        this.session.setLastAccessedTime(System.currentTimeMillis());
        if (!this.resumingSession) {
            if (this.session.isRejoinable()) {
                ((SSLSessionContextImpl)this.sslContext.engineGetClientSessionContext()).put(this.session);
                if (debug != null && Debug.isOn("session")) {
                    System.out.println("%% Cached client session: " + this.session);
                }
            } else if (debug != null && Debug.isOn("session")) {
                System.out.println("%% Didn't cache non-resumable client session: " + this.session);
            }
        }
    }

    private void sendChangeCipherAndFinish(boolean bl) throws IOException {
        HandshakeMessage.Finished finished = new HandshakeMessage.Finished(this.protocolVersion, this.handshakeHash, 1, this.session.getMasterSecret());
        this.sendChangeCipherSpec(finished, bl);
        this.state = 19;
    }

    HandshakeMessage getKickstartMessage() throws SSLException {
        HandshakeMessage.ClientHello clientHello = new HandshakeMessage.ClientHello(this.sslContext.getSecureRandom(), this.protocolVersion);
        this.maxProtocolVersion = this.protocolVersion;
        this.clnt_random = clientHello.clnt_random;
        this.session = ((SSLSessionContextImpl)this.sslContext.engineGetClientSessionContext()).get(this.getHostSE(), this.getPortSE());
        if (debug != null && Debug.isOn("session")) {
            if (this.session != null) {
                System.out.println("%% Client cached " + this.session + (this.session.isRejoinable() ? "" : " (not rejoinable)"));
            } else {
                System.out.println("%% No cached client session");
            }
        }
        if (this.session != null && !this.session.isRejoinable()) {
            this.session = null;
        }
        if (this.session != null) {
            CipherSuite cipherSuite = this.session.getSuite();
            ProtocolVersion protocolVersion = this.session.getProtocolVersion();
            if (!this.isEnabled(cipherSuite)) {
                if (debug != null && Debug.isOn("session")) {
                    System.out.println("%% can't resume, cipher disabled");
                }
                this.session = null;
            }
            if (this.session != null && !this.enabledProtocols.contains(protocolVersion)) {
                if (debug != null && Debug.isOn("session")) {
                    System.out.println("%% can't resume, protocol disabled");
                }
                this.session = null;
            }
            if (this.session != null) {
                if (debug != null && (Debug.isOn("handshake") || Debug.isOn("session"))) {
                    System.out.println("%% Try resuming " + this.session + " from port " + this.getLocalPortSE());
                }
                clientHello.sessionId = this.session.getSessionId();
                clientHello.protocolVersion = protocolVersion;
                this.maxProtocolVersion = protocolVersion;
                this.setVersion(protocolVersion);
            }
            if (!this.enableNewSession) {
                if (this.session == null) {
                    throw new SSLException("Can't reuse existing SSL client session");
                }
                clientHello.setCipherSuites(new CipherSuiteList(cipherSuite));
                return clientHello;
            }
        }
        if (this.session == null) {
            if (this.enableNewSession) {
                clientHello.sessionId = SSLSessionImpl.nullSession.getSessionId();
            } else {
                throw new SSLException("No existing session to resume.");
            }
        }
        clientHello.setCipherSuites(this.enabledCipherSuites);
        return clientHello;
    }

    void handshakeAlert(byte by) throws SSLProtocolException {
        String string = Alerts.alertDescription(by);
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("SSL - handshake alert: " + string);
        }
        throw new SSLProtocolException("handshake alert:  " + string);
    }

    private void serverCertificate(HandshakeMessage.CertificateMsg certificateMsg) throws IOException {
        X509Certificate[] x509CertificateArray;
        if (debug != null && Debug.isOn("handshake")) {
            certificateMsg.print(System.out);
        }
        if ((x509CertificateArray = certificateMsg.getCertificateChain()).length == 0) {
            this.fatalSE((byte)42, "empty certificate chain");
        }
        X509TrustManager x509TrustManager = this.sslContext.getX509TrustManager();
        try {
            String string = this.keyExchange == CipherSuite.KeyExchange.K_RSA_EXPORT && !this.serverKeyExchangeReceived ? CipherSuite.KeyExchange.K_RSA.name : this.keyExchange.name;
            String string2 = this.getHostnameVerificationSE();
            if (x509TrustManager instanceof X509ExtendedTrustManager) {
                ((X509ExtendedTrustManager)x509TrustManager).checkServerTrusted(x509CertificateArray != null ? (X509Certificate[])x509CertificateArray.clone() : null, string, this.getHostSE(), string2);
            } else {
                if (string2 != null) {
                    throw new RuntimeException("trust manager does not support peer identification");
                }
                x509TrustManager.checkServerTrusted(x509CertificateArray != null ? (X509Certificate[])x509CertificateArray.clone() : x509CertificateArray, string);
            }
        }
        catch (CertificateException certificateException) {
            this.fatalSE((byte)46, certificateException);
        }
        this.session.setPeerCertificates(x509CertificateArray);
    }
}

