/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.internal.navigator.NavigatorFilterService;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;

public class ToggleFilterAction
extends Action
implements IAction {
    private ICommonFilterDescriptor descriptor;
    private NavigatorFilterService filterService;
    private CommonViewer commonViewer;

    protected ToggleFilterAction(CommonViewer aCommonViewer, NavigatorFilterService aFilterService, ICommonFilterDescriptor aFilterDescriptor) {
        Assert.isNotNull((Object)((Object)aCommonViewer));
        Assert.isNotNull((Object)aFilterService);
        Assert.isNotNull((Object)aFilterDescriptor);
        this.commonViewer = aCommonViewer;
        this.filterService = aFilterService;
        this.descriptor = aFilterDescriptor;
        this.setChecked(this.filterService.isActive(this.descriptor.getId()));
        this.setText(this.descriptor.getName());
    }

    public void run() {
        boolean toMakeActive = !this.isChecked();
        this.filterService.setActive(this.descriptor.getId(), toMakeActive);
        this.filterService.persistFilterActivationState();
        ViewerFilter viewerFilter = this.filterService.getViewerFilter(this.descriptor);
        if (toMakeActive) {
            this.commonViewer.addFilter(viewerFilter);
        } else {
            this.commonViewer.removeFilter(viewerFilter);
        }
        this.commonViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this.setChecked(toMakeActive);
    }
}

