/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class EclipseCommandProvider
implements CommandProvider {
    private BundleContext context;

    public EclipseCommandProvider(BundleContext context) {
        this.context = context;
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer(512);
        help.append(EclipseAdaptorMsg.NEW_LINE);
        help.append("---");
        help.append(EclipseAdaptorMsg.ECLIPSE_CONSOLE_COMMANDS_HEADER);
        help.append("---");
        help.append(EclipseAdaptorMsg.NEW_LINE);
        help.append("\tdiag - " + EclipseAdaptorMsg.ECLIPSE_CONSOLE_HELP_DIAG_COMMAND_DESCRIPTION);
        help.append(EclipseAdaptorMsg.NEW_LINE);
        help.append("\tactive - " + EclipseAdaptorMsg.ECLIPSE_CONSOLE_HELP_ACTIVE_COMMAND_DESCRIPTION);
        help.append(EclipseAdaptorMsg.NEW_LINE);
        help.append("\tgetprop " + EclipseAdaptorMsg.ECLIPSE_CONSOLE_HELP_GETPROP_COMMAND_DESCRIPTION);
        return help.toString();
    }

    private BundleDescription getBundleDescriptionFromToken(State state, String token) {
        try {
            long id = Long.parseLong(token);
            return state.getBundle(id);
        }
        catch (NumberFormatException numberFormatException) {
            BundleDescription[] allBundles = state.getBundles(token);
            if (allBundles.length > 0) {
                return allBundles[0];
            }
            return null;
        }
    }

    public void _diag(CommandInterpreter ci) throws Exception {
        String nextArg = ci.nextArgument();
        if (nextArg == null) {
            ci.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_BUNDLE_SPECIFIED_ERROR);
            return;
        }
        ServiceReference platformAdminRef = this.context.getServiceReference(PlatformAdmin.class.getName());
        if (platformAdminRef == null) {
            ci.print("  ");
            ci.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_CONSTRAINTS_NO_PLATFORM_ADMIN_MESSAGE);
            return;
        }
        try {
            PlatformAdmin platformAdmin = (PlatformAdmin)this.context.getService(platformAdminRef);
            if (platformAdmin == null) {
                return;
            }
            State systemState = platformAdmin.getState(false);
            while (nextArg != null) {
                BundleDescription bundle = this.getBundleDescriptionFromToken(systemState, nextArg);
                if (bundle == null) {
                    ci.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_CANNOT_FIND_BUNDLE_ERROR, nextArg));
                    nextArg = ci.nextArgument();
                    continue;
                }
                ci.println(String.valueOf(bundle.getLocation()) + " [" + bundle.getBundleId() + "]");
                VersionConstraint[] unsatisfied = platformAdmin.getStateHelper().getUnsatisfiedConstraints(bundle);
                if (unsatisfied.length == 0) {
                    ResolverError[] resolverErrors = platformAdmin.getState(false).getResolverErrors(bundle);
                    if (!bundle.isResolved() && resolverErrors.length > 0) {
                        int i = 0;
                        while (i < resolverErrors.length) {
                            ci.print("  ");
                            ci.println(resolverErrors[i].toString());
                            ++i;
                        }
                    } else {
                        ci.print("  ");
                        ci.println(EclipseAdaptorMsg.ECLIPSE_CONSOLE_NO_CONSTRAINTS);
                    }
                }
                int i = 0;
                while (i < unsatisfied.length) {
                    ci.print("  ");
                    ci.println(EclipseAdaptorMsg.getResolutionFailureMessage(unsatisfied[i]));
                    ++i;
                }
                nextArg = ci.nextArgument();
            }
        }
        finally {
            this.context.ungetService(platformAdminRef);
        }
    }

    public void _active(CommandInterpreter ci) throws Exception {
        Bundle[] allBundles = this.context.getBundles();
        int activeCount = 0;
        int i = 0;
        while (i < allBundles.length) {
            if (allBundles[i].getState() == 32) {
                ci.println(allBundles[i]);
                ++activeCount;
            }
            ++i;
        }
        ci.print("  ");
        ci.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONSOLE_BUNDLES_ACTIVE, String.valueOf(activeCount)));
    }

    public void _getprop(CommandInterpreter ci) throws Exception {
        Properties allProperties = FrameworkProperties.getProperties();
        String filter = ci.nextArgument();
        Enumeration<Object> propertyNames = allProperties.keys();
        while (propertyNames.hasMoreElements()) {
            String prop = (String)propertyNames.nextElement();
            if (filter != null && !prop.startsWith(filter)) continue;
            ci.println(String.valueOf(prop) + '=' + allProperties.getProperty(prop));
        }
    }
}

