/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.NotifyInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;

abstract class AbstractStructureVisitor
implements ICVSResourceVisitor {
    protected Session session;
    private ICVSFolder lastFolderSent;
    protected IProgressMonitor monitor;
    protected boolean sendQuestionable;
    protected boolean sendModifiedContents;
    private boolean sendBinary;
    private boolean recurse = true;

    public AbstractStructureVisitor(Session session, Command.LocalOption[] localOptions, boolean sendQuestionable, boolean sendModifiedContents) {
        this(session, localOptions, sendQuestionable, sendModifiedContents, true);
    }

    public AbstractStructureVisitor(Session session, Command.LocalOption[] localOptions, boolean sendQuestionable, boolean sendModifiedContents, boolean sendBinary) {
        this.session = session;
        this.sendQuestionable = sendQuestionable;
        this.sendModifiedContents = sendModifiedContents;
        this.sendBinary = sendBinary;
        if (Command.DO_NOT_RECURSE.isElementOf(localOptions)) {
            this.recurse = false;
        }
    }

    protected boolean isLastSent(ICVSFolder folder) {
        return folder.equals(this.lastFolderSent);
    }

    protected void recordLastSent(ICVSFolder folder) {
        this.lastFolderSent = folder;
    }

    protected boolean isOrphanedSubtree(ICVSFolder mFolder) throws CVSException {
        return mFolder.isCVSFolder() && !mFolder.isManaged() && !mFolder.equals(this.session.getLocalRoot()) && mFolder.getParent().isCVSFolder();
    }

    protected void sendFolder(ICVSFolder mFolder) throws CVSException {
        boolean isQuestionable;
        boolean isCVSFolder;
        Policy.checkCanceled(this.monitor);
        boolean exists = mFolder.exists();
        FolderSyncInfo info = mFolder.getFolderSyncInfo();
        boolean bl = isCVSFolder = info != null;
        if (!exists && !isCVSFolder) {
            return;
        }
        if (this.isLastSent(mFolder)) {
            return;
        }
        if (isCVSFolder && info.isVirtualDirectory()) {
            return;
        }
        String localPath = mFolder.getRelativePath(this.session.getLocalRoot());
        this.monitor.subTask(NLS.bind((String)CVSMessages.AbstractStructureVisitor_sendingFolder, (Object[])new String[]{Util.toTruncatedPath(mFolder, this.session.getLocalRoot(), 3)}));
        boolean bl2 = isQuestionable = exists && (!isCVSFolder || this.isOrphanedSubtree(mFolder));
        if (isQuestionable) {
            if (this.sendQuestionable) {
                this.sendFolder(mFolder.getParent());
                this.session.sendQuestionable(mFolder);
            }
            return;
        }
        String remotePath = mFolder.getRemoteLocation(this.session.getLocalRoot());
        if (remotePath == null) {
            throw new CVSException(CVSMessages.AbstractStructureVisitor_noRemote);
        }
        this.session.sendDirectory(localPath, remotePath);
        if (info != null) {
            CVSEntryLineTag tag;
            if (info.getIsStatic()) {
                this.session.sendStaticDirectory();
            }
            if ((tag = info.getTag()) != null && tag.getType() != 0) {
                this.session.sendSticky(tag.toEntryLineFormat(false));
            }
        }
        this.recordLastSent(mFolder);
        this.monitor.worked(1);
    }

    protected void sendFile(ICVSFile mFile) throws CVSException {
        boolean sendContents;
        boolean isManaged;
        Policy.checkCanceled(this.monitor);
        this.sendFolder(mFile.getParent());
        byte[] syncBytes = mFile.getSyncBytes();
        boolean bl = isManaged = syncBytes != null;
        if (isManaged) {
            this.sendPendingNotification(mFile);
        } else if (this.sendQuestionable) {
            if (mFile.exists()) {
                this.session.sendQuestionable(mFile);
            }
            return;
        }
        boolean bl2 = sendContents = mFile.exists() && mFile.isModified(this.monitor);
        if (ResourceSyncInfo.isDeletion(syncBytes)) {
            this.sendEntryLineToServer(mFile, syncBytes);
        } else if (sendContents) {
            IResource resource = mFile.getIResource();
            try {
                if (resource != null) {
                    Platform.getJobManager().beginRule((ISchedulingRule)resource, this.monitor);
                }
                this.sendEntryLineToServer(mFile, syncBytes);
                if (mFile.exists() && mFile.isModified(null)) {
                    boolean binary = ResourceSyncInfo.isBinary(syncBytes);
                    if (this.sendModifiedContents) {
                        this.session.sendModified(mFile, binary, this.sendBinary, this.monitor);
                    }
                    this.session.sendIsModified(mFile, binary, this.monitor);
                }
                this.session.sendUnchanged(mFile);
            }
            finally {
                if (resource != null) {
                    Platform.getJobManager().endRule((ISchedulingRule)resource);
                }
            }
        } else {
            this.sendEntryLineToServer(mFile, syncBytes);
            this.session.sendUnchanged(mFile);
        }
        this.monitor.worked(1);
    }

    private void sendEntryLineToServer(ICVSFile mFile, byte[] syncBytes) throws CVSException {
        if (syncBytes != null) {
            String syncBytesToServer = ResourceSyncInfo.getTimestampToServer(syncBytes, mFile.getTimeStamp());
            this.session.sendEntry(syncBytes, syncBytesToServer);
        }
    }

    protected void sendPendingNotification(ICVSFile mFile) throws CVSException {
        NotifyInfo notify = mFile.getPendingNotification();
        if (notify != null) {
            this.sendFolder(mFile.getParent());
            this.session.sendNotify(mFile.getParent(), notify);
        }
    }

    public void visit(Session session, ICVSResource[] resources, IProgressMonitor monitor) throws CVSException {
        ArrayList resourceList = new ArrayList(resources.length);
        resourceList.addAll(Arrays.asList(resources));
        final ICVSFolder localRoot = session.getLocalRoot();
        Collections.sort(resourceList, new Comparator(){

            public int compare(Object object1, Object object2) {
                int pathCompare;
                block5: {
                    ICVSResource resource1 = (ICVSResource)object1;
                    ICVSResource resource2 = (ICVSResource)object2;
                    try {
                        String path1 = resource1.getParent().getRelativePath(localRoot);
                        String path2 = resource2.getParent().getRelativePath(localRoot);
                        pathCompare = path1.compareTo(path2);
                        if (pathCompare != 0) break block5;
                        if (resource1.isFolder() == resource2.isFolder()) {
                            return resource1.getName().compareTo(resource2.getName());
                        }
                        if (resource1.isFolder()) {
                            return 1;
                        }
                        return -1;
                    }
                    catch (CVSException cVSException) {
                        return resource1.getName().compareTo(resource2.getName());
                    }
                }
                return pathCompare;
            }
        });
        int resourceHint = 64;
        monitor.beginTask(null, resourceHint);
        this.monitor = Policy.infiniteSubMonitorFor(monitor, resourceHint);
        try {
            this.monitor.beginTask(null, resourceHint);
            session.setSendFileTitleKey(this.getSendFileMessage());
            int i = 0;
            while (i < resourceList.size()) {
                ((ICVSResource)resourceList.get(i)).accept(this);
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected String getSendFileMessage() {
        return CVSMessages.AbstractStructureVisitor_sendingFile;
    }

    public boolean isRecurse() {
        return this.recurse;
    }
}

