/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingLabelProvider;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingLine;
import org.eclipse.debug.ui.memory.AbstractTableRendering;
import org.eclipse.debug.ui.memory.MemoryRenderingElement;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class TableRenderingLabelProviderEx
extends TableRenderingLabelProvider
implements ITableColorProvider,
ITableFontProvider {
    private IFontProvider fFontProvider;
    private ILabelProvider fLabelProvider;
    private IColorProvider fColorProvider;

    public TableRenderingLabelProviderEx(AbstractTableRendering rendering) {
        super(rendering);
        this.fLabelProvider = (ILabelProvider)rendering.getAdapter(ILabelProvider.class);
        this.fColorProvider = (IColorProvider)rendering.getAdapter(IColorProvider.class);
        this.fFontProvider = (IFontProvider)rendering.getAdapter(IFontProvider.class);
    }

    public void dispose() {
        if (this.fFontProvider != null) {
            this.fFontProvider = null;
        }
        if (this.fColorProvider != null) {
            this.fColorProvider = null;
        }
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
            this.fLabelProvider = null;
        }
        super.dispose();
    }

    public Color getBackground(Object element, int columnIndex) {
        Color color;
        MemoryRenderingElement renderingElement;
        if (this.fColorProvider != null && columnIndex > 0 && (renderingElement = this.getMemoryRenderingElement(element, columnIndex)) != null && (color = this.fColorProvider.getBackground((Object)renderingElement)) != null) {
            return color;
        }
        return super.getBackground(element);
    }

    public Color getForeground(Object element, int columnIndex) {
        Color color;
        MemoryRenderingElement renderingElement;
        if (this.fColorProvider != null && columnIndex > 0 && (renderingElement = this.getMemoryRenderingElement(element, columnIndex)) != null && (color = this.fColorProvider.getForeground((Object)renderingElement)) != null) {
            return color;
        }
        return super.getForeground(element);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image;
        MemoryRenderingElement renderingElement;
        if (this.fLabelProvider != null && columnIndex > 0 && (renderingElement = this.getMemoryRenderingElement(element, columnIndex)) != null && (image = this.fLabelProvider.getImage((Object)renderingElement)) != null) {
            return image;
        }
        return super.getColumnImage(element, columnIndex);
    }

    public Font getFont(Object element, int columnIndex) {
        Font font;
        MemoryRenderingElement renderingElement;
        if (this.fFontProvider != null && columnIndex > 0 && (renderingElement = this.getMemoryRenderingElement(element, columnIndex)) != null && (font = this.fFontProvider.getFont((Object)renderingElement)) != null) {
            return font;
        }
        return null;
    }

    private MemoryRenderingElement getMemoryRenderingElement(Object element, int columnIndex) {
        if (element instanceof TableRenderingLine) {
            TableRenderingLine line = (TableRenderingLine)((Object)element);
            BigInteger lineAddress = new BigInteger(line.getAddress(), 16);
            int offset = (columnIndex - 1) * this.fRendering.getBytesPerColumn();
            if (offset < this.fRendering.getBytesPerLine() && offset + this.fRendering.getBytesPerColumn() <= this.fRendering.getBytesPerLine()) {
                return this.getMemoryRenderingElement(line, lineAddress, offset);
            }
        }
        return null;
    }

    private MemoryRenderingElement getMemoryRenderingElement(TableRenderingLine line, BigInteger lineAddress, int offset) {
        BigInteger cellAddress = lineAddress.add(BigInteger.valueOf(offset));
        MemoryByte[] bytes = line.getBytes(offset, offset + this.fRendering.getBytesPerColumn());
        MemoryByte[] copy = new MemoryByte[bytes.length];
        System.arraycopy(bytes, 0, copy, 0, bytes.length);
        MemoryRenderingElement renderingElement = new MemoryRenderingElement(this.fRendering, cellAddress, copy);
        return renderingElement;
    }
}

