/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CodePagesPreferencePage
extends FieldEditorPreferencePage {
    private StringFieldEditor fEbcdicCodePage;
    private StringFieldEditor fAsciiCodePage;

    protected CodePagesPreferencePage() {
        super(1);
        this.setPreferenceStore(DebugUITools.getPreferenceStore());
        this.setTitle(DebugUIMessages.CodePagesPrefDialog_1);
    }

    protected void createFieldEditors() {
        this.fAsciiCodePage = new StringFieldEditor(IDebugUIConstants.PREF_DEFAULT_ASCII_CODE_PAGE, DebugUIMessages.CodePagesPrefDialog_2, this.getFieldEditorParent());
        this.fAsciiCodePage.setEmptyStringAllowed(false);
        this.addField((FieldEditor)this.fAsciiCodePage);
        this.fEbcdicCodePage = new StringFieldEditor(IDebugUIConstants.PREF_DEFAULT_EBCDIC_CODE_PAGE, DebugUIMessages.CodePagesPrefDialog_4, this.getFieldEditorParent());
        this.fEbcdicCodePage.setEmptyStringAllowed(false);
        this.addField((FieldEditor)this.fEbcdicCodePage);
    }

    public boolean performOk() {
        if (this.fAsciiCodePage == null || this.fEbcdicCodePage == null) {
            return super.performOk();
        }
        String asciiCodePage = this.fAsciiCodePage.getStringValue();
        asciiCodePage = asciiCodePage.trim();
        try {
            new String(new byte[]{1}, asciiCodePage);
        }
        catch (UnsupportedEncodingException e) {
            Shell shell = DebugUIPlugin.getShell();
            if (shell != null) {
                IStatus status = DebugUIPlugin.newErrorStatus(DebugUIMessages.CodePagesPrefDialog_0, e);
                ErrorDialog.openError((Shell)shell, (String)DebugUIMessages.CodePagesPrefDialog_6, (String)DebugUIMessages.CodePagesPrefDialog_7, (IStatus)status);
            }
            return false;
        }
        String ebcdicCodePage = this.fEbcdicCodePage.getStringValue();
        ebcdicCodePage = ebcdicCodePage.trim();
        try {
            new String(new byte[]{1}, ebcdicCodePage);
        }
        catch (UnsupportedEncodingException e) {
            Shell shell = DebugUIPlugin.getShell();
            if (shell != null) {
                IStatus status = DebugUIPlugin.newErrorStatus(DebugUIMessages.CodePagesPrefDialog_0, e);
                ErrorDialog.openError((Shell)shell, (String)DebugUIMessages.CodePagesPrefDialog_8, (String)DebugUIMessages.CodePagesPrefDialog_9, (IStatus)status);
            }
            return false;
        }
        return super.performOk();
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".CodePagesPrefDialog_context");
        return super.createContents(parent);
    }
}

