/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.context;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.actions.context.AbstractDebugContextAction;
import org.eclipse.debug.internal.ui.actions.context.BooleanRequestMonitor;
import org.eclipse.debug.internal.ui.actions.provisional.IAsynchronousStepFiltersAdapter;
import org.eclipse.debug.internal.ui.actions.provisional.IBooleanRequestMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ToggleStepFiltersAction
extends AbstractDebugContextAction {
    public ToggleStepFiltersAction() {
        this.setEnabled(true);
    }

    protected void doAction(Object target) {
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_DLCL_TOGGLE_STEP_FILTERS");
    }

    public String getHelpContextId() {
        return "step_with_filters_action_context";
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_ELCL_TOGGLE_STEP_FILTERS");
    }

    public String getId() {
        return "org.eclipse.debug.ui.actions.ToggleStepFilters";
    }

    public ImageDescriptor getImageDescriptor() {
        return DebugPluginImages.getImageDescriptor("IMG_ELCL_TOGGLE_STEP_FILTERS");
    }

    public String getText() {
        return "Toggle Step Filters";
    }

    public String getToolTipText() {
        return "Toggle Step Filters";
    }

    protected void isEnabledFor(Object element, IBooleanRequestMonitor monitor) {
        if (element instanceof IAdaptable) {
            IAsynchronousStepFiltersAdapter stepFilters = (IAsynchronousStepFiltersAdapter)((IAdaptable)element).getAdapter(IAsynchronousStepFiltersAdapter.class);
            if (stepFilters != null) {
                stepFilters.supportsStepFilters(element, monitor);
            } else {
                this.notSupported(monitor);
            }
        }
    }

    protected void updateEnableStateForContext(IStructuredSelection selection) {
        int size = selection.size();
        if (size == 1) {
            BooleanRequestMonitor monitor = new BooleanRequestMonitor((IAction)this, size);
            for (Object element : selection) {
                this.isEnabledFor(element, monitor);
            }
        } else {
            BooleanRequestMonitor monitor = new BooleanRequestMonitor((IAction)this, 1);
            monitor.setResult(true);
            monitor.done();
        }
    }

    protected boolean getInitialEnablement() {
        return true;
    }
}

