/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.console;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.internal.console.ConsoleManager;
import org.eclipse.ui.internal.console.ConsolePluginImages;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ConsolePlugin
extends AbstractUIPlugin {
    private IConsoleManager fConsoleManager = null;
    private static ConsolePlugin fgPlugin = null;
    private static final String PI_UI_CONSOLE = "org.eclipse.ui.console";

    public static ConsolePlugin getDefault() {
        return fgPlugin;
    }

    public ConsolePlugin() {
        fgPlugin = this;
    }

    public static String getUniqueIdentifier() {
        return PI_UI_CONSOLE;
    }

    public static void log(IStatus status) {
        ConsolePlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable t) {
        ConsolePlugin.log(ConsolePlugin.newErrorStatus("Error logged from Console plug-in: ", t));
    }

    public static IStatus newErrorStatus(String message, Throwable exception) {
        return new Status(4, ConsolePlugin.getUniqueIdentifier(), 120, message, exception);
    }

    public IConsoleManager getConsoleManager() {
        if (this.fConsoleManager == null) {
            this.fConsoleManager = new ConsoleManager();
        }
        return this.fConsoleManager;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static void errorDialog(Shell shell, String title, String message, Throwable t) {
        IStatus status;
        if (t instanceof CoreException) {
            status = ((CoreException)t).getStatus();
            if (status != null && message.equals(status.getMessage())) {
                message = null;
            }
        } else {
            status = new Status(4, ConsolePlugin.getUniqueIdentifier(), 120, "Error within Debug UI: ", t);
            ConsolePlugin.log(status);
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }

    public static Image getImage(String key) {
        return ConsolePluginImages.getImage(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return ConsolePluginImages.getImageDescriptor(key);
    }

    public void stop(BundleContext context) throws Exception {
        IConsole[] consoles;
        if (this.fConsoleManager != null && (consoles = this.fConsoleManager.getConsoles()) != null) {
            this.fConsoleManager.removeConsoles(consoles);
        }
        super.stop(context);
    }
}

