/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.buildpath;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifierOperation;
import org.eclipse.jdt.internal.corext.buildpath.IClasspathInformationProvider;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;

public class RemoveFromClasspathOperation
extends ClasspathModifierOperation {
    public RemoveFromClasspathOperation(ClasspathModifier.IClasspathModifierListener listener, IClasspathInformationProvider informationProvider) {
        super(listener, informationProvider, NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_tooltip, 1);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        List result = null;
        this.fException = null;
        try {
            result = this.removeFromClasspath(this.fInformationProvider.getRemoveLinkedFolderQuery(), this.getSelectedElements(), this.fInformationProvider.getJavaProject(), monitor);
        }
        catch (CoreException e) {
            this.fException = e;
            result = null;
        }
        super.handleResult(result, monitor);
    }

    public boolean isValid(List elements, int[] types) throws JavaModelException {
        if (elements.size() == 0) {
            return false;
        }
        IJavaProject project = this.fInformationProvider.getJavaProject();
        for (Object element : elements) {
            IClasspathEntry entry;
            if (!(element instanceof IPackageFragmentRoot || element instanceof IJavaProject || element instanceof ClassPathContainer)) {
                return false;
            }
            if (!(element instanceof IJavaProject ? !RemoveFromClasspathOperation.isSourceFolder(project) : element instanceof IPackageFragmentRoot && (entry = ((IPackageFragmentRoot)element).getRawClasspathEntry()) != null && entry.getEntryKind() == 5)) continue;
            return false;
        }
        return true;
    }

    public String getDescription(int type) {
        IJavaElement elem = (IJavaElement)this.getSelectedElements().get(0);
        String name = RemoveFromClasspathOperation.escapeSpecialChars(elem.getElementName());
        if (type == 1) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ProjectFromBuildpath, name);
        }
        if (type == 2 || type == 14) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_fromBuildpath, name);
        }
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_FromBuildpath;
    }
}

