/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerPermission;
import javax.management.ObjectName;
import javax.management.loading.ClassLoaderRepository;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.server.MBeanServerImpl;

public class MBeanServerFactory {
    private static ArrayList m_mbeanServers = new ArrayList();
    static /* synthetic */ Class class$javax$management$MBeanServerFactory;

    private MBeanServerFactory() {
    }

    private static Logger getLogger() {
        return Log.getLogger((class$javax$management$MBeanServerFactory == null ? (class$javax$management$MBeanServerFactory = MBeanServerFactory.class$("javax.management.MBeanServerFactory")) : class$javax$management$MBeanServerFactory).getName());
    }

    public static MBeanServer createMBeanServer() {
        return MBeanServerFactory.createMBeanServer(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanServer createMBeanServer(String defaultDomain) {
        MBeanServer s = MBeanServerFactory.createMBeanServerImpl(defaultDomain, "createMBeanServer");
        ArrayList arrayList = m_mbeanServers;
        synchronized (arrayList) {
            m_mbeanServers.add(s);
        }
        Logger logger = MBeanServerFactory.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info("MBeanServer " + s + " registered successfully");
        }
        return s;
    }

    public static MBeanServer newMBeanServer() {
        return MBeanServerFactory.newMBeanServer(null);
    }

    public static MBeanServer newMBeanServer(String defaultDomain) {
        return MBeanServerFactory.createMBeanServerImpl(defaultDomain, "newMBeanServer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseMBeanServer(MBeanServer server) {
        block12: {
            Logger logger = MBeanServerFactory.getLogger();
            try {
                if (logger.isEnabledFor(20)) {
                    logger.info("Releasing MBeanServer " + server);
                }
                if (server != null) {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkPermission(new MBeanServerPermission("releaseMBeanServer"));
                    }
                    boolean removed = false;
                    ArrayList arrayList = m_mbeanServers;
                    synchronized (arrayList) {
                        removed = m_mbeanServers.remove(server);
                    }
                    if (removed) {
                        if (logger.isEnabledFor(20)) {
                            logger.info("MBeanServer " + server + " released successfully");
                        }
                    } else {
                        logger.warn("MBeanServer " + server + " not released, cannot find it");
                    }
                    break block12;
                }
                logger.warn("MBeanServer not released, it's null");
            }
            catch (SecurityException x) {
                if (logger.isEnabledFor(20)) {
                    logger.info("Security Exception caught while releasing MBeanServer " + server, x);
                }
                throw x;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList findMBeanServer(String id) {
        Logger logger = MBeanServerFactory.getLogger();
        ArrayList<MBeanServer> list = null;
        try {
            SecurityManager sm;
            if (logger.isEnabledFor(20)) {
                logger.info("Finding MBeanServer with ID: " + id);
            }
            if ((sm = System.getSecurityManager()) != null) {
                sm.checkPermission(new MBeanServerPermission("findMBeanServer"));
            }
            if (id == null) {
                list = (ArrayList<MBeanServer>)m_mbeanServers.clone();
            } else {
                list = new ArrayList<MBeanServer>();
                ArrayList arrayList = m_mbeanServers;
                synchronized (arrayList) {
                    int i = 0;
                    while (i < m_mbeanServers.size()) {
                        MBeanServer server = (MBeanServer)m_mbeanServers.get(i);
                        try {
                            String serverId = (String)server.getAttribute(new ObjectName("JMImplementation:type=MBeanServerDelegate"), "MBeanServerId");
                            if (id.equals(serverId)) {
                                list.add(server);
                                if (logger.isEnabledFor(10)) {
                                    logger.debug("Found matching MBeanServer: " + server);
                                }
                            }
                        }
                        catch (Exception ignored) {
                            logger.error("Delegate implementation is buggy", ignored);
                        }
                        ++i;
                    }
                }
            }
            if (logger.isEnabledFor(20)) {
                logger.info("MBeanServer(s) found: " + list);
            }
            return list;
        }
        catch (SecurityException x) {
            if (logger.isEnabledFor(20)) {
                logger.info("Security Exception caught while finding MBeanServer with ID: " + id, x);
            }
            throw x;
        }
    }

    public static ClassLoaderRepository getClassLoaderRepository(MBeanServer server) {
        if (server instanceof MBeanServerImpl) {
            return ((MBeanServerImpl)server).getClassLoaderRepository();
        }
        return MBeanServerImpl.getStaticClassLoaderRepository();
    }

    private static MBeanServer createMBeanServerImpl(String domain, String permission) {
        Logger logger = MBeanServerFactory.getLogger();
        try {
            SecurityManager sm;
            if (logger.isEnabledFor(20)) {
                logger.info("Creating MBeanServer...");
            }
            if ((sm = System.getSecurityManager()) != null) {
                sm.checkPermission(new MBeanServerPermission(permission));
            }
            MBeanServerImpl mbs = new MBeanServerImpl(domain);
            if (logger.isEnabledFor(20)) {
                logger.info("MBeanServer " + mbs + " created successfully");
            }
            return mbs;
        }
        catch (SecurityException x) {
            if (logger.isEnabledFor(20)) {
                logger.info("Security Exception caught while creating an MBeanServer", x);
            }
            throw x;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

