/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;

public class QualifiedTypeDeclarationPattern
extends TypeDeclarationPattern
implements IIndexConstants {
    public char[] qualification;
    public int packageIndex;

    public QualifiedTypeDeclarationPattern(char[] qualification, char[] simpleName, char typeSuffix, int matchRule) {
        this(matchRule);
        this.qualification = this.isCaseSensitive() ? qualification : CharOperation.toLowerCase(qualification);
        this.simpleName = this.isCaseSensitive() || this.isCamelCase() ? simpleName : CharOperation.toLowerCase(simpleName);
        this.typeSuffix = typeSuffix;
        this.mustResolve = this.qualification != null || typeSuffix != '\u0000';
    }

    QualifiedTypeDeclarationPattern(int matchRule) {
        super(matchRule);
    }

    public void decodeIndexKey(char[] key) {
        int slash = CharOperation.indexOf('/', key, 0);
        this.simpleName = CharOperation.subarray(key, 0, slash);
        int start = slash + 1;
        slash = CharOperation.indexOf('/', key, start);
        int secondSlash = CharOperation.indexOf('/', key, slash + 1);
        this.packageIndex = -1;
        if (start + 1 == secondSlash) {
            this.qualification = CharOperation.NO_CHAR;
        } else if (slash + 1 == secondSlash) {
            this.qualification = CharOperation.subarray(key, start, slash);
        } else if (slash == start) {
            this.qualification = CharOperation.subarray(key, slash + 1, secondSlash);
            this.packageIndex = 0;
        } else {
            this.qualification = CharOperation.subarray(key, start, secondSlash);
            this.packageIndex = slash - start;
            this.qualification[this.packageIndex] = 46;
        }
        int last = key.length - 1;
        boolean bl = this.secondary = key[last] == 'S';
        if (this.secondary) {
            last -= 2;
        }
        this.modifiers = key[last - 1] + (key[last] << 16);
        this.decodeModifiers();
    }

    public SearchPattern getBlankPattern() {
        return new QualifiedTypeDeclarationPattern(8);
    }

    public char[] getPackageName() {
        if (this.packageIndex == -1) {
            return this.qualification;
        }
        return internedPackageNames.add(CharOperation.subarray(this.qualification, 0, this.packageIndex));
    }

    public char[][] getEnclosingTypeNames() {
        if (this.packageIndex == -1) {
            return CharOperation.NO_CHAR_CHAR;
        }
        if (this.packageIndex == 0) {
            return CharOperation.splitOn('.', this.qualification);
        }
        char[] names = CharOperation.subarray(this.qualification, this.packageIndex + 1, this.qualification.length);
        return CharOperation.splitOn('.', names);
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        QualifiedTypeDeclarationPattern pattern = (QualifiedTypeDeclarationPattern)decodedPattern;
        block0 : switch (this.typeSuffix) {
            case 'C': {
                switch (pattern.typeSuffix) {
                    case '\t': 
                    case '\n': 
                    case 'C': {
                        break block0;
                    }
                }
                return false;
            }
            case 'I': {
                switch (pattern.typeSuffix) {
                    case '\n': 
                    case 'I': {
                        break block0;
                    }
                }
                return false;
            }
            case 'E': {
                switch (pattern.typeSuffix) {
                    case '\t': 
                    case 'E': {
                        break block0;
                    }
                }
                return false;
            }
            case 'A': {
                if (this.typeSuffix == pattern.typeSuffix) break;
                return false;
            }
            case '\n': {
                switch (pattern.typeSuffix) {
                    case '\n': 
                    case 'C': 
                    case 'I': {
                        break block0;
                    }
                }
                return false;
            }
            case '\t': {
                switch (pattern.typeSuffix) {
                    case '\t': 
                    case 'C': 
                    case 'E': {
                        break block0;
                    }
                }
                return false;
            }
        }
        return this.matchesName(this.simpleName, pattern.simpleName) && this.matchesName(this.qualification, pattern.qualification);
    }

    protected StringBuffer print(StringBuffer output) {
        switch (this.typeSuffix) {
            case 'C': {
                output.append("ClassDeclarationPattern: qualification<");
                break;
            }
            case '\n': {
                output.append("ClassAndInterfaceDeclarationPattern: qualification<");
                break;
            }
            case '\t': {
                output.append("ClassAndEnumDeclarationPattern: qualification<");
                break;
            }
            case 'I': {
                output.append("InterfaceDeclarationPattern: qualification<");
                break;
            }
            case 'E': {
                output.append("EnumDeclarationPattern: qualification<");
                break;
            }
            case 'A': {
                output.append("AnnotationTypeDeclarationPattern: qualification<");
                break;
            }
            default: {
                output.append("TypeDeclarationPattern: qualification<");
            }
        }
        if (this.qualification != null) {
            output.append(this.qualification);
        } else {
            output.append("*");
        }
        output.append(">, type<");
        if (this.simpleName != null) {
            output.append(this.simpleName);
        } else {
            output.append("*");
        }
        output.append("> ");
        return super.print(output);
    }
}

