/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.factories;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.internal.databinding.internal.ClassLookupSupport;
import org.eclipse.jface.internal.databinding.internal.Pair;
import org.eclipse.jface.internal.databinding.provisional.BindingException;
import org.eclipse.jface.internal.databinding.provisional.conversion.IConverter;
import org.eclipse.jface.internal.databinding.provisional.conversion.IdentityConverter;
import org.eclipse.jface.internal.databinding.provisional.factories.BindSupportFactory;
import org.eclipse.jface.internal.databinding.provisional.validation.IDomainValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.IValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.ReadOnlyValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.String2BigDecimalValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.String2ByteValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.String2DateValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.String2DoubleValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.String2FloatValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.String2IntValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.String2LongValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.String2ShortValidator;
import org.eclipse.jface.internal.databinding.provisional.validation.ValidationError;

public final class DefaultBindSupportFactory
extends BindSupportFactory {
    private ValidatorRegistry validatorRegistry = new ValidatorRegistry();
    private Map converterMap;

    public IValidator createValidator(Object fromType, Object toType) {
        if (fromType == null || toType == null) {
            return new IValidator(){

                public ValidationError isPartiallyValid(Object value) {
                    return null;
                }

                public ValidationError isValid(Object value) {
                    return null;
                }
            };
        }
        IValidator dataTypeValidator = this.findValidator(fromType, toType);
        if (dataTypeValidator == null) {
            throw new BindingException("No IValidator is registered for conversions from " + fromType + " to " + toType);
        }
        return dataTypeValidator;
    }

    private IValidator findValidator(Object fromType, Object toType) {
        return this.validatorRegistry.get(fromType, toType);
    }

    public IConverter createConverter(Object fromType, Object toType) {
        Class fromClass;
        if (!(fromType instanceof Class) || !(toType instanceof Class)) {
            return null;
        }
        Class toClass = (Class)toType;
        if (toClass.isPrimitive()) {
            toClass = this.autoboxed(toClass);
        }
        if ((fromClass = (Class)fromType).isPrimitive()) {
            fromClass = this.autoboxed(fromClass);
        }
        if (toClass.isAssignableFrom(fromClass)) {
            return new IdentityConverter(fromClass, toClass);
        }
        Map converterMap = this.getConverterMap();
        Class[] supertypeHierarchyFlattened = ClassLookupSupport.getTypeHierarchyFlattened(fromClass);
        int i = 0;
        while (i < supertypeHierarchyFlattened.length) {
            Class currentFromClass = supertypeHierarchyFlattened[i];
            if (currentFromClass == toType) {
                return new IdentityConverter(fromClass, toClass);
            }
            Pair key = new Pair(currentFromClass.getName(), toClass.getName());
            Object converterOrClassname = converterMap.get(key);
            if (converterOrClassname instanceof IConverter) {
                return (IConverter)converterOrClassname;
            }
            if (converterOrClassname instanceof String) {
                String classname = (String)converterOrClassname;
                try {
                    Class<?> converterClass = Class.forName(classname);
                    IConverter result = (IConverter)converterClass.newInstance();
                    converterMap.put(key, result);
                    return result;
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        if (fromClass.isAssignableFrom(toClass)) {
            return new IdentityConverter(fromClass, toClass);
        }
        return null;
    }

    private Map getConverterMap() {
        if (this.converterMap == null) {
            this.converterMap = new HashMap();
            this.converterMap.put(new Pair("java.util.Date", "java.lang.String"), "org.eclipse.jface.internal.databinding.provisional.conversion.ConvertDate2String");
            this.converterMap.put(new Pair("java.lang.String", "java.math.BigDecimal"), "org.eclipse.jface.internal.databinding.provisional.conversion.ConvertString2BigDecimal");
            this.converterMap.put(new Pair("java.lang.String", "java.lang.Boolean"), "org.eclipse.jface.internal.databinding.provisional.conversion.ConvertString2Boolean");
            this.converterMap.put(new Pair("java.lang.String", "java.lang.Byte"), "org.eclipse.jface.internal.databinding.provisional.conversion.ConvertString2Byte");
            this.converterMap.put(new Pair("java.lang.String", "java.lang.Character"), "org.eclipse.jface.internal.databinding.provisional.conversion.ConvertString2Character");
            this.converterMap.put(new Pair("java.lang.String", "java.util.Date"), "org.eclipse.jface.internal.databinding.provisional.conversion.ConvertString2Date");
            this.converterMap.put(new Pair("java.lang.String", "java.lang.Double"), "org.eclipse.jface.internal.databinding.provisional.conversion.ConvertString2Double");
            this.converterMap.put(new Pair("java.lang.String", "java.lang.Float"), "org.eclipse.jface.internal.databinding.provisional.conversion.ConvertString2Float");
            this.converterMap.put(new Pair("java.lang.String", "java.lang.Integer"), "org.eclipse.jface.internal.databinding.provisional.conversion.ConvertString2Integer");
            this.converterMap.put(new Pair("java.lang.String", "java.lang.Long"), "org.eclipse.jface.internal.databinding.provisional.conversion.ConvertString2Long");
            this.converterMap.put(new Pair("java.lang.String", "java.lang.Short"), "org.eclipse.jface.internal.databinding.provisional.conversion.ConvertString2Short");
            this.converterMap.put(new Pair("java.lang.Object", "java.lang.String"), "org.eclipse.jface.internal.databinding.provisional.conversion.ToStringConverter");
        }
        return this.converterMap;
    }

    public IDomainValidator createDomainValidator(Object modelType) {
        return new IDomainValidator(){

            public ValidationError isValid(Object value) {
                return null;
            }
        };
    }

    public Boolean isAssignableFromTo(Object fromType, Object toType) {
        if (fromType instanceof Class && toType instanceof Class) {
            Class fromClass;
            Class toClass = (Class)toType;
            if (toClass.isPrimitive()) {
                toClass = this.autoboxed(toClass);
            }
            if ((fromClass = (Class)fromType).isPrimitive()) {
                fromClass = this.autoboxed(fromClass);
            }
            return toClass.isAssignableFrom(fromClass);
        }
        return null;
    }

    private Class autoboxed(Class clazz) {
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        return clazz;
    }

    private static class ValidatorRegistry {
        private HashMap validators = new HashMap();

        private void associate(Object fromClass, Object toClass, IValidator validator) {
            this.validators.put(new Pair(fromClass, toClass), validator);
        }

        private IValidator get(Object fromClass, Object toClass) {
            IValidator result = (IValidator)this.validators.get(new Pair(fromClass, toClass));
            if (result != null) {
                return result;
            }
            if (fromClass != null && toClass != null && fromClass == toClass) {
                return new IValidator(){

                    public ValidationError isPartiallyValid(Object value) {
                        return null;
                    }

                    public ValidationError isValid(Object value) {
                        return null;
                    }
                };
            }
            return ReadOnlyValidator.getDefault();
        }

        private ValidatorRegistry() {
            this.associate(String.class, Integer.TYPE, new String2IntValidator());
            this.associate(String.class, Byte.TYPE, new String2ByteValidator());
            this.associate(String.class, Short.TYPE, new String2ShortValidator());
            this.associate(String.class, Long.TYPE, new String2LongValidator());
            this.associate(String.class, Float.TYPE, new String2FloatValidator());
            this.associate(String.class, Double.TYPE, new String2DoubleValidator());
            this.associate(String.class, Integer.class, new String2IntValidator());
            this.associate(String.class, Byte.class, new String2ByteValidator());
            this.associate(String.class, Short.class, new String2ShortValidator());
            this.associate(String.class, Long.class, new String2LongValidator());
            this.associate(String.class, Float.class, new String2FloatValidator());
            this.associate(String.class, Double.class, new String2DoubleValidator());
            this.associate(String.class, Date.class, new String2DateValidator());
            this.associate(String.class, BigDecimal.class, new String2BigDecimalValidator());
        }
    }
}

