/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.server.internal.ui.wizards.NewConnectionWizard;


/**
 * @author ljulien
 */
public class AddConnectionAction extends AbstractAction
{
    private ISelection selection;
	
    protected void setSelection(ISelection selection)
    {
        this.selection = selection;
    }

    protected ISelection getSelection()
    {
        return this.selection;
    }

    public void run(IAction action)
    {
        ConnectionInfo [] infos = RDBCorePlugin.getDefault().getConnectionManager().getAllNamedConnectionInfo();
        List nameList = new ArrayList (infos.length);
        for (int i = 0, n = infos.length; i < n; i++)
        {
            if (!nameList.contains(infos[i].getName()))
            {
                nameList.add(infos[i].getName().toLowerCase());
            }
        }
        String [] names = (String []) nameList.toArray(new String [nameList.size()]);       

        NewConnectionWizard wizard = new NewConnectionWizard(null, true);

        wizard.setExistingConnectionNames (Arrays.asList(names));
        wizard.init(PlatformUI.getWorkbench(), null);
        wizard.setNeedsProgressMonitor(true);
        
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), wizard);
        dialog.create();
        dialog.open();
    }
}
