/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.web.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.eclipse.wst.common.componentcore.internal.ModuleMigratorManager;

public final class ModuleCoreValidatorMarkerResolutions
implements IMarkerResolutionGenerator {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        return new IMarkerResolution[]{new ModuleCoreMigrationResolution(marker)};
    }

    private class ModuleCoreMigrationResolution
    extends WorkbenchMarkerResolution
    implements IMarkerResolution,
    IMarkerResolution2 {
        private final IMarker theMarker;
        private final String MARKERTYPE = "org.eclipse.wst.common.modulecore.ModuleCoreValidatorMarker";
        private final IMarker[] NO_MARKERS = new IMarker[0];

        public ModuleCoreMigrationResolution(IMarker marker) {
            this.theMarker = marker;
        }

        public String getLabel() {
            return Resources.migrateMetaData;
        }

        public void run(IMarker marker) {
            IProject proj = marker.getResource().getProject();
            try {
                ModuleMigratorManager manager = ModuleMigratorManager.getManager((IProject)proj);
                if (!manager.isMigrating() && !ResourcesPlugin.getWorkspace().isTreeLocked()) {
                    manager.migrateOldMetaData(proj, true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String getDescription() {
            return Resources.migrateMetaData;
        }

        public Image getImage() {
            return null;
        }

        public IMarker[] findOtherMarkers(IMarker[] markers) {
            ArrayList<IMarker> marks = new ArrayList<IMarker>();
            int i = 0;
            while (i < markers.length) {
                IMarker marker = markers[i];
                try {
                    if (marker.getType().equals("org.eclipse.wst.common.modulecore.ModuleCoreValidatorMarker") && !marker.equals((Object)this.theMarker)) {
                        marks.add(marker);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            return marks.toArray(new IMarker[marks.size()]);
        }
    }

    private static final class Resources
    extends NLS {
        public static String migrateMetaData;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.web.ui.internal.ModuleCoreValidatorMarkerResolutions");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.web.ui.internal.ModuleCoreValidatorMarkerResolutions$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        private Resources() {
        }
    }
}

