/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsController;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsControllerManager;
import org.eclipse.jst.j2ee.internal.project.WTPJETEmitter;
import org.eclipse.jst.j2ee.internal.web.operations.CreateServletTemplateModel;
import org.eclipse.jst.j2ee.internal.web.plugin.WebPlugin;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.FacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.operation.ArtifactEditProviderOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.WFTWrappedException;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class NewServletClassOperation
extends ArtifactEditProviderOperation {
    private static final String JST_WEB_XDOCLET_VERSION = "1.2.3";
    private static final String JST_WEB_XDOCLET = "jst.web.xdoclet";
    private static final String DOT_JAVA = ".java";
    protected static final String WEB_PLUGIN = "WEB_PLUGIN";
    protected static final String TEMPLATE_DIR = "/templates/";
    protected static final String TEMPLATE_EMITTER = "org.eclipse.jst.j2ee.ejb.annotations.emitter.template";
    protected static final String BUILDER_ID = "builderId";

    public NewServletClassOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.createJavaSourceFolder();
        IPackageFragment pack = this.createJavaPackage();
        try {
            this.generateUsingTemplates(monitor, pack);
        }
        catch (Exception e) {
            return WTPCommonPlugin.createErrorStatus((String)e.toString());
        }
        return OK_STATUS;
    }

    protected final IPackageFragment createJavaPackage() {
        String packageName = this.model.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE");
        IPackageFragmentRoot packRoot = (IPackageFragmentRoot)this.model.getProperty("NewJavaClassDataModel.JAVA_PACKAGE_FRAGMENT_ROOT");
        IPackageFragment pack = packRoot.getPackageFragment(packageName);
        if (pack == null) {
            pack = packRoot.getPackageFragment("");
        }
        if (!pack.exists()) {
            String packName = pack.getElementName();
            try {
                pack = packRoot.createPackageFragment(packName, true, null);
            }
            catch (JavaModelException e) {
                Logger.getLogger().log((Throwable)e);
            }
        }
        return pack;
    }

    protected void generateUsingTemplates(IProgressMonitor monitor, IPackageFragment fragment) throws WFTWrappedException, CoreException {
        String source;
        CreateServletTemplateModel tempModel = this.createTemplateModel();
        IProject project = this.getTargetProject();
        try {
            source = this.generateTemplateSource(tempModel, monitor);
        }
        catch (Exception e) {
            throw new WFTWrappedException((Throwable)e);
        }
        if (fragment != null) {
            String javaFileName = String.valueOf(tempModel.getServletClassName()) + DOT_JAVA;
            ICompilationUnit cu = fragment.getCompilationUnit(javaFileName);
            if (cu == null || !cu.exists()) {
                cu = fragment.createCompilationUnit(javaFileName, source, true, monitor);
            }
            IFile aFile = (IFile)cu.getResource();
            AnnotationsController controller = AnnotationsControllerManager.INSTANCE.getAnnotationsController(project);
            if (controller != null) {
                controller.process((IResource)aFile);
            }
        }
        try {
            this.installXDocletFacetIfNecessary(monitor, project);
        }
        catch (Exception e) {
            throw new WFTWrappedException((Throwable)e);
        }
    }

    private void installXDocletFacet(IProgressMonitor monitor, IProject project) throws CoreException, ExecutionException {
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        Set fixedFacets = facetedProject.getFixedProjectFacets();
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new FacetInstallDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_ID", (Object)JST_WEB_XDOCLET);
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)project.getName());
        dm.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)JST_WEB_XDOCLET_VERSION);
        IDataModel fdm = DataModelFactory.createDataModel((IDataModelProvider)new FacetProjectCreationDataModelProvider());
        fdm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)project.getName());
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)fdm.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        map.add(dm);
        fdm.getDefaultOperation().execute(monitor, null);
        facetedProject.setFixedProjectFacets(fixedFacets);
    }

    private void installXDocletFacetIfNecessary(IProgressMonitor monitor, IProject project) throws CoreException, ExecutionException {
        if (!this.model.getBooleanProperty("IAnnotationsDataModel.useAnnotations")) {
            return;
        }
        AnnotationsControllerManager.Descriptor descriptor = AnnotationsControllerManager.INSTANCE.getDescriptor(this.getTargetComponent().getProject());
        if (descriptor != null) {
            return;
        }
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        Set facets = facetedProject.getProjectFacets();
        Iterator iter = facets.iterator();
        while (iter.hasNext()) {
            IProjectFacetVersion facetVersion = (IProjectFacetVersion)iter.next();
            String facetID = facetVersion.getProjectFacet().getId();
            if (!JST_WEB_XDOCLET.equals(facetID)) continue;
            return;
        }
        this.installXDocletFacet(monitor, project);
    }

    private String generateTemplateSource(CreateServletTemplateModel tempModel, IProgressMonitor monitor) throws JETException {
        URL templateURL = null;
        templateURL = this.model.getBooleanProperty("IAnnotationsDataModel.useAnnotations") ? WebPlugin.getDefault().find((IPath)new Path(TEMPLATE_DIR + this.getDataModel().getStringProperty("NewServletClassDataModel.TEMPLATE_FILE"))) : WebPlugin.getDefault().find((IPath)new Path(TEMPLATE_DIR + this.getDataModel().getStringProperty("NewServletClassDataModel.NON_ANNOTATED_TEMPLATE_FILE")));
        this.cleanUpOldEmitterProject();
        WTPJETEmitter emitter = new WTPJETEmitter(templateURL.toString(), ((Object)((Object)this)).getClass().getClassLoader());
        emitter.setIntelligentLinkingEnabled(true);
        emitter.addVariable(WEB_PLUGIN, "org.eclipse.jst.j2ee.web");
        return emitter.generate(monitor, new Object[]{tempModel});
    }

    private void cleanUpOldEmitterProject() {
        IProject project = ProjectUtilities.getProject((String)".JETEmitters");
        if (project == null || !project.exists()) {
            return;
        }
        try {
            IMarker[] markers = project.findMarkers("org.eclipse.jdt.core.buildpath_problem", false, 0);
            int i = 0;
            int l = markers.length;
            while (i < l) {
                if ((Integer)markers[i].getAttribute("severity") == 2) {
                    project.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CreateServletTemplateModel createTemplateModel() {
        CreateServletTemplateModel templateModel = new CreateServletTemplateModel(this.model);
        return templateModel;
    }

    protected final IFolder createJavaSourceFolder() {
        String folderFullPath = this.model.getStringProperty("NewJavaClassDataModel.SOURCE_FOLDER");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFolder folder = root.getFolder((IPath)new Path(folderFullPath));
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                Logger.getLogger().log((Throwable)e);
            }
        }
        return folder;
    }
}

