/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.IVersion;
import org.eclipse.wst.common.project.facet.core.internal.ProjectFacetsManagerImpl;
import org.eclipse.wst.common.project.facet.core.internal.VersionExpr;

public final class ProjectFacetRef {
    private static final String ATTR_ID = "id";
    private static final String ATTR_VERSION = "version";
    private final IProjectFacet f;
    private final VersionExpr vexpr;

    public ProjectFacetRef(IProjectFacet f, VersionExpr vexpr) {
        this.f = f;
        this.vexpr = vexpr;
    }

    public boolean check(Set facets) throws CoreException {
        Iterator itr = facets.iterator();
        while (itr.hasNext()) {
            IProjectFacetVersion fv = (IProjectFacetVersion)itr.next();
            if (this.f != fv.getProjectFacet()) continue;
            if (this.vexpr != null) {
                return this.vexpr.evaluate((IVersion)((Object)fv));
            }
            return true;
        }
        return false;
    }

    public static ProjectFacetRef read(IConfigurationElement config) {
        String id = config.getAttribute(ATTR_ID);
        if (id == null) {
            ProjectFacetsManagerImpl.reportMissingAttribute(config, ATTR_ID);
            return null;
        }
        if (!ProjectFacetsManager.isProjectFacetDefined(id)) {
            ProjectFacetsManagerImpl.reportMissingFacet(id, config.getContributor().getName());
            return null;
        }
        IProjectFacet f = ProjectFacetsManager.getProjectFacet(id);
        String v = config.getAttribute(ATTR_VERSION);
        VersionExpr vexpr = null;
        if (v != null) {
            try {
                vexpr = new VersionExpr(f, v, config.getContributor().getName());
            }
            catch (CoreException e) {
                FacetCorePlugin.log(e.getStatus());
                return null;
            }
        }
        return new ProjectFacetRef(f, vexpr);
    }

    public String toString() {
        if (this.vexpr == null) {
            return this.f.getLabel();
        }
        if (this.vexpr.isSingleVersionMatch()) {
            return NLS.bind((String)Resources.exactVersion, (Object)this.f.getLabel(), (Object)this.vexpr.toString());
        }
        if (this.vexpr.isSimpleAllowNewer()) {
            return NLS.bind((String)Resources.allowNewer, (Object)this.f.getLabel(), (Object)this.vexpr.getFirstVersion());
        }
        if (this.vexpr.isWildcard()) {
            return NLS.bind((String)Resources.wildcard, (Object)this.f.getLabel());
        }
        return NLS.bind((String)Resources.versionExpr, (Object)this.f.getLabel(), (Object)this.vexpr.toString());
    }

    private static final class Resources
    extends NLS {
        public static String exactVersion;
        public static String allowNewer;
        public static String wildcard;
        public static String versionExpr;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.ProjectFacetRef");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.ProjectFacetRef$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        private Resources() {
        }
    }
}

