/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.application.internal.operations.ClassPathSelection;
import org.eclipse.jst.j2ee.application.internal.operations.ClasspathElement;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.frameworks.internal.ui.OverlayIcon;

public class AvailableJarsProvider
implements IStructuredContentProvider,
ITableLabelProvider {
    protected static Image utilImage;
    protected static Image invalidImage;
    protected static Image ejbImage;
    protected static Image ejbClientImage;

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex > 0) {
            return null;
        }
        ClasspathElement cp = (ClasspathElement)element;
        if (!cp.isValid()) {
            return AvailableJarsProvider.getInvalidImage();
        }
        switch (cp.getJarType()) {
            case 1: {
                return AvailableJarsProvider.getEjbImage();
            }
            case 2: {
                return AvailableJarsProvider.getEjbClientImage();
            }
        }
        return AvailableJarsProvider.getUtilImage();
    }

    public String getColumnText(Object element, int columnIndex) {
        String value = null;
        switch (columnIndex) {
            case 0: {
                value = ((ClasspathElement)element).getText();
                break;
            }
            case 1: {
                value = ((ClasspathElement)element).getProjectName();
            }
        }
        return value == null ? "" : value;
    }

    protected static Image getEjbImage() {
        if (ejbImage == null) {
            ejbImage = AvailableJarsProvider.getImageDescriptor("EJBJar").createImage();
        }
        return ejbImage;
    }

    protected static Image getEjbClientImage() {
        if (ejbClientImage == null) {
            ejbClientImage = AvailableJarsProvider.getImageDescriptor("ejbclientjar_obj").createImage();
        }
        return ejbClientImage;
    }

    public Object[] getElements(Object inputElement) {
        ClassPathSelection selection = (ClassPathSelection)inputElement;
        return this.filter(selection, selection.getFilterLevel()).toArray();
    }

    /*
     * Enabled aggressive block sorting
     */
    private List filter(ClassPathSelection selection, int filterLevel) {
        List list = selection.getClasspathElements();
        ArrayList<ClasspathElement> result = new ArrayList<ClasspathElement>(list.size());
        int i = 0;
        while (i < list.size()) {
            block6: {
                ClasspathElement element;
                block5: {
                    element = (ClasspathElement)list.get(i);
                    if (element.isSelected()) break block5;
                    switch (filterLevel) {
                        case 1: {
                            if (!element.isEJBClientJar()) break;
                            break block6;
                        }
                        case 0: {
                            if (element.isEJBJar() && selection.getOppositeElement(element) != null) break block6;
                        }
                    }
                }
                result.add(element);
            }
            ++i;
        }
        return result;
    }

    protected static ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = null;
        URL gifImageURL = (URL)J2EEPlugin.getPlugin().getImage(key);
        imageDescriptor = ImageDescriptor.createFromURL((URL)gifImageURL);
        return imageDescriptor;
    }

    protected static Image getInvalidImage() {
        if (invalidImage == null) {
            ImageDescriptor base = AvailableJarsProvider.getImageDescriptor("jar_nonexist_obj");
            ImageDescriptor overlay = AvailableJarsProvider.getImageDescriptor("warning_co");
            invalidImage = new OverlayIcon(base, (ImageDescriptor[][])new ImageDescriptor[][]{{overlay}}).createImage();
        }
        return invalidImage;
    }

    public static Image getUtilImage() {
        if (utilImage == null) {
            utilImage = AvailableJarsProvider.getImageDescriptor("jar_obj").createImage();
        }
        return utilImage;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

