/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.ui.internal.viewers;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.internet.monitor.ui.internal.MonitorUIPlugin;
import org.eclipse.wst.internet.monitor.ui.internal.provisional.ContentViewer;

public class ByteViewer
extends ContentViewer {
    protected Text text;

    public void init(Composite parent) {
        this.text = new Text(parent, 2826);
        Display display = parent.getDisplay();
        this.text.setBackground(display.getSystemColor(25));
        this.text.setForeground(display.getSystemColor(24));
        this.text.setLayoutData((Object)new GridData(1808));
        this.text.setFont(JFaceResources.getTextFont());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.text, "org.eclipse.wst.internet.monitor.ui.tmvw0006");
    }

    public void setEditable(boolean editable) {
        this.text.setEditable(editable);
    }

    public byte[] getContent() {
        if (this.text == null) {
            return new byte[0];
        }
        String content = this.text.getText().trim();
        if (content.equals("")) {
            return new byte[0];
        }
        byte[] twoNewlines = new byte[]{13, 10};
        byte[] contentBytes = content.getBytes();
        byte[] retBytes = new byte[contentBytes.length + 2];
        System.arraycopy(contentBytes, 0, retBytes, 0, contentBytes.length);
        System.arraycopy(twoNewlines, 0, retBytes, contentBytes.length, 2);
        return retBytes;
    }

    public void setContent(byte[] b) {
        String out = "";
        if (b != null) {
            b = MonitorUIPlugin.unzip(b);
            out = MonitorUIPlugin.parse(b);
        }
        String lineSeparator = System.getProperty("line.separator");
        int ls = lineSeparator.length();
        if (out.length() > ls) {
            while (out.substring(0, ls).indexOf(lineSeparator) >= 0) {
                out = out.substring(ls, out.length());
            }
        }
        this.text.setText(out);
    }

    public void dispose() {
        this.text.dispose();
        this.text = null;
    }
}

