/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.builder;

import java.util.Iterator;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.jruby.ast.ClassNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.DefnNode;
import org.jruby.ast.IScopingNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.INameNode;
import org.rubypeople.rdt.internal.core.symbols.ClassSymbol;
import org.rubypeople.rdt.internal.core.symbols.MethodSymbol;
import org.rubypeople.rdt.internal.core.symbols.SymbolIndex;

public class IndexUpdater {
    private final SymbolIndex index;
    private Stack scopeStack = new Stack();

    public IndexUpdater(SymbolIndex symbolIndex) {
        this.index = symbolIndex;
    }

    public void update(IFile iFile, Node node, boolean bl) {
        if (!bl) {
            this.index.flush(iFile);
        }
        this.processNode(iFile, node);
    }

    private void processNode(IFile iFile, Node node) {
        String string;
        Object object;
        if (node == null) {
            return;
        }
        if (this.isScopingNode(node)) {
            object = (IScopingNode)node;
            string = this.getFullyQualifiedName((IScopingNode)object);
            this.scopeStack.push(object.getCPath().getName());
            if (node instanceof ClassNode) {
                this.index.add(new ClassSymbol(string), iFile, object.getCPath().getPosition());
            }
        }
        if (node instanceof DefnNode) {
            object = (DefnNode)node;
            string = String.valueOf(this.getContext()) + object.getName();
            this.index.add(new MethodSymbol(string), iFile, object.getNameNode().getPosition());
        }
        object = node.childNodes().iterator();
        while (object.hasNext()) {
            string = (Node)object.next();
            this.processNode(iFile, (Node)string);
        }
        if (this.isScopingNode(node)) {
            this.scopeStack.pop();
        }
    }

    private boolean isScopingNode(Node node) {
        return node instanceof IScopingNode;
    }

    private String getFullyQualifiedName(IScopingNode iScopingNode) {
        Colon2Node colon2Node = iScopingNode.getCPath();
        return String.valueOf(this.getContext()) + this.assembleQualifiedName((INameNode)colon2Node);
    }

    private String getContext() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.scopeStack.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(string);
            stringBuffer.append("::");
        }
        return stringBuffer.toString();
    }

    private String assembleQualifiedName(INameNode iNameNode) {
        Colon2Node colon2Node;
        INameNode iNameNode2;
        String string = "";
        if (iNameNode instanceof Colon2Node && (iNameNode2 = (INameNode)(colon2Node = (Colon2Node)iNameNode).getLeftNode()) != null) {
            string = String.valueOf(string) + this.assembleQualifiedName(iNameNode2) + "::";
        }
        return String.valueOf(string) + iNameNode.getName();
    }
}

