/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.HashSet;
import java.util.Iterator;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.Openable;
import org.rubypeople.rdt.internal.core.RubyElementInfo;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyProject;

public class ModelUpdater {
    HashSet projectsToUpdate = new HashSet();

    protected void addToParentInfo(Openable openable) {
        Openable openable2 = (Openable)openable.getParent();
        if (openable2 != null && openable2.isOpen()) {
            try {
                RubyElementInfo rubyElementInfo = (RubyElementInfo)openable2.getElementInfo();
                rubyElementInfo.addChild(openable);
            }
            catch (RubyModelException rubyModelException) {}
        }
    }

    protected static void close(Openable openable) {
        try {
            openable.close();
        }
        catch (RubyModelException rubyModelException) {}
    }

    protected void elementAdded(Openable openable) {
        int n = openable.getElementType();
        if (n == 1) {
            this.addToParentInfo(openable);
            this.projectsToUpdate.add(openable);
        } else {
            this.addToParentInfo(openable);
            ModelUpdater.close(openable);
        }
    }

    protected void elementChanged(Openable openable) {
        ModelUpdater.close(openable);
    }

    protected void elementRemoved(Openable openable) {
        if (openable.isOpen()) {
            ModelUpdater.close(openable);
        }
        this.removeFromParentInfo(openable);
        int n = openable.getElementType();
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                RubyModelManager.getRubyModelManager().removePerProjectInfo((RubyProject)openable);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processRubyDelta(IRubyElementDelta iRubyElementDelta) {
        try {
            this.traverseDelta(iRubyElementDelta, null);
            Iterator iterator = this.projectsToUpdate.iterator();
            while (iterator.hasNext()) {
                RubyProject cfr_ignored_0 = (RubyProject)iterator.next();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.projectsToUpdate = new HashSet();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.projectsToUpdate = new HashSet();
            return;
        }
    }

    protected void removeFromParentInfo(Openable openable) {
        Openable openable2 = (Openable)openable.getParent();
        if (openable2 != null && openable2.isOpen()) {
            try {
                RubyElementInfo rubyElementInfo = (RubyElementInfo)openable2.getElementInfo();
                rubyElementInfo.removeChild(openable);
            }
            catch (RubyModelException rubyModelException) {}
        }
    }

    protected void traverseDelta(IRubyElementDelta iRubyElementDelta, IRubyProject iRubyProject) {
        IRubyElementDelta[] iRubyElementDeltaArray;
        boolean bl = true;
        Openable openable = (Openable)iRubyElementDelta.getElement();
        switch (openable.getElementType()) {
            case 1: {
                iRubyProject = (IRubyProject)((Object)openable);
                break;
            }
            case 2: {
                iRubyElementDeltaArray = (IRubyElementDelta[])openable;
                if (!iRubyElementDeltaArray.isWorkingCopy() || iRubyElementDeltaArray.isPrimary()) break;
                return;
            }
        }
        switch (iRubyElementDelta.getKind()) {
            case 1: {
                this.elementAdded(openable);
                break;
            }
            case 2: {
                this.elementRemoved(openable);
                break;
            }
            case 4: {
                if ((iRubyElementDelta.getFlags() & 1) == 0) break;
                this.elementChanged(openable);
            }
        }
        if (bl) {
            iRubyElementDeltaArray = iRubyElementDelta.getAffectedChildren();
            int n = 0;
            while (n < iRubyElementDeltaArray.length) {
                IRubyElementDelta iRubyElementDelta2 = iRubyElementDeltaArray[n];
                this.traverseDelta(iRubyElementDelta2, iRubyProject);
                ++n;
            }
        }
    }
}

