/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.report;

import fr.jayasoft.ivy.IvyNode;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.filter.Filter;
import fr.jayasoft.ivy.report.ArtifactDownloadReport;
import fr.jayasoft.ivy.report.ConfigurationResolveReport;
import fr.jayasoft.ivy.report.ReportOutputter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ResolveReport {
    private ModuleDescriptor _md;
    private Map _confReports = new LinkedHashMap();
    private List _problemMessages;
    private List _dependencies;
    private List _artifacts;
    private long _resolveTime;
    private long _downloadTime;

    public ResolveReport(ModuleDescriptor md) {
        this._md = md;
    }

    public void addReport(String conf, ConfigurationResolveReport report) {
        this._confReports.put(conf, report);
    }

    public ConfigurationResolveReport getConfigurationReport(String conf) {
        return (ConfigurationResolveReport)this._confReports.get(conf);
    }

    public String[] getConfigurations() {
        return this._confReports.keySet().toArray(new String[this._confReports.size()]);
    }

    public boolean hasError() {
        boolean hasError;
        ConfigurationResolveReport report;
        Iterator it = this._confReports.values().iterator();
        for (hasError = false; it.hasNext() && !hasError; hasError |= report.hasError()) {
            report = (ConfigurationResolveReport)it.next();
        }
        return hasError;
    }

    public void output(ReportOutputter[] outputters, File cache) {
        for (int i = 0; i < outputters.length; ++i) {
            outputters[i].output(this, cache);
        }
    }

    public ModuleDescriptor getModuleDescriptor() {
        return this._md;
    }

    public IvyNode[] getEvictedNodes() {
        HashSet<IvyNode> all = new HashSet<IvyNode>();
        Iterator iter = this._confReports.values().iterator();
        while (iter.hasNext()) {
            ConfigurationResolveReport report = (ConfigurationResolveReport)iter.next();
            all.addAll(Arrays.asList(report.getEvictedNodes()));
        }
        return all.toArray(new IvyNode[all.size()]);
    }

    public IvyNode[] getUnresolvedDependencies() {
        HashSet<IvyNode> all = new HashSet<IvyNode>();
        Iterator iter = this._confReports.values().iterator();
        while (iter.hasNext()) {
            ConfigurationResolveReport report = (ConfigurationResolveReport)iter.next();
            all.addAll(Arrays.asList(report.getUnresolvedDependencies()));
        }
        return all.toArray(new IvyNode[all.size()]);
    }

    public ArtifactDownloadReport[] getFailedArtifactsReports() {
        HashSet<ArtifactDownloadReport> all = new HashSet<ArtifactDownloadReport>();
        Iterator iter = this._confReports.values().iterator();
        while (iter.hasNext()) {
            ConfigurationResolveReport report = (ConfigurationResolveReport)iter.next();
            all.addAll(Arrays.asList(report.getFailedArtifactsReports()));
        }
        return all.toArray(new ArtifactDownloadReport[all.size()]);
    }

    public boolean hasChanged() {
        Iterator iter = this._confReports.values().iterator();
        while (iter.hasNext()) {
            ConfigurationResolveReport report = (ConfigurationResolveReport)iter.next();
            if (!report.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public void setProblemMessages(List problems) {
        this._problemMessages = problems;
    }

    public List getProblemMessages() {
        return this._problemMessages;
    }

    public List getAllProblemMessages() {
        ArrayList<String> ret = new ArrayList<String>(this._problemMessages);
        Iterator iter = this._confReports.values().iterator();
        while (iter.hasNext()) {
            ConfigurationResolveReport r = (ConfigurationResolveReport)iter.next();
            IvyNode[] unresolved = r.getUnresolvedDependencies();
            for (int i = 0; i < unresolved.length; ++i) {
                Exception e = unresolved[i].getProblem();
                if (e != null) {
                    String errMsg;
                    String string = errMsg = e instanceof RuntimeException ? e.getMessage() : e.toString();
                    if (errMsg == null || errMsg.length() == 0 || "null".equals(errMsg)) {
                        errMsg = e.getClass().getName() + " at " + e.getStackTrace()[0].toString();
                    }
                    ret.add("unresolved dependency: " + unresolved[i].getId() + ": " + errMsg);
                    continue;
                }
                ret.add("unresolved dependency: " + unresolved[i].getId());
            }
            ArtifactDownloadReport[] adrs = r.getFailedArtifactsReports();
            for (int i = 0; i < adrs.length; ++i) {
                ret.add("download failed: " + adrs[i].getArtifact());
            }
        }
        return ret;
    }

    public void setDependencies(List dependencies, Filter artifactFilter) {
        this._dependencies = dependencies;
        this._artifacts = new ArrayList();
        Iterator iter = dependencies.iterator();
        while (iter.hasNext()) {
            IvyNode dependency = (IvyNode)iter.next();
            if (!dependency.isCompletelyEvicted() && !dependency.hasProblem()) {
                this._artifacts.addAll(Arrays.asList(dependency.getSelectedArtifacts(artifactFilter)));
            }
            String[] dconfs = dependency.getRootModuleConfigurations();
            for (int j = 0; j < dconfs.length; ++j) {
                ConfigurationResolveReport configurationReport = this.getConfigurationReport(dconfs[j]);
                if (configurationReport == null) continue;
                configurationReport.addDependency(dependency);
            }
        }
    }

    public List getDependencies() {
        return this._dependencies;
    }

    public List getArtifacts() {
        return this._artifacts;
    }

    public List getModuleIds() {
        ArrayList<ModuleId> ret = new ArrayList<ModuleId>();
        ArrayList sortedDependencies = new ArrayList(this._dependencies);
        Iterator iter = sortedDependencies.iterator();
        while (iter.hasNext()) {
            IvyNode dependency = (IvyNode)iter.next();
            ModuleId mid = dependency.getResolvedId().getModuleId();
            if (ret.contains(mid)) continue;
            ret.add(mid);
        }
        return ret;
    }

    public void setResolveTime(long elapsedTime) {
        this._resolveTime = elapsedTime;
    }

    public long getResolveTime() {
        return this._resolveTime;
    }

    public void setDownloadTime(long elapsedTime) {
        this._downloadTime = elapsedTime;
    }

    public long getDownloadTime() {
        return this._downloadTime;
    }
}

