/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class InefficientToArray
extends BytecodeScanningDetector
implements StatelessDetector {
    private static final boolean DEBUG = SystemProperties.getBoolean((String)"ita.debug");
    static final int SEEN_NOTHING = 0;
    static final int SEEN_ICONST_0 = 1;
    static final int SEEN_ANEWARRAY = 2;
    private static final JavaClass collectionClass;
    private BugReporter bugReporter;
    private int state = 0;

    public InefficientToArray(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        if (collectionClass != null) {
            classContext.getJavaClass().accept((Visitor)this);
        }
    }

    public void visit(Method obj) {
        if (DEBUG) {
            System.out.println("------------------- Analyzing " + obj.getName() + " ----------------");
        }
        this.state = 0;
        super.visit(obj);
    }

    public void sawOpcode(int seen) {
        if (DEBUG) {
            System.out.println("State: " + this.state + "  Opcode: " + OPCODE_NAMES[seen]);
        }
        switch (this.state) {
            case 0: {
                if (seen != 3) break;
                this.state = 1;
                break;
            }
            case 1: {
                if (seen == 189) {
                    this.state = 2;
                    break;
                }
                this.state = 0;
                break;
            }
            case 2: {
                if ((seen == 182 || seen == 185) && this.getNameConstantOperand().equals("toArray") && this.getSigConstantOperand().equals("([Ljava/lang/Object;)[Ljava/lang/Object;")) {
                    try {
                        String clsName = this.getDottedClassConstantOperand();
                        JavaClass cls = Repository.lookupClass((String)clsName);
                        if (cls.implementationOf(collectionClass)) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "ITA_INEFFICIENT_TO_ARRAY", 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        }
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.bugReporter.reportMissingClass(cnfe);
                    }
                }
                this.state = 0;
                break;
            }
            default: {
                this.state = 0;
            }
        }
    }

    static {
        JavaClass tmp = null;
        try {
            tmp = AnalysisContext.lookupSystemClass((String)"java.util.Collection");
        }
        catch (ClassNotFoundException cnfe) {
            AnalysisContext.reportMissingClass((ClassNotFoundException)cnfe);
        }
        collectionClass = tmp;
    }
}

