/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.AbstractField;
import edu.umd.cs.findbugs.ba.AbstractMethod;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassMember;
import edu.umd.cs.findbugs.ba.InstanceField;
import edu.umd.cs.findbugs.ba.InstanceMethod;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.StaticField;
import edu.umd.cs.findbugs.ba.StaticMethod;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XFactory {
    private Map<XMethod, XMethod> methods = new HashMap<XMethod, XMethod>();
    private Set<ClassMember> deprecated = new HashSet<ClassMember>();
    private Set<? extends ClassMember> deprecatedView = Collections.unmodifiableSet(this.deprecated);
    private Map<XField, XField> fields = new HashMap<XField, XField>();
    private Set<XMethod> methodsView = Collections.unmodifiableSet(this.methods.keySet());
    private Set<XField> fieldsView = Collections.unmodifiableSet(this.fields.keySet());
    private Set<XMethod> calledMethods = new HashSet<XMethod>();
    private boolean calledMethodsIsInterned = false;
    static ThreadLocal<RecursionDepth> recursionDepth = new ThreadLocal<RecursionDepth>(){

        @Override
        public RecursionDepth initialValue() {
            return new RecursionDepth();
        }

        @Override
        public /* synthetic */ Object initialValue() {
            return this.initialValue();
        }
    };
    public static final boolean DEBUG_CIRCULARITY = SystemProperties.getBoolean("circularity.debug");
    static /* synthetic */ Class class$edu$umd$cs$findbugs$ba$XFactory;

    public void addCalledMethod(XMethod m) {
        if (this.calledMethods.add(m) && !m.isResolved()) {
            this.calledMethodsIsInterned = false;
        }
    }

    public boolean isCalled(XMethod m) {
        if (!this.calledMethodsIsInterned) {
            HashSet<XMethod> tmp = new HashSet<XMethod>();
            for (XMethod m2 : this.calledMethods) {
                tmp.add(this.intern(m2));
            }
            this.calledMethodsIsInterned = true;
        }
        return this.calledMethods.contains(m);
    }

    public boolean isInterned(XMethod m) {
        return this.methods.containsKey(m);
    }

    @CheckReturnValue
    @NonNull
    public XMethod intern(XMethod m) {
        XMethod m2 = this.methods.get(m);
        if (m2 != null) {
            return m2;
        }
        this.methods.put(m, m);
        return m;
    }

    @CheckReturnValue
    @NonNull
    public XField intern(XField f) {
        XField f2 = this.fields.get(f);
        if (f2 != null) {
            return f2;
        }
        this.fields.put(f, f);
        return f;
    }

    public Set<XMethod> getMethods() {
        return this.methodsView;
    }

    public Set<XField> getFields() {
        return this.fieldsView;
    }

    public static String canonicalizeString(String s) {
        return ConstantUtf8.getCachedInstance(s).getBytes();
    }

    public static XMethod createXMethod(String className, Method method) {
        String methodName = method.getName();
        String methodSig = method.getSignature();
        int accessFlags = method.getAccessFlags();
        return XFactory.createXMethod(className, methodName, methodSig, accessFlags);
    }

    public static XMethod createXMethod(String className, String methodName, String methodSig, int accessFlags) {
        boolean isStatic = (accessFlags & 8) != 0;
        XFactory xFactory = AnalysisContext.currentXFactory();
        AbstractMethod m = isStatic ? new StaticMethod(className, methodName, methodSig, accessFlags) : new InstanceMethod(className, methodName, methodSig, accessFlags);
        XMethod m2 = xFactory.intern(m);
        ((AbstractMethod)m2).markAsResolved();
        return m2;
    }

    public static XMethod createXMethod(JavaClass javaClass, Method method) {
        return XFactory.createXMethod(javaClass.getClassName(), method);
    }

    public static XMethod createXMethod(String className, String methodName, String methodSig, boolean isStatic) {
        XMethod m = isStatic ? new StaticMethod(className, methodName, methodSig, 8) : new InstanceMethod(className, methodName, methodSig, 0);
        XFactory xFactory = AnalysisContext.currentXFactory();
        m = xFactory.intern(m);
        m = xFactory.resolve(m);
        return m;
    }

    public static XMethod createXMethod(MethodAnnotation ma) {
        return XFactory.createXMethod(ma.getClassName(), ma.getMethodName(), ma.getMethodSignature(), ma.isStatic());
    }

    public static XField createXField(String className, String fieldName, String fieldSignature, boolean isStatic) {
        XField f;
        XFactory xFactory = AnalysisContext.currentXFactory();
        if (isStatic) {
            int accessFlags = 0;
            if (fieldName.toUpperCase().equals(fieldName)) {
                accessFlags = 16;
            }
            f = new StaticField(className, fieldName, fieldSignature, accessFlags);
        } else {
            int accessFlags = 0;
            if (fieldName.startsWith("this$")) {
                accessFlags = 16;
            }
            f = new InstanceField(className, fieldName, fieldSignature, accessFlags);
        }
        f = xFactory.intern(f);
        f = xFactory.resolve(f);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NonNull
    private XField resolve(XField f) {
        block15: {
            JavaClass superClass;
            XField f2;
            block14: {
                String classname;
                block13: {
                    block12: {
                        if (f.isResolved()) {
                            return f;
                        }
                        if (f.isStatic()) {
                            return f;
                        }
                        if (f.getName().startsWith("this$")) {
                            return f;
                        }
                        if (recursionDepth.get().enter(f)) break block12;
                        XFactory.fail(new StringBuffer().append("recursive cycle trying to resolve ").append(f).toString(), null, null);
                        XField xField = f;
                        recursionDepth.get().exit();
                        return xField;
                    }
                    f2 = f;
                    classname = f.getClassName();
                    superClass = Repository.lookupClass(classname).getSuperClass();
                    if (superClass != null) break block13;
                    XField xField = f;
                    recursionDepth.get().exit();
                    return xField;
                }
                if (!classname.equals(superClass.getClassName())) break block14;
                XField xField = f;
                recursionDepth.get().exit();
                return xField;
            }
            f2 = XFactory.createXField(superClass.getClassName(), f.getName(), f.getSignature(), f.isStatic());
            f2 = this.intern(f2);
            if (!f2.isResolved()) break block15;
            this.fields.put(f, f2);
            XField xField = f2;
            recursionDepth.get().exit();
            return xField;
        }
        try {
            block16: {
                break block16;
                {
                    catch (ClassNotFoundException e) {
                        AnalysisContext.reportMissingClass(e);
                    }
                }
            }
            XField xField = f;
            return xField;
        }
        finally {
            recursionDepth.get().exit();
        }
    }

    private static void fail(String s, @CheckForNull JavaClass jClass, @CheckForNull JavaClass superClass) {
        AnalysisContext.logError(s);
        if (DEBUG_CIRCULARITY) {
            System.out.println(s);
            recursionDepth.get().dump();
        }
        if (jClass != null) {
            System.out.println(jClass);
        }
        if (superClass != null) {
            System.out.println(superClass);
        }
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NonNull
    private XMethod resolve(XMethod m) {
        block17: {
            String superClassName;
            String methodName;
            block16: {
                JavaClass superClass;
                JavaClass javaClass;
                String className;
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                if (m.isResolved()) {
                                    return m;
                                }
                                if (recursionDepth.get().enter(m)) break block12;
                                XFactory.fail(new StringBuffer().append("recursive cycle trying to resolve ").append(m).toString(), null, null);
                                XMethod xMethod = m;
                                recursionDepth.get().exit();
                                return xMethod;
                            }
                            className = m.getClassName();
                            methodName = m.getName();
                            if (className.charAt(0) != '[' && !methodName.equals("<init>") && !methodName.equals("<clinit>") && !methodName.startsWith("access$")) break block13;
                            ((AbstractMethod)m).markAsResolved();
                            XMethod xMethod = m;
                            recursionDepth.get().exit();
                            return xMethod;
                        }
                        javaClass = Repository.lookupClass(className);
                        if (javaClass.getClassName().equals(className)) break block14;
                        XFactory.fail(new StringBuffer().append("Looked up ").append(className).append(", got a class named ").append(javaClass.getClassName()).toString(), javaClass, null);
                        XMethod xMethod = m;
                        recursionDepth.get().exit();
                        return xMethod;
                    }
                    superClass = javaClass.getSuperClass();
                    if (superClass != null) break block15;
                    XMethod xMethod = m;
                    recursionDepth.get().exit();
                    return xMethod;
                }
                superClassName = superClass.getClassName();
                if (!javaClass.getSuperclassName().equals(superClassName)) {
                    XFactory.fail(new StringBuffer().append("requested superclass of ").append(className).append(", expecting to get ").append(javaClass.getSuperclassName()).append(", instead got ").append(superClassName).toString(), javaClass, superClass);
                }
                if (!superClass.getSuperclassName().equals(className) && !className.equals(superClassName)) break block16;
                XFactory.fail(new StringBuffer().append("superclass of  ").append(className).append(" is ").append(superClassName).toString(), javaClass, superClass);
                XMethod xMethod = m;
                recursionDepth.get().exit();
                return xMethod;
            }
            XMethod m2 = XFactory.createXMethod(superClassName, methodName, m.getSignature(), m.isStatic());
            if (!m2.isResolved()) break block17;
            this.methods.put(m, m2);
            XMethod xMethod = m2;
            recursionDepth.get().exit();
            return xMethod;
        }
        try {
            block18: {
                break block18;
                catch (ClassNotFoundException e) {
                    AnalysisContext.reportMissingClass(e);
                }
            }
            XMethod xMethod = m;
            return xMethod;
        }
        finally {
            recursionDepth.get().exit();
        }
    }

    public static XField createXField(FieldInstruction fieldInstruction, ConstantPoolGen cpg) {
        String className = fieldInstruction.getClassName(cpg);
        String fieldName = fieldInstruction.getName(cpg);
        String fieldSig = fieldInstruction.getSignature(cpg);
        short opcode = fieldInstruction.getOpcode();
        return XFactory.createXField(className, fieldName, fieldSig, opcode == 178 || opcode == 179);
    }

    public static XField createReferencedXField(DismantleBytecode visitor) {
        return XFactory.createXField(visitor.getDottedClassConstantOperand(), visitor.getNameConstantOperand(), visitor.getSigConstantOperand(), visitor.getRefFieldIsStatic());
    }

    public static XMethod createReferencedXMethod(DismantleBytecode visitor) {
        return XFactory.createXMethod(visitor.getDottedClassConstantOperand(), visitor.getNameConstantOperand(), visitor.getSigConstantOperand(), visitor.getOpcode() == 184);
    }

    public static XField createXField(FieldAnnotation f) {
        return XFactory.createXField(f.getClassName(), f.getFieldName(), f.getFieldSignature(), f.isStatic());
    }

    public static XField createXField(JavaClass javaClass, Field field) {
        return XFactory.createXField(javaClass.getClassName(), field);
    }

    public static XField createXField(String className, Field field) {
        String fieldName = field.getName();
        String fieldSig = field.getSignature();
        int accessFlags = field.getAccessFlags();
        return XFactory.createXField(className, fieldName, fieldSig, accessFlags);
    }

    public static XField createXField(String className, String fieldName, String fieldSig, int accessFlags) {
        XFactory xFactory = AnalysisContext.currentXFactory();
        AbstractField f = (accessFlags & 8) != 0 ? new StaticField(className, fieldName, fieldSig, accessFlags) : new InstanceField(className, fieldName, fieldSig, accessFlags);
        XField f2 = xFactory.intern(f);
        ((AbstractField)f2).markAsResolved();
        return f2;
    }

    public static XMethod createXMethod(InvokeInstruction invokeInstruction, ConstantPoolGen cpg) {
        String className = invokeInstruction.getClassName(cpg);
        String methodName = invokeInstruction.getName(cpg);
        String methodSig = invokeInstruction.getSignature(cpg);
        return XFactory.createXMethod(className, methodName, methodSig, invokeInstruction.getOpcode() == 184);
    }

    public static XMethod createXMethod(PreorderVisitor visitor) {
        JavaClass javaClass = visitor.getThisClass();
        Method method = visitor.getMethod();
        XMethod m = XFactory.createXMethod(javaClass, method);
        return m;
    }

    public static XField createXField(PreorderVisitor visitor) {
        JavaClass javaClass = visitor.getThisClass();
        Field field = visitor.getField();
        XField f = XFactory.createXField(javaClass, field);
        return f;
    }

    public static XMethod createXMethod(MethodGen methodGen) {
        String className = methodGen.getClassName();
        String methodName = methodGen.getName();
        String methodSig = methodGen.getSignature();
        int accessFlags = methodGen.getAccessFlags();
        return XFactory.createXMethod(className, methodName, methodSig, accessFlags);
    }

    public void deprecate(ClassMember m) {
        this.deprecated.add(m);
    }

    public Set<? extends ClassMember> getDeprecated() {
        return this.deprecatedView;
    }

    public static XMethod createXMethod(JavaClassAndMethod classAndMethod) {
        return XFactory.createXMethod(classAndMethod.getJavaClass(), classAndMethod.getMethod());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static class RecursionDepth {
        private static final int MAX_DEPTH = 50;
        private int depth = 0;
        ArrayList<Object> list = new ArrayList();
        static final /* synthetic */ boolean $assertionsDisabled;

        RecursionDepth() {
        }

        public String toString() {
            return this.list.toString();
        }

        public void dump() {
            System.out.println("Recursive calls");
            Iterator<Object> i$ = this.list.iterator();
            while (i$.hasNext()) {
                Object o = i$.next();
                System.out.println("  resolve " + o);
            }
        }

        public boolean enter(Object value) {
            if (this.depth > 50) {
                return false;
            }
            if (DEBUG_CIRCULARITY) {
                this.list.add(value);
            }
            ++this.depth;
            return true;
        }

        public void exit() {
            --this.depth;
            if (DEBUG_CIRCULARITY) {
                this.list.remove(this.list.size() - 1);
            }
            if (!$assertionsDisabled && this.depth < 0) {
                throw new AssertionError();
            }
        }

        static {
            $assertionsDisabled = !(class$edu$umd$cs$findbugs$ba$XFactory == null ? (class$edu$umd$cs$findbugs$ba$XFactory = XFactory.class$("edu.umd.cs.findbugs.ba.XFactory")) : class$edu$umd$cs$findbugs$ba$XFactory).desiredAssertionStatus();
        }
    }
}

