/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.parser;

import antlr.CharStreamException;
import antlr.InputBuffer;
import antlr.LexerSharedInputState;
import antlr.TokenStreamException;
import antlr.TokenStreamSelector;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.epic.core.parser.CurlyToken;
import org.epic.core.parser.DocumentInputBuffer;
import org.epic.core.parser.LexExpectHereDocEnd;
import org.epic.core.parser.LexExpectString;
import org.epic.core.parser.LexExpectStringEnd;
import org.epic.core.parser.LexExpectStringSuffix;
import org.epic.core.parser.LexExpectSubstExpr;
import org.epic.core.parser.PODLexer;
import org.epic.core.parser.PerlLexer;
import org.epic.core.parser.PerlToken;

public class PerlMultiLexer
extends TokenStreamSelector {
    private final PerlLexer mainLexer;
    private final PODLexer lexExpectPODEnd;
    private final LexExpectString lexExpectString;
    private final LexExpectStringEnd lexExpectStringEnd;
    private final LexExpectStringSuffix lexExpectStringSuffix;
    private final LexExpectSubstExpr lexExpectSubstExpr;
    private final LexExpectHereDocEnd lexExpectHereDocEnd;
    private IDocument doc;

    public PerlMultiLexer() {
        this(null, null, null);
    }

    public PerlMultiLexer(Reader reader) {
        this(reader, null, null);
    }

    public PerlMultiLexer(IDocument doc, CurlyToken parseStartCurly) {
        this(null, doc, parseStartCurly);
    }

    private PerlMultiLexer(Reader reader, IDocument doc, CurlyToken parseStartCurly) {
        this.doc = doc;
        StringReader dummyReader = new StringReader("");
        LexerSharedInputState inputState = new LexerSharedInputState((Reader)dummyReader);
        this.mainLexer = new PerlLexer(inputState);
        this.mainLexer.setTabSize(1);
        this.mainLexer.setParent(this);
        this.lexExpectPODEnd = new PODLexer(inputState);
        this.lexExpectPODEnd.setTabSize(1);
        this.lexExpectPODEnd.setParent(this);
        this.lexExpectStringEnd = new LexExpectStringEnd(inputState);
        this.lexExpectStringEnd.setTabSize(1);
        this.lexExpectStringEnd.setParent(this);
        this.lexExpectString = new LexExpectString(inputState);
        this.lexExpectString.setTabSize(1);
        this.lexExpectString.setParent(this);
        this.lexExpectSubstExpr = new LexExpectSubstExpr(inputState);
        this.lexExpectSubstExpr.setTabSize(1);
        this.lexExpectSubstExpr.setParent(this);
        this.lexExpectStringSuffix = new LexExpectStringSuffix(inputState);
        this.lexExpectStringSuffix.setTabSize(1);
        this.lexExpectStringSuffix.setParent(this);
        this.lexExpectHereDocEnd = new LexExpectHereDocEnd(inputState);
        this.lexExpectHereDocEnd.setTabSize(1);
        this.lexExpectHereDocEnd.setParent(this);
        if (reader != null || doc != null) {
            this.reset(reader, doc, parseStartCurly);
        }
    }

    public int getCurlyLevel() {
        return this.mainLexer.getCurlyLevel();
    }

    public void recover() {
        LexerSharedInputState inputState = this.mainLexer.getInputState();
        if (inputState instanceof PerlLexerSharedInputState) {
            ((PerlLexerSharedInputState)inputState).recover();
        }
    }

    public void reset(Reader reader, IDocument doc, CurlyToken parseStartCurly) {
        this.doc = doc;
        LexerSharedInputState inputState = this.createInputState(reader, doc, parseStartCurly);
        this.mainLexer.setInputState(inputState);
        this.lexExpectPODEnd.setInputState(inputState);
        this.lexExpectStringEnd.setInputState(inputState);
        this.lexExpectString.setInputState(inputState);
        this.lexExpectSubstExpr.setInputState(inputState);
        this.lexExpectStringSuffix.setInputState(inputState);
        this.lexExpectHereDocEnd.setInputState(inputState);
        if (parseStartCurly != null) {
            this.mainLexer.setCurlyLevel(parseStartCurly.getLevel());
        }
        this.select(this.mainLexer);
    }

    void expectFormatEnd() {
        this.lexExpectHereDocEnd.setTerminator(".");
        this.lexExpectHereDocEnd.setStartLine(this.mainLexer.getLine());
        this.push(this.lexExpectHereDocEnd);
    }

    void expectHereDocEnd(String terminator) {
        this.lexExpectHereDocEnd.setTerminator(terminator.substring(2));
        this.lexExpectHereDocEnd.setStartLine(this.mainLexer.getLine());
        this.push(this.lexExpectHereDocEnd);
    }

    void expectPODEnd() {
        this.push(this.lexExpectPODEnd);
    }

    void expectString() {
        this.push(this.lexExpectString);
    }

    void expectStringEnd(char quoteBeginChar) {
        this.lexExpectStringEnd.setQuoteEndChar(this.getQuoteEndChar(quoteBeginChar));
        this.lexExpectStringEnd.setStartLine(this.mainLexer.getLine());
        this.push(this.lexExpectStringEnd);
    }

    void expectStringSuffix() {
        this.push(this.lexExpectStringSuffix);
    }

    void expectSubstExpr() {
        this.push(this.lexExpectSubstExpr);
    }

    void uponEOF() throws TokenStreamException, CharStreamException {
        while (this.getCurrentStream() != this.mainLexer) {
            this.pop();
        }
    }

    int computeTokenOffset(PerlToken t) {
        if (this.doc == null) {
            return 0;
        }
        try {
            return this.doc.getLineOffset(t.getLine() - 1) + t.getColumn() - 1;
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private LexerSharedInputState createInputState(Reader reader, IDocument doc, CurlyToken parseStartCurly) {
        if (doc == null) {
            return new LexerSharedInputState(reader);
        }
        return new PerlLexerSharedInputState(doc, this.getStartOffset(parseStartCurly));
    }

    private int getStartOffset(CurlyToken parseStartCurly) {
        return parseStartCurly != null ? parseStartCurly.getOffset() : 0;
    }

    private char getQuoteEndChar(char quoteBeginChar) {
        switch (quoteBeginChar) {
            case '{': {
                return '}';
            }
            case '[': {
                return ']';
            }
            case '(': {
                return ')';
            }
            case '<': {
                return '>';
            }
        }
        return quoteBeginChar;
    }

    private static Reader createStringReader(IDocument doc, int startOffset) {
        try {
            return new StringReader(doc.get(startOffset, doc.getLength() - startOffset));
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private static class PerlLexerSharedInputState
    extends LexerSharedInputState {
        public PerlLexerSharedInputState(IDocument doc, int startOffset) {
            super((InputBuffer)new DocumentInputBuffer(doc, startOffset));
            try {
                this.line = doc.getLineOfOffset(startOffset) + 1;
                this.tokenStartColumn = this.column = startOffset - doc.getLineOffset(this.line - 1) + 1;
                this.tokenStartLine = this.line;
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }

        public void recover() {
            try {
                char c;
                while ((c = this.input.LA(1)) != '\r' && c != '\n' && c != '\uffff') {
                    this.input.consume();
                    ++this.column;
                }
            }
            catch (CharStreamException charStreamException) {}
        }
    }
}

