/* See md5.c for explanation and copyright information.  */

/*
 * $Id: md5.h 1973 2007-09-21 16:10:16Z peter $
 */

#ifndef YASM_MD5_H
#define YASM_MD5_H

/* Unlike previous versions of this code, uint32 need not be exactly
   32 bits, merely 32 bits or more.  Choosing a data type which is 32
   bits instead of 64 is not important; speed is considerably more
   important.  ANSI guarantees that "unsigned long" will be big enough,
   and always using it seems to have few disadvantages.  */

typedef struct yasm_md5_context {
        unsigned long buf[4];
        unsigned long bits[2];
        unsigned char in[64];
} yasm_md5_context;

void yasm_md5_init(yasm_md5_context *context);
void yasm_md5_update(yasm_md5_context *context, unsigned char const *buf,
                     unsigned long len);
void yasm_md5_final(unsigned char digest[16], yasm_md5_context *context);
void yasm_md5_transform(unsigned long buf[4], const unsigned char in[64]);

#endif /* !YASM_MD5_H */
