require 'mocha/class_method'

module Mocha

  class AnyInstanceMethod < ClassMethod
  
    def unstub
      remove_new_method
      restore_original_method
      stubbee.any_instance.reset_mocha
    end
    
    def mock
      stubbee.any_instance.mocha
    end
   
    def hide_original_method
      if method_exists?(method)
        begin
          stubbee.class_eval("alias_method :#{hidden_method}, :#{method}", __FILE__, __LINE__)
        rescue NameError
          # deal with nasties like ActiveRecord::Associations::AssociationProxy
        end
      end
    end

    def define_new_method
      stubbee.class_eval("def #{method}(*args, &block); self.class.any_instance.mocha.method_missing(:#{method}, *args, &block); end", __FILE__, __LINE__)
    end

    def remove_new_method
      stubbee.class_eval("remove_method :#{method}", __FILE__, __LINE__)
    end

    def restore_original_method
      if method_exists?(hidden_method)
        begin
          stubbee.class_eval("alias_method :#{method}, :#{hidden_method}; remove_method :#{hidden_method}", __FILE__, __LINE__)
        rescue NameError
          # deal with nasties like ActiveRecord::Associations::AssociationProxy
        end
      end
    end

    def method_exists?(method)
      existing_methods = []
      existing_methods += stubbee.public_instance_methods(false)
      existing_methods += stubbee.protected_instance_methods(false)
      existing_methods += stubbee.private_instance_methods(false)
      existing_methods.any? { |m| m.to_s == method.to_s }
    end
    
  end
  
end