/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ajp.tomcat4;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.ajp.Ajp13;
import org.apache.catalina.connector.HttpResponseBase;
import org.apache.catalina.util.CookieTools;
import org.apache.tomcat.util.http.MimeHeaders;

public class Ajp13Response
extends HttpResponseBase {
    private Ajp13 ajp13;
    private boolean finished = false;
    private boolean headersSent = false;
    private MimeHeaders headers = new MimeHeaders();
    private StringBuffer cookieValue = new StringBuffer();

    String getStatusMessage() {
        return this.getStatusMessage(this.getStatus());
    }

    public void recycle() {
        super.recycle();
        this.finished = false;
        this.headersSent = false;
        this.headers.recycle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendHeaders() throws IOException {
        int i;
        ArrayList cookie;
        HttpServletRequest hreq;
        HttpSession session;
        if (this.headersSent) {
            return;
        }
        this.headersSent = true;
        int numHeaders = 0;
        if (this.getContentType() != null) {
            ++numHeaders;
        }
        if (this.getContentLength() >= 0) {
            ++numHeaders;
        }
        if ((session = (hreq = (HttpServletRequest)this.request.getRequest()).getSession(false)) != null && session.isNew() && this.getContext() != null && this.getContext().getCookies()) {
            cookie = new Cookie("JSESSIONID", session.getId());
            cookie.setMaxAge(-1);
            String contextPath = null;
            if (this.context != null) {
                contextPath = this.context.getPath();
            }
            if (contextPath != null && contextPath.length() > 0) {
                cookie.setPath(contextPath);
            } else {
                cookie.setPath("/");
            }
            if (hreq.isSecure()) {
                cookie.setSecure(true);
            }
            this.addCookie((Cookie)cookie);
        }
        cookie = this.cookies;
        synchronized (cookie) {
            Iterator items = this.cookies.iterator();
            while (items.hasNext()) {
                Cookie cookie2 = (Cookie)items.next();
                this.cookieValue.delete(0, this.cookieValue.length());
                CookieTools.getCookieHeaderValue((Cookie)cookie2, (StringBuffer)this.cookieValue);
                this.addHeader(CookieTools.getCookieHeaderName((Cookie)cookie2), this.cookieValue.toString());
            }
        }
        String[] hnames = this.getHeaderNames();
        Object[] hvalues = new Object[hnames.length];
        for (i = 0; i < hnames.length; ++i) {
            String[] tmp = this.getHeaderValues(hnames[i]);
            numHeaders += tmp.length;
            hvalues[i] = tmp;
        }
        this.ajp13.beginSendHeaders(this.getStatus(), this.getStatusMessage(this.getStatus()), numHeaders);
        if (this.getContentType() != null) {
            this.ajp13.sendHeader("Content-Type", this.getContentType());
        }
        if (this.getContentLength() >= 0) {
            this.ajp13.sendHeader("Content-Length", String.valueOf(this.getContentLength()));
        }
        for (i = 0; i < hnames.length; ++i) {
            String name = hnames[i];
            String[] values = (String[])hvalues[i];
            for (int j = 0; j < values.length; ++j) {
                this.ajp13.sendHeader(name, values[j]);
            }
        }
        this.ajp13.endSendHeaders();
        this.committed = true;
    }

    public void finishResponse() throws IOException {
        if (!this.finished) {
            try {
                super.finishResponse();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.finished = true;
            this.ajp13.finish();
        }
    }

    void setAjp13(Ajp13 ajp13) {
        this.ajp13 = ajp13;
    }

    Ajp13 getAjp13() {
        return this.ajp13;
    }
}

