/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ajp.tomcat4;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.ajp.tomcat4.Ajp13Connector;
import org.apache.ajp.tomcat4.Ajp13Logger;
import org.apache.ajp.tomcat4.Ajp13Principal;
import org.apache.catalina.connector.HttpRequestBase;
import org.apache.catalina.util.StringParser;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.BaseRequest;
import org.apache.tomcat.util.http.Cookies;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.ServerCookie;

public class Ajp13Request
extends HttpRequestBase {
    private static final String match = ";jsessionid=";
    private static int id = 1;
    private Ajp13Logger logger = new Ajp13Logger();
    private int debug;

    public Ajp13Request(Ajp13Connector connector) {
        this.debug = connector.getDebug();
        this.logger.setConnector(connector);
        this.logger.setName("Ajp13Request[" + id++ + "]");
    }

    public void recycle() {
        super.recycle();
    }

    void setAjpRequest(BaseRequest ajp) throws UnsupportedEncodingException {
        Object name;
        this.setMethod(ajp.method().toString());
        this.setProtocol(ajp.protocol().toString());
        this.setRequestURI(ajp.requestURI().toString());
        this.setRemoteAddr(ajp.remoteAddr().toString());
        this.setRemoteHost(ajp.remoteHost().toString());
        this.setServerName(ajp.serverName().toString());
        this.setServerPort(ajp.getServerPort());
        if (!((Ajp13Connector)this.connector).getTomcatAuthentication() && ajp.remoteUser() != null) {
            this.setUserPrincipal(new Ajp13Principal(ajp.remoteUser().toString()));
        } else {
            this.setUserPrincipal(null);
        }
        this.setAuthType(ajp.authType().toString());
        this.setAuthorization(ajp.authorization().toString());
        this.setQueryString(ajp.queryString().toString());
        this.setScheme(ajp.getScheme());
        this.setSecure(ajp.getSecure());
        this.setContentLength(ajp.getContentLength());
        String contentType = ajp.contentType().toString();
        if (contentType != null) {
            this.setContentType(contentType);
        }
        MimeHeaders mheaders = ajp.headers();
        int nheaders = mheaders.size();
        for (int i = 0; i < nheaders; ++i) {
            name = mheaders.getName(i);
            MessageBytes value = mheaders.getValue(i);
            this.addHeader(name.toString(), value.toString());
            if (!"accept-language".equals(name.toString())) continue;
            this.parseLocalesHeader(value.toString());
        }
        Iterator itr = ajp.getAttributeNames();
        while (itr.hasNext()) {
            name = (String)itr.next();
            this.setAttribute((String)name, ajp.getAttribute((String)name));
        }
        this.addCookies(ajp.cookies());
    }

    public void setRequestURI(String uri) {
        int semicolon = uri.indexOf(match);
        if (semicolon >= 0) {
            String rest = uri.substring(semicolon + match.length());
            int semicolon2 = rest.indexOf(";");
            if (semicolon2 >= 0) {
                this.setRequestedSessionId(rest.substring(0, semicolon2));
                rest = rest.substring(semicolon2);
            } else {
                this.setRequestedSessionId(rest);
                rest = "";
            }
            this.setRequestedSessionURL(true);
            uri = uri.substring(0, semicolon) + rest;
            if (this.debug >= 1) {
                this.logger.log(" Requested URL session id is " + ((HttpServletRequest)this.getRequest()).getRequestedSessionId());
            }
        } else {
            this.setRequestedSessionId(null);
            this.setRequestedSessionURL(false);
        }
        super.setRequestURI(uri);
    }

    private void addCookies(Cookies cookies) {
        int ncookies = cookies.getCookieCount();
        for (int j = 0; j < ncookies; ++j) {
            ServerCookie scookie = cookies.getCookie(j);
            Cookie cookie = new Cookie(scookie.getName().toString(), scookie.getValue().toString());
            if (cookie.getName().equals("JSESSIONID") && !this.isRequestedSessionIdFromCookie()) {
                this.setRequestedSessionId(cookie.getValue());
                this.setRequestedSessionCookie(true);
                this.setRequestedSessionURL(false);
                if (this.debug > 0) {
                    this.logger.log(" Requested cookie session id is " + ((HttpServletRequest)this.getRequest()).getRequestedSessionId());
                }
            }
            if (this.debug > 0) {
                this.logger.log(" Adding cookie " + cookie.getName() + "=" + cookie.getValue());
            }
            this.addCookie(cookie);
        }
    }

    public ServletInputStream createInputStream() throws IOException {
        return (ServletInputStream)this.getStream();
    }

    protected void parseLocalesHeader(String value) {
        int start;
        TreeMap<Double, ArrayList<Locale>> locales = new TreeMap<Double, ArrayList<Locale>>();
        int white = value.indexOf(32);
        if (white < 0) {
            white = value.indexOf(9);
        }
        if (white >= 0) {
            StringBuffer sb = new StringBuffer();
            int len = value.length();
            for (int i = 0; i < len; ++i) {
                char ch = value.charAt(i);
                if (ch == ' ' || ch == '\t') continue;
                sb.append(ch);
            }
            value = sb.toString();
        }
        StringParser parser = new StringParser();
        parser.setString(value);
        int length = parser.getLength();
        while ((start = parser.getIndex()) < length) {
            int end = parser.findChar(',');
            String entry = parser.extract(start, end).trim();
            parser.advance();
            double quality = 1.0;
            int semi = entry.indexOf(";q=");
            if (semi >= 0) {
                try {
                    quality = Double.parseDouble(entry.substring(semi + 3));
                }
                catch (NumberFormatException e) {
                    quality = 0.0;
                }
                entry = entry.substring(0, semi);
            }
            if (quality < 5.0E-5 || "*".equals(entry)) continue;
            String language = null;
            String country = null;
            String variant = null;
            int dash = entry.indexOf(45);
            if (dash < 0) {
                language = entry;
                country = "";
                variant = "";
            } else {
                language = entry.substring(0, dash);
                country = entry.substring(dash + 1);
                int vDash = country.indexOf(45);
                if (vDash > 0) {
                    String cTemp = country.substring(0, vDash);
                    variant = country.substring(vDash + 1);
                    country = cTemp;
                } else {
                    variant = "";
                }
            }
            Locale locale = new Locale(language, country, variant);
            Double key = new Double(-quality);
            ArrayList<Locale> values = (ArrayList<Locale>)locales.get(key);
            if (values == null) {
                values = new ArrayList<Locale>();
                locales.put(key, values);
            }
            values.add(locale);
        }
        Iterator keys = locales.keySet().iterator();
        while (keys.hasNext()) {
            Double key = (Double)keys.next();
            ArrayList list = (ArrayList)locales.get(key);
            Iterator values = list.iterator();
            while (values.hasNext()) {
                Locale locale = (Locale)values.next();
                this.addLocale(locale);
            }
        }
    }
}

