/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ListIterator;
import javax.servlet.jsp.tagext.PageData;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.TagConstants;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class PageDataImpl
extends PageData
implements TagConstants {
    private static final String JSP_NAMESPACE = "http://java.sun.com/JSP/Page";
    private static final String JSP_VERSION = "1.2";
    private static final String CDATA_START_SECTION = "<![CDATA[\n";
    private static final String CDATA_END_SECTION = "]]>\n";
    private static AttributesImpl defaultJspRootAttrs = new AttributesImpl();
    private StringBuffer buf;

    public PageDataImpl(Node.Nodes page) throws JasperException {
        FirstPassVisitor firstPassVisitor = new FirstPassVisitor(page.getRoot());
        page.visit(firstPassVisitor);
        this.buf = new StringBuffer();
        SecondPassVisitor secondPassVisitor = new SecondPassVisitor(page.getRoot(), this.buf);
        page.visit(secondPassVisitor);
    }

    public InputStream getInputStream() {
        try {
            return new ByteArrayInputStream(this.buf.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee.toString());
        }
    }

    static {
        defaultJspRootAttrs.addAttribute("", "", "xmlns:jsp", "CDATA", JSP_NAMESPACE);
        defaultJspRootAttrs.addAttribute("", "", "version", "CDATA", JSP_VERSION);
    }

    static class SecondPassVisitor
    extends Node.Visitor
    implements TagConstants {
        private Node.Root root;
        private StringBuffer buf;
        private int jspId;

        public SecondPassVisitor(Node.Root root, StringBuffer buf) {
            this.root = root;
            this.buf = buf;
        }

        public void visit(Node.Root n) throws JasperException {
            this.appendTag("jsp:root", n.getAttributes(), n.getBody());
        }

        public void visit(Node.JspRoot n) throws JasperException {
            if (n == this.root) {
                this.appendTag("jsp:root", n.getAttributes(), n.getBody());
            } else {
                this.visitBody(n);
            }
        }

        public void visit(Node.PageDirective n) throws JasperException {
            this.appendPageDirective(n);
        }

        public void visit(Node.IncludeDirective n) throws JasperException {
            this.visitBody(n);
        }

        public void visit(Node.Comment n) throws JasperException {
        }

        public void visit(Node.Declaration n) throws JasperException {
            this.appendTag("jsp:declaration", n.getAttributes(), n.getText());
        }

        public void visit(Node.Expression n) throws JasperException {
            this.appendTag("jsp:expression", n.getAttributes(), n.getText());
        }

        public void visit(Node.Scriptlet n) throws JasperException {
            this.appendTag("jsp:scriptlet", n.getAttributes(), n.getText());
        }

        public void visit(Node.IncludeAction n) throws JasperException {
            this.appendTag("jsp:include", n.getAttributes(), n.getBody());
        }

        public void visit(Node.ForwardAction n) throws JasperException {
            this.appendTag("jsp:forward", n.getAttributes(), n.getBody());
        }

        public void visit(Node.GetProperty n) throws JasperException {
            this.appendTag("jsp:getProperty", n.getAttributes(), n.getBody());
        }

        public void visit(Node.SetProperty n) throws JasperException {
            this.appendTag("jsp:setProperty", n.getAttributes(), n.getBody());
        }

        public void visit(Node.ParamAction n) throws JasperException {
            this.appendTag("jsp:param", n.getAttributes(), n.getBody());
        }

        public void visit(Node.ParamsAction n) throws JasperException {
            this.appendTag("jsp:params", n.getAttributes(), n.getBody());
        }

        public void visit(Node.FallBackAction n) throws JasperException {
            this.appendTag("jsp:fallback", n.getAttributes(), n.getBody());
        }

        public void visit(Node.UseBean n) throws JasperException {
            this.appendTag("jsp:useBean", n.getAttributes(), n.getBody());
        }

        public void visit(Node.PlugIn n) throws JasperException {
            this.appendTag("jsp:plugin", n.getAttributes(), n.getBody());
        }

        public void visit(Node.CustomTag n) throws JasperException {
            this.appendTag(n.getName(), n.getAttributes(), n.getBody());
        }

        public void visit(Node.UninterpretedTag n) throws JasperException {
            this.appendTag(n.getName(), n.getAttributes(), n.getBody());
        }

        public void visit(Node.JspText n) throws JasperException {
            this.appendTag("jsp:text", n.getAttributes(), n.getBody());
        }

        public void visit(Node.TemplateText n) throws JasperException {
            this.appendText(n.getText(), !n.isXmlSyntax());
        }

        private void appendTag(String tag, Attributes attrs, Node.Nodes body) throws JasperException {
            this.buf.append("<").append(tag);
            this.buf.append("\n");
            this.buf.append("  ").append("jsp:id").append("=\"");
            this.buf.append(this.jspId++).append("\"\n");
            if (attrs != null) {
                this.printAttributes(attrs);
            }
            if (body != null) {
                this.buf.append(">\n");
                body.visit(this);
                this.buf.append("</" + tag + ">\n");
            } else {
                this.buf.append("/>\n");
            }
        }

        private void appendTag(String tag, Attributes attrs, String text) throws JasperException {
            this.buf.append("<").append(tag);
            this.buf.append("\n");
            this.buf.append("  ").append("jsp:id").append("=\"");
            this.buf.append(this.jspId++).append("\"\n");
            if (attrs != null) {
                this.printAttributes(attrs);
            }
            if (text != null) {
                this.buf.append(">\n");
                this.appendText(text, false);
                this.buf.append("</" + tag + ">\n");
            } else {
                this.buf.append("/>\n");
            }
        }

        private void appendPageDirective(Node.PageDirective pageDir) {
            Attributes attrs = pageDir.getAttributes();
            this.buf.append("<").append("jsp:directive.page");
            this.buf.append("\n");
            this.buf.append("  ").append("jsp:id").append("=\"");
            this.buf.append(this.jspId++).append("\"\n");
            int len = attrs.getLength();
            for (int i = 0; i < len; ++i) {
                String attrName = attrs.getQName(i);
                if ("import".equals(attrName)) continue;
                String value = attrs.getValue(i);
                this.buf.append("  ").append(attrName).append("=\"");
                this.buf.append(JspUtil.getExprInXml(value)).append("\"\n");
            }
            if (pageDir.getImports().size() > 0) {
                boolean first = true;
                ListIterator iter = pageDir.getImports().listIterator();
                while (iter.hasNext()) {
                    if (first) {
                        first = false;
                        this.buf.append("  import=\"");
                    } else {
                        this.buf.append(",");
                    }
                    this.buf.append(JspUtil.getExprInXml((String)iter.next()));
                }
                this.buf.append("\"\n");
            }
            this.buf.append("/>\n");
        }

        private void appendText(String text, boolean createJspTextElement) {
            if (createJspTextElement) {
                this.buf.append("<jsp:text>");
                this.appendCDATA(text);
                this.buf.append("</jsp:text>");
            } else {
                this.appendCDATA(text);
            }
        }

        private void appendCDATA(String text) {
            this.buf.append(PageDataImpl.CDATA_START_SECTION);
            this.buf.append(this.escapeCDATA(text));
            this.buf.append(PageDataImpl.CDATA_END_SECTION);
        }

        private String escapeCDATA(String text) {
            int len = text.length();
            CharArrayWriter result = new CharArrayWriter(len);
            for (int i = 0; i < len; ++i) {
                if (i + 2 < len && text.charAt(i) == ']' && text.charAt(i + 1) == ']' && text.charAt(i + 2) == '>') {
                    result.write(93);
                    result.write(93);
                    result.write(38);
                    result.write(103);
                    result.write(116);
                    result.write(59);
                    i += 2;
                    continue;
                }
                result.write(text.charAt(i));
            }
            return result.toString();
        }

        private void printAttributes(Attributes attrs) {
            int len = attrs.getLength();
            for (int i = 0; i < len; ++i) {
                String name = attrs.getQName(i);
                String value = attrs.getValue(i);
                this.buf.append("  ").append(name).append("=\"");
                this.buf.append(JspUtil.getExprInXml(value)).append("\"\n");
            }
        }
    }

    static class FirstPassVisitor
    extends Node.Visitor {
        private Node.Root root;
        private AttributesImpl rootAttrs;

        public FirstPassVisitor(Node.Root root) {
            this.root = root;
            this.rootAttrs = new AttributesImpl(defaultJspRootAttrs);
        }

        public void visit(Node.Root n) throws JasperException {
            this.visitBody(n);
            this.root.setAttributes(this.rootAttrs);
        }

        public void visit(Node.JspRoot n) throws JasperException {
            Attributes attrs = n.getAttributes();
            if (attrs == null) {
                throw new JasperException("Missing attributes in jsp:root");
            }
            int len = attrs.getLength();
            for (int i = 0; i < len; ++i) {
                String qName = attrs.getQName(i);
                if (qName.startsWith("xmlns:jsp") || qName.equals("version")) continue;
                this.rootAttrs.addAttribute(attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getType(i), attrs.getValue(i));
            }
            this.visitBody(n);
            if (n == this.root) {
                this.root.setAttributes(this.rootAttrs);
            }
        }

        public void visit(Node.TaglibDirective n) throws JasperException {
            String qName;
            Attributes attrs = n.getAttributes();
            if (attrs != null && this.rootAttrs.getIndex(qName = "xmlns:" + attrs.getValue("prefix")) == -1) {
                this.rootAttrs.addAttribute("", "", qName, "CDATA", attrs.getValue("uri"));
            }
        }
    }
}

