/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextListener;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;
import org.mozilla.javascript.tools.debugger.ContextData;
import org.mozilla.javascript.tools.debugger.ContextHelper;
import org.mozilla.javascript.tools.debugger.ContextWindow;
import org.mozilla.javascript.tools.debugger.CreateFileWindow;
import org.mozilla.javascript.tools.debugger.EnterInterrupt;
import org.mozilla.javascript.tools.debugger.EvalWindow;
import org.mozilla.javascript.tools.debugger.ExitInterrupt;
import org.mozilla.javascript.tools.debugger.FileWindow;
import org.mozilla.javascript.tools.debugger.FindFunction;
import org.mozilla.javascript.tools.debugger.FrameHelper;
import org.mozilla.javascript.tools.debugger.JSInternalConsole;
import org.mozilla.javascript.tools.debugger.LoadFile;
import org.mozilla.javascript.tools.debugger.Menubar;
import org.mozilla.javascript.tools.debugger.MessageDialogWrapper;
import org.mozilla.javascript.tools.debugger.MoreWindows;
import org.mozilla.javascript.tools.debugger.OfficeScriptInfo;
import org.mozilla.javascript.tools.debugger.OpenFile;
import org.mozilla.javascript.tools.debugger.ScopeProvider;
import org.mozilla.javascript.tools.debugger.ScriptItem;
import org.mozilla.javascript.tools.debugger.SetFilePosition;
import org.mozilla.javascript.tools.debugger.SourceInfo;
import org.mozilla.javascript.tools.debugger.UpdateContext;
import org.mozilla.javascript.tools.debugger.UpdateFileText;

public class Main
extends JFrame
implements Debugger,
ContextListener {
    ObjToIntMap contexts = new ObjToIntMap();
    static Thread mainThread;
    boolean breakFlag = false;
    static final int STEP_OVER = 0;
    static final int STEP_INTO = 1;
    static final int STEP_OUT = 2;
    static final int GO = 3;
    static final int BREAK = 4;
    static final int RUN_TO_CURSOR = 5;
    static final int EXIT = 6;
    private Hashtable threadState = new Hashtable();
    private Thread runToCursorThread;
    private int runToCursorLine;
    private String runToCursorFile;
    private Hashtable scriptItems = new Hashtable();
    private Hashtable sourceNames = new Hashtable();
    Hashtable functionNames = new Hashtable();
    JDesktopPane desk;
    ContextWindow context;
    Menubar menubar;
    JToolBar toolBar;
    JSInternalConsole console;
    EvalWindow evalWindow;
    JSplitPane split1;
    JLabel statusBar;
    ScopeProvider scopeProvider;
    Runnable exitAction;
    int frameIndex = -1;
    boolean isInterrupted = false;
    boolean nonDispatcherWaiting = false;
    int dispatcherIsWaiting = 0;
    Context currentContext = null;
    boolean sourceEditingEnabled = true;
    JFileChooser dlg;
    Hashtable fileWindows = new Hashtable();
    FileWindow currentWindow;
    Object monitor = new Object();
    Object swingMonitor = new Object();
    int returnValue = -1;
    boolean breakOnExceptions;
    boolean breakOnEnter;
    boolean breakOnReturn;
    Hashtable toplevels = new Hashtable();
    OfficeScriptInfo officeScripts = new OfficeScriptInfo();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextCreated(Context context) {
        ObjToIntMap objToIntMap = this.contexts;
        synchronized (objToIntMap) {
            ContextData contextData = new ContextData();
            context.setDebugger(this, contextData);
            context.setGeneratingDebug(true);
            context.setOptimizationLevel(-1);
            if (this.breakFlag || Thread.currentThread() == mainThread) {
                contextData.breakNextLine = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextEntered(Context context) {
        ObjToIntMap objToIntMap = this.contexts;
        synchronized (objToIntMap) {
            if (!this.contexts.has(context) && context.getDebugger() == this) {
                this.contexts.put(context, 1);
            }
        }
    }

    public void contextExited(Context context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextReleased(Context context) {
        ObjToIntMap objToIntMap = this.contexts;
        synchronized (objToIntMap) {
            this.contexts.remove(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBreak() {
        this.breakFlag = true;
        ObjToIntMap objToIntMap = this.contexts;
        synchronized (objToIntMap) {
            ObjToIntMap.Iterator iterator = this.contexts.newIterator();
            iterator.start();
            while (!iterator.done()) {
                Context context = (Context)iterator.getKey();
                ContextData.get((Context)context).breakNextLine = true;
                iterator.next();
            }
        }
    }

    public void setVisible(boolean bl) {
        block0: {
            super.setVisible(bl);
            if (!bl) break block0;
            this.context.split.setDividerLocation(0.5);
        }
    }

    public void handleCompilationDone(Context context, DebuggableScript debuggableScript, String string) {
        String string2 = this.getNormilizedUrl(debuggableScript);
        SourceInfo sourceInfo = this.registerSource(string2, string);
        this.registerScript(sourceInfo, debuggableScript);
    }

    String getNormilizedUrl(DebuggableScript debuggableScript) {
        String string = debuggableScript.getSourceName();
        if (string == null) {
            string = "document";
        } else {
            int n;
            int n2 = 35;
            StringBuffer stringBuffer = null;
            int n3 = string.length();
            int n4 = 0;
            while ((n = string.indexOf(n2, n4)) >= 0) {
                char c;
                int n5;
                String string2 = null;
                boolean bl = false;
                for (n5 = n + 1; n5 != n3 && '0' <= (c = string.charAt(n5)) && c <= '9'; ++n5) {
                }
                if (n5 != n + 1 && "(eval)".regionMatches(0, string, n5, 6)) {
                    n4 = n5 + 6;
                    string2 = "(eval)";
                }
                if (string2 == null) break;
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(string.substring(0, n));
                }
                stringBuffer.append(string2);
            }
            if (stringBuffer != null) {
                if (n4 != n3) {
                    stringBuffer.append(string.substring(n4));
                }
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    private static InputStream openSource(String string) throws IOException {
        int n = string.indexOf(35);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        if (string.indexOf(58) < 0) {
            try {
                String string2;
                File file;
                Object object;
                if (string.startsWith("~/") && (object = System.getProperty("user.home")) != null && (file = new File(new File((String)object), string2 = string.substring(2))).exists()) {
                    return new FileInputStream(file);
                }
                object = new File(string);
                if (((File)object).exists()) {
                    return new FileInputStream((File)object);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            string = string.startsWith("//") ? "http:" + string : (string.startsWith("/") ? "http://127.0.0.1" + string : "http://" + string);
        }
        return new URL(string).openStream();
    }

    private static String readSource(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        int n2 = 0;
        while ((n = inputStream.read(byArray, 0, byArray.length - n2)) >= 0) {
            if ((n2 += n) != byArray.length) continue;
            byte[] byArray2 = new byte[byArray.length * 2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
        }
        return new String(byArray, 0, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SourceInfo registerSource(String string, String string2) {
        SourceInfo sourceInfo;
        Hashtable hashtable = this.sourceNames;
        synchronized (hashtable) {
            sourceInfo = (SourceInfo)this.sourceNames.get(string);
            if (sourceInfo == null) {
                sourceInfo = new SourceInfo(string, string2);
                this.sourceNames.put(string, sourceInfo);
            } else if (!string2.equals(sourceInfo.getSource())) {
                sourceInfo.setSource(string2);
            }
        }
        return sourceInfo;
    }

    private ScriptItem registerScript(SourceInfo sourceInfo, DebuggableScript debuggableScript) {
        ScriptItem scriptItem = new ScriptItem(debuggableScript, sourceInfo);
        sourceInfo.updateLineInfo(scriptItem);
        this.scriptItems.put(debuggableScript, scriptItem);
        String string = debuggableScript.getFunctionName();
        if (string != null && string.length() > 0 && !string.equals("anonymous")) {
            this.functionNames.put(string, scriptItem);
        }
        this.loadedFile(sourceInfo);
        return scriptItem;
    }

    void handleBreakpointHit(Context context) {
        this.breakFlag = false;
        this.interrupted(context);
    }

    private static String exceptionString(Throwable object) {
        Object object2;
        if (object instanceof JavaScriptException) {
            JavaScriptException javaScriptException = (JavaScriptException)object;
            return ScriptRuntime.toString(javaScriptException.getValue());
        }
        if (object instanceof EcmaError) {
            return ((Throwable)object).toString();
        }
        if (object instanceof WrappedException && (object2 = ((WrappedException)object).getWrappedException()) != null) {
            object = object2;
        }
        if ((object2 = ((Throwable)object).toString()) == null || ((String)object2).length() == 0) {
            object2 = object.getClass().toString();
        }
        return object2;
    }

    void handleExceptionThrown(Context context, Throwable throwable, FrameHelper frameHelper) {
        if (this.breakOnExceptions) {
            String string = frameHelper.getUrl();
            int n = frameHelper.getLineNumber();
            FileWindow fileWindow = this.getFileWindow(string);
            String string2 = Main.exceptionString(throwable);
            string2 = string2 + " (" + string + ", line " + n + ")";
            if (fileWindow != null) {
                Main.swingInvoke(new SetFilePosition(this, fileWindow, n));
            }
            MessageDialogWrapper.showMessageDialog(this, string2, "Exception in Script", 0);
            this.interrupted(context);
        }
    }

    public DebugFrame getFrame(Context context, DebuggableScript debuggableScript) {
        return new FrameHelper(context, this, debuggableScript);
    }

    void init() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JButton jButton6;
        this.menubar = new Menubar(this);
        this.setJMenuBar(this.menubar);
        this.toolBar = new JToolBar();
        String[] stringArray = new String[]{"Break (Pause)", "Go (F5)", "Step Into (F11)", "Step Over (F7)", "Step Out (F8)"};
        int n = 0;
        JButton jButton7 = jButton6 = (jButton5 = new JButton("Break"));
        jButton6.setToolTipText("Break");
        jButton6.setActionCommand("Break");
        jButton6.addActionListener(this.menubar);
        jButton6.setEnabled(true);
        jButton6.setToolTipText(stringArray[n++]);
        jButton6 = jButton4 = new JButton("Go");
        jButton6.setToolTipText("Go");
        jButton6.setActionCommand("Go");
        jButton6.addActionListener(this.menubar);
        jButton6.setEnabled(false);
        jButton6.setToolTipText(stringArray[n++]);
        jButton6 = jButton3 = new JButton("Step Into");
        jButton6.setToolTipText("Step Into");
        jButton6.setActionCommand("Step Into");
        jButton6.addActionListener(this.menubar);
        jButton6.setEnabled(false);
        jButton6.setToolTipText(stringArray[n++]);
        jButton6 = jButton2 = new JButton("Step Over");
        jButton6.setToolTipText("Step Over");
        jButton6.setActionCommand("Step Over");
        jButton6.setEnabled(false);
        jButton6.addActionListener(this.menubar);
        jButton6.setToolTipText(stringArray[n++]);
        jButton6 = jButton = new JButton("Step Out");
        jButton6.setToolTipText("Step Out");
        jButton6.setActionCommand("Step Out");
        jButton6.setEnabled(false);
        jButton6.addActionListener(this.menubar);
        jButton6.setToolTipText(stringArray[n++]);
        Dimension dimension = jButton2.getPreferredSize();
        jButton5.setPreferredSize(dimension);
        jButton5.setMinimumSize(dimension);
        jButton5.setMaximumSize(dimension);
        jButton5.setSize(dimension);
        jButton4.setPreferredSize(dimension);
        jButton4.setMinimumSize(dimension);
        jButton4.setMaximumSize(dimension);
        jButton3.setPreferredSize(dimension);
        jButton3.setMinimumSize(dimension);
        jButton3.setMaximumSize(dimension);
        jButton2.setPreferredSize(dimension);
        jButton2.setMinimumSize(dimension);
        jButton2.setMaximumSize(dimension);
        jButton.setPreferredSize(dimension);
        jButton.setMinimumSize(dimension);
        jButton.setMaximumSize(dimension);
        this.toolBar.add(jButton5);
        this.toolBar.add(jButton4);
        this.toolBar.add(jButton3);
        this.toolBar.add(jButton2);
        this.toolBar.add(jButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)jPanel, "Center");
        this.desk = new JDesktopPane();
        this.desk.setPreferredSize(new Dimension(600, 300));
        this.desk.setMinimumSize(new Dimension(150, 50));
        this.context = new ContextWindow(this);
        this.context.setPreferredSize(new Dimension(600, 120));
        this.context.setMinimumSize(new Dimension(50, 50));
        this.split1 = new JSplitPane(0, this.desk, this.context);
        this.split1.setOneTouchExpandable(true);
        Main.setResizeWeight(this.split1, 0.66);
        jPanel.add((Component)this.split1, "Center");
        this.statusBar = new JLabel();
        this.statusBar.setText("Thread: ");
        jPanel.add((Component)this.statusBar, "South");
        this.dlg = new JFileChooser();
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                String string;
                if (file.isDirectory()) {
                    return true;
                }
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                return n > 0 && n < string2.length() - 1 && (string = string2.substring(n + 1).toLowerCase()).equals("js");
            }

            public String getDescription() {
                return "JavaScript Files (*.js)";
            }
        };
        this.dlg.addChoosableFileFilter(fileFilter);
        final Main main = this;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                main.Exit();
            }
        });
    }

    Scriptable getScope() {
        return this.scopeProvider != null ? this.scopeProvider.getScope() : null;
    }

    FileWindow getFileWindow(String string) {
        if (string == null || string.equals("<stdin>")) {
            return null;
        }
        return (FileWindow)this.fileWindows.get(string);
    }

    void loadedFile(SourceInfo sourceInfo) {
        String string = sourceInfo.getUrl();
        FileWindow fileWindow = this.getFileWindow(string);
        if (fileWindow != null) {
            Main.swingInvoke(UpdateFileText.action(fileWindow));
            fileWindow.show();
        } else if (!string.equals("<stdin>")) {
            Main.swingInvoke(CreateFileWindow.action(this, sourceInfo, -1));
        }
    }

    static void swingInvoke(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
            return;
        }
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void swingInvokeLater(Runnable runnable) {
        try {
            SwingUtilities.invokeLater(runnable);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    void contextSwitch(int n) {
        Context context = this.getCurrentContext();
        ContextData contextData = ContextData.get(context);
        ContextHelper contextHelper = new ContextHelper();
        contextHelper.attach(context);
        if (context != null) {
            int n2 = contextData.getFrameCount();
            if (n < 0 || n >= n2) {
                contextHelper.reset();
                return;
            }
            this.frameIndex = n;
            FrameHelper frameHelper = contextData.getFrame(n);
            String string = frameHelper.getUrl();
            if (string == null || string.equals("<stdin>")) {
                contextHelper.reset();
                return;
            }
            int n3 = frameHelper.getLineNumber();
            this.frameIndex = n;
            FileWindow fileWindow = this.getFileWindow(string);
            if (fileWindow != null) {
                SetFilePosition setFilePosition = new SetFilePosition(this, fileWindow, n3);
                setFilePosition.run();
            } else {
                SourceInfo sourceInfo = frameHelper.getSourceInfo();
                CreateFileWindow.action(this, sourceInfo, n3).run();
            }
            contextHelper.reset();
        }
    }

    public boolean isSourceEditingEnabled() {
        return this.sourceEditingEnabled;
    }

    void setSourceEditingEnabled(boolean bl) {
        this.sourceEditingEnabled = bl;
    }

    Context getCurrentContext() {
        return this.currentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interrupted(Context context) {
        Object object;
        block59: {
            FrameHelper frameHelper;
            Object object2;
            int n;
            Object object3;
            Object object4;
            object = this.swingMonitor;
            synchronized (object) {
                if (SwingUtilities.isEventDispatchThread()) {
                    ++this.dispatcherIsWaiting;
                    if (this.nonDispatcherWaiting) {
                        object4 = Toolkit.getDefaultToolkit().getSystemEventQueue();
                        while (this.nonDispatcherWaiting) {
                            try {
                                object3 = ((EventQueue)object4).getNextEvent();
                                if (object3 instanceof ActiveEvent) {
                                    ((ActiveEvent)object3).dispatch();
                                } else {
                                    Object object5 = ((EventObject)object3).getSource();
                                    if (object5 instanceof Component) {
                                        Component component = (Component)object5;
                                        component.dispatchEvent((AWTEvent)object3);
                                    } else if (object5 instanceof MenuComponent) {
                                        ((MenuComponent)object5).dispatchEvent((AWTEvent)object3);
                                    }
                                }
                                if (this.returnValue == 6) {
                                    return;
                                }
                                this.swingMonitor.wait(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                return;
                            }
                        }
                    }
                } else {
                    while (this.isInterrupted || this.dispatcherIsWaiting > 0) {
                        try {
                            this.swingMonitor.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    this.nonDispatcherWaiting = true;
                }
                this.isInterrupted = true;
            }
            this.currentContext = context;
            object = ContextData.get(context);
            object4 = Thread.currentThread();
            this.statusBar.setText("Thread: " + ((Thread)object4).toString());
            object3 = (ThreadState)this.threadState.get(object4);
            int n2 = -1;
            if (object3 != null) {
                n2 = ((ThreadState)object3).stopAtFrameDepth;
            }
            if (this.runToCursorFile != null && object4 == this.runToCursorThread && (n = ((ContextData)object).getFrameCount()) > 0 && (object2 = (frameHelper = ((ContextData)object).getFrame(0)).getUrl()) != null && ((String)object2).equals(this.runToCursorFile)) {
                int n3 = frameHelper.getLineNumber();
                if (n3 == this.runToCursorLine) {
                    n2 = -1;
                    this.runToCursorFile = null;
                } else {
                    FileWindow fileWindow = this.getFileWindow((String)object2);
                    if (fileWindow == null || !fileWindow.isBreakPoint(n3)) {
                        return;
                    }
                    this.runToCursorFile = null;
                }
            }
            if (n2 <= 0 || ((ContextData)object).getFrameCount() <= n2) {
                if (object3 != null) {
                    ((ThreadState)object3).stopAtFrameDepth = -1;
                }
                this.threadState.remove(object4);
                int n4 = ((ContextData)object).getFrameCount();
                this.frameIndex = n4 - 1;
                int n5 = 0;
                if (n4 != 0) {
                    int n6;
                    Object object6;
                    object2 = ((ContextData)object).getFrame(0);
                    String string = ((FrameHelper)object2).getUrl();
                    ((ContextData)object).breakNextLine = false;
                    n5 = ((FrameHelper)object2).getLineNumber();
                    int n7 = 0;
                    boolean bl = SwingUtilities.isEventDispatchThread();
                    if (!bl) {
                        context.exit();
                        while (Context.getCurrentContext() != null) {
                            Context.exit();
                            ++n7;
                        }
                    }
                    if (string != null && !string.equals("<stdin>")) {
                        FileWindow fileWindow = this.getFileWindow(string);
                        if (fileWindow != null) {
                            object6 = new SetFilePosition(this, fileWindow, n5);
                            Main.swingInvoke((Runnable)object6);
                        } else {
                            object6 = ((FrameHelper)object2).getSourceInfo();
                            Main.swingInvoke(CreateFileWindow.action(this, (SourceInfo)object6, n5));
                        }
                    }
                    Main.swingInvoke(new EnterInterrupt(this, context));
                    Main.swingInvoke(new UpdateContext(this, context));
                    if (!bl) {
                        object6 = this.monitor;
                        synchronized (object6) {
                            this.returnValue = -1;
                            try {
                                while (this.returnValue == -1) {
                                    this.monitor.wait();
                                }
                                n6 = this.returnValue;
                            }
                            catch (InterruptedException interruptedException) {
                                break block59;
                            }
                        }
                    }
                    object6 = Toolkit.getDefaultToolkit().getSystemEventQueue();
                    this.returnValue = -1;
                    while (this.returnValue == -1) {
                        try {
                            AWTEvent aWTEvent = ((EventQueue)object6).getNextEvent();
                            if (aWTEvent instanceof ActiveEvent) {
                                ((ActiveEvent)((Object)aWTEvent)).dispatch();
                                continue;
                            }
                            Object object7 = aWTEvent.getSource();
                            if (object7 instanceof Component) {
                                Component component = (Component)object7;
                                component.dispatchEvent(aWTEvent);
                                continue;
                            }
                            if (!(object7 instanceof MenuComponent)) continue;
                            ((MenuComponent)object7).dispatchEvent(aWTEvent);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    n6 = this.returnValue;
                    Main.swingInvoke(new ExitInterrupt(this));
                    if (!bl) {
                        object6 = Context.enter(context);
                        if (object6 != context) {
                            System.out.println("debugger error: cx = " + context + " current = " + object6);
                        }
                        while (n7 > 0) {
                            Context.enter();
                            --n7;
                        }
                    }
                    switch (n6) {
                        case 0: {
                            ((ContextData)object).breakNextLine = true;
                            n2 = ((ContextData)object).getFrameCount();
                            if (object3 == null) {
                                object3 = new ThreadState();
                            }
                            ((ThreadState)object3).stopAtFrameDepth = n2;
                            this.threadState.put(object4, object3);
                            break;
                        }
                        case 1: {
                            ((ContextData)object).breakNextLine = true;
                            if (object3 == null) break;
                            ((ThreadState)object3).stopAtFrameDepth = -1;
                            break;
                        }
                        case 2: {
                            n2 = ((ContextData)object).getFrameCount() - 1;
                            if (n2 <= 0) break;
                            ((ContextData)object).breakNextLine = true;
                            if (object3 == null) {
                                object3 = new ThreadState();
                            }
                            ((ThreadState)object3).stopAtFrameDepth = n2;
                            this.threadState.put(object4, object3);
                            break;
                        }
                        case 5: {
                            ((ContextData)object).breakNextLine = true;
                            if (object3 == null) break;
                            ((ThreadState)object3).stopAtFrameDepth = -1;
                        }
                    }
                }
            }
        }
        object = this.swingMonitor;
        synchronized (object) {
            this.isInterrupted = false;
            if (SwingUtilities.isEventDispatchThread()) {
                --this.dispatcherIsWaiting;
            } else {
                this.nonDispatcherWaiting = false;
            }
            this.swingMonitor.notifyAll();
        }
    }

    String chooseFile(String string) {
        int n;
        this.dlg.setDialogTitle(string);
        File file = null;
        String string2 = System.getProperty("user.dir");
        if (string2 != null) {
            file = new File(string2);
        }
        if (file != null) {
            this.dlg.setCurrentDirectory(file);
        }
        if ((n = this.dlg.showOpenDialog(this)) == 0) {
            try {
                String string3 = this.dlg.getSelectedFile().getCanonicalPath();
                file = this.dlg.getSelectedFile().getParentFile();
                Properties properties = System.getProperties();
                properties.put("user.dir", file.getPath());
                System.setProperties(properties);
                return string3;
            }
            catch (IOException iOException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    JInternalFrame getSelectedFrame() {
        JInternalFrame[] jInternalFrameArray = this.desk.getAllFrames();
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            if (!jInternalFrameArray[i].isShowing()) continue;
            return jInternalFrameArray[i];
        }
        return jInternalFrameArray[jInternalFrameArray.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void actionPerformed(ActionEvent actionEvent) {
        Object object;
        String string = actionEvent.getActionCommand();
        int n = -1;
        if (string.equals("Cut") || string.equals("Copy") || string.equals("Paste")) {
            object = this.getSelectedFrame();
            if (object != null && object instanceof ActionListener) {
                ((ActionListener)object).actionPerformed(actionEvent);
            }
        } else if (string.equals("Step Over")) {
            n = 0;
        } else if (string.equals("Step Into")) {
            n = 1;
        } else if (string.equals("Step Out")) {
            n = 2;
        } else if (string.equals("Go")) {
            n = 3;
        } else if (string.equals("Break")) {
            this.doBreak();
        } else if (string.equals("Run to Cursor")) {
            n = 5;
        } else if (string.equals("Exit")) {
            this.Exit();
        } else if (string.equals("Open")) {
            object = this.chooseFile("Select a file to compile");
            if (object != null) {
                new Thread(new OpenFile(this, (String)object)).start();
            }
        } else if (string.equals("Load")) {
            object = this.getScope();
            if (object == null) {
                MessageDialogWrapper.showMessageDialog(this, "Can't run scripts: no scope available", "Run", 0);
            } else {
                String string2 = this.chooseFile("Select a file to execute");
                if (string2 != null) {
                    new Thread(new LoadFile(this, (Scriptable)object, string2)).start();
                }
            }
        } else if (string.equals("Run")) {
            object = (FileWindow)this.getSelectedFrame();
            if (object != null) {
                ((FileWindow)object).load();
            }
        } else if (string.equals("Save")) {
            object = (FileWindow)this.getSelectedFrame();
            if (object != null) {
                ((FileWindow)object).save();
            }
        } else if (string.equals("More Windows...")) {
            object = new MoreWindows(this, this.fileWindows, "Window", "Files");
            ((MoreWindows)object).showDialog(this);
        } else if (string.equals("Console")) {
            if (this.console.isIcon()) {
                this.desk.getDesktopManager().deiconifyFrame(this.console);
            }
            this.console.show();
            this.desk.getDesktopManager().activateFrame(this.console);
            this.console.consoleTextArea.requestFocus();
        } else if (!(string.equals("Cut") || string.equals("Copy") || string.equals("Paste"))) {
            if (string.equals("Go to function...")) {
                object = new FindFunction(this, this.functionNames, "Go to function", "Function");
                ((FindFunction)object).showDialog(this);
            } else if (string.equals("Tile")) {
                object = this.desk.getAllFrames();
                int n2 = ((JInternalFrame[])object).length;
                int n3 = (int)Math.sqrt(n2);
                int n4 = n3;
                if (n4 * n3 < n2 && n4 * ++n3 < n2) {
                    ++n4;
                }
                Dimension dimension = this.desk.getSize();
                int n5 = dimension.width / n3;
                int n6 = dimension.height / n4;
                int n7 = 0;
                int n8 = 0;
                for (int i = 0; i < n4; ++i) {
                    int n9;
                    for (int j = 0; j < n3 && (n9 = i * n3 + j) < ((Object)object).length; ++j) {
                        Object object2 = object[n9];
                        try {
                            ((JInternalFrame)object2).setIcon(false);
                            ((JInternalFrame)object2).setMaximum(false);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.desk.getDesktopManager().setBoundsForFrame((JComponent)object2, n7, n8, n5, n6);
                        n7 += n5;
                    }
                    n8 += n6;
                    n7 = 0;
                }
            } else if (string.equals("Cascade")) {
                object = this.desk.getAllFrames();
                int n10 = ((Object)object).length;
                int n11 = 0;
                int n12 = 0;
                int n13 = this.desk.getHeight();
                int n14 = n13 / n10;
                if (n14 > 30) {
                    n14 = 30;
                }
                int n15 = n10 - 1;
                while (n15 >= 0) {
                    Object object3 = object[n15];
                    try {
                        ((JInternalFrame)object3).setIcon(false);
                        ((JInternalFrame)object3).setMaximum(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Dimension dimension = ((JComponent)object3).getPreferredSize();
                    int n16 = dimension.width;
                    n13 = dimension.height;
                    this.desk.getDesktopManager().setBoundsForFrame((JComponent)object3, n12, n11, n16, n13);
                    --n15;
                    n12 += n14;
                    n11 += n14;
                }
            } else {
                object = this.getFileWindow(string);
                if (object != null) {
                    FileWindow fileWindow = (FileWindow)object;
                    try {
                        if (fileWindow.isIcon()) {
                            fileWindow.setIcon(false);
                        }
                        fileWindow.setVisible(true);
                        fileWindow.moveToFront();
                        fileWindow.setSelected(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (n != -1) {
            if (this.currentWindow != null) {
                this.currentWindow.setPosition(-1);
            }
            object = this.monitor;
            synchronized (object) {
                this.returnValue = n;
                this.monitor.notify();
            }
        }
    }

    void runToCursor(String string, int n, ActionEvent actionEvent) {
        SourceInfo sourceInfo = (SourceInfo)this.sourceNames.get(string);
        if (sourceInfo == null) {
            System.out.println("debugger error: Couldn't find source: " + string);
        }
        if (sourceInfo.breakableLine(n)) {
            this.runToCursorFile = string;
            this.runToCursorLine = n;
            this.actionPerformed(actionEvent);
        }
    }

    JMenu getWindowMenu() {
        return this.menubar.getMenu(3);
    }

    void removeWindow(FileWindow fileWindow) {
        this.fileWindows.remove(fileWindow.getUrl());
        JMenu jMenu = this.getWindowMenu();
        int n = jMenu.getItemCount();
        JMenuItem jMenuItem = jMenu.getItem(n - 1);
        String string = SourceInfo.getShortName(fileWindow.getUrl());
        for (int i = 5; i < n; ++i) {
            int n2;
            String string2;
            JMenuItem jMenuItem2 = jMenu.getItem(i);
            if (jMenuItem2 == null || !(string2 = jMenuItem2.getText()).substring((n2 = string2.indexOf(32)) + 1).equals(string)) continue;
            jMenu.remove(jMenuItem2);
            if (n == 6) {
                jMenu.remove(4);
                break;
            }
            int n3 = i - 4;
            while (i < n - 1) {
                JMenuItem jMenuItem3 = jMenu.getItem(i);
                if (jMenuItem3 != null) {
                    string2 = jMenuItem3.getText();
                    if (string2.equals("More Windows...")) break;
                    n2 = string2.indexOf(32);
                    jMenuItem3.setText((char)(48 + n3) + " " + string2.substring(n2 + 1));
                    jMenuItem3.setMnemonic(48 + n3);
                    ++n3;
                }
                ++i;
            }
            if (n - 6 != 0 || jMenuItem == jMenuItem2 || !jMenuItem.getText().equals("More Windows...")) break;
            jMenu.remove(jMenuItem);
            break;
        }
        jMenu.revalidate();
    }

    boolean stringIsCompilableUnit(String string) {
        Context context = Context.enter();
        boolean bl = context.stringIsCompilableUnit(string);
        context.exit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String eval(String string) {
        String string2;
        Context context = this.getCurrentContext();
        if (context == null) {
            return "undefined";
        }
        ContextData contextData = ContextData.get(context);
        ContextHelper contextHelper = new ContextHelper();
        contextHelper.attach(context);
        if (this.frameIndex >= contextData.getFrameCount()) {
            contextHelper.reset();
            return "undefined";
        }
        context.setDebugger(null, null);
        context.setGeneratingDebug(false);
        context.setOptimizationLevel(-1);
        boolean bl = contextData.breakNextLine;
        contextData.breakNextLine = false;
        try {
            Object object;
            Script script;
            int n = context.getOptimizationLevel();
            try {
                context.setOptimizationLevel(-1);
                script = context.compileString(string, "", 0, null);
            }
            finally {
                context.setOptimizationLevel(n);
            }
            FrameHelper frameHelper = contextData.getFrame(this.frameIndex);
            Scriptable scriptable = frameHelper.getVariableObject();
            if (scriptable instanceof NativeCall && script instanceof Function) {
                NativeCall nativeCall = (NativeCall)scriptable;
                Function function = (Function)((Object)script);
                object = function.call(context, scriptable, nativeCall.getThisObj(), ScriptRuntime.emptyArgs);
            } else {
                object = script.exec(context, scriptable);
            }
            if (object == Undefined.instance) {
                object = "";
            }
            try {
                string2 = ScriptRuntime.toString(object);
            }
            catch (RuntimeException runtimeException) {
                string2 = object.toString();
            }
        }
        catch (Exception exception) {
            string2 = exception.getMessage();
        }
        if (string2 == null) {
            string2 = "null";
        }
        context.setDebugger(this, contextData);
        context.setGeneratingDebug(true);
        context.setOptimizationLevel(-1);
        contextData.breakNextLine = bl;
        contextHelper.reset();
        return string2;
    }

    void Exit() {
        this.returnValue = 6;
        if (this.exitAction != null) {
            Main.swingInvokeLater(this.exitAction);
        }
    }

    static void setResizeWeight(JSplitPane jSplitPane, double d) {
        try {
            Method method = JSplitPane.class.getMethod("setResizeWeight", Double.TYPE);
            method.invoke((Object)jSplitPane, new Double(d));
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    boolean shouldDispatchTo(Component component) {
        Component component2 = SwingUtilities.getRoot(component);
        if (component2 == this) {
            return true;
        }
        Enumeration enumeration = this.toplevels.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            JFrame jFrame = (JFrame)this.toplevels.get(k);
            if (component2 != jFrame) continue;
            return true;
        }
        return false;
    }

    void addTopLevel(String string, JFrame jFrame) {
        if (jFrame != this) {
            this.toplevels.put(string, jFrame);
        }
    }

    JInternalFrame getFrameForUrl(URL uRL) {
        JInternalFrame[] jInternalFrameArray = this.desk.getAllFrames();
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            FileWindow fileWindow = (FileWindow)jInternalFrameArray[i];
            if (!uRL.toString().equals(fileWindow.getUrl())) continue;
            return fileWindow;
        }
        return null;
    }

    public void highlighLineInSelectedWindow(URL uRL, int n) {
        FileWindow fileWindow = (FileWindow)this.getSelectedFrame();
        if (fileWindow != null && n > -1) {
            Main.swingInvoke(new SetFilePosition(this, fileWindow, n));
        }
    }

    public Object runSelectedWindow(URL uRL) throws Exception {
        Object object = null;
        FileWindow fileWindow = (FileWindow)this.getSelectedFrame();
        fileWindow.toFront();
        if (fileWindow != null) {
            Scriptable scriptable = fileWindow.db.getScope();
            if (scriptable == null) {
                MessageDialogWrapper.showMessageDialog(fileWindow.db, "Can't load scripts: no scope available", "Run", 0);
                object = null;
            } else {
                String string = fileWindow.getUrl();
                Object var6_6 = null;
                if (string != null) {
                    LoadFile loadFile = new LoadFile(fileWindow.db, scriptable, string, new StringReader(fileWindow.textArea.getText()), true);
                    loadFile.run();
                    object = loadFile.result;
                    if (loadFile.exception != null) {
                        throw loadFile.exception;
                    }
                }
            }
        }
        return object;
    }

    public Main(String string) {
        super(string);
        this.init();
    }

    public void setBreakOnExceptions(boolean bl) {
        this.breakOnExceptions = bl;
    }

    public void setBreakOnEnter(boolean bl) {
        this.breakOnEnter = bl;
    }

    public void setBreakOnReturn(boolean bl) {
        this.breakOnReturn = bl;
    }

    public void clearAllBreakpoints() {
        Enumeration enumeration = this.sourceNames.elements();
        while (enumeration.hasMoreElements()) {
            SourceInfo sourceInfo = (SourceInfo)enumeration.nextElement();
            sourceInfo.removeAllBreakpoints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go() {
        this.returnValue = 3;
        Object object = this.monitor;
        synchronized (object) {
            this.returnValue = this.returnValue;
            this.monitor.notifyAll();
        }
    }

    public void setScopeProvider(ScopeProvider scopeProvider) {
        this.scopeProvider = scopeProvider;
    }

    public void setExitAction(Runnable runnable) {
        this.exitAction = runnable;
    }

    public InputStream getIn() {
        return this.console.getIn();
    }

    public PrintStream getOut() {
        return this.console.getOut();
    }

    public PrintStream getErr() {
        return this.console.getErr();
    }

    public void openFile(URL uRL, Scriptable scriptable, Runnable runnable) {
        if (scriptable == null) {
            MessageDialogWrapper.showMessageDialog(this, "Can't compile scripts: no scope available", "Open", 0);
        } else if (uRL != null) {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
                String string = null;
                string = uRL.getProtocol().startsWith("vnd.sun.star.") ? uRL.toString() : uRL.getPath();
                this.officeScripts.addScript(string, uRL, scriptable, runnable);
                Main.swingInvoke(new OpenFile(this, string, inputStreamReader));
            }
            catch (IOException iOException) {
                MessageDialogWrapper.showMessageDialog(this, "Can't open stream for script: " + iOException.toString(), "Open", 0);
            }
        }
        this.split1.setDividerLocation(1.0);
    }

    public void openFile(String string) {
        Scriptable scriptable = this.getScope();
        if (scriptable == null) {
            MessageDialogWrapper.showMessageDialog(this, "Can't compile scripts: no scope available", "Open", 0);
        } else if (string != null) {
            new Thread(new OpenFile(this, string)).start();
        }
        this.split1.setDividerLocation(1.0);
    }

    public void openStream(InputStream inputStream) {
        Scriptable scriptable = this.getScope();
        if (scriptable == null) {
            MessageDialogWrapper.showMessageDialog(this, "Can't compile scripts: no scope available", "Open", 0);
        } else if (inputStream != null) {
            new Thread(new OpenFile(this, null, new InputStreamReader(inputStream))).start();
        }
        this.split1.setDividerLocation(1.0);
        this.menubar.setSaveEnabled(false);
    }

    public static void main(String[] stringArray) {
        try {
            mainThread = Thread.currentThread();
            final Main main = new Main("Rhino JavaScript Debugger");
            Main.swingInvoke(new Runnable(){

                public void run() {
                    main.pack();
                    main.setSize(600, 460);
                    main.setVisible(true);
                }
            });
            main.setExitAction(new Runnable(){

                public void run() {
                    System.exit(0);
                }
            });
            System.setIn(main.getIn());
            System.setOut(main.getOut());
            System.setErr(main.getErr());
            Context.addContextListener(main);
            main.setScopeProvider(new ScopeProvider(){

                public Scriptable getScope() {
                    return org.mozilla.javascript.tools.shell.Main.getScope();
                }
            });
            org.mozilla.javascript.tools.shell.Main.exec(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeScript(String string) {
        this.fileWindows.remove(string);
        Hashtable hashtable = this.sourceNames;
        synchronized (hashtable) {
            this.sourceNames.remove(string);
        }
        hashtable = this.scriptItems;
        synchronized (hashtable) {
            Iterator iterator = this.scriptItems.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ScriptItem scriptItem = (ScriptItem)entry.getValue();
                SourceInfo sourceInfo = scriptItem.getSourceInfo();
                if (!sourceInfo.getUrl().equals(string)) continue;
                this.scriptItems.remove(entry.getKey());
                break;
            }
        }
        this.officeScripts.deleteScript(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ScriptItem getScriptItem(DebuggableScript debuggableScript) {
        ScriptItem scriptItem = (ScriptItem)this.scriptItems.get(debuggableScript);
        if (scriptItem == null) {
            String string = this.getNormilizedUrl(debuggableScript);
            SourceInfo sourceInfo = (SourceInfo)this.sourceNames.get(string);
            if (sourceInfo == null && !debuggableScript.isGeneratedScript()) {
                String string2 = null;
                try {
                    InputStream inputStream = Main.openSource(string);
                    try {
                        string2 = Main.readSource(inputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    System.err.println("Failed to load source from " + string + ": " + iOException);
                }
                if (string2 != null) {
                    sourceInfo = this.registerSource(string, string2);
                }
            }
            if (sourceInfo != null) {
                scriptItem = this.registerScript(sourceInfo, debuggableScript);
            }
        }
        return scriptItem;
    }

    public void showScriptWindow(URL uRL) {
        FileWindow fileWindow;
        String string = uRL.getPath();
        if (uRL.getProtocol().startsWith("vnd.sun.star")) {
            string = uRL.toString();
        }
        if ((fileWindow = this.getFileWindow(string)) != null) {
            this.desk.getDesktopManager().deiconifyFrame(fileWindow);
            this.desk.getDesktopManager().activateFrame(fileWindow);
            fileWindow.show();
            fileWindow.toFront();
        }
    }

    public void highlighLineInScriptWindow(URL uRL, int n) {
        FileWindow fileWindow;
        String string = uRL.getPath();
        if (uRL.getProtocol().startsWith("vnd.sun.star")) {
            string = uRL.getPath();
        }
        if ((fileWindow = this.getFileWindow(string)) != null && n > -1) {
            Main.swingInvoke(new SetFilePosition(this, fileWindow, n));
        }
    }

    public Object runScriptWindow(URL uRL) throws Exception {
        String string = uRL.getPath();
        if (uRL.getProtocol().startsWith("vnd.sun.star")) {
            string = uRL.toString();
        }
        FileWindow fileWindow = this.getFileWindow(string);
        Object object = null;
        fileWindow.toFront();
        if (fileWindow != null) {
            Scriptable scriptable = fileWindow.db.officeScripts.getScriptScope(string);
            if (scriptable == null) {
                MessageDialogWrapper.showMessageDialog(fileWindow.db, "Can't load scripts: no scope available", "Run", 0);
                object = null;
            } else {
                String string2 = fileWindow.getUrl();
                Object var7_7 = null;
                if (string2 != null) {
                    LoadFile loadFile = new LoadFile(fileWindow.db, scriptable, string2, new StringReader(fileWindow.textArea.getText()), true);
                    loadFile.run();
                    object = loadFile.result;
                    if (loadFile.exception != null) {
                        throw loadFile.exception;
                    }
                }
            }
        }
        return object;
    }

    public boolean isModified(URL uRL) {
        String string = uRL.getPath();
        if (uRL.getProtocol().startsWith("vnd.sun.star")) {
            string = uRL.toString();
        }
        FileWindow fileWindow = this.getFileWindow(string);
        return fileWindow.isModified();
    }

    public String getText(URL uRL) {
        String string = uRL.toString();
        if (uRL.getProtocol().startsWith("vnd.sun.star")) {
            string = uRL.toString();
        }
        FileWindow fileWindow = this.getFileWindow(string);
        return fileWindow.getText();
    }

    class ThreadState {
        private int stopAtFrameDepth = -1;

        ThreadState() {
        }
    }
}

