/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeWith;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public final class OptRuntime
extends ScriptRuntime {
    public static final Double zeroObj = new Double(0.0);
    public static final Double oneObj = new Double(1.0);
    public static final Double minusOneObj = new Double(-1.0);

    public static Object getElem(Object object, double d, Scriptable scriptable) {
        Scriptable scriptable2;
        Scriptable scriptable3;
        int n = (int)d;
        if ((double)n != d) {
            String string = OptRuntime.toString(d);
            for (scriptable3 = scriptable2 = object instanceof Scriptable ? (Scriptable)object : OptRuntime.toObject(scriptable, object); scriptable3 != null; scriptable3 = scriptable3.getPrototype()) {
                Object object2 = scriptable3.get(string, scriptable2);
                if (object2 == Scriptable.NOT_FOUND) continue;
                return object2;
            }
        } else {
            while (scriptable3 != null) {
                Object object3 = scriptable3.get(n, scriptable2);
                if (object3 != Scriptable.NOT_FOUND) {
                    return object3;
                }
                scriptable3 = scriptable3.getPrototype();
            }
        }
        return Undefined.instance;
    }

    public static Object setElem(Object object, double d, Object object2, Scriptable scriptable) {
        Scriptable scriptable2;
        int n = (int)d;
        Scriptable scriptable3 = scriptable2 = object instanceof Scriptable ? (Scriptable)object : OptRuntime.toObject(scriptable, object);
        if ((double)n != d) {
            String string = OptRuntime.toString(d);
            do {
                if (!scriptable3.has(string, scriptable2)) continue;
                scriptable3.put(string, scriptable2, object2);
                return object2;
            } while ((scriptable3 = scriptable3.getPrototype()) != null);
            scriptable2.put(string, scriptable2, object2);
        } else {
            do {
                if (!scriptable3.has(n, scriptable2)) continue;
                scriptable3.put(n, scriptable2, object2);
                return object2;
            } while ((scriptable3 = scriptable3.getPrototype()) != null);
            scriptable2.put(n, scriptable2, object2);
        }
        return object2;
    }

    public static Object add(Object object, double d) {
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(null);
        }
        if (!(object instanceof String)) {
            return new Double(OptRuntime.toNumber(object) + d);
        }
        return OptRuntime.toString(object).concat(OptRuntime.toString(d));
    }

    public static Object add(double d, Object object) {
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(null);
        }
        if (!(object instanceof String)) {
            return new Double(OptRuntime.toNumber(object) + d);
        }
        return OptRuntime.toString(d).concat(OptRuntime.toString(object));
    }

    public static boolean neq(Object object, Object object2) {
        return !OptRuntime.eq(object, object2);
    }

    public static boolean shallowNeq(Object object, Object object2) {
        return !OptRuntime.shallowEq(object, object2);
    }

    public static Boolean cmp_LTB(double d, Object object) {
        if (OptRuntime.cmp_LT(d, object) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int cmp_LT(double d, Object object) {
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(NumberClass);
        }
        if (!(object instanceof String)) {
            if (d != d) {
                return 0;
            }
            double d2 = OptRuntime.toNumber(object);
            if (d2 != d2) {
                return 0;
            }
            return d < d2 ? 1 : 0;
        }
        return OptRuntime.toString(d).compareTo(OptRuntime.toString(object)) < 0 ? 1 : 0;
    }

    public static Boolean cmp_LTB(Object object, double d) {
        if (OptRuntime.cmp_LT(object, d) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int cmp_LT(Object object, double d) {
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(NumberClass);
        }
        if (!(object instanceof String)) {
            double d2 = OptRuntime.toNumber(object);
            if (d2 != d2) {
                return 0;
            }
            if (d != d) {
                return 0;
            }
            return d2 < d ? 1 : 0;
        }
        return OptRuntime.toString(object).compareTo(OptRuntime.toString(d)) < 0 ? 1 : 0;
    }

    public static Boolean cmp_LEB(double d, Object object) {
        if (OptRuntime.cmp_LE(d, object) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int cmp_LE(double d, Object object) {
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(NumberClass);
        }
        if (!(object instanceof String)) {
            if (d != d) {
                return 0;
            }
            double d2 = OptRuntime.toNumber(object);
            if (d2 != d2) {
                return 0;
            }
            return d <= d2 ? 1 : 0;
        }
        return OptRuntime.toString(d).compareTo(OptRuntime.toString(object)) <= 0 ? 1 : 0;
    }

    public static Boolean cmp_LEB(Object object, double d) {
        if (OptRuntime.cmp_LE(object, d) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static int cmp_LE(Object object, double d) {
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(NumberClass);
        }
        if (!(object instanceof String)) {
            double d2 = OptRuntime.toNumber(object);
            if (d2 != d2) {
                return 0;
            }
            if (d != d) {
                return 0;
            }
            return d2 <= d ? 1 : 0;
        }
        return OptRuntime.toString(object).compareTo(OptRuntime.toString(d)) <= 0 ? 1 : 0;
    }

    public static int cmp(Object object, Object object2) {
        if (object instanceof Scriptable) {
            object = ((Scriptable)object).getDefaultValue(NumberClass);
        }
        if (object2 instanceof Scriptable) {
            object2 = ((Scriptable)object2).getDefaultValue(NumberClass);
        }
        if (!(object instanceof String) || !(object2 instanceof String)) {
            double d = OptRuntime.toNumber(object);
            if (d != d) {
                return -1;
            }
            double d2 = OptRuntime.toNumber(object2);
            if (d2 != d2) {
                return -1;
            }
            return d < d2 ? 1 : 0;
        }
        return OptRuntime.toString(object).compareTo(OptRuntime.toString(object2)) < 0 ? 1 : 0;
    }

    public static Object callSimple(Context context, String string, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        Object[] objectArray2;
        Object object = null;
        Scriptable scriptable2 = null;
        block0: for (Scriptable scriptable3 = scriptable; scriptable3 != null; scriptable3 = scriptable3.getParentScope()) {
            objectArray2 = scriptable3;
            do {
                if ((object = objectArray2.get(string, scriptable3)) == Scriptable.NOT_FOUND) continue;
                scriptable2 = scriptable3;
                break block0;
            } while ((objectArray2 = objectArray2.getPrototype()) != null);
        }
        if (object == null || object == Scriptable.NOT_FOUND) {
            objectArray2 = ScriptRuntime.getMessage1("msg.is.not.defined", string);
            throw ScriptRuntime.constructError("ReferenceError", (String)objectArray2);
        }
        while (scriptable2 instanceof NativeWith) {
            scriptable2 = scriptable2.getPrototype();
        }
        if (scriptable2 instanceof NativeCall) {
            scriptable2 = ScriptableObject.getTopLevelScope(scriptable2);
        }
        if (!(object instanceof Function)) {
            objectArray2 = new Object[]{OptRuntime.toString(object)};
            throw Context.reportRuntimeError(OptRuntime.getMessage("msg.isnt.function", objectArray2));
        }
        objectArray2 = (Function)object;
        return objectArray2.call(context, scriptable, scriptable2, objectArray);
    }

    public static Object thisGet(Scriptable scriptable, String string, Scriptable scriptable2) {
        if (scriptable == null) {
            throw Context.reportRuntimeError(OptRuntime.getMessage("msg.null.to.object", null));
        }
        Object object = scriptable.get(string, scriptable);
        if (object != Scriptable.NOT_FOUND) {
            return object;
        }
        for (Scriptable scriptable3 = scriptable.getPrototype(); scriptable3 != null; scriptable3 = scriptable3.getPrototype()) {
            object = scriptable3.get(string, scriptable);
            if (object == Scriptable.NOT_FOUND) continue;
            return object;
        }
        return Undefined.instance;
    }

    public static Object[] padStart(Object[] objectArray, int n) {
        Object[] objectArray2 = new Object[objectArray.length + n];
        System.arraycopy(objectArray, 0, objectArray2, n, objectArray.length);
        return objectArray2;
    }

    public static void initFunction(NativeFunction nativeFunction, int n, Scriptable scriptable, Context context) {
        ScriptRuntime.initFunction(context, scriptable, nativeFunction, n, false);
    }

    public static Object callSpecial(Context context, Object object, Object object2, Object[] objectArray, Scriptable scriptable, Scriptable scriptable2, int n, String string, int n2) throws JavaScriptException {
        return ScriptRuntime.callSpecial(context, object, false, object2, objectArray, scriptable, scriptable2, n, string, n2);
    }

    public static Object newObjectSpecial(Context context, Object object, Object[] objectArray, Scriptable scriptable, Scriptable scriptable2, int n) throws JavaScriptException {
        return ScriptRuntime.callSpecial(context, object, true, null, objectArray, scriptable, scriptable2, n, "", -1);
    }

    public static Double wrapDouble(double d) {
        if (d == 0.0) {
            if (1.0 / d > 0.0) {
                return zeroObj;
            }
        } else {
            if (d == 1.0) {
                return oneObj;
            }
            if (d == -1.0) {
                return minusOneObj;
            }
            if (d != d) {
                return NaNobj;
            }
        }
        return new Double(d);
    }
}

