/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.optimizer.Block;

public class FatBlock {
    private ObjToIntMap itsSuccessors = new ObjToIntMap();
    private ObjToIntMap itsPredecessors = new ObjToIntMap();
    private Block itsShadowOfFormerSelf;

    public FatBlock(int n, int n2, Node[] nodeArray) {
        this.itsShadowOfFormerSelf = new Block(n, n2, nodeArray);
    }

    public Node getEndNode() {
        return this.itsShadowOfFormerSelf.getEndNode();
    }

    public Block getSlimmerSelf() {
        return this.itsShadowOfFormerSelf;
    }

    private Block[] reduceToArray(ObjToIntMap objToIntMap) {
        Block[] blockArray = null;
        if (!objToIntMap.isEmpty()) {
            blockArray = new Block[objToIntMap.size()];
            int n = 0;
            ObjToIntMap.Iterator iterator = objToIntMap.newIterator();
            iterator.start();
            while (!iterator.done()) {
                FatBlock fatBlock = (FatBlock)iterator.getKey();
                blockArray[n++] = fatBlock.itsShadowOfFormerSelf;
                iterator.next();
            }
        }
        return blockArray;
    }

    Block diet() {
        this.itsShadowOfFormerSelf.setSuccessorList(this.reduceToArray(this.itsSuccessors));
        this.itsShadowOfFormerSelf.setPredecessorList(this.reduceToArray(this.itsPredecessors));
        return this.itsShadowOfFormerSelf;
    }

    public void addSuccessor(FatBlock fatBlock) {
        this.itsSuccessors.put(fatBlock, 0);
    }

    public void addPredecessor(FatBlock fatBlock) {
        this.itsPredecessors.put(fatBlock, 0);
    }
}

