/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public abstract class JIFunction
extends BaseFunction {
    private int arity;

    public JIFunction() {
    }

    public JIFunction(String string, int n) {
        this.initNameArity(string, n);
    }

    protected final void initNameArity(String string, int n) {
        this.functionName = string;
        this.arity = n;
    }

    public final void defineAsProperty(Scriptable scriptable) {
        this.defineAsProperty(scriptable, 2, false);
    }

    public final void defineAsProperty(Scriptable scriptable, int n) {
        this.defineAsProperty(scriptable, n, false);
    }

    public final void defineAsProperty(Scriptable scriptable, int n, boolean bl) {
        this.setParentScope(scriptable);
        if (bl) {
            this.sealObject();
        }
        ScriptableObject.defineProperty(scriptable, this.functionName, this, n);
    }

    public Scriptable getPrototype() {
        Scriptable scriptable = super.getPrototype();
        if (scriptable == null) {
            scriptable = JIFunction.getFunctionPrototype(this.getParentScope());
            this.setPrototype(scriptable);
        }
        return scriptable;
    }

    public abstract Object call(Context var1, Scriptable var2, Scriptable var3, Object[] var4) throws JavaScriptException;

    public int getArity() {
        return this.arity;
    }

    public int getLength() {
        return this.getArity();
    }
}

