/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.InterpretedScript;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.UintMap;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.debug.DebugFrame;

public class Interpreter {
    private static final int BASE_ICODE = 67;
    private static final int Icode_DUP = 68;
    private static final int Icode_DUPSECOND = 69;
    private static final int Icode_SWAP = 70;
    private static final int Icode_IFEQ_POP = 71;
    private static final int Icode_NAMEINC = 72;
    private static final int Icode_PROPINC = 73;
    private static final int Icode_ELEMINC = 74;
    private static final int Icode_VARINC = 75;
    private static final int Icode_NAMEDEC = 76;
    private static final int Icode_PROPDEC = 77;
    private static final int Icode_ELEMDEC = 78;
    private static final int Icode_VARDEC = 79;
    private static final int Icode_SCOPE = 80;
    private static final int Icode_TYPEOFNAME = 81;
    private static final int Icode_NAME_AND_THIS = 82;
    private static final int Icode_PUSH_PARENT = 83;
    private static final int Icode_GETPROTO = 84;
    private static final int Icode_GETSCOPEPARENT = 85;
    private static final int Icode_SETPROTO = 86;
    private static final int Icode_SETPARENT = 87;
    private static final int Icode_CLOSURE = 88;
    private static final int Icode_CALLSPECIAL = 89;
    private static final int Icode_RETUNDEF = 90;
    private static final int Icode_CATCH = 91;
    private static final int Icode_GOSUB = 92;
    private static final int Icode_RETSUB = 93;
    private static final int Icode_LINE = 94;
    private static final int Icode_SHORTNUMBER = 95;
    private static final int Icode_INTNUMBER = 96;
    private static final int END_ICODE = 97;
    private CompilerEnvirons compilerEnv;
    private boolean itsInFunctionFlag;
    private InterpreterData itsData;
    private ScriptOrFnNode scriptOrFn;
    private int itsStackDepth = 0;
    private int itsWithDepth = 0;
    private int itsLineNumber = 0;
    private int itsDoubleTableTop;
    private ObjToIntMap itsStrings = new ObjToIntMap(20);
    private String lastAddString;
    private int itsLocalTop;
    private static final int MIN_LABEL_TABLE_SIZE = 32;
    private static final int MIN_FIXUP_TABLE_SIZE = 40;
    private int[] itsLabelTable;
    private int itsLabelTableTop;
    private long[] itsFixupTable;
    private int itsFixupTableTop;
    private int itsExceptionTableTop;
    private static final int EXCEPTION_SLOT_SIZE = 6;
    private static final int EXCEPTION_TRY_START_SLOT = 0;
    private static final int EXCEPTION_TRY_END_SLOT = 1;
    private static final int EXCEPTION_CATCH_SLOT = 2;
    private static final int EXCEPTION_FINALLY_SLOT = 3;
    private static final int EXCEPTION_WITH_DEPTH_SLOT = 4;
    private static final int EXCEPTION_LOCAL_SLOT = 5;
    private static final Object DBL_MRK = new Object();

    public Object compile(Scriptable scriptable, CompilerEnvirons compilerEnvirons, ScriptOrFnNode scriptOrFnNode, String string, boolean bl, Object object) {
        Object object2;
        Context context;
        SecurityController securityController;
        this.compilerEnv = compilerEnvirons;
        new NodeTransformer(compilerEnvirons).transform(scriptOrFnNode);
        if (bl) {
            scriptOrFnNode = scriptOrFnNode.getFunctionNode(0);
        }
        if ((securityController = (context = Context.getContext()).getSecurityController()) != null) {
            object2 = securityController.getDynamicSecurityDomain(object);
        } else {
            if (object != null) {
                throw new IllegalArgumentException();
            }
            object2 = null;
        }
        this.scriptOrFn = scriptOrFnNode;
        this.itsData = new InterpreterData(securityController, object2, compilerEnvirons.getLanguageVersion(), this.scriptOrFn.getSourceName(), string);
        this.itsData.topLevel = true;
        if (scriptOrFnNode instanceof FunctionNode) {
            this.generateFunctionICode();
            return Interpreter.createFunction(context, scriptable, this.itsData, false);
        }
        this.generateICodeFromTree(this.scriptOrFn);
        this.itsData.itsFromEvalCode = compilerEnvirons.isFromEval();
        return new InterpretedScript(this.itsData);
    }

    public void notifyDebuggerCompilationDone(Context context, Object object, String string) {
        InterpreterData interpreterData = object instanceof InterpretedScript ? ((InterpretedScript)object).itsData : ((InterpretedFunction)object).itsData;
        Interpreter.notifyDebugger_r(context, interpreterData, string);
    }

    private static void notifyDebugger_r(Context context, InterpreterData interpreterData, String string) {
        context.debugger.handleCompilationDone(context, interpreterData, string);
        if (interpreterData.itsNestedFunctions != null) {
            for (int i = 0; i != interpreterData.itsNestedFunctions.length; ++i) {
                Interpreter.notifyDebugger_r(context, interpreterData.itsNestedFunctions[i], string);
            }
        }
    }

    private void generateFunctionICode() {
        FunctionNode functionNode = (FunctionNode)this.scriptOrFn;
        this.itsData.itsFunctionType = functionNode.getFunctionType();
        this.itsData.itsNeedsActivation = functionNode.requiresActivation();
        this.itsData.itsName = functionNode.getFunctionName();
        if ((functionNode.getParamAndVarCount() & 0xFFFFFF00) != 0) {
            this.itsData.itsNeedsActivation = true;
        }
        if (!functionNode.getIgnoreDynamicScope() && this.compilerEnv.isUseDynamicScope()) {
            this.itsData.useDynamicScope = true;
        }
        this.generateICodeFromTree(functionNode.getLastChild());
    }

    private void generateICodeFromTree(Node node) {
        Object object;
        this.generateNestedFunctions();
        this.generateRegExpLiterals();
        int n = 0;
        n = this.generateICode(node, n);
        this.fixLabelGotos();
        if (this.itsData.itsFunctionType == 0) {
            n = this.addToken(67, n);
        }
        this.itsData.itsICodeTop = n = this.addIcode(91, n);
        if (this.itsData.itsICode.length != n) {
            object = new byte[n];
            System.arraycopy(this.itsData.itsICode, 0, object, 0, n);
            this.itsData.itsICode = object;
        }
        if (this.itsStrings.size() == 0) {
            this.itsData.itsStringTable = null;
        } else {
            this.itsData.itsStringTable = new String[this.itsStrings.size()];
            object = this.itsStrings.newIterator();
            ((ObjToIntMap.Iterator)object).start();
            while (!((ObjToIntMap.Iterator)object).done()) {
                String string = (String)((ObjToIntMap.Iterator)object).getKey();
                int n2 = ((ObjToIntMap.Iterator)object).getValue();
                if (this.itsData.itsStringTable[n2] != null) {
                    Kit.codeBug();
                }
                this.itsData.itsStringTable[n2] = string;
                ((ObjToIntMap.Iterator)object).next();
            }
        }
        if (this.itsDoubleTableTop == 0) {
            this.itsData.itsDoubleTable = null;
        } else if (this.itsData.itsDoubleTable.length != this.itsDoubleTableTop) {
            object = new double[this.itsDoubleTableTop];
            System.arraycopy(this.itsData.itsDoubleTable, 0, object, 0, this.itsDoubleTableTop);
            this.itsData.itsDoubleTable = (double[])object;
        }
        if (this.itsExceptionTableTop != 0 && this.itsData.itsExceptionTable.length != this.itsExceptionTableTop) {
            object = new int[this.itsExceptionTableTop];
            System.arraycopy(this.itsData.itsExceptionTable, 0, object, 0, this.itsExceptionTableTop);
            this.itsData.itsExceptionTable = (int[])object;
        }
        this.itsData.itsMaxVars = this.scriptOrFn.getParamAndVarCount();
        this.itsData.itsMaxFrameArray = this.itsData.itsMaxVars + this.itsData.itsMaxLocals + this.itsData.itsMaxStack;
        this.itsData.argNames = this.scriptOrFn.getParamAndVarNames();
        this.itsData.argCount = this.scriptOrFn.getParamCount();
        this.itsData.encodedSourceStart = this.scriptOrFn.getEncodedSourceStart();
        this.itsData.encodedSourceEnd = this.scriptOrFn.getEncodedSourceEnd();
    }

    private void generateNestedFunctions() {
        int n = this.scriptOrFn.getFunctionCount();
        if (n == 0) {
            return;
        }
        InterpreterData[] interpreterDataArray = new InterpreterData[n];
        for (int i = 0; i != n; ++i) {
            FunctionNode functionNode = this.scriptOrFn.getFunctionNode(i);
            Interpreter interpreter = new Interpreter();
            interpreter.compilerEnv = this.compilerEnv;
            interpreter.scriptOrFn = functionNode;
            interpreter.itsData = new InterpreterData(this.itsData);
            interpreter.itsData.itsCheckThis = functionNode.getCheckThis();
            interpreter.itsInFunctionFlag = true;
            interpreter.generateFunctionICode();
            interpreterDataArray[i] = interpreter.itsData;
        }
        this.itsData.itsNestedFunctions = interpreterDataArray;
    }

    private void generateRegExpLiterals() {
        int n = this.scriptOrFn.getRegexpCount();
        if (n == 0) {
            return;
        }
        Context context = Context.getContext();
        RegExpProxy regExpProxy = ScriptRuntime.checkRegExpProxy(context);
        Object[] objectArray = new Object[n];
        for (int i = 0; i != n; ++i) {
            String string = this.scriptOrFn.getRegexpString(i);
            String string2 = this.scriptOrFn.getRegexpFlags(i);
            objectArray[i] = regExpProxy.compileRegExp(context, string, string2);
        }
        this.itsData.itsRegExpLiterals = objectArray;
    }

    private int updateLineNumber(Node node, int n) {
        int n2 = node.getLineno();
        if (n2 != this.itsLineNumber && n2 >= 0) {
            this.itsLineNumber = n2;
            n = this.addIcode(94, n);
            n = this.addShort(n2, n);
        }
        return n;
    }

    private void badTree(Node node) {
        throw new RuntimeException("Un-handled node: " + node.toString());
    }

    private int generateICode(Node node, int n) {
        Node node2;
        int n2 = node.getType();
        Node node3 = node2 = node.getFirstChild();
        int n3 = this.itsStackDepth++;
        int n4 = 0;
        boolean bl = false;
        block0 : switch (n2) {
            case 87: {
                int n5 = node.getExistingIntProp(1);
                FunctionNode functionNode = this.scriptOrFn.getFunctionNode(n5);
                if (functionNode.getFunctionType() != 1) {
                    n4 = 1;
                    n = this.addIcode(88, n);
                    n = this.addIndex(n5, n);
                    if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                    this.itsData.itsMaxStack = this.itsStackDepth;
                    break;
                }
                bl = true;
                break;
            }
            case 118: {
                bl = true;
                n = this.updateLineNumber(node, n);
                while (node2 != null) {
                    if (node2.getType() != 87) {
                        n = this.generateICode(node2, n);
                    }
                    node2 = node2.getNext();
                }
                break;
            }
            case 93: {
                node2 = node2.getNext();
            }
            case 94: 
            case 101: 
            case 106: 
            case 107: 
            case 110: 
            case 112: {
                bl = true;
                n = this.updateLineNumber(node, n);
                while (node2 != null) {
                    n = this.generateICode(node2, n);
                    node2 = node2.getNext();
                }
                break;
            }
            case 124: {
                bl = true;
                if ((this.itsLocalTop & 0xFFFFFF00) != 0) {
                    throw Context.reportRuntimeError("Program too complex (out of locals)");
                }
                node.putIntProp(3, this.itsLocalTop);
                ++this.itsLocalTop;
                if (this.itsLocalTop > this.itsData.itsMaxLocals) {
                    this.itsData.itsMaxLocals = this.itsLocalTop;
                }
                n = this.updateLineNumber(node, n);
                while (node2 != null) {
                    n = this.generateICode(node2, n);
                    node2 = node2.getNext();
                }
                --this.itsLocalTop;
                break;
            }
            case 57: {
                n4 = 1;
                n = this.addToken(57, n);
                n = this.addLocalBlockRef(node, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 77: {
                n4 = 1;
                n = this.generateICode(node2, n);
                while (null != (node2 = node2.getNext())) {
                    if (1 != this.itsStackDepth - n3) {
                        Kit.codeBug();
                    }
                    n = this.addToken(51, n);
                    --this.itsStackDepth;
                    n = this.generateICode(node2, n);
                }
                break;
            }
            case 123: {
                n4 = 1;
                n = this.generateICode(node2, n);
                while (null != (node2 = node2.getNext())) {
                    if (1 != this.itsStackDepth - n3) {
                        Kit.codeBug();
                    }
                    n = this.addIcode(68, n);
                    n = this.generateICode(node2, n);
                    n = this.addToken(51, n);
                    --this.itsStackDepth;
                }
                break;
            }
            case 120: {
                n4 = 1;
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 92: {
                Node node4;
                bl = true;
                Node.Jump jump = (Node.Jump)node;
                n = this.updateLineNumber(jump, n);
                n = this.generateICode(node2, n);
                ObjArray objArray = (ObjArray)jump.getProp(8);
                for (int i = 0; i < objArray.size(); ++i) {
                    node4 = (Node)objArray.get(i);
                    Node node5 = node4.getFirstChild();
                    n = this.generateICode(node5, n);
                    n = this.addIcode(69, n);
                    ++this.itsStackDepth;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    n = this.addToken(48, n);
                    --this.itsStackDepth;
                    Node.Target target = new Node.Target();
                    node4.addChildAfter(target, node5);
                    n = this.addGoto(target, 71, n);
                    --this.itsStackDepth;
                }
                n = this.addToken(51, n);
                --this.itsStackDepth;
                Node node6 = (Node)jump.getProp(9);
                if (node6 != null) {
                    node4 = new Node.Target();
                    node6.getFirstChild().addChildToFront(node4);
                    n = this.addGoto((Node.Target)node4, 6, n);
                }
                node4 = jump.target;
                n = this.addGoto((Node.Target)node4, 6, n);
                break;
            }
            case 111: {
                bl = true;
                this.markTargetLabel((Node.Target)node, n);
                break;
            }
            case 31: 
            case 38: {
                n4 = 1;
                if (n2 == 31) {
                    n = this.generateICode(node2, n);
                } else {
                    n = this.generateCallFunAndThis(node2, n);
                    if (this.itsStackDepth - n3 != 2) {
                        Kit.codeBug();
                    }
                }
                String string = null;
                int n6 = node2.getType();
                if (n6 == 39 || n6 == 34 || n6 == 59) {
                    string = this.lastAddString;
                }
                int n7 = 0;
                while ((node2 = node2.getNext()) != null) {
                    n = this.generateICode(node2, n);
                    ++n7;
                }
                int n8 = node.getIntProp(17, 0);
                if (n8 != 0) {
                    n = this.addIcode(89, n);
                    n = this.addByte(n8, n);
                    n = this.addByte(n2 == 31 ? 1 : 0, n);
                    n = this.addShort(this.itsLineNumber, n);
                } else {
                    n = this.addToken(n2, n);
                    n = this.addString(string, n);
                }
                this.itsStackDepth = n2 == 31 ? (this.itsStackDepth -= n7) : (this.itsStackDepth -= n7 + 1);
                n = this.addIndex(n7, n);
                if (n7 <= this.itsData.itsMaxCalleeArgs) break;
                this.itsData.itsMaxCalleeArgs = n7;
                break;
            }
            case 7: 
            case 8: {
                n = this.generateICode(node2, n);
                --this.itsStackDepth;
            }
            case 6: {
                bl = true;
                Node.Target target = ((Node.Jump)node).target;
                n = this.addGoto(target, (byte)n2, n);
                break;
            }
            case 115: {
                bl = true;
                Node.Target target = ((Node.Jump)node).target;
                n = this.addGoto(target, 92, n);
                break;
            }
            case 103: {
                bl = true;
                ++this.itsStackDepth;
                if (this.itsStackDepth > this.itsData.itsMaxStack) {
                    this.itsData.itsMaxStack = this.itsStackDepth;
                }
                int n9 = this.getLocalBlockRef(node);
                n = this.addToken(56, n);
                n = this.addByte(n9, n);
                --this.itsStackDepth;
                while (node2 != null) {
                    n = this.generateICode(node2, n);
                    if (this.itsStackDepth != 0) {
                        Kit.codeBug();
                    }
                    node2 = node2.getNext();
                }
                n = this.addIcode(93, n);
                n = this.addByte(n9, n);
                break;
            }
            case 82: 
            case 83: {
                n4 = 1;
                n = this.generateICode(node2, n);
                n = this.addIcode(68, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth > this.itsData.itsMaxStack) {
                    this.itsData.itsMaxStack = this.itsStackDepth;
                }
                int n10 = n;
                int n11 = n2 == 83 ? 8 : 7;
                n = this.addForwardGoto(n11, n);
                --this.itsStackDepth;
                n = this.addToken(51, n);
                --this.itsStackDepth;
                node2 = node2.getNext();
                n = this.generateICode(node2, n);
                this.resolveForwardGoto(n10, n);
                break;
            }
            case 80: {
                n4 = 1;
                Node node7 = node2.getNext();
                Node node8 = node7.getNext();
                int n12 = n = this.generateICode(node2, n);
                n = this.addForwardGoto(8, n);
                --this.itsStackDepth;
                int n13 = n = this.generateICode(node7, n);
                n = this.addForwardGoto(6, n);
                this.resolveForwardGoto(n12, n);
                this.itsStackDepth = n3;
                n = this.generateICode(node8, n);
                this.resolveForwardGoto(n13, n);
                break;
            }
            case 34: {
                n4 = 1;
                n = this.generateICode(node2, n);
                int n14 = node.getIntProp(11, 0);
                if (n14 != 0) {
                    if (n14 == 1) {
                        n = this.addIcode(84, n);
                        break;
                    }
                    if (n14 == 2) {
                        n = this.addIcode(85, n);
                        break;
                    }
                    this.badTree(node);
                    break;
                }
                node2 = node2.getNext();
                n = this.generateICode(node2, n);
                n = this.addToken(34, n);
                --this.itsStackDepth;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 32: 
            case 36: 
            case 48: 
            case 49: 
            case 54: 
            case 55: {
                n4 = 1;
                n = this.generateICode(node2, n);
                node2 = node2.getNext();
                n = this.generateICode(node2, n);
                n = this.addToken(n2, n);
                --this.itsStackDepth;
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 104: {
                n4 = 1;
                n = this.generateICode(node2, n);
                if (n2 == 104) {
                    n = this.addToken(51, n);
                    n = this.addToken(61, n);
                    break;
                }
                n = this.addToken(n2, n);
                break;
            }
            case 35: 
            case 121: {
                n4 = 1;
                n = this.generateICode(node2, n);
                node2 = node2.getNext();
                int n15 = node.getIntProp(11, 0);
                if (n15 != 0) {
                    if (n2 == 121) {
                        n = this.addIcode(68, n);
                        if (this.itsStackDepth > this.itsData.itsMaxStack) {
                            this.itsData.itsMaxStack = this.itsStackDepth;
                        }
                        if (n15 == 1) {
                            n = this.addIcode(84, n);
                        } else if (n15 == 2) {
                            n = this.addIcode(85, n);
                        } else {
                            this.badTree(node);
                        }
                        --this.itsStackDepth;
                    }
                    n = this.generateICode(node2, n);
                    if (n15 == 1) {
                        n = this.addIcode(86, n);
                    } else if (n15 == 2) {
                        n = this.addIcode(87, n);
                    } else {
                        this.badTree(node);
                    }
                    --this.itsStackDepth;
                    break;
                }
                n = this.generateICode(node2, n);
                node2 = node2.getNext();
                if (n2 == 121) {
                    n = this.addIcode(69, n);
                    n = this.addIcode(69, n);
                    this.itsStackDepth += 2;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    n = this.addToken(34, n);
                    --this.itsStackDepth;
                    --this.itsStackDepth;
                }
                n = this.generateICode(node2, n);
                n = this.addToken(35, n);
                this.itsStackDepth -= 2;
                break;
            }
            case 37: 
            case 122: {
                n4 = 1;
                n = this.generateICode(node2, n);
                node2 = node2.getNext();
                n = this.generateICode(node2, n);
                node2 = node2.getNext();
                if (n2 == 122) {
                    n = this.addIcode(69, n);
                    n = this.addIcode(69, n);
                    this.itsStackDepth += 2;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    n = this.addToken(36, n);
                    --this.itsStackDepth;
                    --this.itsStackDepth;
                }
                n = this.generateICode(node2, n);
                n = this.addToken(37, n);
                this.itsStackDepth -= 2;
                break;
            }
            case 9: {
                n4 = 1;
                n = this.generateICode(node2, n);
                node2 = node2.getNext();
                n = this.generateICode(node2, n);
                n = this.addToken(9, n);
                n = this.addString(node3.getString(), n);
                --this.itsStackDepth;
                break;
            }
            case 119: {
                n4 = 1;
                String string = node.getString();
                int n16 = -1;
                if (this.itsInFunctionFlag && !this.itsData.itsNeedsActivation) {
                    n16 = this.scriptOrFn.getParamOrVarIndex(string);
                }
                if (n16 == -1) {
                    n = this.addIcode(81, n);
                    n = this.addString(string, n);
                } else {
                    n = this.addToken(59, n);
                    n = this.addByte(n16, n);
                    n = this.addToken(33, n);
                }
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 39: 
            case 41: 
            case 52: 
            case 58: {
                n4 = 1;
                n = this.addToken(n2, n);
                n = this.addString(node.getString(), n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 84: 
            case 85: {
                n4 = 1;
                int n17 = node2.getType();
                switch (n17) {
                    case 59: {
                        String string = node2.getString();
                        if (this.itsData.itsNeedsActivation) {
                            n = this.addIcode(80, n);
                            n = this.addToken(41, n);
                            n = this.addString(string, n);
                            this.itsStackDepth += 2;
                            if (this.itsStackDepth > this.itsData.itsMaxStack) {
                                this.itsData.itsMaxStack = this.itsStackDepth;
                            }
                            n = this.addIcode(n2 == 84 ? 73 : 77, n);
                            --this.itsStackDepth;
                            break;
                        }
                        int n18 = this.scriptOrFn.getParamOrVarIndex(string);
                        n = this.addIcode(n2 == 84 ? 75 : 79, n);
                        n = this.addByte(n18, n);
                        ++this.itsStackDepth;
                        if (this.itsStackDepth <= this.itsData.itsMaxStack) break block0;
                        this.itsData.itsMaxStack = this.itsStackDepth;
                        break;
                    }
                    case 34: 
                    case 36: {
                        Node node9 = node2.getFirstChild();
                        n = this.generateICode(node9, n);
                        node9 = node9.getNext();
                        n = this.generateICode(node9, n);
                        int n19 = n17 == 34 ? (n2 == 84 ? 73 : 77) : (n2 == 84 ? 74 : 78);
                        n = this.addIcode(n19, n);
                        --this.itsStackDepth;
                        break;
                    }
                    default: {
                        n = this.addIcode(n2 == 84 ? 72 : 76, n);
                        n = this.addString(node2.getString(), n);
                        ++this.itsStackDepth;
                        if (this.itsStackDepth <= this.itsData.itsMaxStack) break block0;
                        this.itsData.itsMaxStack = this.itsStackDepth;
                        break;
                    }
                }
                break;
            }
            case 40: {
                n4 = 1;
                double d = node.getDouble();
                int n20 = (int)d;
                if ((double)n20 == d) {
                    if (n20 == 0) {
                        n = this.addToken(42, n);
                        if (1.0 / d < 0.0) {
                            n = this.addToken(30, n);
                        }
                    } else if (n20 == 1) {
                        n = this.addToken(43, n);
                    } else if ((short)n20 == n20) {
                        n = this.addIcode(95, n);
                        n = this.addShort(n20, n);
                    } else {
                        n = this.addIcode(96, n);
                        n = this.addInt(n20, n);
                    }
                } else {
                    n = this.addToken(40, n);
                    n = this.addDouble(d, n);
                }
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 2: {
                bl = true;
            }
            case 51: {
                n = this.updateLineNumber(node, n);
                n = this.generateICode(node2, n);
                n = this.addToken(n2, n);
                --this.itsStackDepth;
                break;
            }
            case 3: {
                bl = true;
                n = this.generateICode(node2, n);
                n = this.addToken(3, n);
                --this.itsStackDepth;
                break;
            }
            case 62: {
                n4 = 1;
                n = this.generateICode(node2, n);
                n = this.addToken(62, n);
                n = this.addString(node.getString(), n);
                break;
            }
            case 4: {
                bl = true;
                n = this.addToken(4, n);
                break;
            }
            case 69: {
                bl = true;
                Node.Jump jump = (Node.Jump)node;
                int n21 = this.getLocalBlockRef(jump);
                Node.Target target = jump.target;
                Node.Target target2 = jump.getFinally();
                int n22 = n;
                int n23 = -1;
                int n24 = -1;
                int n25 = -1;
                while (node2 != null) {
                    boolean bl2 = false;
                    if (node2 == target) {
                        if (n23 >= 0) {
                            Kit.codeBug();
                        }
                        n23 = n;
                        n24 = n;
                        this.markTargetLabel((Node.Target)node2, n);
                        bl2 = true;
                    } else if (node2 == target2) {
                        if (n23 < 0) {
                            n23 = n;
                        }
                        n25 = n;
                        this.markTargetLabel((Node.Target)node2, n);
                        bl2 = true;
                    }
                    if (!bl2) {
                        n = this.generateICode(node2, n);
                    }
                    node2 = node2.getNext();
                }
                this.addExceptionHandler(n22, n23, n24, n25, this.itsWithDepth, n21);
                break;
            }
            case 53: {
                bl = true;
                n = this.updateLineNumber(node, n);
                n = this.generateICode(node2, n);
                n = this.addToken(53, n);
                n = this.addShort(this.itsLineNumber, n);
                --this.itsStackDepth;
                break;
            }
            case 5: {
                bl = true;
                n = this.updateLineNumber(node, n);
                if (node2 != null) {
                    n = this.generateICode(node2, n);
                    n = this.addToken(5, n);
                    --this.itsStackDepth;
                    break;
                }
                n = this.addIcode(90, n);
                break;
            }
            case 67: {
                bl = true;
                n = this.updateLineNumber(node, n);
                n = this.addToken(67, n);
                break;
            }
            case 59: {
                n4 = 1;
                String string = node.getString();
                if (this.itsData.itsNeedsActivation) {
                    n = this.addIcode(80, n);
                    n = this.addToken(41, n);
                    n = this.addString(string, n);
                    this.itsStackDepth += 2;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    n = this.addToken(34, n);
                    --this.itsStackDepth;
                    break;
                }
                int n26 = this.scriptOrFn.getParamOrVarIndex(string);
                n = this.addToken(59, n);
                n = this.addByte(n26, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 60: {
                n4 = 1;
                if (this.itsData.itsNeedsActivation) {
                    node2.setType(52);
                    node.setType(9);
                    n = this.generateICode(node, n);
                    break;
                }
                String string = node2.getString();
                node2 = node2.getNext();
                n = this.generateICode(node2, n);
                int n27 = this.scriptOrFn.getParamOrVarIndex(string);
                n = this.addToken(60, n);
                n = this.addByte(n27, n);
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 61: 
            case 66: {
                n4 = 1;
                n = this.addToken(n2, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 63: {
                bl = true;
                n = this.generateICode(node2, n);
                n = this.addToken(63, n);
                n = this.addLocalBlockRef(node, n);
                --this.itsStackDepth;
                break;
            }
            case 64: 
            case 65: {
                n4 = 1;
                n = this.addToken(n2, n);
                n = this.addLocalBlockRef(node, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 50: {
                n4 = 1;
                int n28 = node.getExistingIntProp(7);
                n = this.addToken(50, n);
                n = this.addIndex(n28, n);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            default: {
                this.badTree(node);
            }
        }
        if (n4 != this.itsStackDepth - n3) {
            Kit.codeBug();
        }
        if (bl && (n4 != 0 || this.itsStackDepth != 0)) {
            Kit.codeBug();
        }
        return n;
    }

    private int generateCallFunAndThis(Node node, int n) {
        int n2 = node.getType();
        if (n2 == 39) {
            String string = node.getString();
            n = this.addIcode(82, n);
            n = this.addString(string, n);
            this.itsStackDepth += 2;
            if (this.itsStackDepth > this.itsData.itsMaxStack) {
                this.itsData.itsMaxStack = this.itsStackDepth;
            }
        } else if (n2 == 34 || n2 == 36) {
            Node node2 = node.getFirstChild();
            node.removeChild(node2);
            node.addChildToFront(new Node(120));
            n = this.generateICode(node2, n);
            n = this.addIcode(68, n);
            n = this.generateICode(node, n);
            n = this.addIcode(70, n);
        } else {
            n = this.generateICode(node, n);
            n = this.addIcode(83, n);
            ++this.itsStackDepth;
            if (this.itsStackDepth > this.itsData.itsMaxStack) {
                this.itsData.itsMaxStack = this.itsStackDepth;
            }
        }
        return n;
    }

    private int getLocalBlockRef(Node node) {
        Node node2 = (Node)node.getProp(4);
        return node2.getExistingIntProp(3);
    }

    private int addLocalBlockRef(Node node, int n) {
        int n2 = this.getLocalBlockRef(node);
        n = this.addByte(n2, n);
        return n;
    }

    private int getTargetLabel(Node.Target target) {
        int n = target.labelId;
        if (n != -1) {
            return n;
        }
        n = this.itsLabelTableTop;
        if (this.itsLabelTable == null || n == this.itsLabelTable.length) {
            if (this.itsLabelTable == null) {
                this.itsLabelTable = new int[32];
            } else {
                int[] nArray = new int[this.itsLabelTable.length * 2];
                System.arraycopy(this.itsLabelTable, 0, nArray, 0, n);
                this.itsLabelTable = nArray;
            }
        }
        this.itsLabelTableTop = n + 1;
        this.itsLabelTable[n] = -1;
        target.labelId = n;
        return n;
    }

    private void markTargetLabel(Node.Target target, int n) {
        int n2 = this.getTargetLabel(target);
        if (this.itsLabelTable[n2] != -1) {
            Kit.codeBug();
        }
        this.itsLabelTable[n2] = n;
    }

    private int addGoto(Node.Target target, int n, int n2) {
        int n3 = this.getTargetLabel(target);
        if (n3 >= this.itsLabelTableTop) {
            Kit.codeBug();
        }
        int n4 = this.itsLabelTable[n3];
        int n5 = n2;
        n2 = n > 67 ? this.addIcode(n, n2) : this.addToken(n, n2);
        int n6 = n2;
        n2 = this.addShort(0, n2);
        if (n4 != -1) {
            this.recordJumpOffset(n6, n4 - n5);
        } else {
            int n7 = this.itsFixupTableTop;
            if (this.itsFixupTable == null || n7 == this.itsFixupTable.length) {
                if (this.itsFixupTable == null) {
                    this.itsFixupTable = new long[40];
                } else {
                    long[] lArray = new long[this.itsFixupTable.length * 2];
                    System.arraycopy(this.itsFixupTable, 0, lArray, 0, n7);
                    this.itsFixupTable = lArray;
                }
            }
            this.itsFixupTableTop = n7 + 1;
            this.itsFixupTable[n7] = (long)n3 << 32 | (long)n6;
        }
        return n2;
    }

    private void fixLabelGotos() {
        byte[] byArray = this.itsData.itsICode;
        for (int i = 0; i < this.itsFixupTableTop; ++i) {
            long l = this.itsFixupTable[i];
            int n = (int)(l >> 32);
            int n2 = (int)l;
            int n3 = this.itsLabelTable[n];
            if (n3 == -1) {
                throw new RuntimeException();
            }
            int n4 = n3 - (n2 - 1);
            if ((short)n4 != n4) {
                throw new RuntimeException("Program too complex: too big jump offset");
            }
            byArray[n2] = (byte)(n4 >> 8);
            byArray[n2 + 1] = (byte)n4;
        }
        this.itsFixupTableTop = 0;
    }

    private int addForwardGoto(int n, int n2) {
        n2 = this.addToken(n, n2);
        n2 = this.addShort(0, n2);
        return n2;
    }

    private void resolveForwardGoto(int n, int n2) {
        if (n + 3 > n2) {
            Kit.codeBug();
        }
        int n3 = n2 - n;
        this.recordJumpOffset(n + 1, n3);
    }

    private void recordJumpOffset(int n, int n2) {
        if (n2 != (short)n2) {
            throw Context.reportRuntimeError0("msg.too.big.jump");
        }
        this.itsData.itsICode[n] = (byte)(n2 >> 8);
        this.itsData.itsICode[n + 1] = (byte)n2;
    }

    private int addByte(int n, int n2) {
        byte[] byArray = this.itsData.itsICode;
        if (n2 == byArray.length) {
            byArray = this.increaseICodeCapasity(n2, 1);
        }
        byArray[n2++] = (byte)n;
        return n2;
    }

    private int addToken(int n, int n2) {
        if (2 > n || n > 67) {
            Kit.codeBug();
        }
        return this.addByte(n, n2);
    }

    private int addIcode(int n, int n2) {
        if (67 >= n || n >= 97) {
            Kit.codeBug();
        }
        return this.addByte(n, n2);
    }

    private int addShort(int n, int n2) {
        byte[] byArray = this.itsData.itsICode;
        if (n2 + 2 > byArray.length) {
            byArray = this.increaseICodeCapasity(n2, 2);
        }
        byArray[n2] = (byte)(n >>> 8);
        byArray[n2 + 1] = (byte)n;
        return n2 + 2;
    }

    private int addIndex(int n, int n2) {
        if (n < 0) {
            Kit.codeBug();
        }
        if (n > 65535) {
            throw Context.reportRuntimeError0("msg.too.big.index");
        }
        byte[] byArray = this.itsData.itsICode;
        if (n2 + 2 > byArray.length) {
            byArray = this.increaseICodeCapasity(n2, 2);
        }
        byArray[n2] = (byte)(n >>> 8);
        byArray[n2 + 1] = (byte)n;
        return n2 + 2;
    }

    private int addInt(int n, int n2) {
        byte[] byArray = this.itsData.itsICode;
        if (n2 + 4 > byArray.length) {
            byArray = this.increaseICodeCapasity(n2, 4);
        }
        byArray[n2] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
        return n2 + 4;
    }

    private int addDouble(double d, int n) {
        int n2 = this.itsDoubleTableTop;
        if (n2 == 0) {
            this.itsData.itsDoubleTable = new double[64];
        } else if (this.itsData.itsDoubleTable.length == n2) {
            double[] dArray = new double[n2 * 2];
            System.arraycopy(this.itsData.itsDoubleTable, 0, dArray, 0, n2);
            this.itsData.itsDoubleTable = dArray;
        }
        this.itsData.itsDoubleTable[n2] = d;
        this.itsDoubleTableTop = n2 + 1;
        n = this.addIndex(n2, n);
        return n;
    }

    private int addString(String string, int n) {
        int n2 = this.itsStrings.get(string, -1);
        if (n2 == -1) {
            n2 = this.itsStrings.size();
            this.itsStrings.put(string, n2);
        }
        n = this.addIndex(n2, n);
        this.lastAddString = string;
        return n;
    }

    private void addExceptionHandler(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.itsExceptionTableTop;
        int[] nArray = this.itsData.itsExceptionTable;
        if (nArray == null) {
            if (n7 != 0) {
                Kit.codeBug();
            }
            this.itsData.itsExceptionTable = nArray = new int[12];
        } else if (nArray.length == n7) {
            nArray = new int[nArray.length * 2];
            System.arraycopy(this.itsData.itsExceptionTable, 0, nArray, 0, n7);
            this.itsData.itsExceptionTable = nArray;
        }
        nArray[n7 + 0] = n;
        nArray[n7 + 1] = n2;
        nArray[n7 + 2] = n3;
        nArray[n7 + 3] = n4;
        nArray[n7 + 4] = n5;
        nArray[n7 + 5] = n6;
        this.itsExceptionTableTop = n7 + 6;
    }

    private byte[] increaseICodeCapasity(int n, int n2) {
        int n3 = this.itsData.itsICode.length;
        if (n + n2 <= n3) {
            Kit.codeBug();
        }
        if (n + n2 > (n3 *= 2)) {
            n3 = n + n2;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.itsData.itsICode, 0, byArray, 0, n);
        this.itsData.itsICode = byArray;
        return byArray;
    }

    private static int getShort(byte[] byArray, int n) {
        return byArray[n] << 8 | byArray[n + 1] & 0xFF;
    }

    private static int getIndex(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    private static int getInt(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private static int getTarget(byte[] byArray, int n) {
        int n2 = Interpreter.getShort(byArray, n);
        return n - 1 + n2;
    }

    private static int getExceptionHandler(int[] nArray, int n) {
        if (nArray == null) {
            return -1;
        }
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i != nArray.length; i += 6) {
            int n5 = nArray[i + 0];
            int n6 = nArray[i + 1];
            if (n5 > n || n >= n6 || n2 >= 0 && n3 > n5) continue;
            if (n2 >= 0 && n4 < n6) {
                Kit.codeBug();
            }
            n2 = i;
            n3 = n5;
            n4 = n6;
        }
        return n2;
    }

    private static String icodeToName(int n) {
        return "";
    }

    private static void dumpICode(InterpreterData interpreterData) {
    }

    private static int icodeTokenLength(int n) {
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 54: 
            case 55: 
            case 61: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 80: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 90: 
            case 91: {
                return 1;
            }
            case 53: {
                return 3;
            }
            case 6: 
            case 7: 
            case 8: 
            case 71: 
            case 92: {
                return 3;
            }
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 75: 
            case 79: 
            case 93: {
                return 2;
            }
            case 89: {
                return 7;
            }
            case 50: {
                return 3;
            }
            case 88: {
                return 3;
            }
            case 31: 
            case 38: {
                return 5;
            }
            case 95: {
                return 3;
            }
            case 96: {
                return 5;
            }
            case 40: {
                return 3;
            }
            case 9: 
            case 39: 
            case 41: 
            case 52: 
            case 58: 
            case 62: 
            case 72: 
            case 76: 
            case 81: 
            case 82: {
                return 3;
            }
            case 94: {
                return 3;
            }
        }
        Kit.codeBug();
        return 0;
    }

    static int[] getLineNumbers(InterpreterData interpreterData) {
        int n;
        UintMap uintMap = new UintMap();
        int n2 = interpreterData.itsICodeTop;
        byte[] byArray = interpreterData.itsICode;
        for (int i = 0; i != n2; i += n) {
            int n3 = byArray[i] & 0xFF;
            n = Interpreter.icodeTokenLength(n3);
            if (n3 != 94) continue;
            if (n != 3) {
                Kit.codeBug();
            }
            int n4 = Interpreter.getShort(byArray, i + 1);
            uintMap.put(n4, 0);
        }
        return uintMap.getKeys();
    }

    static String getSourcePositionFromStack(Context context, int[] nArray) {
        InterpreterData interpreterData = context.interpreterData;
        nArray[0] = Interpreter.getShort(interpreterData.itsICode, context.interpreterLineIndex);
        return interpreterData.itsSourceFile;
    }

    static String getEncodedSource(InterpreterData interpreterData) {
        if (interpreterData.encodedSource == null) {
            return null;
        }
        return interpreterData.encodedSource.substring(interpreterData.encodedSourceStart, interpreterData.encodedSourceEnd);
    }

    private static Scriptable[] wrapRegExps(Context context, Scriptable scriptable, InterpreterData interpreterData) {
        if (interpreterData.itsRegExpLiterals == null) {
            Kit.codeBug();
        }
        RegExpProxy regExpProxy = ScriptRuntime.checkRegExpProxy(context);
        int n = interpreterData.itsRegExpLiterals.length;
        Scriptable[] scriptableArray = new Scriptable[n];
        for (int i = 0; i != n; ++i) {
            scriptableArray[i] = regExpProxy.wrapRegExp(context, scriptable, interpreterData.itsRegExpLiterals[i]);
        }
        return scriptableArray;
    }

    private static InterpretedFunction createFunction(Context context, Scriptable scriptable, InterpreterData interpreterData, boolean bl) {
        InterpretedFunction interpretedFunction = new InterpretedFunction(interpreterData);
        if (interpreterData.itsRegExpLiterals != null) {
            interpretedFunction.itsRegExps = Interpreter.wrapRegExps(context, scriptable, interpreterData);
        }
        ScriptRuntime.initFunction(context, scriptable, interpretedFunction, interpreterData.itsFunctionType, bl);
        return interpretedFunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object interpret(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray, double[] dArray, int n, int n2, NativeFunction nativeFunction, InterpreterData interpreterData) throws JavaScriptException {
        int n3;
        Object object;
        int n4;
        if (context.interpreterSecurityDomain != interpreterData.securityDomain) {
            if (dArray != null) {
                objectArray = Interpreter.getArgsArray(objectArray, dArray, n, n2);
            }
            SecurityController securityController = interpreterData.securityController;
            Object object2 = context.interpreterSecurityDomain;
            context.interpreterSecurityDomain = interpreterData.securityDomain;
            try {
                Object object3 = securityController.callWithDomain(interpreterData.securityDomain, context, nativeFunction, scriptable, scriptable2, objectArray);
                return object3;
            }
            finally {
                context.interpreterSecurityDomain = object2;
            }
        }
        Object object4 = DBL_MRK;
        Scriptable scriptable3 = Undefined.instance;
        int n5 = interpreterData.itsMaxFrameArray;
        int n6 = interpreterData.itsMaxVars;
        int n7 = 0 + n6;
        int n8 = n7 + interpreterData.itsMaxLocals;
        if (n5 != n8 + interpreterData.itsMaxStack) {
            Kit.codeBug();
        }
        Object[] objectArray2 = new Object[n5];
        double[] dArray2 = new double[n5];
        int n9 = n8 - 1;
        int n10 = 0;
        int n11 = nativeFunction.argCount;
        if (n11 > n2) {
            n11 = n2;
        }
        for (n4 = 0; n4 != n11; ++n4) {
            objectArray2[0 + n4] = object = objectArray[n + n4];
            if (object != object4) continue;
            dArray2[0 + n4] = dArray[n + n4];
        }
        for (n4 = n11; n4 != n6; ++n4) {
            objectArray2[0 + n4] = scriptable3;
        }
        DebugFrame debugFrame = null;
        if (context.debugger != null) {
            debugFrame = context.debugger.getFrame(context, interpreterData);
        }
        if (interpreterData.itsFunctionType != 0) {
            object = (InterpretedFunction)nativeFunction;
            if (!interpreterData.useDynamicScope) {
                scriptable = nativeFunction.getParentScope();
            }
            if (interpreterData.itsCheckThis) {
                scriptable2 = ScriptRuntime.getThis(scriptable2);
            }
            if (interpreterData.itsNeedsActivation) {
                if (dArray != null) {
                    objectArray = Interpreter.getArgsArray(objectArray, dArray, n, n2);
                    n = 0;
                    dArray = null;
                }
                scriptable = ScriptRuntime.initVarObj(context, scriptable, nativeFunction, scriptable2, objectArray);
            }
        } else {
            ScriptRuntime.initScript(context, scriptable, nativeFunction, scriptable2, interpreterData.itsFromEvalCode);
        }
        if (interpreterData.itsNestedFunctions != null) {
            if (interpreterData.itsFunctionType != 0 && !interpreterData.itsNeedsActivation) {
                Kit.codeBug();
            }
            for (int i = 0; i < interpreterData.itsNestedFunctions.length; ++i) {
                InterpreterData interpreterData2 = interpreterData.itsNestedFunctions[i];
                if (interpreterData2.itsFunctionType != 1) continue;
                Interpreter.createFunction(context, scriptable, interpreterData2, interpreterData.itsFromEvalCode);
            }
        }
        Scriptable[] scriptableArray = null;
        boolean bl = false;
        if (debugFrame != null) {
            if (dArray != null) {
                objectArray = Interpreter.getArgsArray(objectArray, dArray, n, n2);
                n = 0;
                dArray = null;
            }
            if (interpreterData.itsFunctionType != 0 && !interpreterData.itsNeedsActivation) {
                bl = true;
                scriptable = ScriptRuntime.initVarObj(context, scriptable, nativeFunction, scriptable2, objectArray);
            }
            debugFrame.onEnter(context, scriptable, scriptable2, objectArray);
        }
        InterpreterData interpreterData3 = context.interpreterData;
        context.interpreterData = interpreterData;
        Object object5 = scriptable3;
        Throwable throwable = null;
        int n12 = -1;
        byte[] byArray = interpreterData.itsICode;
        String[] stringArray = interpreterData.itsStringTable;
        int n13 = n3 = 0;
        int n14 = context.instructionThreshold;
        int n15 = context.instructionCount;
        block104: while (true) {
            try {
                block105: while (true) {
                    switch (byArray[n3] & 0xFF) {
                        case 91: {
                            int n16;
                            if (throwable == null) {
                                Kit.codeBug();
                            }
                            int n17 = -1;
                            boolean bl2 = false;
                            int n18 = Interpreter.getExceptionHandler(interpreterData.itsExceptionTable, n12);
                            if (n18 >= 0 && (n16 = throwable instanceof JavaScriptException ? 0 : (throwable instanceof EcmaError ? 0 : (throwable instanceof EvaluatorException ? 0 : (throwable instanceof RuntimeException ? 1 : 2)))) != 2) {
                                if (n16 == 0 && (n17 = interpreterData.itsExceptionTable[n18 + 2]) >= 0) {
                                    bl2 = true;
                                }
                                if (n17 < 0) {
                                    n17 = interpreterData.itsExceptionTable[n18 + 3];
                                }
                            }
                            if (debugFrame != null && !(throwable instanceof Error)) {
                                debugFrame.onExceptionThrown(context, throwable);
                            }
                            if (n17 < 0) break block104;
                            int n19 = interpreterData.itsExceptionTable[n18 + 4];
                            while (n19 != n10) {
                                if (scriptable == null) {
                                    Kit.codeBug();
                                }
                                scriptable = ScriptRuntime.leaveWith(scriptable);
                                --n10;
                            }
                            if (bl2) {
                                n9 = n8 - 1;
                                int n20 = interpreterData.itsExceptionTable[n18 + 5];
                                objectArray2[n7 + n20] = ScriptRuntime.getCatchObject(context, scriptable, throwable);
                            } else {
                                n9 = n8;
                                objectArray2[n9] = throwable;
                            }
                            throwable = null;
                            if (n14 != 0 && n15 > n14) {
                                context.observeInstructionCount(n15);
                                n15 = 0;
                            }
                            n13 = n3 = n17;
                            continue block105;
                        }
                        case 53: {
                            Object object6 = objectArray2[n9];
                            if (object6 == object4) {
                                object6 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            --n9;
                            int n21 = Interpreter.getShort(byArray, n3 + 1);
                            throwable = new JavaScriptException(object6, interpreterData.itsSourceFile, n21);
                            n12 = n3;
                            if (n14 != 0 && (n15 += n3 + 1 - n13) > n14) {
                                context.observeInstructionCount(n15);
                                n15 = 0;
                            }
                            n13 = n3 = Interpreter.getJavaCatchPC(byArray);
                            continue block105;
                        }
                        case 18: {
                            int n18;
                            Object object7 = objectArray2[--n9 + 1];
                            Object object8 = objectArray2[n9];
                            if (object7 == object4 || object8 == object4) {
                                double d = Interpreter.stack_double(objectArray2, dArray2, n9 + 1);
                                double d2 = Interpreter.stack_double(objectArray2, dArray2, n9);
                                n18 = d == d && d2 == d2 && d <= d2 ? 1 : 0;
                            } else {
                                n18 = 1 == ScriptRuntime.cmp_LE(object7, object8) ? 1 : 0;
                            }
                            objectArray2[n9] = n18 != 0 ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 16: {
                            int n18;
                            Object object9 = objectArray2[--n9 + 1];
                            Object object10 = objectArray2[n9];
                            if (object9 == object4 || object10 == object4) {
                                double d = Interpreter.stack_double(objectArray2, dArray2, n9 + 1);
                                double d3 = Interpreter.stack_double(objectArray2, dArray2, n9);
                                n18 = d == d && d3 == d3 && d3 <= d ? 1 : 0;
                            } else {
                                n18 = 1 == ScriptRuntime.cmp_LE(object10, object9) ? 1 : 0;
                            }
                            objectArray2[n9] = n18 != 0 ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 17: {
                            int n18;
                            Object object11 = objectArray2[--n9 + 1];
                            Object object12 = objectArray2[n9];
                            if (object11 == object4 || object12 == object4) {
                                double d = Interpreter.stack_double(objectArray2, dArray2, n9 + 1);
                                double d4 = Interpreter.stack_double(objectArray2, dArray2, n9);
                                n18 = d == d && d4 == d4 && d < d4 ? 1 : 0;
                            } else {
                                n18 = 1 == ScriptRuntime.cmp_LT(object11, object12) ? 1 : 0;
                            }
                            objectArray2[n9] = n18 != 0 ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 15: {
                            int n18;
                            Object object13 = objectArray2[--n9 + 1];
                            Object object14 = objectArray2[n9];
                            if (object13 == object4 || object14 == object4) {
                                double d = Interpreter.stack_double(objectArray2, dArray2, n9 + 1);
                                double d5 = Interpreter.stack_double(objectArray2, dArray2, n9);
                                n18 = d == d && d5 == d5 && d5 < d ? 1 : 0;
                            } else {
                                n18 = 1 == ScriptRuntime.cmp_LT(object14, object13) ? 1 : 0;
                            }
                            objectArray2[n9] = n18 != 0 ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 54: {
                            Object object15;
                            int n18;
                            Object object16 = objectArray2[n9];
                            if (object16 == object4) {
                                object16 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            if ((object15 = objectArray2[--n9]) == object4) {
                                object15 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            objectArray2[n9] = (n18 = (int)(ScriptRuntime.in(object15, object16, scriptable) ? 1 : 0)) != 0 ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 55: {
                            Object object17;
                            int n18;
                            Object object18 = objectArray2[n9];
                            if (object18 == object4) {
                                object18 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            if ((object17 = objectArray2[--n9]) == object4) {
                                object17 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            objectArray2[n9] = (n18 = (int)(ScriptRuntime.instanceOf(object17, object18, scriptable) ? 1 : 0)) != 0 ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 13: {
                            boolean bl3 = Interpreter.do_eq(objectArray2, dArray2, --n9);
                            objectArray2[n9] = bl3 ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 14: {
                            boolean bl4 = !Interpreter.do_eq(objectArray2, dArray2, --n9);
                            objectArray2[n9] = bl4 ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 48: {
                            boolean bl5 = Interpreter.do_sheq(objectArray2, dArray2, --n9);
                            objectArray2[n9] = bl5 ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 49: {
                            boolean bl6 = !Interpreter.do_sheq(objectArray2, dArray2, --n9);
                            objectArray2[n9] = bl6 ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 8: {
                            boolean bl7 = Interpreter.stack_boolean(objectArray2, dArray2, n9);
                            --n9;
                            if (!bl7) {
                                if (n14 != 0 && (n15 += n3 + 3 - n13) > n14) {
                                    context.observeInstructionCount(n15);
                                    n15 = 0;
                                }
                                n13 = n3 = Interpreter.getTarget(byArray, n3 + 1);
                                continue block105;
                            }
                            n3 += 2;
                            break;
                        }
                        case 7: {
                            boolean bl8 = Interpreter.stack_boolean(objectArray2, dArray2, n9);
                            --n9;
                            if (bl8) {
                                if (n14 != 0 && (n15 += n3 + 3 - n13) > n14) {
                                    context.observeInstructionCount(n15);
                                    n15 = 0;
                                }
                                n13 = n3 = Interpreter.getTarget(byArray, n3 + 1);
                                continue block105;
                            }
                            n3 += 2;
                            break;
                        }
                        case 71: {
                            boolean bl9 = Interpreter.stack_boolean(objectArray2, dArray2, n9);
                            --n9;
                            if (bl9) {
                                if (n14 != 0 && (n15 += n3 + 3 - n13) > n14) {
                                    context.observeInstructionCount(n15);
                                    n15 = 0;
                                }
                                n13 = n3 = Interpreter.getTarget(byArray, n3 + 1);
                                objectArray2[n9--] = null;
                                continue block105;
                            }
                            n3 += 2;
                            break;
                        }
                        case 6: {
                            if (n14 != 0 && (n15 += n3 + 3 - n13) > n14) {
                                context.observeInstructionCount(n15);
                                n15 = 0;
                            }
                            n13 = n3 = Interpreter.getTarget(byArray, n3 + 1);
                            continue block105;
                        }
                        case 92: {
                            objectArray2[++n9] = object4;
                            dArray2[n9] = n3 + 3;
                            if (n14 != 0 && (n15 += n3 + 3 - n13) > n14) {
                                context.observeInstructionCount(n15);
                                n15 = 0;
                            }
                            n13 = n3 = Interpreter.getTarget(byArray, n3 + 1);
                            continue block105;
                        }
                        case 93: {
                            int n22;
                            Object object19;
                            int n23 = byArray[n3 + 1] & 0xFF;
                            if (n14 != 0 && (n15 += n3 + 2 - n13) > n14) {
                                context.observeInstructionCount(n15);
                                n15 = 0;
                            }
                            if ((object19 = objectArray2[n7 + n23]) != object4) {
                                throwable = (Throwable)object19;
                                n12 = n3;
                                n22 = Interpreter.getJavaCatchPC(byArray);
                            } else {
                                n22 = (int)dArray2[n7 + n23];
                            }
                            n13 = n3 = n22;
                            continue block105;
                        }
                        case 51: {
                            objectArray2[n9] = null;
                            --n9;
                            break;
                        }
                        case 68: {
                            objectArray2[n9 + 1] = objectArray2[n9];
                            dArray2[n9 + 1] = dArray2[n9];
                            ++n9;
                            break;
                        }
                        case 69: {
                            objectArray2[n9 + 1] = objectArray2[n9 - 1];
                            dArray2[n9 + 1] = dArray2[n9 - 1];
                            ++n9;
                            break;
                        }
                        case 70: {
                            Object object20 = objectArray2[n9];
                            objectArray2[n9] = objectArray2[n9 - 1];
                            objectArray2[n9 - 1] = object20;
                            double d = dArray2[n9];
                            dArray2[n9] = dArray2[n9 - 1];
                            dArray2[n9 - 1] = d;
                            break;
                        }
                        case 2: {
                            object5 = objectArray2[n9];
                            if (object5 == object4) {
                                object5 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            objectArray2[n9] = null;
                            --n9;
                            break;
                        }
                        case 5: {
                            object5 = objectArray2[n9];
                            if (object5 == object4) {
                                object5 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            --n9;
                            break block104;
                        }
                        case 67: {
                            break block104;
                        }
                        case 90: {
                            object5 = scriptable3;
                            break block104;
                        }
                        case 28: {
                            int n24 = Interpreter.stack_int32(objectArray2, dArray2, n9);
                            objectArray2[n9] = object4;
                            dArray2[n9] = ~n24;
                            break;
                        }
                        case 12: {
                            int n25 = Interpreter.stack_int32(objectArray2, dArray2, n9);
                            int n26 = Interpreter.stack_int32(objectArray2, dArray2, --n9);
                            objectArray2[n9] = object4;
                            dArray2[n9] = n26 & n25;
                            break;
                        }
                        case 10: {
                            int n27 = Interpreter.stack_int32(objectArray2, dArray2, n9);
                            int n28 = Interpreter.stack_int32(objectArray2, dArray2, --n9);
                            objectArray2[n9] = object4;
                            dArray2[n9] = n28 | n27;
                            break;
                        }
                        case 11: {
                            int n29 = Interpreter.stack_int32(objectArray2, dArray2, n9);
                            int n30 = Interpreter.stack_int32(objectArray2, dArray2, --n9);
                            objectArray2[n9] = object4;
                            dArray2[n9] = n30 ^ n29;
                            break;
                        }
                        case 19: {
                            int n31 = Interpreter.stack_int32(objectArray2, dArray2, n9);
                            int n32 = Interpreter.stack_int32(objectArray2, dArray2, --n9);
                            objectArray2[n9] = object4;
                            dArray2[n9] = n32 << n31;
                            break;
                        }
                        case 20: {
                            int n33 = Interpreter.stack_int32(objectArray2, dArray2, n9);
                            int n34 = Interpreter.stack_int32(objectArray2, dArray2, --n9);
                            objectArray2[n9] = object4;
                            dArray2[n9] = n34 >> n33;
                            break;
                        }
                        case 21: {
                            int n35 = Interpreter.stack_int32(objectArray2, dArray2, n9) & 0x1F;
                            double d = Interpreter.stack_double(objectArray2, dArray2, --n9);
                            objectArray2[n9] = object4;
                            dArray2[n9] = ScriptRuntime.toUint32(d) >>> n35;
                            break;
                        }
                        case 22: {
                            Interpreter.do_add(objectArray2, dArray2, --n9);
                            break;
                        }
                        case 23: {
                            double d = Interpreter.stack_double(objectArray2, dArray2, n9);
                            double d6 = Interpreter.stack_double(objectArray2, dArray2, --n9);
                            objectArray2[n9] = object4;
                            dArray2[n9] = d6 - d;
                            break;
                        }
                        case 30: {
                            double d = Interpreter.stack_double(objectArray2, dArray2, n9);
                            objectArray2[n9] = object4;
                            dArray2[n9] = -d;
                            break;
                        }
                        case 29: {
                            double d = Interpreter.stack_double(objectArray2, dArray2, n9);
                            objectArray2[n9] = object4;
                            dArray2[n9] = d;
                            break;
                        }
                        case 24: {
                            double d = Interpreter.stack_double(objectArray2, dArray2, n9);
                            double d7 = Interpreter.stack_double(objectArray2, dArray2, --n9);
                            objectArray2[n9] = object4;
                            dArray2[n9] = d7 * d;
                            break;
                        }
                        case 25: {
                            double d = Interpreter.stack_double(objectArray2, dArray2, n9);
                            double d8 = Interpreter.stack_double(objectArray2, dArray2, --n9);
                            objectArray2[n9] = object4;
                            dArray2[n9] = d8 / d;
                            break;
                        }
                        case 26: {
                            double d = Interpreter.stack_double(objectArray2, dArray2, n9);
                            double d9 = Interpreter.stack_double(objectArray2, dArray2, --n9);
                            objectArray2[n9] = object4;
                            dArray2[n9] = d9 % d;
                            break;
                        }
                        case 27: {
                            objectArray2[n9] = Interpreter.stack_boolean(objectArray2, dArray2, n9) ? Boolean.FALSE : Boolean.TRUE;
                            break;
                        }
                        case 52: {
                            String string = stringArray[Interpreter.getIndex(byArray, n3 + 1)];
                            objectArray2[++n9] = ScriptRuntime.bind(scriptable, string);
                            n3 += 2;
                            break;
                        }
                        case 58: {
                            String string = stringArray[Interpreter.getIndex(byArray, n3 + 1)];
                            objectArray2[++n9] = ScriptRuntime.getBase(scriptable, string);
                            n3 += 2;
                            break;
                        }
                        case 9: {
                            String string = stringArray[Interpreter.getIndex(byArray, n3 + 1)];
                            Object object21 = objectArray2[n9];
                            if (object21 == object4) {
                                object21 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            Scriptable scriptable4 = (Scriptable)objectArray2[--n9];
                            objectArray2[n9] = ScriptRuntime.setName(scriptable4, object21, scriptable, string);
                            n3 += 2;
                            break;
                        }
                        case 32: {
                            Object object22;
                            Object object23 = objectArray2[n9];
                            if (object23 == object4) {
                                object23 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            if ((object22 = objectArray2[--n9]) == object4) {
                                object22 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.delete(context, scriptable, object22, object23);
                            break;
                        }
                        case 34: {
                            String string = (String)objectArray2[n9];
                            Object object24 = objectArray2[--n9];
                            if (object24 == object4) {
                                object24 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.getProp(object24, string, scriptable);
                            break;
                        }
                        case 35: {
                            Object object25;
                            Object object26 = objectArray2[n9];
                            if (object26 == object4) {
                                object26 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            String string = (String)objectArray2[--n9];
                            if ((object25 = objectArray2[--n9]) == object4) {
                                object25 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.setProp(object25, string, object26, scriptable);
                            break;
                        }
                        case 36: {
                            Interpreter.do_getElem(context, objectArray2, dArray2, n9, scriptable);
                            --n9;
                            break;
                        }
                        case 37: {
                            Interpreter.do_setElem(context, objectArray2, dArray2, n9, scriptable);
                            n9 -= 2;
                            break;
                        }
                        case 73: {
                            String string = (String)objectArray2[n9];
                            Object object27 = objectArray2[--n9];
                            if (object27 == object4) {
                                object27 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.postIncrement(object27, string, scriptable);
                            break;
                        }
                        case 77: {
                            String string = (String)objectArray2[n9];
                            Object object28 = objectArray2[--n9];
                            if (object28 == object4) {
                                object28 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.postDecrement(object28, string, scriptable);
                            break;
                        }
                        case 74: {
                            Object object29;
                            Object object30 = objectArray2[n9];
                            if (object30 == object4) {
                                object30 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            if ((object29 = objectArray2[--n9]) == object4) {
                                object29 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.postIncrementElem(object29, object30, scriptable);
                            break;
                        }
                        case 78: {
                            Object object31;
                            Object object32 = objectArray2[n9];
                            if (object32 == object4) {
                                object32 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            if ((object31 = objectArray2[--n9]) == object4) {
                                object31 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.postDecrementElem(object31, object32, scriptable);
                            break;
                        }
                        case 56: {
                            int n36 = byArray[++n3] & 0xFF;
                            objectArray2[n7 + n36] = objectArray2[n9];
                            dArray2[n7 + n36] = dArray2[n9];
                            --n9;
                            break;
                        }
                        case 57: {
                            int n37 = byArray[++n3] & 0xFF;
                            objectArray2[++n9] = objectArray2[n7 + n37];
                            dArray2[n9] = dArray2[n7 + n37];
                            break;
                        }
                        case 89: {
                            Object object33;
                            if (n14 != 0) {
                                context.instructionCount = n15 += 100;
                                n15 = -1;
                            }
                            int n38 = byArray[n3 + 1] & 0xFF;
                            boolean bl10 = byArray[n3 + 2] != 0;
                            int n18 = Interpreter.getShort(byArray, n3 + 3);
                            int n19 = Interpreter.getIndex(byArray, n3 + 5);
                            Object[] objectArray3 = Interpreter.getArgsArray(objectArray2, dArray2, (n9 -= n19) + 1, n19);
                            if (bl10) {
                                object33 = null;
                            } else {
                                object33 = objectArray2[n9];
                                if (object33 == object4) {
                                    object33 = Interpreter.doubleWrap(dArray2[n9]);
                                }
                                --n9;
                            }
                            Object object34 = objectArray2[n9];
                            if (object34 == object4) {
                                object34 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.callSpecial(context, object34, bl10, object33, objectArray3, scriptable, scriptable2, n38, interpreterData.itsSourceFile, n18);
                            n3 += 6;
                            n15 = context.instructionCount;
                            break;
                        }
                        case 38: {
                            Function function;
                            if (n14 != 0) {
                                context.instructionCount = n15 += 100;
                                n15 = -1;
                            }
                            int n39 = Interpreter.getIndex(byArray, n3 + 3);
                            int n40 = (n9 -= n39) + 1;
                            Object object35 = objectArray2[n9];
                            if (object35 == object4) {
                                object35 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            Object object36 = objectArray2[--n9];
                            Scriptable scriptable5 = scriptable;
                            if (interpreterData.itsNeedsActivation) {
                                scriptable5 = ScriptableObject.getTopLevelScope(scriptable);
                            }
                            Scriptable scriptable6 = object35 instanceof Scriptable || object35 == null ? (Scriptable)object35 : ScriptRuntime.toObject(context, scriptable5, object35);
                            if (object36 instanceof InterpretedFunction) {
                                function = (InterpretedFunction)object36;
                                objectArray2[n9] = Interpreter.interpret(context, scriptable5, scriptable6, objectArray2, dArray2, n40, n39, (NativeFunction)function, ((InterpretedFunction)function).itsData);
                            } else if (object36 instanceof Function) {
                                function = (Function)object36;
                                Object[] objectArray4 = Interpreter.getArgsArray(objectArray2, dArray2, n40, n39);
                                objectArray2[n9] = function.call(context, scriptable5, scriptable6, objectArray4);
                            } else {
                                if (object36 == object4) {
                                    object36 = Interpreter.doubleWrap(dArray2[n9]);
                                } else if (object36 == scriptable3 && (object36 = stringArray[Interpreter.getIndex(byArray, n3 + 1)]) == null) {
                                    object36 = scriptable3;
                                }
                                throw ScriptRuntime.typeError1("msg.isnt.function", ScriptRuntime.toString(object36));
                            }
                            n3 += 4;
                            n15 = context.instructionCount;
                            break;
                        }
                        case 31: {
                            Object[] objectArray5;
                            Function function;
                            if (n14 != 0) {
                                context.instructionCount = n15 += 100;
                                n15 = -1;
                            }
                            int n41 = Interpreter.getIndex(byArray, n3 + 3);
                            int n42 = (n9 -= n41) + 1;
                            Object object37 = objectArray2[n9];
                            if (object37 instanceof InterpretedFunction) {
                                function = (InterpretedFunction)object37;
                                objectArray5 = ((BaseFunction)function).createObject(context, scriptable);
                                Object object38 = Interpreter.interpret(context, scriptable, (Scriptable)objectArray5, objectArray2, dArray2, n42, n41, (NativeFunction)function, ((InterpretedFunction)function).itsData);
                                objectArray2[n9] = object38 instanceof Scriptable && object38 != scriptable3 ? object38 : objectArray5;
                            } else if (object37 instanceof Function) {
                                function = (Function)object37;
                                objectArray5 = Interpreter.getArgsArray(objectArray2, dArray2, n42, n41);
                                objectArray2[n9] = function.construct(context, scriptable, objectArray5);
                            } else {
                                if (object37 == object4) {
                                    object37 = Interpreter.doubleWrap(dArray2[n9]);
                                } else if (object37 == scriptable3 && (object37 = stringArray[Interpreter.getIndex(byArray, n3 + 1)]) == null) {
                                    object37 = scriptable3;
                                }
                                throw ScriptRuntime.typeError1("msg.isnt.function", ScriptRuntime.toString(object37));
                            }
                            n3 += 4;
                            n15 = context.instructionCount;
                            break;
                        }
                        case 33: {
                            Object object39 = objectArray2[n9];
                            if (object39 == object4) {
                                object39 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.typeof(object39);
                            break;
                        }
                        case 81: {
                            String string = stringArray[Interpreter.getIndex(byArray, n3 + 1)];
                            objectArray2[++n9] = ScriptRuntime.typeofName(scriptable, string);
                            n3 += 2;
                            break;
                        }
                        case 82: {
                            String string = stringArray[Interpreter.getIndex(byArray, n3 + 1)];
                            Scriptable scriptable7 = ScriptRuntime.getBase(scriptable, string);
                            objectArray2[++n9] = ScriptRuntime.getProp(scriptable7, string, scriptable);
                            objectArray2[++n9] = ScriptRuntime.getThis(scriptable7);
                            n3 += 2;
                            break;
                        }
                        case 41: {
                            objectArray2[++n9] = stringArray[Interpreter.getIndex(byArray, n3 + 1)];
                            n3 += 2;
                            break;
                        }
                        case 95: {
                            objectArray2[++n9] = object4;
                            dArray2[n9] = Interpreter.getShort(byArray, n3 + 1);
                            n3 += 2;
                            break;
                        }
                        case 96: {
                            objectArray2[++n9] = object4;
                            dArray2[n9] = Interpreter.getInt(byArray, n3 + 1);
                            n3 += 4;
                            break;
                        }
                        case 40: {
                            objectArray2[++n9] = object4;
                            dArray2[n9] = interpreterData.itsDoubleTable[Interpreter.getIndex(byArray, n3 + 1)];
                            n3 += 2;
                            break;
                        }
                        case 39: {
                            String string = stringArray[Interpreter.getIndex(byArray, n3 + 1)];
                            objectArray2[++n9] = ScriptRuntime.name(scriptable, string);
                            n3 += 2;
                            break;
                        }
                        case 72: {
                            String string = stringArray[Interpreter.getIndex(byArray, n3 + 1)];
                            objectArray2[++n9] = ScriptRuntime.postIncrement(scriptable, string);
                            n3 += 2;
                            break;
                        }
                        case 76: {
                            String string = stringArray[Interpreter.getIndex(byArray, n3 + 1)];
                            objectArray2[++n9] = ScriptRuntime.postDecrement(scriptable, string);
                            n3 += 2;
                            break;
                        }
                        case 60: {
                            int n43 = byArray[++n3] & 0xFF;
                            if (!bl) {
                                objectArray2[0 + n43] = objectArray2[n9];
                                dArray2[0 + n43] = dArray2[n9];
                                break;
                            }
                            Object object40 = objectArray2[n9];
                            if (object40 == object4) {
                                object40 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            Interpreter.activationPut(nativeFunction, scriptable, n43, object40);
                            break;
                        }
                        case 59: {
                            int n44 = byArray[++n3] & 0xFF;
                            ++n9;
                            if (!bl) {
                                objectArray2[n9] = objectArray2[0 + n44];
                                dArray2[n9] = dArray2[0 + n44];
                                break;
                            }
                            objectArray2[n9] = Interpreter.activationGet(nativeFunction, scriptable, n44);
                            break;
                        }
                        case 75: {
                            Object object41;
                            int n45 = byArray[++n3] & 0xFF;
                            ++n9;
                            if (!bl) {
                                objectArray2[n9] = objectArray2[0 + n45];
                                dArray2[n9] = dArray2[0 + n45];
                                objectArray2[0 + n45] = object4;
                                dArray2[0 + n45] = Interpreter.stack_double(objectArray2, dArray2, n9) + 1.0;
                                break;
                            }
                            objectArray2[n9] = object41 = Interpreter.activationGet(nativeFunction, scriptable, n45);
                            object41 = Interpreter.doubleWrap(ScriptRuntime.toNumber(object41) + 1.0);
                            Interpreter.activationPut(nativeFunction, scriptable, n45, object41);
                            break;
                        }
                        case 79: {
                            Object object42;
                            int n46 = byArray[++n3] & 0xFF;
                            ++n9;
                            if (!bl) {
                                objectArray2[n9] = objectArray2[0 + n46];
                                dArray2[n9] = dArray2[0 + n46];
                                objectArray2[0 + n46] = object4;
                                dArray2[0 + n46] = Interpreter.stack_double(objectArray2, dArray2, n9) - 1.0;
                                break;
                            }
                            objectArray2[n9] = object42 = Interpreter.activationGet(nativeFunction, scriptable, n46);
                            object42 = Interpreter.doubleWrap(ScriptRuntime.toNumber(object42) - 1.0);
                            Interpreter.activationPut(nativeFunction, scriptable, n46, object42);
                            break;
                        }
                        case 42: {
                            objectArray2[++n9] = object4;
                            dArray2[n9] = 0.0;
                            break;
                        }
                        case 43: {
                            objectArray2[++n9] = object4;
                            dArray2[n9] = 1.0;
                            break;
                        }
                        case 44: {
                            objectArray2[++n9] = null;
                            break;
                        }
                        case 45: {
                            objectArray2[++n9] = scriptable2;
                            break;
                        }
                        case 66: {
                            objectArray2[++n9] = nativeFunction;
                            break;
                        }
                        case 46: {
                            objectArray2[++n9] = Boolean.FALSE;
                            break;
                        }
                        case 47: {
                            objectArray2[++n9] = Boolean.TRUE;
                            break;
                        }
                        case 61: {
                            objectArray2[++n9] = Undefined.instance;
                            break;
                        }
                        case 3: {
                            Object object43 = objectArray2[n9];
                            if (object43 == object4) {
                                object43 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            --n9;
                            scriptable = ScriptRuntime.enterWith(object43, scriptable);
                            ++n10;
                            break;
                        }
                        case 4: {
                            scriptable = ScriptRuntime.leaveWith(scriptable);
                            --n10;
                            break;
                        }
                        case 62: {
                            String string = stringArray[Interpreter.getIndex(byArray, n3 + 1)];
                            objectArray2[n9] = ScriptRuntime.newCatchScope(string, objectArray2[n9]);
                            n3 += 2;
                            break;
                        }
                        case 63: {
                            int n47 = byArray[++n3] & 0xFF;
                            Object object44 = objectArray2[n9];
                            if (object44 == object4) {
                                object44 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            --n9;
                            objectArray2[n7 + n47] = ScriptRuntime.enumInit(object44, scriptable);
                            break;
                        }
                        case 64: 
                        case 65: {
                            int n48 = byArray[++n3] & 0xFF;
                            Object object45 = objectArray2[n7 + n48];
                            objectArray2[++n9] = (byArray[n3 - 1] & 0xFF) == 64 ? ScriptRuntime.enumNext(object45) : ScriptRuntime.enumId(object45);
                            break;
                        }
                        case 84: {
                            Object object46 = objectArray2[n9];
                            if (object46 == object4) {
                                object46 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.getProto(object46, scriptable);
                            break;
                        }
                        case 83: {
                            Object object47 = objectArray2[n9];
                            if (object47 == object4) {
                                object47 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            objectArray2[++n9] = ScriptRuntime.getParent(object47);
                            break;
                        }
                        case 85: {
                            Object object48 = objectArray2[n9];
                            if (object48 == object4) {
                                object48 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.getParent(object48, scriptable);
                            break;
                        }
                        case 86: {
                            Object object49;
                            Object object50 = objectArray2[n9];
                            if (object50 == object4) {
                                object50 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            if ((object49 = objectArray2[--n9]) == object4) {
                                object49 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.setProto(object49, object50, scriptable);
                            break;
                        }
                        case 87: {
                            Object object51;
                            Object object52 = objectArray2[n9];
                            if (object52 == object4) {
                                object52 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            if ((object51 = objectArray2[--n9]) == object4) {
                                object51 = Interpreter.doubleWrap(dArray2[n9]);
                            }
                            objectArray2[n9] = ScriptRuntime.setParent(object51, object52, scriptable);
                            break;
                        }
                        case 80: {
                            objectArray2[++n9] = scriptable;
                            break;
                        }
                        case 88: {
                            int n49 = Interpreter.getIndex(byArray, n3 + 1);
                            InterpreterData interpreterData4 = interpreterData.itsNestedFunctions[n49];
                            objectArray2[++n9] = Interpreter.createFunction(context, scriptable, interpreterData4, interpreterData.itsFromEvalCode);
                            n3 += 2;
                            break;
                        }
                        case 50: {
                            Scriptable scriptable8;
                            int n50 = Interpreter.getIndex(byArray, n3 + 1);
                            if (interpreterData.itsFunctionType != 0) {
                                scriptable8 = ((InterpretedFunction)nativeFunction).itsRegExps[n50];
                            } else {
                                if (scriptableArray == null) {
                                    scriptableArray = Interpreter.wrapRegExps(context, scriptable, interpreterData);
                                }
                                scriptable8 = scriptableArray[n50];
                            }
                            objectArray2[++n9] = scriptable8;
                            n3 += 2;
                            break;
                        }
                        case 94: {
                            context.interpreterLineIndex = n3 + 1;
                            if (debugFrame != null) {
                                int n51 = Interpreter.getShort(byArray, n3 + 1);
                                debugFrame.onLineChange(context, n51);
                            }
                            n3 += 2;
                            break;
                        }
                        default: {
                            Interpreter.dumpICode(interpreterData);
                            throw new RuntimeException("Unknown icode : " + (byArray[n3] & 0xFF) + " @ pc : " + n3);
                        }
                    }
                    ++n3;
                }
            }
            catch (Throwable throwable2) {
                if (n14 != 0) {
                    if (n15 < 0) {
                        n15 = context.instructionCount;
                    } else {
                        context.instructionCount = n15 += n3 - n13;
                    }
                }
                throwable = throwable2;
                n12 = n3;
                n3 = Interpreter.getJavaCatchPC(byArray);
                continue;
            }
            break;
        }
        context.interpreterData = interpreterData3;
        if (debugFrame != null) {
            if (throwable != null) {
                debugFrame.onExit(context, true, throwable);
            } else {
                debugFrame.onExit(context, false, object5);
            }
        }
        if (interpreterData.itsNeedsActivation || debugFrame != null) {
            ScriptRuntime.popActivation(context);
        }
        if (n14 != 0) {
            if (n15 > n14) {
                context.observeInstructionCount(n15);
                n15 = 0;
            }
            context.instructionCount = n15;
        }
        if (throwable != null) {
            if (throwable instanceof JavaScriptException) {
                throw (JavaScriptException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw (Error)throwable;
        }
        return object5;
    }

    private static Object doubleWrap(double d) {
        return new Double(d);
    }

    private static int stack_int32(Object[] objectArray, double[] dArray, int n) {
        Object object = objectArray[n];
        return object != DBL_MRK ? ScriptRuntime.toInt32(object) : ScriptRuntime.toInt32(dArray[n]);
    }

    private static double stack_double(Object[] objectArray, double[] dArray, int n) {
        Object object = objectArray[n];
        return object != DBL_MRK ? ScriptRuntime.toNumber(object) : dArray[n];
    }

    private static boolean stack_boolean(Object[] objectArray, double[] dArray, int n) {
        Object object = objectArray[n];
        if (object == DBL_MRK) {
            double d = dArray[n];
            return d == d && d != 0.0;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object == null || object == Undefined.instance) {
            return false;
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            return d == d && d != 0.0;
        }
        return ScriptRuntime.toBoolean(object);
    }

    private static void do_add(Object[] objectArray, double[] dArray, int n) {
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        if (object == DBL_MRK) {
            double d = dArray[n + 1];
            if (object2 == DBL_MRK) {
                int n2 = n;
                dArray[n2] = dArray[n2] + d;
            } else {
                Interpreter.do_add(object2, d, objectArray, dArray, n, true);
            }
        } else if (object2 == DBL_MRK) {
            Interpreter.do_add(object, dArray[n], objectArray, dArray, n, false);
        } else {
            if (object2 instanceof Scriptable) {
                object2 = ((Scriptable)object2).getDefaultValue(null);
            }
            if (object instanceof Scriptable) {
                object = ((Scriptable)object).getDefaultValue(null);
            }
            if (object2 instanceof String) {
                String string = (String)object2;
                String string2 = ScriptRuntime.toString(object);
                objectArray[n] = string.concat(string2);
            } else if (object instanceof String) {
                String string = ScriptRuntime.toString(object2);
                String string3 = (String)object;
                objectArray[n] = string.concat(string3);
            } else {
                double d = object2 instanceof Number ? ((Number)object2).doubleValue() : ScriptRuntime.toNumber(object2);
                double d2 = object instanceof Number ? ((Number)object).doubleValue() : ScriptRuntime.toNumber(object);
                objectArray[n] = DBL_MRK;
                dArray[n] = d + d2;
            }
        }
    }

    private static void do_add(Object object, double d, Object[] objectArray, double[] dArray, int n, boolean bl) {
        if (object instanceof Scriptable) {
            object = object == Undefined.instance ? ScriptRuntime.NaNobj : ((Scriptable)object).getDefaultValue(null);
        }
        if (object instanceof String) {
            String string = (String)object;
            String string2 = ScriptRuntime.toString(d);
            objectArray[n] = bl ? string.concat(string2) : string2.concat(string);
        } else {
            double d2 = object instanceof Number ? ((Number)object).doubleValue() : ScriptRuntime.toNumber(object);
            objectArray[n] = DBL_MRK;
            dArray[n] = d2 + d;
        }
    }

    private static boolean do_eq(Object[] objectArray, double[] dArray, int n) {
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        boolean bl = object == DBL_MRK ? (object2 == DBL_MRK ? dArray[n] == dArray[n + 1] : Interpreter.do_eq(dArray[n + 1], object2)) : (object2 == DBL_MRK ? Interpreter.do_eq(dArray[n], object) : ScriptRuntime.eq(object2, object));
        return bl;
    }

    private static boolean do_eq(double d, Object object) {
        while (true) {
            if (object instanceof Number) {
                return d == ((Number)object).doubleValue();
            }
            if (object instanceof String) {
                return d == ScriptRuntime.toNumber((String)object);
            }
            if (object instanceof Boolean) {
                return d == (double)((Boolean)object != false ? 1 : 0);
            }
            if (!(object instanceof Scriptable)) break;
            if (object == Undefined.instance) {
                return false;
            }
            object = ScriptRuntime.toPrimitive(object);
        }
        return false;
    }

    private static boolean do_sheq(Object[] objectArray, double[] dArray, int n) {
        boolean bl;
        Object object = objectArray[n + 1];
        Object object2 = objectArray[n];
        if (object == DBL_MRK) {
            double d = dArray[n + 1];
            if (object2 == DBL_MRK) {
                bl = dArray[n] == d;
            } else {
                bl = object2 instanceof Number;
                if (bl) {
                    bl = ((Number)object2).doubleValue() == d;
                }
            }
        } else if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (object2 == DBL_MRK) {
                bl = dArray[n] == d;
            } else {
                bl = object2 instanceof Number;
                if (bl) {
                    bl = ((Number)object2).doubleValue() == d;
                }
            }
        } else {
            bl = ScriptRuntime.shallowEq(object2, object);
        }
        return bl;
    }

    private static void do_getElem(Context context, Object[] objectArray, double[] dArray, int n, Scriptable scriptable) {
        Object object;
        Object object2;
        Object object3 = objectArray[n - 1];
        if (object3 == DBL_MRK) {
            object3 = Interpreter.doubleWrap(dArray[n - 1]);
        }
        if ((object2 = objectArray[n]) != DBL_MRK) {
            object = ScriptRuntime.getElem(object3, object2, scriptable);
        } else {
            double d = dArray[n];
            if (object3 == null || object3 == Undefined.instance) {
                throw ScriptRuntime.undefReadError(object3, ScriptRuntime.toString(d));
            }
            Scriptable scriptable2 = object3 instanceof Scriptable ? (Scriptable)object3 : ScriptRuntime.toObject(context, scriptable, object3);
            int n2 = (int)d;
            if ((double)n2 == d) {
                object = ScriptRuntime.getElem(scriptable2, n2);
            } else {
                String string = ScriptRuntime.toString(d);
                object = ScriptRuntime.getStrIdElem(scriptable2, string);
            }
        }
        objectArray[n - 1] = object;
    }

    private static void do_setElem(Context context, Object[] objectArray, double[] dArray, int n, Scriptable scriptable) {
        Object object;
        Object object2;
        Object object3;
        Object object4 = objectArray[n];
        if (object4 == DBL_MRK) {
            object4 = Interpreter.doubleWrap(dArray[n]);
        }
        if ((object3 = objectArray[n - 2]) == DBL_MRK) {
            object3 = Interpreter.doubleWrap(dArray[n - 2]);
        }
        if ((object2 = objectArray[n - 1]) != DBL_MRK) {
            object = ScriptRuntime.setElem(object3, object2, object4, scriptable);
        } else {
            double d = dArray[n - 1];
            if (object3 == null || object3 == Undefined.instance) {
                throw ScriptRuntime.undefWriteError(object3, ScriptRuntime.toString(d), object4);
            }
            Scriptable scriptable2 = object3 instanceof Scriptable ? (Scriptable)object3 : ScriptRuntime.toObject(context, scriptable, object3);
            int n2 = (int)d;
            if ((double)n2 == d) {
                object = ScriptRuntime.setElem(scriptable2, n2, object4);
            } else {
                String string = ScriptRuntime.toString(d);
                object = ScriptRuntime.setStrIdElem(scriptable2, string, object4, scriptable);
            }
        }
        objectArray[n - 2] = object;
    }

    private static Object[] getArgsArray(Object[] objectArray, double[] dArray, int n, int n2) {
        if (n2 == 0) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] objectArray2 = new Object[n2];
        int n3 = 0;
        while (n3 != n2) {
            Object object = objectArray[n];
            if (object == DBL_MRK) {
                object = Interpreter.doubleWrap(dArray[n]);
            }
            objectArray2[n3] = object;
            ++n3;
            ++n;
        }
        return objectArray2;
    }

    private static Object activationGet(NativeFunction nativeFunction, Scriptable scriptable, int n) {
        String string = nativeFunction.argNames[n];
        Object object = scriptable.get(string, scriptable);
        if (object == Scriptable.NOT_FOUND) {
            Kit.codeBug();
        }
        return object;
    }

    private static void activationPut(NativeFunction nativeFunction, Scriptable scriptable, int n, Object object) {
        String string = nativeFunction.argNames[n];
        scriptable.put(string, scriptable, object);
    }

    private static int getJavaCatchPC(byte[] byArray) {
        int n = byArray.length - 1;
        if ((byArray[n] & 0xFF) != 91) {
            Kit.codeBug();
        }
        return n;
    }
}

