/*

Copyright (C) 2000 - 2007 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_trace_area_gui_h
#define __nd_trace_area_gui_h

#include <nd.h>

/**
 * nd_trace_area_dialog_show - shows trace area iteration dialog.
 *
 * The function shows a dialog that is used to specify
 * the area in a trace that changes get applied to.
 */
void             nd_trace_area_dialog_show(void);

/**
 * nd_trace_area_dialog_hide - hides trace area iteration dialog.
 *
 * The function hides the dialog.
 */
void             nd_trace_area_dialog_hide(void);

/* FIXME fix comments */
void             nd_trace_area_dialog_new_area(void);
void             nd_trace_area_dialog_del_area(void);
void             nd_trace_area_dialog_set_area(void);

void             nd_trace_area_dialog_select_area(LND_TraceArea *area);

/**
 * nd_trace_area_dialog_apply - applies current iteration area settings.
 *
 * The function stores the currently specified trace area as
 * the one to use for iteration.
 *
 * Returns: %TRUE when this was successful, %FALSE otherwise.
 * The application may fail e.g. when a timestamp contains
 * invalid characters.
 */
gboolean         nd_trace_area_dialog_apply(void);

void             nd_trace_area_dialog_sync(LND_TraceArea *area);
void             nd_trace_area_dialog_set_mode(LND_TPM_NavMode mode);
LND_TPM_NavMode  nd_trace_area_dialog_get_mode(void);

void             nd_trace_area_dialog_set_current_part(void);

/**
 * nd_trace_area_dialog_sync_time_scale - syncs rest of dialog to time entry fields.
 * @start: whether to sync to the start or end time entry fields.
 *
 * The function updates the scale widgets and the other time entry
 * fields to reflect the current value of the time entry fields for
 * the start time (when @start is %TRUE) or the end time.
 */
void             nd_trace_area_dialog_sync_time_scale(gboolean start);

#endif

