/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.modeler.annotation;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Messager;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.SourcePosition;
import com.sun.tools.ws.ToolVersion;
import com.sun.tools.ws.processor.ProcessorNotificationListener;
import com.sun.tools.ws.processor.generator.GeneratorUtil;
import com.sun.tools.ws.processor.generator.Names;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.processor.model.Operation;
import com.sun.tools.ws.processor.model.Port;
import com.sun.tools.ws.processor.model.Service;
import com.sun.tools.ws.processor.model.jaxb.JAXBModel;
import com.sun.tools.ws.processor.modeler.ModelerException;
import com.sun.tools.ws.processor.modeler.annotation.AnnotationProcessorContext;
import com.sun.tools.ws.processor.modeler.annotation.ModelBuilder;
import com.sun.tools.ws.processor.modeler.annotation.TypeModeler;
import com.sun.tools.ws.processor.modeler.annotation.WebServiceConstants;
import com.sun.tools.ws.processor.modeler.annotation.WebServiceReferenceCollector;
import com.sun.tools.ws.processor.modeler.annotation.WebServiceVisitor;
import com.sun.tools.ws.processor.modeler.annotation.WebServiceWrapperGenerator;
import com.sun.tools.ws.processor.util.ClientProcessorEnvironment;
import com.sun.tools.ws.processor.util.ProcessorEnvironment;
import com.sun.tools.ws.util.ToolBase;
import com.sun.tools.xjc.api.JavaCompiler;
import com.sun.tools.xjc.api.Reference;
import com.sun.tools.xjc.api.XJC;
import com.sun.xml.ws.util.localization.Localizable;
import com.sun.xml.ws.util.localization.LocalizableMessage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceProvider;

public class WebServiceAP
extends ToolBase
implements AnnotationProcessor,
ModelBuilder,
WebServiceConstants,
ProcessorNotificationListener {
    protected AnnotationProcessorEnvironment apEnv;
    protected ProcessorEnvironment env;
    private File sourceDir;
    private Model model;
    private TypeDeclaration remoteDecl;
    private TypeDeclaration remoteExceptionDecl;
    private TypeDeclaration exceptionDecl;
    private TypeDeclaration defHolderDecl;
    private Service service;
    private Port port;
    protected AnnotationProcessorContext context;
    private Set<TypeDeclaration> processedTypeDecls = new HashSet<TypeDeclaration>();
    protected Messager messager;
    private ByteArrayOutputStream output;
    private ToolBase tool;
    private boolean doNotOverWrite = false;
    private boolean wrapperGenerated = false;
    private boolean isAPTInvocation = false;

    public void run() {
    }

    protected boolean parseArguments(String[] args) {
        return true;
    }

    public WebServiceAP(ToolBase tool, ProcessorEnvironment env, Properties options, AnnotationProcessorContext context) {
        super(System.out, "WebServiceAP");
        this.context = context;
        this.tool = tool;
        this.env = env;
        if (options != null) {
            this.sourceDir = new File(options.getProperty("sourceDirectory"));
            String key = "doNotOverWrite";
            this.doNotOverWrite = Boolean.valueOf(options.getProperty(key));
        }
    }

    public void init(AnnotationProcessorEnvironment apEnv) {
        this.apEnv = apEnv;
        this.remoteDecl = this.apEnv.getTypeDeclaration(REMOTE_CLASSNAME);
        this.remoteExceptionDecl = this.apEnv.getTypeDeclaration(REMOTE_EXCEPTION_CLASSNAME);
        this.exceptionDecl = this.apEnv.getTypeDeclaration(EXCEPTION_CLASSNAME);
        this.defHolderDecl = this.apEnv.getTypeDeclaration(HOLDER_CLASSNAME);
        if (this.env == null) {
            Map apOptions = apEnv.getOptions();
            this.output = new ByteArrayOutputStream();
            String classDir = (String)apOptions.get("-d");
            if (classDir == null) {
                classDir = ".";
            }
            this.sourceDir = apOptions.get("-s") != null ? new File((String)apOptions.get("-s")) : new File(classDir);
            String cp = (String)apOptions.get("-classpath");
            String cpath = classDir + File.pathSeparator + cp + File.pathSeparator + System.getProperty("java.class.path");
            this.env = new ClientProcessorEnvironment(this.output, cpath, this);
            ((ClientProcessorEnvironment)this.env).setNames(new Names());
            boolean setVerbose = false;
            for (String key : apOptions.keySet()) {
                if (!key.equals("-verbose")) continue;
                setVerbose = true;
            }
            if (setVerbose) {
                this.env.setFlags(1);
            }
            this.messager = apEnv.getMessager();
            this.isAPTInvocation = true;
        }
        this.env.setFiler(apEnv.getFiler());
    }

    public AnnotationProcessorEnvironment getAPEnv() {
        return this.apEnv;
    }

    public ProcessorEnvironment getEnvironment() {
        return this.env;
    }

    public ProcessorEnvironment getProcessorEnvironment() {
        return this.env;
    }

    public File getSourceDir() {
        return this.sourceDir;
    }

    public void onError(String key) {
        this.onError(new LocalizableMessage(this.getResourceBundleName(), key, new Object[0]));
    }

    public void onError(String key, Object[] args) throws ModelerException {
        this.onError(null, key, args);
    }

    public void onError(SourcePosition pos, String key, Object[] args) throws ModelerException {
        this.onError(pos, new LocalizableMessage(this.getResourceBundleName(), key, args));
    }

    public void onError(Localizable msg) throws ModelerException {
        this.onError(null, msg);
    }

    public void onError(SourcePosition pos, Localizable msg) throws ModelerException {
        if (this.messager == null) {
            throw new ModelerException(msg);
        }
        this.messager.printError(pos, this.localizer.localize(msg));
    }

    public void onWarning(String key) {
        this.onWarning(new LocalizableMessage(this.getResourceBundleName(), key, new Object[0]));
    }

    public void onWarning(Localizable msg) {
        String message = this.localizer.localize(this.getMessage("webserviceap.warning", this.localizer.localize(msg)));
        if (this.messager != null) {
            this.messager.printWarning(message);
        } else {
            this.report(message);
        }
    }

    public void onInfo(Localizable msg) {
        if (this.messager != null) {
            String message = this.localizer.localize(msg);
            this.messager.printNotice(message);
        } else {
            String message = this.localizer.localize(this.getMessage("webserviceap.info", this.localizer.localize(msg)));
            this.report(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        if (this.context.getRound() == 1) {
            this.buildModel();
        }
        if (!this.wrapperGenerated || this.context.getRound() == 2 || this.context.allEncoded()) {
            if (!(this.context.getRound() != 2 && this.wrapperGenerated || this.context.isModelCompleted())) {
                this.completeModel();
                this.context.setModelCompleted(true);
            }
            try {
                for (AnnotationProcessorContext.SEIContext seiContext : this.context.getSEIContexts()) {
                    if (seiContext.getModelCompiled()) continue;
                    this.runProcessorActions(seiContext.getModel());
                    seiContext.setModelCompiled(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (this.messager != null && this.output != null && this.output.size() > 0) {
                    this.messager.printNotice(this.output.toString());
                }
            }
        }
        this.context.incrementRound();
    }

    public boolean checkAndSetProcessed(TypeDeclaration typeDecl) {
        if (!this.processedTypeDecls.contains(typeDecl)) {
            this.processedTypeDecls.add(typeDecl);
            return false;
        }
        return true;
    }

    public void clearProcessed() {
        this.processedTypeDecls.clear();
    }

    protected void runProcessorActions(Model model) throws Exception {
        if (this.tool != null) {
            this.tool.runProcessorActions();
        }
    }

    protected String getGenericErrorMessage() {
        return "webserviceap.error";
    }

    protected String getResourceBundleName() {
        return "com.sun.tools.ws.resources.webserviceap";
    }

    public void createModel(TypeDeclaration d, QName modelName, String targetNamespace, String modelerClassName) {
        AnnotationProcessorContext.SEIContext seiContext = this.context.getSEIContext(d);
        if (seiContext.getModel() != null) {
            this.onError("webserviceap.model.already.exists");
            return;
        }
        this.log("creating model: " + modelName);
        this.model = new Model(modelName);
        this.model.setTargetNamespaceURI(targetNamespace);
        this.model.setProperty("com.sun.xml.ws.processor.model.ModelerName", modelerClassName);
        seiContext.setModel(this.model);
    }

    public void setService(Service service) {
        this.service = service;
        this.model.addService(service);
    }

    public void setPort(Port port) {
        this.port = port;
        this.service.addPort(port);
    }

    public void addOperation(Operation operation) {
        this.port.addOperation(operation);
    }

    public void setWrapperGenerated(boolean wrapperGenerated) {
        this.wrapperGenerated = wrapperGenerated;
    }

    public TypeDeclaration getTypeDeclaration(String typeName) {
        return this.apEnv.getTypeDeclaration(typeName);
    }

    public String getSourceVersion() {
        return ToolVersion.VERSION.MAJOR_VERSION;
    }

    private void buildModel() {
        WebServiceProvider webServiceProvider = null;
        WebServiceVisitor wrapperGenerator = this.createWrapperGenerator();
        boolean processedEndpoint = false;
        for (TypeDeclaration typedecl : this.apEnv.getTypeDeclarations()) {
            if (!(typedecl instanceof ClassDeclaration)) continue;
            webServiceProvider = (WebServiceProvider)typedecl.getAnnotation(WebServiceProvider.class);
            WebService webService = (WebService)typedecl.getAnnotation(WebService.class);
            if (webServiceProvider != null) {
                if (webService != null) {
                    this.onError("webserviceap.webservice.and.webserviceprovider", new Object[]{typedecl.getQualifiedName()});
                }
                processedEndpoint = true;
            }
            if (!this.shouldProcessWebService(webService)) continue;
            typedecl.accept((DeclarationVisitor)wrapperGenerator);
            processedEndpoint = true;
        }
        if (!processedEndpoint) {
            if (this.isAPTInvocation) {
                this.onWarning("webserviceap.no.webservice.endpoint.found");
            } else {
                this.onError("webserviceap.no.webservice.endpoint.found");
            }
        }
    }

    protected WebServiceVisitor createWrapperGenerator() {
        return new WebServiceWrapperGenerator(this, this.context);
    }

    protected WebServiceVisitor createReferenceCollector() {
        return new WebServiceReferenceCollector(this, this.context);
    }

    protected boolean shouldProcessWebService(WebService webService) {
        return webService != null;
    }

    private void completeModel() {
        TypeDeclaration decl;
        this.clearProcessed();
        JavaCompiler javaC = XJC.createJavaCompiler();
        WebServiceVisitor referenceCollector = this.createReferenceCollector();
        for (AnnotationProcessorContext.SEIContext seiContext : this.context.getSEIContexts()) {
            this.log("completing model for endpoint: " + seiContext.getSEIImplName());
            decl = this.apEnv.getTypeDeclaration(seiContext.getSEIImplName());
            if (decl == null) {
                this.onError("webserviceap.could.not.find.typedecl", new Object[]{seiContext.getSEIImplName(), this.context.getRound()});
            }
            decl.accept((DeclarationVisitor)referenceCollector);
        }
        this.clearProcessed();
        for (AnnotationProcessorContext.SEIContext seiContext : this.context.getSEIContexts()) {
            decl = this.apEnv.getTypeDeclaration(seiContext.getSEIName());
            Collection<Reference> schemaMirrors = seiContext.getSchemaReferences(this);
            JAXBModel jaxBModel = new JAXBModel(javaC.bind(schemaMirrors, seiContext.getSchemaElementMap(this), seiContext.getNamespaceURI(), this.apEnv));
            seiContext.setJAXBModel(jaxBModel);
        }
    }

    public boolean isException(TypeDeclaration typeDecl) {
        return WebServiceAP.isSubtype(typeDecl, this.exceptionDecl);
    }

    public boolean isRemoteException(TypeDeclaration typeDecl) {
        return WebServiceAP.isSubtype(typeDecl, this.remoteExceptionDecl);
    }

    public boolean isRemote(TypeDeclaration typeDecl) {
        return WebServiceAP.isSubtype(typeDecl, this.remoteDecl);
    }

    public static boolean isSubtype(TypeDeclaration d1, TypeDeclaration d2) {
        ClassType superClass;
        if (d1.equals(d2)) {
            return true;
        }
        ClassDeclaration superClassDecl = null;
        if (d1 instanceof ClassDeclaration && (superClass = ((ClassDeclaration)d1).getSuperclass()) != null && (superClassDecl = superClass.getDeclaration()).equals(d2)) {
            return true;
        }
        InterfaceDeclaration superIntf = null;
        for (InterfaceType interfaceType : d1.getSuperinterfaces()) {
            superIntf = interfaceType.getDeclaration();
            if (!superIntf.equals(d2)) continue;
            return true;
        }
        if (superIntf != null && WebServiceAP.isSubtype(superIntf, d2)) {
            return true;
        }
        return superClassDecl != null && WebServiceAP.isSubtype((TypeDeclaration)superClassDecl, d2);
    }

    public static String getMethodSig(MethodDeclaration method) {
        StringBuffer buf = new StringBuffer(method.getSimpleName() + "(");
        Iterator params = method.getFormalTypeParameters().iterator();
        int i = 0;
        while (params.hasNext()) {
            if (i > 0) {
                buf.append(", ");
            }
            TypeParameterDeclaration param = (TypeParameterDeclaration)params.next();
            buf.append(param.getSimpleName());
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    public String getOperationName(String messageName) {
        return messageName;
    }

    public String getResponseName(String operationName) {
        return Names.getResponseName(operationName);
    }

    public TypeMirror getHolderValueType(TypeMirror type) {
        return TypeModeler.getHolderValueType(type, this.defHolderDecl, this.apEnv);
    }

    public boolean canOverWriteClass(String className) {
        return !this.doNotOverWrite || !GeneratorUtil.classExists(this.env, className);
    }

    public void log(String msg) {
        if (this.env != null && this.env.verbose()) {
            String message = "[" + msg + "]";
            if (this.messager != null) {
                this.messager.printNotice(message);
            } else {
                System.out.println(message);
            }
        }
    }

    public String getXMLName(String javaName) {
        return javaName;
    }
}

