/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.IntrospectionException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.IdxPropertyPattern;
import org.netbeans.modules.beans.JMIUtils;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PropertyActionSettings;
import org.netbeans.modules.beans.PropertyPattern;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

public final class PatternAnalyser
implements Node.Cookie {
    private static final int PROPERTIES_RESERVE = 11;
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";
    private static final String ADD_PREFIX = "add";
    private static final String REMOVE_PREFIX = "remove";
    private ArrayList currentPropertyPatterns = new ArrayList();
    private ArrayList currentIdxPropertyPatterns = new ArrayList();
    private ArrayList currentEventSetPatterns = new ArrayList();
    private HashMap propertyPatterns;
    private HashMap idxPropertyPatterns;
    private HashMap eventSetPatterns;
    private JavaClass classElement;
    private JavaClass referenceClassElement;
    private boolean analyzed = false;
    private boolean ignore;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PatternAnalyser(JavaClass classElement) {
        this.classElement = classElement;
    }

    public PatternAnalyser(JavaClass classElement, JavaClass referenceClassElement) {
        this(classElement);
        this.referenceClassElement = referenceClassElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void analyzeAll() {
        if (this.ignore) {
            return;
        }
        this.analyzed = true;
        this.propertyPatterns = new HashMap(11);
        this.idxPropertyPatterns = new HashMap();
        this.eventSetPatterns = new HashMap();
        try {
            JMIUtils.beginTrans(false);
            try {
                if (!this.classElement.isValid()) {
                    return;
                }
                this.resolveMethods();
                this.resolveFields();
                this.resolveChangesOfProperties();
                this.resolveChangesOfIdxProperties();
                this.resolveChangesOfEventSets();
            }
            finally {
                JMIUtils.endTrans();
            }
        }
        catch (JmiException e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
    }

    boolean isAnalyzed() {
        return this.analyzed;
    }

    void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public Collection getPropertyPatterns() {
        return this.currentPropertyPatterns;
    }

    public Collection getIdxPropertyPatterns() {
        return this.currentIdxPropertyPatterns;
    }

    public Collection getEventSetPatterns() {
        return this.currentEventSetPatterns;
    }

    public JavaClass getClassElement() {
        return this.classElement;
    }

    private void resolveMethods() throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        List methods = JMIUtils.getMethods((ClassDefinition)this.classElement);
        HashMap adds = new HashMap();
        HashMap removes = new HashMap();
        Iterator it = methods.iterator();
        while (it.hasNext()) {
            PropertyPattern pp;
            Method method = (Method)it.next();
            String name = method.getName();
            int len = name.length();
            if ((name.startsWith(GET_PREFIX) && len > GET_PREFIX.length() || name.startsWith(SET_PREFIX) && len > SET_PREFIX.length() || name.startsWith(IS_PREFIX) && len > IS_PREFIX.length()) && (pp = this.analyseMethodForProperties(method)) != null) {
                this.addProperty(pp);
            }
            if ((!name.startsWith(ADD_PREFIX) || len <= ADD_PREFIX.length()) && (!name.startsWith(REMOVE_PREFIX) || len <= REMOVE_PREFIX.length())) continue;
            this.analyseMethodForEventSets(method, adds, removes);
        }
        Iterator keys = adds.keySet().iterator();
        while (keys.hasNext()) {
            String compound = (String)keys.next();
            if (removes.get(compound) == null || compound.indexOf("Listener:") <= 0) continue;
            Method addMethod = (Method)adds.get(compound);
            Method removeMethod = (Method)removes.get(compound);
            List params = addMethod.getParameters();
            Type argType = ((Parameter)params.get(0)).getType();
            if (!(argType instanceof ClassDefinition) || !PatternAnalyser.isSubclass((ClassDefinition)argType, (ClassDefinition)this.findClassElement("java.util.EventListener"))) continue;
            EventSetPattern esp = new EventSetPattern(this, addMethod, removeMethod);
            this.addEventSet(esp);
        }
    }

    private void resolveFields() throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        List fields = JMIUtils.getFields(this.classElement);
        String propertyStyle = PropertyActionSettings.getDefault().getPropStyle();
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            Type ppType;
            PropertyPattern pp;
            Field field = (Field)it.next();
            if ((field.getModifiers() & 8) != 0) continue;
            String fieldName = field.getName();
            if (fieldName.startsWith(propertyStyle)) {
                fieldName = fieldName.substring(1);
            }
            if ((pp = (PropertyPattern)this.propertyPatterns.get(fieldName)) == null) {
                pp = (PropertyPattern)this.idxPropertyPatterns.get(fieldName);
            }
            if (pp == null || (ppType = pp.getType()) == null || !ppType.equals(field.getType())) continue;
            pp.setEstimatedField(field);
        }
    }

    private void resolveChangesOfProperties() {
        this.currentPropertyPatterns = PatternAnalyser.resolveChanges(this.currentPropertyPatterns, this.propertyPatterns, LevelComparator.PROPERTY);
    }

    private void resolveChangesOfIdxProperties() {
        this.currentIdxPropertyPatterns = PatternAnalyser.resolveChanges(this.currentIdxPropertyPatterns, this.idxPropertyPatterns, LevelComparator.IDX_PROPERTY);
    }

    private void resolveChangesOfEventSets() {
        this.currentEventSetPatterns = PatternAnalyser.resolveChanges(this.currentEventSetPatterns, this.eventSetPatterns, LevelComparator.EVENT_SET);
    }

    static ArrayList resolveChanges(Collection current, Map created, LevelComparator comparator) throws JmiException {
        JMIUtils.isInsideTrans();
        ArrayList old = new ArrayList(current);
        ArrayList cre = new ArrayList(created.size());
        cre.addAll(created.values());
        ArrayList<Pattern> result = new ArrayList<Pattern>(created.size() + 5);
        for (int level = 0; level <= comparator.getLevels(); ++level) {
            Iterator itCre = cre.iterator();
            block1: while (itCre.hasNext()) {
                Pattern crePattern = (Pattern)itCre.next();
                Iterator itOld = old.iterator();
                while (itOld.hasNext()) {
                    Pattern oldPattern = (Pattern)itOld.next();
                    if (!comparator.compare(level, oldPattern, crePattern)) continue;
                    itOld.remove();
                    itCre.remove();
                    comparator.copyProperties(oldPattern, crePattern);
                    result.add(oldPattern);
                    continue block1;
                }
            }
        }
        result.addAll(cre);
        return result;
    }

    PropertyPattern analyseMethodForProperties(Method method) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        int modifiers = method.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            return null;
        }
        String name = method.getName();
        Parameter[] params = method.getParameters().toArray(new Parameter[0]);
        Type returnType = method.getType();
        PropertyPattern pp = null;
        try {
            if (params.length == 0) {
                if (name.startsWith(GET_PREFIX)) {
                    pp = new PropertyPattern(this, method, null);
                } else if (JMIUtils.isPrimitiveType(returnType, PrimitiveTypeKindEnum.BOOLEAN) && name.startsWith(IS_PREFIX)) {
                    pp = new PropertyPattern(this, method, null);
                }
            } else if (params.length == 1) {
                if (JMIUtils.isPrimitiveType(params[0].getType(), PrimitiveTypeKindEnum.INT) && name.startsWith(GET_PREFIX)) {
                    pp = new IdxPropertyPattern(this, null, null, method, null);
                } else if (JMIUtils.isPrimitiveType(returnType, PrimitiveTypeKindEnum.VOID) && name.startsWith(SET_PREFIX)) {
                    pp = new PropertyPattern(this, null, method);
                }
            } else if (params.length == 2 && JMIUtils.isPrimitiveType(params[0].getType(), PrimitiveTypeKindEnum.INT) && name.startsWith(SET_PREFIX)) {
                pp = new IdxPropertyPattern(this, null, null, null, method);
            }
        }
        catch (IntrospectionException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            pp = null;
        }
        return pp;
    }

    void analyseMethodForEventSets(Method method, Map adds, Map removes) throws JmiException {
        Type paramType;
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        int modifiers = method.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            return;
        }
        String name = method.getName();
        Parameter[] params = method.getParameters().toArray(new Parameter[0]);
        Type returnType = method.getType();
        if (params.length == 1 && JMIUtils.isPrimitiveType(returnType, PrimitiveTypeKindEnum.VOID) && (paramType = params[0].getType()) instanceof JavaClass) {
            JavaClass lsnrType = (JavaClass)paramType;
            if (name.startsWith(ADD_PREFIX) && name.substring(3).equals(lsnrType.getSimpleName())) {
                String compound = name.substring(3) + ":" + lsnrType.getName();
                adds.put(compound, method);
            } else if (name.startsWith(REMOVE_PREFIX) && name.substring(6).equals(lsnrType.getSimpleName())) {
                String compound = name.substring(6) + ":" + lsnrType.getName();
                removes.put(compound, method);
            }
        }
    }

    private void addProperty(PropertyPattern pp) {
        boolean isIndexed = pp instanceof IdxPropertyPattern;
        HashMap hm = isIndexed ? this.idxPropertyPatterns : this.propertyPatterns;
        String name = pp.getName();
        PropertyPattern old = (PropertyPattern)this.propertyPatterns.get(name);
        if (old == null) {
            old = (PropertyPattern)this.idxPropertyPatterns.get(name);
        }
        if (old == null) {
            hm.put(name, pp);
            return;
        }
        Type opt = old.getType();
        Type npt = pp.getType();
        if (opt != null && npt != null && !opt.equals(npt)) {
            hm.put(name, pp);
            return;
        }
        boolean isOldIndexed = old instanceof IdxPropertyPattern;
        if (isIndexed || isOldIndexed) {
            if (isIndexed && !isOldIndexed) {
                this.propertyPatterns.remove(old.getName());
            } else if (!isIndexed && isOldIndexed) {
                this.idxPropertyPatterns.remove(old.getName());
            }
            IdxPropertyPattern composite = new IdxPropertyPattern(old, pp);
            this.idxPropertyPatterns.put(name, composite);
        } else {
            PropertyPattern composite = new PropertyPattern(old, pp);
            this.propertyPatterns.put(name, composite);
        }
    }

    void addEventSet(EventSetPattern esp) {
        String key = esp.getName() + esp.getType().getName();
        EventSetPattern old = (EventSetPattern)this.eventSetPatterns.get(key);
        if (old == null) {
            this.eventSetPatterns.put(key, esp);
            return;
        }
        EventSetPattern composite = new EventSetPattern(old, esp);
        this.eventSetPatterns.put(key, composite);
    }

    static boolean isSubclass(ClassDefinition a, ClassDefinition b) {
        if (a == null || b == null) {
            return false;
        }
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        return a.isSubTypeOf(b);
    }

    public static FileObject fileObjectForElement(Element element) {
        return JavaMetamodel.getManager().getFileObject(element.getResource());
    }

    public static JavaClass findClassElement(String name, Pattern pattern) {
        return pattern.patternAnalyser.findClassElement(name);
    }

    public FileObject findFileObject() {
        return PatternAnalyser.fileObjectForElement((Element)(this.referenceClassElement != null ? this.referenceClassElement : this.classElement));
    }

    JavaClass findClassElement(String name) {
        Type t = this.findType(name);
        if (t instanceof JavaClass) {
            return (JavaClass)t;
        }
        return null;
    }

    Type findType(String name) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        JavaClass jc = this.referenceClassElement != null ? this.referenceClassElement : this.classElement;
        Type t = null;
        if (jc.isValid()) {
            t = JavaMetamodel.getManager().getJavaExtent((Element)jc).getType().resolve(name);
        }
        return t;
    }

    static {
        $assertionsDisabled = !PatternAnalyser.class.desiredAssertionStatus();
    }

    static abstract class LevelComparator {
        static LevelComparator PROPERTY = new Property();
        static LevelComparator IDX_PROPERTY = new IdxProperty();
        static LevelComparator EVENT_SET = new EventSet();

        LevelComparator() {
        }

        abstract boolean compare(int var1, Pattern var2, Pattern var3);

        abstract int getLevels();

        abstract void copyProperties(Pattern var1, Pattern var2);

        static class EventSet
        extends LevelComparator {
            EventSet() {
            }

            boolean compare(int level, Pattern p1, Pattern p2) {
                switch (level) {
                    case 0: {
                        return ((EventSetPattern)p1).getAddListenerMethod() == ((EventSetPattern)p2).getAddListenerMethod() || ((EventSetPattern)p1).getRemoveListenerMethod() == ((EventSetPattern)p2).getRemoveListenerMethod();
                    }
                }
                return false;
            }

            int getLevels() {
                return 0;
            }

            void copyProperties(Pattern p1, Pattern p2) {
                ((EventSetPattern)p1).copyProperties((EventSetPattern)p2);
            }
        }

        static class IdxProperty
        extends LevelComparator {
            IdxProperty() {
            }

            boolean compare(int level, Pattern p1, Pattern p2) {
                switch (level) {
                    case 0: {
                        return ((IdxPropertyPattern)p1).getIndexedGetterMethod() == ((IdxPropertyPattern)p2).getIndexedGetterMethod() && ((IdxPropertyPattern)p1).getIndexedSetterMethod() == ((IdxPropertyPattern)p2).getIndexedSetterMethod();
                    }
                    case 1: {
                        return ((IdxPropertyPattern)p1).getIndexedGetterMethod() == ((IdxPropertyPattern)p2).getIndexedGetterMethod();
                    }
                    case 2: {
                        return ((IdxPropertyPattern)p1).getIndexedSetterMethod() == ((IdxPropertyPattern)p2).getIndexedSetterMethod();
                    }
                }
                return false;
            }

            int getLevels() {
                return 2;
            }

            void copyProperties(Pattern p1, Pattern p2) {
                ((IdxPropertyPattern)p1).copyProperties((IdxPropertyPattern)p2);
            }
        }

        static class Property
        extends LevelComparator {
            Property() {
            }

            boolean compare(int level, Pattern p1, Pattern p2) {
                switch (level) {
                    case 0: {
                        return ((PropertyPattern)p1).getGetterMethod() == ((PropertyPattern)p2).getGetterMethod() && ((PropertyPattern)p1).getSetterMethod() == ((PropertyPattern)p2).getSetterMethod();
                    }
                    case 1: {
                        return ((PropertyPattern)p1).getGetterMethod() == ((PropertyPattern)p2).getGetterMethod();
                    }
                    case 2: {
                        return ((PropertyPattern)p1).getSetterMethod() == ((PropertyPattern)p2).getSetterMethod();
                    }
                }
                return false;
            }

            int getLevels() {
                return 2;
            }

            void copyProperties(Pattern p1, Pattern p2) {
                ((PropertyPattern)p1).copyProperties((PropertyPattern)p2);
            }
        }
    }
}

