/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.Introspector;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.beans.JMIUtils;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PatternNode;
import org.netbeans.modules.beans.PropertyActionSettings;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;

final class BeanPatternGenerator {
    private static final String THIS_QUALIFIER = "this.";
    private static final String TAB = "  ";
    private static final String TABx2 = "    ";
    private static final String TABx3 = "      ";
    static final /* synthetic */ boolean $assertionsDisabled;

    BeanPatternGenerator() {
    }

    static String createFieldName(String base, boolean adjustName, boolean paramClash) {
        if (!adjustName) {
            if (!paramClash) {
                return base;
            }
            return THIS_QUALIFIER + base;
        }
        String propertyStyle = PropertyActionSettings.getDefault().getPropStyle();
        return propertyStyle + base;
    }

    static String propertySetterBody(String name, Type type, boolean bound, boolean constrained, boolean withSet, boolean withSupport, String supportName, String vetoSupportName) throws JmiException {
        return BeanPatternGenerator.propertySetterBody(name, type, bound, constrained, withSet, withSupport, supportName, vetoSupportName, true);
    }

    static String propertySetterBody(String name, Type type, boolean bound, boolean constrained, boolean withSet, boolean withSupport, String supportName, String vetoSupportName, boolean adjustName) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        StringBuffer setterBody = new StringBuffer(200);
        String decoratedName = BeanPatternGenerator.createFieldName(name, adjustName, true);
        setterBody.append("\n");
        if (withSupport) {
            setterBody.append(TAB + type.getName());
            setterBody.append(" old").append(Pattern.capitalizeFirstLetter(name));
            setterBody.append(" = ").append(decoratedName).append(";\n");
            if (constrained) {
                setterBody.append(TAB + vetoSupportName).append(".fireVetoableChange(\"").append(name).append("\", ");
                if (type instanceof PrimitiveType) {
                    setterBody.append("new ").append(BeanPatternGenerator.getWrapperClassName(type)).append(" (");
                    setterBody.append("old").append(Pattern.capitalizeFirstLetter(name));
                    setterBody.append("), ");
                    setterBody.append("new ").append(BeanPatternGenerator.getWrapperClassName(type)).append(" (");
                    setterBody.append(name).append("));\n");
                } else {
                    setterBody.append("old").append(Pattern.capitalizeFirstLetter(name));
                    setterBody.append(", ").append(name).append(");\n");
                }
                if (!bound) {
                    setterBody.append(TAB).append(decoratedName);
                    setterBody.append(" = ").append(name).append(";\n");
                }
            }
            if (bound) {
                setterBody.append(TAB).append(decoratedName);
                setterBody.append(" = ").append(name).append(";\n");
                setterBody.append(TAB + supportName).append(".firePropertyChange (\"").append(name).append("\", ");
                if (type instanceof PrimitiveType) {
                    setterBody.append("new ").append(BeanPatternGenerator.getWrapperClassName(type)).append(" (");
                    setterBody.append("old").append(Pattern.capitalizeFirstLetter(name));
                    setterBody.append("), ");
                    setterBody.append("new ").append(BeanPatternGenerator.getWrapperClassName(type)).append(" (");
                    setterBody.append(name).append("));\n");
                } else {
                    setterBody.append("old").append(Pattern.capitalizeFirstLetter(name));
                    setterBody.append(", ").append(name).append(");\n");
                }
            }
        } else if (withSet) {
            setterBody.append(TAB).append(decoratedName);
            setterBody.append(" = ").append(name).append(";\n");
        }
        return setterBody.toString();
    }

    static String idxPropertySetterBody(String name, Type indexedType, boolean bound, boolean constrained, boolean withSet, boolean withSupport, String supportName, String vetoSupportName) throws JmiException {
        return BeanPatternGenerator.idxPropertySetterBody(name, indexedType, bound, constrained, withSet, withSupport, supportName, vetoSupportName, true);
    }

    static String idxPropertySetterBody(String name, Type indexedType, boolean bound, boolean constrained, boolean withSet, boolean withSupport, String supportName, String vetoSupportName, boolean adjustName) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        StringBuffer setterBody = new StringBuffer(200);
        String decoratedName = BeanPatternGenerator.createFieldName(name, adjustName, true);
        setterBody.append("\n");
        if (withSupport && constrained) {
            setterBody.append(TAB + indexedType.getName());
            setterBody.append(" old").append(Pattern.capitalizeFirstLetter(name));
            setterBody.append(" = ").append(decoratedName);
            setterBody.append("[index];\n");
        }
        if (withSet || withSupport) {
            setterBody.append(TAB).append(decoratedName);
            setterBody.append("[index] = ").append(name).append(";\n");
        }
        if (withSupport && constrained) {
            setterBody.append("  try {\n");
            setterBody.append(TABx2 + vetoSupportName).append(".fireVetoableChange (\"").append(name).append("\", ");
            setterBody.append("null, null );\n");
            setterBody.append("  }\n");
            setterBody.append("  catch(java.beans.PropertyVetoException vetoException ) {\n");
            setterBody.append(TABx2).append(decoratedName);
            setterBody.append("[index] = old").append(Pattern.capitalizeFirstLetter(name)).append(";\n");
            setterBody.append("    throw vetoException;\n");
            setterBody.append("  }\n");
        }
        if (withSupport && bound) {
            setterBody.append(TAB + supportName).append(".firePropertyChange (\"").append(name).append("\", ");
            setterBody.append("null, null );\n");
        }
        return setterBody.toString();
    }

    static String propertyGetterBody(String name, boolean withReturn) {
        return BeanPatternGenerator.propertyGetterBody(name, withReturn, true);
    }

    static String propertyGetterBody(String name, boolean withReturn, boolean adjustName) {
        StringBuffer getterBody = new StringBuffer(50);
        String decorated = BeanPatternGenerator.createFieldName(name, adjustName, false);
        getterBody.append("\n");
        if (withReturn) {
            getterBody.append("  return ");
            getterBody.append(decorated).append(";\n");
        }
        return getterBody.toString();
    }

    static String idxPropertyGetterBody(String name, boolean withReturn) {
        return BeanPatternGenerator.idxPropertyGetterBody(name, withReturn, true);
    }

    static String idxPropertyGetterBody(String name, boolean withReturn, boolean adjustName) {
        StringBuffer getterBody = new StringBuffer(50);
        String decorated = BeanPatternGenerator.createFieldName(name, adjustName, false);
        getterBody.append("\n");
        if (withReturn) {
            getterBody.append("  return ");
            getterBody.append(decorated).append("[index];\n");
        }
        return getterBody.toString();
    }

    static String supportField(JavaClass ce) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        String supportName = null;
        JavaModelPackage jmodel = JavaMetamodel.getManager().getJavaExtent((Element)ce);
        Type pcsType = jmodel.getType().resolve("java.beans.PropertyChangeSupport");
        List fields = JMIUtils.getFields(ce);
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            Field field = (Field)it.next();
            if (!JMIUtils.equalTypes(pcsType, field.getType())) continue;
            supportName = field.getName();
            break;
        }
        if (supportName == null) {
            supportName = BeanPatternGenerator.findFreeFieldName(ce, "propertyChangeSupport");
            Field supportField = jmodel.getField().createField();
            supportField.setName(supportName);
            supportField.setType(pcsType);
            supportField.setModifiers(2);
            supportField.setInitialValueText(" new java.beans.PropertyChangeSupport(this)");
            supportField.setJavadocText(PatternNode.getString("COMMENT_PropertyChangeSupport"));
            ce.getFeatures().add(supportField);
        }
        return supportName;
    }

    static String vetoSupportField(JavaClass ce) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        String vetoSupportName = null;
        JavaModelPackage jmodel = JavaMetamodel.getManager().getJavaExtent((Element)ce);
        Type vcsType = jmodel.getType().resolve("java.beans.VetoableChangeSupport");
        List fields = JMIUtils.getFields(ce);
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            Field field = (Field)it.next();
            if (!JMIUtils.equalTypes(vcsType, field.getType())) continue;
            vetoSupportName = field.getName();
            break;
        }
        if (vetoSupportName == null) {
            vetoSupportName = BeanPatternGenerator.findFreeFieldName(ce, "vetoableChangeSupport");
            Field supportField = jmodel.getField().createField();
            supportField.setName(vetoSupportName);
            supportField.setType(vcsType);
            supportField.setModifiers(2);
            supportField.setInitialValueText(" new java.beans.VetoableChangeSupport(this)");
            supportField.setJavadocText(PatternNode.getString("COMMENT_VetoableChangeSupport"));
            ce.getFeatures().add(supportField);
        }
        return vetoSupportName;
    }

    private static String findFreeFieldName(JavaClass ce, String defName) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        String name = defName;
        int i = 1;
        while (ce.getField(name, true) != null) {
            name = defName + '_' + i;
            ++i;
        }
        return name;
    }

    static void supportListenerMethods(JavaClass classElement, String supportName) throws JmiException {
        StringBuffer body;
        Parameter param;
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        String addMethodId = "addPropertyChangeListener";
        Method addMethod = null;
        String removeMethodId = "removePropertyChangeListener";
        Method removeMethod = null;
        String listenerTypeId = "java.beans.PropertyChangeListener";
        JavaModelPackage jmodel = JavaMetamodel.getManager().getJavaExtent((Element)classElement);
        Type listenerType = jmodel.getType().resolve(listenerTypeId);
        addMethod = classElement.getMethod(addMethodId, Collections.singletonList(listenerType), false);
        if (addMethod == null) {
            addMethod = jmodel.getMethod().createMethod();
            addMethod.setName(addMethodId);
            addMethod.setType(jmodel.getType().resolve("void"));
            addMethod.setModifiers(1);
            param = jmodel.getParameter().createParameter();
            param.setName("l");
            param.setType(listenerType);
            addMethod.getParameters().add(param);
            body = new StringBuffer(80);
            body.append("\n").append(TAB + supportName);
            body.append(".addPropertyChangeListener(l);\n");
            addMethod.setBodyText(body.toString());
            addMethod.setJavadocText(PatternNode.getString("COMMENT_AddPropertyChangeListener"));
            classElement.getFeatures().add(addMethod);
        }
        if ((removeMethod = classElement.getMethod(removeMethodId, Collections.singletonList(listenerType), false)) == null) {
            removeMethod = jmodel.getMethod().createMethod();
            removeMethod.setName(removeMethodId);
            removeMethod.setType(jmodel.getType().resolve("void"));
            removeMethod.setModifiers(1);
            param = jmodel.getParameter().createParameter();
            param.setName("l");
            param.setType(listenerType);
            removeMethod.getParameters().add(param);
            body = new StringBuffer(80);
            body.append("\n").append(TAB + supportName);
            body.append(".removePropertyChangeListener(l);\n");
            removeMethod.setBodyText(body.toString());
            removeMethod.setJavadocText(PatternNode.getString("COMMENT_RemovePropertyChangeListener"));
            classElement.getFeatures().add(removeMethod);
        }
    }

    static void vetoSupportListenerMethods(JavaClass classElement, String supportName) throws JmiException {
        StringBuffer body;
        Parameter param;
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        String addMethodId = "addVetoableChangeListener";
        Method addMethod = null;
        String removeMethodId = "removeVetoableChangeListener";
        Method removeMethod = null;
        String listenerTypeId = "java.beans.VetoableChangeListener";
        JavaModelPackage jmodel = JavaMetamodel.getManager().getJavaExtent((Element)classElement);
        Type listenerType = jmodel.getType().resolve(listenerTypeId);
        addMethod = classElement.getMethod(addMethodId, Collections.singletonList(listenerType), false);
        if (addMethod == null) {
            addMethod = jmodel.getMethod().createMethod();
            addMethod.setName(addMethodId);
            addMethod.setType(jmodel.getType().resolve("void"));
            addMethod.setModifiers(1);
            param = jmodel.getParameter().createParameter();
            param.setName("l");
            param.setType(listenerType);
            addMethod.getParameters().add(param);
            body = new StringBuffer(80);
            body.append("\n").append(TAB + supportName);
            body.append(".addVetoableChangeListener (l);\n");
            addMethod.setBodyText(body.toString());
            addMethod.setJavadocText(PatternNode.getString("COMMENT_AddVetoableChangeListener"));
            classElement.getFeatures().add(addMethod);
        }
        if ((removeMethod = classElement.getMethod(removeMethodId, Collections.singletonList(listenerType), false)) == null) {
            removeMethod = jmodel.getMethod().createMethod();
            removeMethod.setName(removeMethodId);
            removeMethod.setType(jmodel.getType().resolve("void"));
            removeMethod.setModifiers(1);
            param = jmodel.getParameter().createParameter();
            param.setName("l");
            param.setType(listenerType);
            removeMethod.getParameters().add(param);
            body = new StringBuffer(80);
            body.append("\n").append(TAB + supportName);
            body.append(".removeVetoableChangeListener (l);\n");
            removeMethod.setBodyText(body.toString());
            removeMethod.setJavadocText(PatternNode.getString("COMMENT_RemoveVetoableChangeListener"));
            classElement.getFeatures().add(removeMethod);
        }
    }

    static Field listenersArrayListField(JavaClass ce, Type type, boolean create) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        Field ret = null;
        String fieldName = null;
        String simpleTypeName = ((JavaClass)type).getSimpleName();
        String fieldNameToFind = Introspector.decapitalize(simpleTypeName) + "List";
        String fieldTypeId = "java.util.ArrayList";
        JavaModelPackage jmodel = JavaMetamodel.getManager().getJavaExtent((Element)ce);
        Type fieldType = jmodel.getType().resolve(fieldTypeId);
        List fields = JMIUtils.getFields(ce);
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            Field field = (Field)it.next();
            if (!JMIUtils.equalTypes(fieldType, field.getType()) || !fieldNameToFind.equals(field.getName())) continue;
            fieldName = fieldNameToFind;
            ret = field;
            break;
        }
        if (fieldName == null && create) {
            fieldName = fieldNameToFind;
            Field field = jmodel.getField().createField();
            field.setName(fieldName);
            field.setType(fieldType);
            field.setModifiers(130);
            String comment = MessageFormat.format(PatternNode.getString("COMMENT_ListenerArrayList"), simpleTypeName);
            field.setJavadocText(comment);
            ce.getFeatures().add(field);
            ret = field;
        }
        return ret;
    }

    static Field eventListenerListField(JavaClass ce, Type type, boolean create) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        String fieldName = null;
        Field ret = null;
        String fieldTypeId = "javax.swing.event.EventListenerList";
        JavaModelPackage jmodel = JavaMetamodel.getManager().getJavaExtent((Element)ce);
        Type fieldType = jmodel.getType().resolve(fieldTypeId);
        List fields = JMIUtils.getFields(ce);
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            Field field = (Field)it.next();
            if (!JMIUtils.equalTypes(fieldType, field.getType())) continue;
            fieldName = field.getName();
            ret = field;
            break;
        }
        if (fieldName == null && create) {
            fieldName = "listenerList";
            Field field = jmodel.getField().createField();
            field.setName(fieldName);
            field.setType(fieldType);
            field.setModifiers(2);
            field.setInitialValueText(" null");
            String comment = MessageFormat.format(PatternNode.getString("COMMENT_EventListenerList"), ((JavaClass)type).getSimpleName());
            field.setJavadocText(comment);
            ce.getFeatures().add(field);
            ret = field;
        }
        return ret;
    }

    static Field unicastListenerField(JavaClass ce, Type type, boolean create) throws JmiException {
        Field field;
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        Field ret = null;
        String fieldName = null;
        String typeSimpleName = ((JavaClass)type).getSimpleName();
        String fieldNameToFind = Introspector.decapitalize(typeSimpleName);
        if (fieldNameToFind.equals(typeSimpleName)) {
            fieldNameToFind = "listener" + fieldNameToFind;
        }
        List fields = JMIUtils.getFields(ce);
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            field = (Field)it.next();
            if (!JMIUtils.equalTypes(type, field.getType()) || !fieldNameToFind.equals(field.getName())) continue;
            fieldName = fieldNameToFind;
            ret = field;
            break;
        }
        if (fieldName == null && create) {
            fieldName = fieldNameToFind;
            JavaModelPackage jmodel = JavaMetamodel.getManager().getJavaExtent((Element)ce);
            field = jmodel.getField().createField();
            field.setName(fieldName);
            field.setType(type);
            field.setModifiers(130);
            field.setInitialValueText(" null");
            String comment = MessageFormat.format(PatternNode.getString("COMMENT_UnicastEventListener"), ((JavaClass)type).getSimpleName());
            field.setJavadocText(comment);
            ce.getFeatures().add(field);
            ret = field;
        }
        return ret;
    }

    static String mcAddBody(Type type, int implementation, String listenerList) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        String fieldName = Introspector.decapitalize(((JavaClass)type).getSimpleName()) + "List";
        StringBuffer body = new StringBuffer(50);
        if (listenerList == null) {
            listenerList = "listenerList";
        }
        body.append("\n");
        if (implementation == 1) {
            body.append("  if (").append(fieldName).append(" == null ) {\n");
            body.append(TABx2).append(fieldName).append(" = new java.util.ArrayList ();\n");
            body.append(TAB).append("}\n");
            body.append(TAB + fieldName).append(".add (listener);\n");
        } else if (implementation == 2) {
            body.append("  if (").append(listenerList).append(" == null ) {\n");
            body.append(TABx2).append(listenerList).append(" = new javax.swing.event.EventListenerList();\n");
            body.append(TAB).append("}\n");
            body.append(TAB + listenerList).append(".add (");
            body.append(type.getName()).append(".class, listener);\n");
        }
        return body.toString();
    }

    static String mcRemoveBody(Type type, int implementation, String listenerList) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        String fieldName = Introspector.decapitalize(((JavaClass)type).getSimpleName()) + "List";
        if (listenerList == null) {
            listenerList = "listenerList";
        }
        StringBuffer body = new StringBuffer(50);
        body.append("\n");
        if (implementation == 1) {
            body.append("  if (").append(fieldName).append(" != null ) {\n");
            body.append(TABx2 + fieldName).append(".remove (listener);\n");
            body.append(TAB).append("}\n");
        } else if (implementation == 2) {
            body.append(TAB + listenerList).append(".remove (");
            body.append(type.getName()).append(".class, listener);\n");
        }
        return body.toString();
    }

    static String ucAddBody(Type type, int implementation) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        String simpleTypeName = ((JavaClass)type).getSimpleName();
        String fieldName = Introspector.decapitalize(simpleTypeName);
        if (fieldName.equals(simpleTypeName)) {
            fieldName = "listener" + fieldName;
        }
        StringBuffer body = new StringBuffer(50);
        body.append("\n");
        if (implementation == 1) {
            body.append("  if (").append(fieldName).append(" != null) {\n");
            body.append("    throw new java.util.TooManyListenersException ();\n");
            body.append("  }\n");
            body.append(TAB + fieldName).append(" = listener;\n");
        }
        return body.toString();
    }

    static String ucRemoveBody(Type type, int implementation) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        String simpleTypeName = ((JavaClass)type).getSimpleName();
        String fieldName = Introspector.decapitalize(simpleTypeName);
        if (fieldName.equals(simpleTypeName)) {
            fieldName = "listener" + fieldName;
        }
        StringBuffer body = new StringBuffer(50);
        body.append("\n");
        if (implementation == 1) {
            body.append(TAB + fieldName).append(" = null;\n");
        }
        return body.toString();
    }

    static void fireMethod(JavaClass classElement, Type type, Method method, int implementation, String listenerList, boolean passEvent) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        if (listenerList == null) {
            listenerList = "listenerList";
        }
        String simpleTypeName = ((JavaClass)type).getSimpleName();
        String methodId = "fire" + Pattern.capitalizeFirstLetter(simpleTypeName) + Pattern.capitalizeFirstLetter(method.getName());
        Method newMethod = null;
        Type eventType = null;
        JavaModelPackage jmodel = JavaMetamodel.getManager().getJavaExtent((Element)classElement);
        List params = method.getParameters();
        eventType = params.isEmpty() ? jmodel.getType().resolve("java.util.EventObject") : ((Parameter)params.get(0)).getType();
        JavaClass eventClass = (JavaClass)eventType;
        newMethod = jmodel.getMethod().createMethod();
        newMethod.setName(methodId);
        newMethod.setType(jmodel.getType().resolve("void"));
        newMethod.setModifiers(2);
        List newMethodParams = BeanPatternGenerator.generateFireParameters(eventClass, jmodel, passEvent);
        newMethod.getParameters().addAll(newMethodParams);
        StringBuffer body = new StringBuffer(80);
        body.append("\n");
        if (implementation == 1) {
            String fieldName = Introspector.decapitalize(simpleTypeName) + "List";
            body.append("  java.util.ArrayList list;\n");
            if (BeanPatternGenerator.usesConstructorParameters(eventClass, passEvent)) {
                body.append(TAB + eventType.getName()).append(" e = new ");
                body.append(eventType.getName()).append(" (");
                body.append(BeanPatternGenerator.fireParameterstoString(newMethodParams));
                body.append(");\n");
            }
            body.append("  synchronized (this) {\n");
            body.append("    if (" + fieldName + " == null) return;\n");
            body.append("    list = (java.util.ArrayList)");
            body.append(fieldName).append(".clone ();\n  }\n");
            body.append("  for (int i = 0; i < list.size (); i++) {\n");
            body.append("    ((").append(type.getName());
            body.append(")list.get (i)).").append(method.getName());
            body.append(" (");
            if (BeanPatternGenerator.usesConstructorParameters(eventClass, passEvent)) {
                body.append("e");
            } else {
                body.append(BeanPatternGenerator.fireParameterstoString(newMethodParams));
            }
            body.append(");\n  }\n");
        } else if (implementation == 2) {
            if (BeanPatternGenerator.usesConstructorParameters(eventClass, passEvent)) {
                body.append(TAB + eventType.getName()).append(" e = null;\n ");
            }
            body.append("  if (" + listenerList + " == null) return;\n");
            body.append("  Object[] listeners = ").append(listenerList).append(".getListenerList ();\n");
            body.append("  for (int i = listeners.length - 2; i >= 0; i -= 2) {\n");
            body.append("    if (listeners[i]==").append(type.getName()).append(".class) {\n");
            if (BeanPatternGenerator.usesConstructorParameters(eventClass, passEvent)) {
                body.append("      if (e == null)\n");
                body.append("        e = new ").append(eventType.getName()).append(" (");
                body.append(BeanPatternGenerator.fireParameterstoString(newMethodParams));
                body.append(");\n");
            }
            body.append("      ((").append(type.getName()).append(")listeners[i+1]).").append(method.getName());
            body.append(" (");
            if (BeanPatternGenerator.usesConstructorParameters(eventClass, passEvent)) {
                body.append("e");
            } else {
                body.append(BeanPatternGenerator.fireParameterstoString(newMethodParams));
            }
            body.append(");\n    }\n  }\n");
        }
        newMethod.setBodyText(body.toString());
        StringBuffer comment = new StringBuffer(PatternNode.getString("COMMENT_FireMethodMC"));
        if (!BeanPatternGenerator.usesConstructorParameters(eventClass, passEvent)) {
            comment.append("\n@param event The event to be fired\n");
        } else {
            comment.append(BeanPatternGenerator.fireParametersComment(newMethodParams, ((JavaClass)eventType).getSimpleName()));
        }
        newMethod.setJavadocText(comment.toString());
        classElement.getFeatures().add(newMethod);
    }

    static void unicastFireMethod(JavaClass classElement, Type type, Method method, int implementation, boolean passEvent) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        String simpleTypeName = ((JavaClass)type).getSimpleName();
        String methodId = "fire" + Pattern.capitalizeFirstLetter(simpleTypeName) + Pattern.capitalizeFirstLetter(method.getName());
        Method newMethod = null;
        Type eventType = null;
        JavaModelPackage jmodel = JavaMetamodel.getManager().getJavaExtent((Element)classElement);
        List params = method.getParameters();
        eventType = params.isEmpty() ? jmodel.getType().resolve("java.util.EventObject") : ((Parameter)params.get(0)).getType();
        JavaClass eventClass = (JavaClass)eventType;
        newMethod = jmodel.getMethod().createMethod();
        newMethod.setName(methodId);
        newMethod.setType(jmodel.getType().resolve("void"));
        newMethod.setModifiers(2);
        List newMethodParams = BeanPatternGenerator.generateFireParameters(eventClass, jmodel, passEvent);
        newMethod.getParameters().addAll(newMethodParams);
        StringBuffer body = new StringBuffer(80);
        body.append("\n");
        if (implementation == 1) {
            String fieldName = Introspector.decapitalize(simpleTypeName);
            if (fieldName.equals(simpleTypeName)) {
                fieldName = "listener" + fieldName;
            }
            body.append("  if (" + fieldName + " == null) return;\n");
            if (BeanPatternGenerator.usesConstructorParameters(eventClass, passEvent)) {
                body.append(TAB + eventType.getName()).append(" e = new ");
                body.append(eventType.getName()).append(" (");
                body.append(BeanPatternGenerator.fireParameterstoString(newMethodParams));
                body.append(");\n");
            }
            body.append(TAB + fieldName).append(".").append(method.getName());
            body.append(" (");
            if (BeanPatternGenerator.usesConstructorParameters(eventClass, passEvent)) {
                body.append("e");
            } else {
                body.append(BeanPatternGenerator.fireParameterstoString(newMethodParams));
            }
            body.append(");\n");
        }
        newMethod.setBodyText(body.toString());
        StringBuffer comment = new StringBuffer(PatternNode.getString("COMMENT_FireMethodUC"));
        if (!BeanPatternGenerator.usesConstructorParameters(eventClass, passEvent)) {
            comment.append("\n@param event The event to be fired\n");
        } else {
            comment.append(BeanPatternGenerator.fireParametersComment(newMethodParams, ((JavaClass)eventType).getSimpleName()));
        }
        newMethod.setJavadocText(comment.toString());
        classElement.getFeatures().add(newMethod);
    }

    static boolean usesConstructorParameters(JavaClass eventClass, boolean passEvent) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        return !passEvent && eventClass != null && !eventClass.isInterface() && JMIUtils.getConstructors((ClassDefinition)eventClass).size() <= 1;
    }

    static List generateFireParameters(JavaClass eventClass, JavaModelPackage jmodel, boolean passEvent) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        if (!BeanPatternGenerator.usesConstructorParameters(eventClass, passEvent)) {
            Parameter param = jmodel.getParameter().createParameter();
            param.setName("event");
            param.setType((Type)eventClass);
            return Collections.singletonList(param);
        }
        Constructor constructor = (Constructor)JMIUtils.getConstructors((ClassDefinition)eventClass).get(0);
        List params = constructor.getParameters();
        ArrayList<Parameter> result = new ArrayList<Parameter>(params.size());
        Iterator it = params.iterator();
        while (it.hasNext()) {
            Parameter param = (Parameter)it.next();
            Parameter newParam = jmodel.getParameter().createParameter();
            newParam.setName(param.getName());
            newParam.setType(param.getType());
            result.add(newParam);
        }
        return result;
    }

    static String fireParameterstoString(List params) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        StringBuffer buffer = new StringBuffer(60);
        Iterator it = params.iterator();
        while (it.hasNext()) {
            Parameter param = (Parameter)it.next();
            buffer.append(param.getName());
            buffer.append(", ");
        }
        if (buffer.length() > 2) {
            return buffer.substring(0, buffer.length() - 2);
        }
        return buffer.toString();
    }

    static String fireParametersComment(List params, String evntType) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        StringBuffer buffer = new StringBuffer(60);
        int i = 0;
        Iterator it = params.iterator();
        while (it.hasNext()) {
            Parameter param = (Parameter)it.next();
            buffer.append("\n@param ").append(param.getName());
            buffer.append(" Parameter #").append(i++ + 1).append(" of the <CODE>");
            buffer.append(evntType).append("<CODE> constructor.");
        }
        buffer.append("\n");
        return buffer.toString();
    }

    public static String getWrapperClassName(Type type) throws JmiException {
        if (!$assertionsDisabled && !JMIUtils.isInsideTrans()) {
            throw new AssertionError();
        }
        if (type instanceof ClassDefinition) {
            return type.getName();
        }
        if (!(type instanceof PrimitiveType)) {
            throw new IllegalStateException("Unknonw type: " + type);
        }
        String typeName = type.getName();
        char[] ctype = typeName.toCharArray();
        switch (ctype[0]) {
            case 'b': {
                if (ctype[1] == 'o') {
                    return "Boolean";
                }
                return "Byte";
            }
            case 'd': {
                return "Double";
            }
            case 'f': {
                return "Float";
            }
            case 'c': {
                return "Character";
            }
            case 'i': {
                return "Integer";
            }
            case 'l': {
                return "Long";
            }
            case 's': {
                return "Short";
            }
        }
        return "Object";
    }

    static {
        $assertionsDisabled = !BeanPatternGenerator.class.desiredAssertionStatus();
    }
}

