/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.ResultPanelOutput;
import org.netbeans.modules.junit.output.ResultPanelTree;
import org.netbeans.modules.junit.output.ResultViewOutput;
import org.netbeans.modules.junit.output.ResultViewTree;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

final class ResultDisplayHandler {
    private static final String ID_TREE = "tree";
    private static final String ID_OUTPUT = "output";
    private MultiViewHandler handler;
    private MultiViewPerspective treeViewHandle;
    private MultiViewPerspective outputViewHandle;
    private ResultPanelTree treePanel;
    private ResultPanelOutput outputListener;
    private TopComponent displayComp;
    static final Object[] EMPTY_QUEUE = new Object[0];
    private final Object queueLock = new Object();
    private volatile Object[] outputQueue;
    private volatile int outputQueueSize = 0;
    private int outputQueueAvailSpace;
    static final String ANONYMOUS_SUITE = new String();
    private String runningSuite;
    private List reports;
    private String message;
    private Map methodsMap;

    ResultDisplayHandler() {
    }

    TopComponent getDisplayComponent() {
        if (this.displayComp == null) {
            this.displayComp = this.createDisplayComp();
        }
        return this.displayComp;
    }

    private TopComponent createDisplayComp() {
        ResultTreeViewDesc descTree = new ResultTreeViewDesc(ID_TREE, "LBL_resultTreeView");
        ResultOutputViewDesc descOutput = new ResultOutputViewDesc(ID_OUTPUT, "LBL_resultOutputView");
        TopComponent tc = MultiViewFactory.createMultiView((MultiViewDescription[])new MultiViewDescription[]{descTree, descOutput}, (MultiViewDescription)descTree);
        this.setUpNavigation((JComponent)tc);
        this.handler = MultiViews.findMultiViewHandler((TopComponent)tc);
        MultiViewPerspective[] viewHandles = this.handler.getPerspectives();
        this.treeViewHandle = viewHandles[0];
        this.outputViewHandle = viewHandles[1];
        return tc;
    }

    void displayShown() {
    }

    void displayHidden() {
    }

    private void setUpNavigation(JComponent c) {
        String actionName = "toggleView";
        int keyModifiers = 576;
        InputMap inputMap = c.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(37, 576), "toggleView");
        inputMap.put(KeyStroke.getKeyStroke(39, 576), "toggleView");
        c.getActionMap().put("toggleView", new ToggleViewAction());
    }

    Object getOutputQueueLock() {
        return this.queueLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOutputListener(ResultPanelOutput outputPanel) {
        Object object = this.queueLock;
        synchronized (object) {
            this.outputListener = outputPanel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayOutput(String text, boolean error) {
        Object object = this.queueLock;
        synchronized (object) {
            int itemSpace;
            if (this.outputQueue == null) {
                this.outputQueue = new Object[40];
                this.outputQueueAvailSpace = this.outputQueue.length - 1;
                this.outputQueueSize = 0;
            }
            int n = itemSpace = error ? 2 : 1;
            if ((this.outputQueueAvailSpace -= itemSpace) < 0) {
                int newCapacity = this.outputQueue.length < 640 ? this.outputQueue.length * 2 : this.outputQueue.length * 3 / 2;
                Object[] oldQueue = this.outputQueue;
                this.outputQueue = new Object[newCapacity];
                System.arraycopy(oldQueue, 0, this.outputQueue, 0, this.outputQueueSize);
                this.outputQueueAvailSpace += this.outputQueue.length - oldQueue.length;
            }
            if (error) {
                this.outputQueue[this.outputQueueSize++] = Boolean.TRUE;
            }
            this.outputQueue[this.outputQueueSize++] = text;
            if (this.outputListener != null) {
                this.outputListener.outputAvailable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] consumeOutput() {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.outputQueueSize == 0) {
                return EMPTY_QUEUE;
            }
            Object[] passedQueue = this.outputQueue;
            this.outputQueue = null;
            this.outputQueueSize = 0;
            return passedQueue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displaySuiteRunning(String suiteName) {
        assert (this.runningSuite == null);
        suiteName = suiteName != null ? suiteName : ANONYMOUS_SUITE;
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            if (this.treePanel == null) {
                this.runningSuite = suiteName;
                return;
            }
        }
        this.displayInDispatchThread("displaySuiteRunning", suiteName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayReport(Report report) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            if (this.treePanel == null) {
                if (this.reports == null) {
                    this.reports = new ArrayList(10);
                }
                this.reports.add(report);
                this.runningSuite = null;
                return;
            }
        }
        this.displayInDispatchThread("displayReport", report);
        assert (this.runningSuite == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayMessage(String msg) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            if (this.treePanel == null) {
                this.message = msg;
                return;
            }
        }
        this.displayInDispatchThread("displayMsg", msg);
    }

    private void displayInDispatchThread(String methodName, final Object param) {
        assert (methodName != null);
        assert (this.treePanel != null);
        final Method method = this.prepareMethod(methodName);
        if (method == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    method.invoke((Object)ResultDisplayHandler.this.treePanel, param);
                }
                catch (InvocationTargetException ex) {
                    ErrorManager.getDefault().notify(ex.getTargetException());
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(65536, (Throwable)ex);
                }
            }
        });
    }

    private Method prepareMethod(String methodName) {
        Method method;
        if (this.methodsMap == null) {
            this.methodsMap = new HashMap(4);
            method = null;
        } else {
            method = (Method)this.methodsMap.get(methodName);
        }
        if (method == null && !this.methodsMap.containsKey(methodName)) {
            Class paramType;
            if (methodName.equals("displayReport")) {
                paramType = Report.class;
            } else {
                assert (methodName.equals("displayMsg") || methodName.equals("displaySuiteRunning"));
                paramType = String.class;
            }
            try {
                method = ResultPanelTree.class.getDeclaredMethod(methodName, paramType);
            }
            catch (Exception ex) {
                method = null;
                ErrorManager.getDefault().notify(65536, (Throwable)ex);
            }
            this.methodsMap.put(methodName, method);
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTreePanel(ResultPanelTree treePanel) {
        ResultDisplayHandler resultDisplayHandler = this;
        synchronized (resultDisplayHandler) {
            if (this.treePanel != null) {
                return;
            }
            this.treePanel = treePanel;
        }
        if (this.message != null) {
            treePanel.displayMsg(this.message);
            this.message = null;
        }
        if (this.reports != null) {
            treePanel.displayReports(this.reports);
            this.reports = null;
        }
        if (this.runningSuite != null) {
            treePanel.displaySuiteRunning(this.runningSuite != ANONYMOUS_SUITE ? this.runningSuite : null);
        }
    }

    private final class ResultOutputViewDesc
    extends AbstractResultViewDesc
    implements Serializable {
        static final long serialVersionUID = -6007918504501341013L;

        private ResultOutputViewDesc(String id, String displayNameKey) {
            super(id, displayNameKey);
        }

        public Image getIcon() {
            return null;
        }

        public MultiViewElement createElement() {
            return new ResultViewOutput(ResultDisplayHandler.this);
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }
    }

    private final class ResultTreeViewDesc
    extends AbstractResultViewDesc
    implements Serializable {
        static final long serialVersionUID = -4369549644387784567L;

        private ResultTreeViewDesc(String id, String displayNameKey) {
            super(id, displayNameKey);
        }

        public Image getIcon() {
            return null;
        }

        public MultiViewElement createElement() {
            return new ResultViewTree(ResultDisplayHandler.this);
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }
    }

    private static abstract class AbstractResultViewDesc
    implements MultiViewDescription {
        private final String idPart;
        private transient String id;
        private final String displayNameKey;
        private transient String displayName;

        private AbstractResultViewDesc(String id, String displayNameKey) {
            this.idPart = id;
            this.displayNameKey = displayNameKey;
        }

        public String preferredID() {
            return this.idPart;
        }

        public String getDisplayName() {
            if (this.displayName == null) {
                try {
                    this.displayName = NbBundle.getMessage(ResultDisplayHandler.class, (String)this.displayNameKey);
                }
                catch (MissingResourceException ex) {
                    ErrorManager.getDefault().notify(4096, (Throwable)ex);
                    this.displayName = "??? (" + this.displayNameKey + ')';
                }
            }
            return this.displayName;
        }

        public int getPersistenceType() {
            return 2;
        }
    }

    final class ToggleViewAction
    extends AbstractAction {
        ToggleViewAction() {
        }

        public void actionPerformed(ActionEvent e) {
            MultiViewPerspective currView = ResultDisplayHandler.this.handler.getSelectedPerspective();
            if (currView == ResultDisplayHandler.this.treeViewHandle) {
                ResultDisplayHandler.this.handler.requestActive(ResultDisplayHandler.this.outputViewHandle);
            } else if (currView == ResultDisplayHandler.this.outputViewHandle) {
                ResultDisplayHandler.this.handler.requestActive(ResultDisplayHandler.this.treeViewHandle);
            } else assert (false);
        }
    }
}

