/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.request;

import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.request.BasicAuthHandler;
import org.apache.tomcat.request.FormAuthHandler;
import org.apache.tomcat.request.FormSecurityCheckHandler;
import org.apache.tomcat.request.SSLRequiredHandler;
import org.apache.tomcat.request.SecurityConstraints;
import org.apache.tomcat.util.URLUtil;

public class AccessInterceptor
extends BaseInterceptor {
    ContextManager cm;
    int secMapNote;
    int reqRolesNote;
    int reqTransportNote;

    public void addContainer(Container ct) throws TomcatException {
        Context ctx = ct.getContext();
        Container ctxCt = ctx.getContainer();
        SecurityConstraints ctxSecurityC = (SecurityConstraints)ctxCt.getNote(this.secMapNote);
        if (ctxSecurityC == null) {
            ctxCt.setNote(this.secMapNote, new SecurityConstraints());
        }
        if (ct.getRoles() != null || ct.getTransport() != null) {
            if (this.debug > 0) {
                this.log("addContainer() " + ctx.getHost() + " " + ctx.getPath() + " " + ct.getPath());
            }
            ctxSecurityC.addContainer(ct);
        }
    }

    public void contextInit(Context ctx) throws TomcatException {
        String login_type = ctx.getAuthMethod();
        if (this.debug > 0) {
            this.log("Init  " + ctx.getHost() + " " + ctx.getPath() + " " + login_type);
        }
        if (ctx.getErrorPage("403") == null) {
            ctx.addServlet(new SSLRequiredHandler());
            ctx.addErrorPage("403", "tomcat.sslRequiredHandler");
        }
        if ("FORM".equals(login_type)) {
            String cpath;
            String page = ctx.getFormLoginPage();
            String errorPage = ctx.getFormErrorPage();
            if (page == null || errorPage == null) {
                ctx.log("Form login without form pages, defaulting to basic " + page + " " + errorPage);
                if (ctx.getErrorPage("401") == null) {
                    ctx.addServlet(new BasicAuthHandler());
                    ctx.addErrorPage("401", "tomcat.basicAuthHandler");
                }
                return;
            }
            if (!page.startsWith("/")) {
                ctx.log("FORM: login page doesn't start with / " + page);
                page = "/" + page;
            }
            if (!errorPage.startsWith("/")) {
                ctx.log("FORM: error page doesn't start with / " + errorPage);
                errorPage = "/" + errorPage;
            }
            if (page.startsWith(cpath = ctx.getPath())) {
                if (!"".equals(cpath) && !"/".equals(cpath)) {
                    ctx.log("FORM: WARNING, login page starts with context path " + page + " " + cpath);
                }
            } else {
                page = String.valueOf(cpath) + page;
            }
            if (errorPage.startsWith(cpath)) {
                if (!"/".equals(cpath) && !"".equals(cpath)) {
                    ctx.log("FORM: WARNING, error page starts with context path " + errorPage);
                }
            } else {
                errorPage = String.valueOf(cpath) + errorPage;
            }
            ctx.setFormLoginPage(page);
            ctx.setFormErrorPage(errorPage);
            FormAuthHandler formH = new FormAuthHandler();
            formH.setDebug(0);
            ctx.addServlet(formH);
            ctx.addServlet(new FormSecurityCheckHandler());
            ctx.addErrorPage("401", "tomcat.formAuthHandler");
            String pageP = page.substring(cpath.length());
            int lastS = pageP.lastIndexOf("/");
            String location = "/j_security_check";
            if (lastS > 0) {
                location = String.valueOf(pageP.substring(0, lastS)) + "/j_security_check";
            }
            ctx.addServletMapping(location, "tomcat.formSecurityCheck");
            if (this.debug > 0) {
                ctx.log("Map " + location + " to tomcat.formSecurityCheck for " + page);
            }
        } else if ("BASIC".equals(login_type) && ctx.getErrorPage("401") == null) {
            ctx.addServlet(new BasicAuthHandler());
            ctx.addErrorPage("401", "tomcat.basicAuthHandler");
        }
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        super.engineInit(cm);
        this.cm = cm;
        try {
            this.secMapNote = cm.getNoteId(1, "map.security");
            this.reqRolesNote = cm.getNoteId(2, "required.roles");
            this.reqTransportNote = cm.getNoteId(2, "required.transport");
        }
        catch (TomcatException ex) {
            ex.printStackTrace();
            throw new RuntimeException("Invalid state ");
        }
    }

    boolean match(Container ct, String path, String method) {
        String ctPath = ct.getPath();
        int ctPathL = ctPath.length();
        String[] ctMethods = ct.getMethods();
        if (ctMethods != null && ctMethods.length > 0) {
            boolean ok = false;
            int i = 0;
            while (i < ctMethods.length) {
                if (method.equals(ctMethods[i])) {
                    ok = true;
                    break;
                }
                ++i;
            }
            if (!ok) {
                return false;
            }
        }
        switch (ct.getMapType()) {
            case 2: {
                return path.startsWith(ctPath.substring(0, ctPathL - 2));
            }
            case 3: {
                return ctPath.substring(1).equals(URLUtil.getExtension(path));
            }
            case 1: {
                return path.equals(ctPath);
            }
        }
        return false;
    }

    public void removeContainer(Container ct) throws TomcatException {
    }

    public int requestMap(Request req) {
        Context ctx = req.getContext();
        SecurityConstraints ctxSec = (SecurityConstraints)ctx.getContainer().getNote(this.secMapNote);
        if (ctxSec.patterns == 0) {
            return 0;
        }
        String reqURI = req.getRequestURI();
        String ctxPath = ctx.getPath();
        String path = reqURI.substring(ctxPath.length());
        String method = req.getMethod();
        if (this.debug > 1) {
            this.log("checking " + path);
        }
        int i = 0;
        while (i < ctxSec.patterns) {
            Container ct = ctxSec.securityPatterns[i];
            if (this.match(ct, path, method)) {
                String[] roles = ct.getRoles();
                String[] methods = ct.getMethods();
                String transport = ct.getTransport();
                if (this.debug > 0) {
                    int j;
                    StringBuffer sb = new StringBuffer("matched ");
                    sb.append(ct.getPath()).append(" ");
                    if (methods != null) {
                        j = 0;
                        while (j < methods.length) {
                            sb.append(methods[j]).append(" ");
                            ++j;
                        }
                    }
                    sb.append(transport).append(" ");
                    if (roles != null) {
                        j = 0;
                        while (j < roles.length) {
                            sb.append(roles[j]).append(" ");
                            ++j;
                        }
                    }
                    this.log(sb.toString());
                }
                if (roles != null && roles.length > 0) {
                    req.setRequiredRoles(roles);
                }
                if (transport != null && !"NONE".equals(transport)) {
                    req.setNote(this.reqTransportNote, transport);
                    if ("INTEGRAL".equalsIgnoreCase(transport) || "CONFIDENTIAL".equalsIgnoreCase(transport)) {
                        if (this.debug > 0) {
                            this.log("Transport " + transport + " " + req.isSecure());
                        }
                        if (!req.isSecure()) {
                            return 403;
                        }
                    }
                }
            }
            ++i;
        }
        return 0;
    }
}

