/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspparser_ext;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.ExtractPageData;
import org.apache.jasper.compiler.GetParseData;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.compiler.TldLocationsCache;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.web.jspparser.ContextUtil;
import org.netbeans.modules.web.jspparser.ParserServletContext;
import org.netbeans.modules.web.jspparser.WebAppParseProxy;
import org.netbeans.modules.web.jspparser_ext.OptionsImpl;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.web.jsps.parserapi.Node;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;

public class WebAppParseSupport
implements WebAppParseProxy,
PropertyChangeListener {
    private FileObject wmRoot;
    private OptionsImpl editorOptions;
    private OptionsImpl diskOptions;
    private ServletContext editorContext;
    private ServletContext diskContext;
    private JspRuntimeContext rctxt;
    private URLClassLoader waClassLoader;
    private URLClassLoader waContextClassLoader;
    private HashMap clRootsTimeStamps;
    private JspParserAPI.WebModule wm;
    private static Field mappingsF;
    private Map mappings;
    private boolean isClassPathCurrent;
    private HashMap mappingFiles;
    private int lastCheckedClasspath;
    private Set parserSystemJars = null;
    private static int parserDebugLevel;
    private static Pattern rePatternMyFaces;
    private static Pattern rePatternCommonsLogging;

    public WebAppParseSupport(JspParserAPI.WebModule wm) {
        this.wm = wm;
        this.wmRoot = wm.getDocumentBase();
        wm.addPropertyChangeListener((PropertyChangeListener)this);
        this.clRootsTimeStamps = new HashMap();
        this.reinitOptions();
        this.mappings = null;
        this.mappingFiles = null;
    }

    public JspParserAPI.JspOpenInfo getJspOpenInfo(FileObject jspFile, boolean useEditor) {
        JspCompilationContext ctxt = this.createCompilationContext(jspFile, useEditor);
        ExtractPageData epd = new ExtractPageData(ctxt);
        try {
            return new JspParserAPI.JspOpenInfo(epd.isXMLSyntax(), epd.getEncoding());
        }
        catch (Exception e) {
            if (parserDebugLevel > 0) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            return this.getDefaultJspOpenInfo(this.wmRoot, jspFile);
        }
    }

    private JspParserAPI.JspOpenInfo getDefaultJspOpenInfo(FileObject wmRoot, FileObject jspFile) {
        return new JspParserAPI.JspOpenInfo(false, "8859_1");
    }

    synchronized void reinitOptions() {
        if (parserDebugLevel > 0) {
            System.out.println("[" + new Date() + "] " + "JSP parser reinitialized for WM " + FileUtil.toFile((FileObject)this.wmRoot));
            ErrorManager.getDefault().log(1, "[" + new Date() + "] " + "JSP parser reinitialized for WM " + FileUtil.toFile((FileObject)this.wmRoot));
        }
        this.editorContext = new ParserServletContext(this.wmRoot, this.wm, true);
        this.diskContext = new ParserServletContext(this.wmRoot, this.wm, false);
        this.editorOptions = new OptionsImpl(this.editorContext);
        this.diskOptions = new OptionsImpl(this.diskContext);
        this.rctxt = null;
        this.isClassPathCurrent = true;
        this.createClassLoaders();
    }

    private boolean isParserSystemJar(URL path) {
        Matcher m;
        int index;
        String name = path.getFile();
        if (name.endsWith("!/")) {
            name = name.substring(0, name.length() - 2);
        }
        if ((index = name.lastIndexOf(47) + 1) > 0) {
            name = name.substring(index).trim();
        }
        return (m = rePatternMyFaces.matcher(path.getFile())).matches() || this.getParserSystemJar().contains(name);
    }

    private boolean isUnexpectedLibrary(URL url) {
        Matcher m = rePatternCommonsLogging.matcher(url.getFile());
        return m.matches();
    }

    private void createClassLoaders() {
        FileObject classesDir;
        int i;
        FileObject[] roots;
        ClassPath cp;
        boolean isSystemJar;
        URL helpurl;
        this.clRootsTimeStamps.clear();
        FileObject webxml = ContextUtil.findRelativeFileObject((FileObject)this.wmRoot, (String)"WEB-INF/web.xml");
        if (webxml != null) {
            this.registerTimeStamp(webxml, false);
        }
        Hashtable<URL, URL> tomcatTable = new Hashtable<URL, URL>();
        Hashtable<URL, URL> loadingTable = new Hashtable<URL, URL>();
        HashSet<URL> systemJars = new HashSet<URL>();
        FileObject libDir = ContextUtil.findRelativeFileObject((FileObject)this.wmRoot, (String)"WEB-INF/lib");
        if (libDir != null) {
            Enumeration libDirKids = libDir.getChildren(false);
            while (libDirKids.hasMoreElements()) {
                FileObject elem = (FileObject)libDirKids.nextElement();
                if (!elem.getExt().equals("jar")) continue;
                helpurl = this.findInternalURL(elem);
                isSystemJar = this.isParserSystemJar(helpurl);
                if (!this.isUnexpectedLibrary(helpurl)) {
                    tomcatTable.put(helpurl, helpurl);
                    loadingTable.put(helpurl, helpurl);
                    this.registerTimeStamp(elem, false);
                }
                if (!isSystemJar) continue;
                systemJars.add(helpurl);
            }
        }
        if ((cp = ClassPath.getClassPath((FileObject)this.wmRoot, (String)"classpath/compile")) != null) {
            roots = cp.getRoots();
            for (i = 0; i < roots.length; ++i) {
                helpurl = this.findInternalURL(roots[i]);
                isSystemJar = this.isParserSystemJar(helpurl);
                if (loadingTable.get(helpurl) == null && !this.isUnexpectedLibrary(helpurl)) {
                    loadingTable.put(helpurl, helpurl);
                    tomcatTable.put(helpurl, this.findExternalURL(roots[i]));
                    this.registerTimeStamp(roots[i], false);
                }
                if (!isSystemJar || systemJars.contains(helpurl)) continue;
                systemJars.add(helpurl);
            }
        }
        cp = ClassPath.getClassPath((FileObject)this.wmRoot, (String)"classpath/execute");
        this.lastCheckedClasspath = cp.hashCode();
        if (cp != null) {
            roots = cp.getRoots();
            for (i = 0; i < roots.length; ++i) {
                helpurl = this.findInternalURL(roots[i]);
                isSystemJar = this.isParserSystemJar(helpurl);
                if (loadingTable.get(helpurl) == null && !this.isUnexpectedLibrary(helpurl)) {
                    loadingTable.put(helpurl, helpurl);
                    tomcatTable.put(helpurl, this.findExternalURL(roots[i]));
                    this.registerTimeStamp(roots[i], false);
                }
                if (!isSystemJar || systemJars.contains(helpurl)) continue;
                systemJars.add(helpurl);
            }
        }
        if ((classesDir = ContextUtil.findRelativeFileObject((FileObject)this.wmRoot, (String)"WEB-INF/classes")) != null && loadingTable.get(helpurl = this.findInternalURL(classesDir)) == null) {
            loadingTable.put(helpurl, helpurl);
            tomcatTable.put(helpurl, helpurl);
            this.registerTimeStamp(classesDir, false);
        }
        Iterator<Object> iter = loadingTable.values().iterator();
        URL[] loadingURLs = new URL[loadingTable.size()];
        int index = 0;
        while (iter.hasNext()) {
            loadingURLs[index++] = (URL)iter.next();
        }
        URL[] tomcatURLs = new URL[tomcatTable.size()];
        iter = tomcatTable.values().iterator();
        index = 0;
        while (iter.hasNext()) {
            tomcatURLs[index++] = (URL)iter.next();
        }
        File[] files = this.wm.getExtraClasspathEntries();
        if (files == null) {
            files = new File[]{};
        }
        URL[] urls = new URL[files.length + systemJars.size()];
        try {
            int i2;
            for (i2 = 0; i2 < files.length; ++i2) {
                urls[i2] = files[i2].toURI().toURL();
            }
            iter = systemJars.iterator();
            for (i2 = files.length; i2 < urls.length; ++i2) {
                urls[i2] = (URL)iter.next();
            }
        }
        catch (MalformedURLException ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
        }
        this.waClassLoader = new ParserClassLoader(loadingURLs, tomcatURLs, this.getClass().getClassLoader());
        this.waContextClassLoader = new ParserClassLoader(loadingURLs, tomcatURLs, (ClassLoader)new JasperSystemClassLoader(urls, Thread.currentThread().getContextClassLoader()));
        if (parserDebugLevel > 3) {
            String clString = "wa class loader   : " + this.waClassLoader;
            System.out.println(clString);
            ErrorManager.getDefault().log(1, clString);
            clString = "ctxt class loader : " + this.waContextClassLoader;
            System.out.println(clString);
            ErrorManager.getDefault().log(1, clString);
        }
    }

    private URL findInternalURL(FileObject fo) {
        URL url = URLMapper.findURL((FileObject)fo, (int)0);
        return url;
    }

    private URL findExternalURL(FileObject fo) {
        File f = FileUtil.toFile((FileObject)fo);
        if (f != null) {
            try {
                return f.toURI().toURL();
            }
            catch (MalformedURLException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return URLMapper.findURL((FileObject)fo, (int)1);
    }

    private void registerTimeStamp(FileObject fo, boolean recursive) {
        File f;
        try {
            if (fo.getURL().getProtocol().equals("jar")) {
                fo = FileUtil.getArchiveFile((FileObject)fo);
            }
        }
        catch (FileStateInvalidException e) {
            // empty catch block
        }
        if (fo != null && (f = FileUtil.toFile((FileObject)fo)) != null) {
            this.registerTimeStamp(f, recursive);
        }
    }

    private void registerTimeStamp(Map where, File f, boolean recursive) {
        where.put(f, new Long(f.lastModified()));
        if (recursive && f.isDirectory()) {
            File[] kids = f.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            });
            for (int i = 0; i < kids.length; ++i) {
                this.registerTimeStamp(where, kids[i], recursive);
            }
        }
    }

    private void registerTimeStamp(File f, boolean recursive) {
        this.clRootsTimeStamps.put(f, new Long(f.lastModified()));
        if (recursive && f.isDirectory()) {
            File[] kids = f.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            });
            for (int i = 0; i < kids.length; ++i) {
                this.registerTimeStamp(kids[i], recursive);
            }
        }
    }

    private synchronized JspCompilationContext createCompilationContext(FileObject jspFile, boolean useEditor) {
        boolean isTagFile = this.determineIsTagFile(jspFile);
        String jspUri = this.getJSPUri(jspFile);
        OptionsImpl options = useEditor ? this.editorOptions : this.diskOptions;
        ServletContext context = useEditor ? this.editorContext : this.diskContext;
        JspCompilationContext clctxt = null;
        try {
            clctxt = isTagFile ? new JspCompilationContext(jspUri, null, (Options)options, context, null, this.rctxt, null) : new JspCompilationContext(jspUri, false, (Options)options, context, null, this.rctxt);
        }
        catch (JasperException ex) {
            ErrorManager.getDefault().annotate((Throwable)ex, "JSP Parser");
        }
        clctxt.setClassLoader(this.getWAClassLoader());
        return clctxt;
    }

    private boolean determineIsTagFile(FileObject fo) {
        if (fo.getExt().startsWith("tag")) {
            return true;
        }
        return "text/x-tag".equals(fo.getMIMEType());
    }

    private String getJSPUri(FileObject jsp) {
        return ContextUtil.findRelativeContextPath((FileObject)this.wmRoot, (FileObject)jsp);
    }

    public JspParserAPI.ParseResult analyzePage(FileObject jspFile, int errorReportingMode) {
        JspCompilationContext ctxt = this.createCompilationContext(jspFile, true);
        return this.callTomcatParser(jspFile, ctxt, this.waContextClassLoader, errorReportingMode);
    }

    public synchronized Map getTaglibMap(boolean useEditor) throws IOException {
        OptionsImpl options = useEditor ? this.editorOptions : this.diskOptions;
        TldLocationsCache lc = options.getTldLocationsCache();
        HashMap mappings = new HashMap();
        mappings.putAll(this.getMappingsByReflection(lc));
        mappings.putAll(this.getImplicitLocation());
        return mappings;
    }

    private Map getImplicitLocation() {
        HashMap<String, String[]> returnMap = new HashMap<String, String[]>();
        FileObject webInf = ContextUtil.findRelativeFileObject((FileObject)this.wmRoot, (String)"WEB-INF");
        if (webInf != null && webInf.isFolder()) {
            Enumeration en = webInf.getChildren(true);
            while (en.hasMoreElements()) {
                FileObject fo = (FileObject)en.nextElement();
                if (!fo.getExt().equals("tld")) continue;
                File file = FileUtil.toFile((FileObject)fo);
                String path = "/" + ContextUtil.findRelativePath((FileObject)this.wmRoot, (FileObject)fo);
                returnMap.put(path, new String[]{path, null});
            }
        }
        return returnMap;
    }

    private synchronized boolean checkMappingsAreCurrent() {
        File file;
        FileObject fo;
        if (this.mappingFiles == null) {
            return false;
        }
        HashMap<File, Long> checkedFiles = new HashMap<File, Long>();
        FileObject[] roots = ClassPath.getClassPath((FileObject)this.wm.getDocumentBase(), (String)"classpath/execute").getRoots();
        try {
            for (int i = 0; i < roots.length; ++i) {
                if (!roots[i].getURL().getProtocol().equals("jar") || (fo = FileUtil.getArchiveFile((FileObject)roots[i])) == null) continue;
                file = FileUtil.toFile((FileObject)fo);
                checkedFiles.put(file, new Long(file.lastModified()));
            }
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        FileObject webInf = ContextUtil.findRelativeFileObject((FileObject)this.wmRoot, (String)"WEB-INF");
        if (webInf != null && webInf.isFolder()) {
            Enumeration en = webInf.getChildren(true);
            while (en.hasMoreElements()) {
                fo = (FileObject)en.nextElement();
                if (!fo.getExt().equals("tld")) continue;
                file = FileUtil.toFile((FileObject)fo);
                checkedFiles.put(file, new Long(file.lastModified()));
            }
        }
        if ((fo = ContextUtil.findRelativeFileObject((FileObject)this.wmRoot, (String)"WEB-INF")) != null) {
            file = FileUtil.toFile((FileObject)fo);
            this.registerTimeStamp(checkedFiles, file, true);
        }
        return checkedFiles.equals(this.mappingFiles);
    }

    private Set getParserSystemJar() {
        if (this.parserSystemJars == null) {
            TldLocationsCache lc = this.diskOptions.getTldLocationsCache();
            try {
                Field systemsJar = TldLocationsCache.class.getDeclaredField("systemJars");
                systemsJar.setAccessible(true);
                this.parserSystemJars = (HashSet)systemsJar.get(lc);
            }
            catch (IllegalArgumentException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            catch (SecurityException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            catch (NoSuchFieldException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return this.parserSystemJars;
    }

    private Map getMappingsByReflection(TldLocationsCache lc) throws IOException {
        try {
            if (!this.isClassPathCurrent || !this.checkMappingsAreCurrent()) {
                File file;
                FileObject fo;
                if (!this.isClassPathCurrent) {
                    this.reinitOptions();
                }
                mappingsF = TldLocationsCache.class.getDeclaredField("mappings");
                mappingsF.setAccessible(true);
                ((Hashtable)mappingsF.get(lc)).clear();
                InitTldLocationCacheThread compThread = new InitTldLocationCacheThread(lc);
                compThread.setContextClassLoader(this.waContextClassLoader);
                compThread.start();
                try {
                    compThread.join();
                }
                catch (InterruptedException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                this.mappings = (Map)mappingsF.get(lc);
                if (this.mappingFiles == null) {
                    this.mappingFiles = new HashMap();
                } else {
                    this.mappingFiles.clear();
                }
                HashMap usedFile = new HashMap();
                Iterator<Object> iter = this.mappings.values().iterator();
                while (iter.hasNext()) {
                    usedFile.put(((String[])iter.next())[0], null);
                }
                for (String uri : usedFile.keySet()) {
                    if (!uri.startsWith("file:")) {
                        fo = ContextUtil.findRelativeFileObject((FileObject)this.wmRoot, (String)uri);
                        file = fo != null ? FileUtil.toFile((FileObject)fo) : null;
                    } else {
                        uri = uri.substring(5);
                        file = new File(uri);
                    }
                    if (file == null) continue;
                    this.mappingFiles.put(file, new Long(file.lastModified()));
                }
                FileObject[] roots = ClassPath.getClassPath((FileObject)this.wm.getDocumentBase(), (String)"classpath/execute").getRoots();
                try {
                    for (int i = 0; i < roots.length; ++i) {
                        if (!roots[i].getURL().getProtocol().equals("jar") || (fo = FileUtil.getArchiveFile((FileObject)roots[i])) == null) continue;
                        file = FileUtil.toFile((FileObject)fo);
                        this.mappingFiles.put(file, new Long(file.lastModified()));
                    }
                }
                catch (FileStateInvalidException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                fo = ContextUtil.findRelativeFileObject((FileObject)this.wmRoot, (String)"WEB-INF");
                if (fo != null) {
                    file = FileUtil.toFile((FileObject)fo);
                    this.registerTimeStamp(this.mappingFiles, file, true);
                }
            }
            return this.mappings;
        }
        catch (NoSuchFieldException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            IOException e2 = new IOException();
            e2.initCause(e);
            throw e2;
        }
        catch (IllegalAccessException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            IOException e2 = new IOException();
            e2.initCause(e);
            throw e2;
        }
    }

    public URLClassLoader getWAClassLoader() {
        if (!this.checkClassesAreCurrent()) {
            this.reinitOptions();
        }
        return this.waClassLoader;
    }

    private boolean checkClassesAreCurrent() {
        if (!this.isClassPathCurrent) {
            return false;
        }
        long timeStamp = 0L;
        if (parserDebugLevel > 0) {
            System.out.println("[" + new Date() + "] " + "JSP parser classloader check started for WM " + FileUtil.toFile((FileObject)this.wmRoot));
            ErrorManager.getDefault().log(1, "[" + new Date() + "] " + "JSP parser classloader check started for WM " + FileUtil.toFile((FileObject)this.wmRoot));
            timeStamp = System.currentTimeMillis();
        }
        if (this.clRootsTimeStamps == null) {
            return false;
        }
        for (Map.Entry e : this.clRootsTimeStamps.entrySet()) {
            File f = (File)e.getKey();
            if (parserDebugLevel > 9) {
                System.out.println(" -> checking file " + f);
                ErrorManager.getDefault().log(1, " -> checking file " + f);
            }
            if (!f.exists()) {
                return false;
            }
            if (f.lastModified() == ((Long)e.getValue()).longValue()) continue;
            return false;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)this.wmRoot, (String)"classpath/execute");
        if (this.lastCheckedClasspath != cp.hashCode()) {
            return false;
        }
        FileObject[] roots = cp.getRoots();
        for (int i = 0; i < roots.length; ++i) {
            URL url = this.findInternalURL(roots[i]);
            if (this.isParserSystemJar(url) || this.isUnexpectedLibrary(url)) continue;
            FileObject fo = roots[i];
            File file = null;
            try {
                if (roots[i].getURL().getProtocol().equals("jar")) {
                    fo = FileUtil.getArchiveFile((FileObject)roots[i]);
                }
            }
            catch (FileStateInvalidException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            if (fo != null) {
                file = FileUtil.toFile((FileObject)fo);
            }
            if (this.clRootsTimeStamps.containsKey(file)) continue;
            return false;
        }
        if (parserDebugLevel > 0) {
            long timeStamp2 = System.currentTimeMillis();
            System.out.println("[" + new Date() + "] " + "check completed with result 'true', time " + (timeStamp2 - timeStamp));
        }
        return true;
    }

    private JspParserAPI.ParseResult callTomcatParser(final FileObject jspFile, final JspCompilationContext ctxt, ClassLoader contextClassLoader, final int errorReportingMode) {
        final RRef resultRef = new RRef();
        Thread compThread = new Thread("JSP Parsing"){

            private void setResult(GetParseData gpd) {
                PageInfo nbPageInfo = gpd.getNbPageInfo();
                Node.Nodes nbNodes = gpd.getNbNodes();
                Throwable e = gpd.getParseException();
                if (e == null) {
                    resultRef.result = new JspParserAPI.ParseResult(nbPageInfo, nbNodes);
                } else {
                    ErrorManager.getDefault().annotate(e, NbBundle.getMessage(WebAppParseSupport.class, (String)"MSG_errorDuringJspParsing"));
                    if (parserDebugLevel > 0) {
                        ErrorManager.getDefault().notify(1, e);
                    }
                    JspParserAPI.ErrorDescriptor error = WebAppParseSupport.constructErrorDescriptor(e, WebAppParseSupport.this.wmRoot, jspFile);
                    resultRef.result = new JspParserAPI.ParseResult(nbPageInfo, nbNodes, new JspParserAPI.ErrorDescriptor[]{error});
                }
            }

            public void run() {
                GetParseData gpd = null;
                try {
                    gpd = new GetParseData(ctxt, errorReportingMode);
                    gpd.parse();
                    this.setResult(gpd);
                }
                catch (ThreadDeath td) {
                    ErrorManager.getDefault().notify(1, (Throwable)td);
                    throw td;
                }
                catch (Throwable t) {
                    if (gpd != null) {
                        this.setResult(gpd);
                    }
                    ErrorManager.getDefault().notify(1, t);
                }
            }
        };
        compThread.setContextClassLoader(contextClassLoader);
        compThread.start();
        try {
            compThread.join();
            return resultRef.result;
        }
        catch (InterruptedException e) {
            JspParserAPI.ErrorDescriptor error = WebAppParseSupport.constructErrorDescriptor(e, this.wmRoot, jspFile);
            return new JspParserAPI.ParseResult(new JspParserAPI.ErrorDescriptor[]{error});
        }
    }

    private static JspParserAPI.ErrorDescriptor constructErrorDescriptor(Throwable e, FileObject wmRoot, FileObject jspPage) {
        JspParserAPI.ErrorDescriptor error = null;
        try {
            error = WebAppParseSupport.constructJakartaErrorDescriptor(wmRoot, jspPage, e);
        }
        catch (FileStateInvalidException e2) {
            ErrorManager.getDefault().notify(1, (Throwable)e2);
        }
        catch (IOException e2) {
            ErrorManager.getDefault().notify(1, (Throwable)e2);
        }
        if (error == null) {
            error = new JspParserAPI.ErrorDescriptor(wmRoot, jspPage, -1, -1, ContextUtil.getThrowableMessage((Throwable)e, (!(e instanceof JasperException) ? 1 : 0) != 0), "");
        }
        return error;
    }

    private static JspParserAPI.ErrorDescriptor constructJakartaErrorDescriptor(FileObject wmRoot, FileObject jspPage, Throwable ex) throws IOException {
        String wmFileName;
        String m1;
        StringBuffer allStack = new StringBuffer();
        Throwable last = ex;
        allStack.append(ContextUtil.getThrowableMessage((Throwable)ex, (boolean)true));
        while (ex instanceof JasperException) {
            last = ex;
            if ((ex = ((JasperException)ex).getRootCause()) == null) continue;
            ErrorManager.getDefault().annotate(last, ex);
            allStack.append(ContextUtil.getThrowableMessage((Throwable)ex, (boolean)true));
        }
        if (ex == null) {
            ex = last;
        }
        if ((m1 = ex.getMessage()) == null) {
            return null;
        }
        int lpar = m1.indexOf(40);
        if (lpar == -1) {
            return null;
        }
        int comma = m1.indexOf(44, lpar);
        if (comma == -1) {
            return null;
        }
        int rpar = m1.indexOf(41, comma);
        if (rpar == -1) {
            return null;
        }
        String line = m1.substring(lpar + 1, comma).trim();
        String col = m1.substring(comma + 1, rpar).trim();
        String fileName = m1.substring(0, lpar);
        File file = FileUtil.toFile((FileObject)wmRoot);
        FileObject errorFile = jspPage;
        if ((fileName = new File(fileName).getCanonicalPath()).startsWith(wmFileName = file.getCanonicalPath())) {
            FileObject errorTemp;
            String errorRes = fileName.substring(wmFileName.length());
            if ((errorRes = errorRes.replace(File.separatorChar, '/')).startsWith("/")) {
                errorRes = errorRes.substring(1);
            }
            if ((errorTemp = ContextUtil.findRelativeFileObject((FileObject)wmRoot, (String)errorRes)) != null) {
                errorFile = errorTemp;
            }
        }
        try {
            String errContextPath = ContextUtil.findRelativeContextPath((FileObject)wmRoot, (FileObject)errorFile);
            String errorMessage = errContextPath + " [" + line + ";" + col + "] " + m1.substring(rpar + 1).trim();
            return new JspParserAPI.ErrorDescriptor(wmRoot, errorFile, Integer.parseInt(line), Integer.parseInt(col), errorMessage, "");
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("libraries".equals(propName) || "package_roots".equals(propName)) {
            this.isClassPathCurrent = false;
        }
    }

    static {
        parserDebugLevel = Integer.getInteger("org.netbeans.modules.jspparser.debug", 0);
        rePatternMyFaces = Pattern.compile(".*myfaces-impl.*\\.jar.*");
        rePatternCommonsLogging = Pattern.compile(".*commons-logging.*\\.jar.*");
    }

    private static class InitTldLocationCacheThread
    extends Thread {
        private TldLocationsCache cache;

        InitTldLocationCacheThread(TldLocationsCache lc) {
            super("Init TldLocationCache");
            this.cache = lc;
        }

        public void run() {
            try {
                Field initialized = TldLocationsCache.class.getDeclaredField("initialized");
                initialized.setAccessible(true);
                initialized.setBoolean(this.cache, false);
                this.cache.getLocation("");
            }
            catch (JasperException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            catch (NoSuchFieldException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    public static class ParserClassLoader
    extends URLClassLoader {
        private static final AllPermission ALL_PERM = new AllPermission();
        private URL[] tomcatURLs;

        public ParserClassLoader(URL[] classLoadingURLs, URL[] tomcatURLs, ClassLoader parent) {
            super(classLoadingURLs, parent);
            this.tomcatURLs = tomcatURLs;
        }

        public URL[] getURLs() {
            return this.tomcatURLs;
        }

        protected PermissionCollection getPermissions(CodeSource codesource) {
            PermissionCollection perms = super.getPermissions(codesource);
            perms.add(ALL_PERM);
            return perms;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(super.toString());
            sb.append(", parent : ");
            sb.append(this.getParent().toString());
            return sb.toString();
        }
    }

    public static class JasperSystemClassLoader
    extends URLClassLoader {
        private static final AllPermission ALL_PERM = new AllPermission();

        public JasperSystemClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        protected PermissionCollection getPermissions(CodeSource codesource) {
            PermissionCollection perms = super.getPermissions(codesource);
            perms.add(ALL_PERM);
            return perms;
        }
    }

    public class RRef {
        JspParserAPI.ParseResult result;
    }
}

