/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

import com.sun.faces.el.impl.BinaryOperator;
import com.sun.faces.el.impl.Coercions;
import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.Expression;
import com.sun.faces.el.impl.ExpressionInfo;
import java.util.List;

public class BinaryOperatorExpression
extends Expression {
    Expression mExpression;
    List mOperators;
    List mExpressions;

    public Expression getExpression() {
        return this.mExpression;
    }

    public void setExpression(Expression pExpression) {
        this.mExpression = pExpression;
    }

    public List getOperators() {
        return this.mOperators;
    }

    public void setOperators(List pOperators) {
        this.mOperators = pOperators;
    }

    public List getExpressions() {
        return this.mExpressions;
    }

    public void setExpressions(List pExpressions) {
        this.mExpressions = pExpressions;
    }

    public BinaryOperatorExpression(Expression pExpression, List pOperators, List pExpressions) {
        this.mExpression = pExpression;
        this.mOperators = pOperators;
        this.mExpressions = pExpressions;
    }

    public String getExpressionString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        buf.append(this.mExpression.getExpressionString());
        int i = 0;
        int size = this.mOperators.size();
        while (i < size) {
            BinaryOperator operator = (BinaryOperator)this.mOperators.get(i);
            Expression expression = (Expression)this.mExpressions.get(i);
            buf.append(" ");
            buf.append(operator.getOperatorSymbol());
            buf.append(" ");
            buf.append(expression.getExpressionString());
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    public Object evaluate(ExpressionInfo exprInfo) throws ElException {
        Object value = this.mExpression.evaluate(exprInfo);
        int i = 0;
        int size = this.mOperators.size();
        while (i < size) {
            BinaryOperator operator = (BinaryOperator)this.mOperators.get(i);
            if (operator.shouldCoerceToBoolean()) {
                value = Coercions.coerceToBoolean(value);
            }
            if (operator.shouldEvaluate(value)) {
                Expression expression = (Expression)this.mExpressions.get(i);
                Object nextValue = expression.evaluate(exprInfo);
                value = operator.apply(value, nextValue);
            }
            ++i;
        }
        return value;
    }
}

