/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.dnd;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.queries.api.InjectionTargetQuery;
import org.netbeans.modules.j2ee.dd.api.common.EjbLocalRef;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entres.ServiceLocatorStrategy;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

public class EjbReferenceImpl
implements Node.Cookie,
EjbReference {
    private AntArtifact precursor;
    private EntityAndSession dd;
    private boolean isSimplified;
    private static final String LOG_STATEMENT = "java.util.logging.Logger.getLogger(getClass().getName()).log(java.util.logging.Level.SEVERE,\"exception caught\" ,{0});\n";
    private static final String JNDI_LOOKUP_LOCAL = "javax.naming.Context c = new javax.naming.InitialContext();\n{1} rv = ({1}) c.lookup(\"java:comp/env/{0}\");\nreturn rv{2};\n";
    private static final String JNDI_LOOKUP_REMOTE = "javax.naming.Context c = new javax.naming.InitialContext();\nObject remote = c.lookup(\"java:comp/env/{0}\");\n{1} rv = ({1}) javax.rmi.PortableRemoteObject.narrow(remote, {1}.class);\nreturn rv{2};\n";
    private static final String JNDI_LOOKUP_REMOTE_JAVASE = "javax.naming.Context c = new javax.naming.InitialContext();\nObject remote = c.lookup(\"{0}\");\n{1} rv = ({1}) javax.rmi.PortableRemoteObject.narrow(remote, {1}.class);\nreturn rv{2};\n";
    private static final String JNDI_LOOKUP_EJB3 = "javax.naming.Context c = new javax.naming.InitialContext();\nreturn ({1}) c.lookup(\"java:comp/env/{0}\");\n";
    private static final String JNDI_LOOKUP_EJB3_JAVASE = "javax.naming.Context c = new javax.naming.InitialContext();\nreturn ({1}) c.lookup(\"{0}\");\n";

    public EjbReferenceImpl(AntArtifact precursor, EntityAndSession dd) {
        this.precursor = precursor;
        this.dd = dd;
        this.isSimplified = dd.getRoot().getVersion().doubleValue() > 2.1;
    }

    public AntArtifact getClientJarTarget() {
        return this.precursor;
    }

    public EjbRef createRef() {
        EjbRef ref = this.dd.newEjbRef();
        this.populateReference(ref);
        return ref;
    }

    public EjbLocalRef createLocalRef() {
        EjbLocalRef ref = this.dd.newEjbLocalRef();
        this.populateReference(ref);
        return ref;
    }

    public boolean supportsLocalInvocation() {
        if (this.isSimplified) {
            return this.dd.getLocal() != null;
        }
        return this.dd.getLocal() != null && this.dd.getLocalHome() != null;
    }

    public boolean supportsRemoteInvocation() {
        if (this.isSimplified) {
            return this.dd.getRemote() != null;
        }
        return this.dd.getRemote() != null && this.dd.getHome() != null;
    }

    public void populateReference(EjbRef ref) {
        ref.setEjbRefName("ejb/" + this.dd.getEjbName());
        if (this.dd instanceof Session) {
            ref.setEjbRefType("Session");
        } else {
            ref.setEjbRefType("Entity");
        }
        ref.setRemote(this.dd.getRemote());
        if (this.dd.getHome() != null) {
            ref.setHome(this.dd.getHome());
        }
        String jarName = "";
        if (this.getClientJarTarget() != null) {
            String[] names = this.getClientJarTarget().getArtifactLocations()[0].getPath().split("/");
            jarName = names[names.length - 1] + "#";
        }
        ref.setEjbLink(jarName + this.dd.getEjbName());
    }

    public void populateReference(EjbLocalRef ref) {
        ref.setEjbRefName("ejb/" + this.dd.getEjbName());
        if (this.dd instanceof Session) {
            ref.setEjbRefType("Session");
        } else {
            ref.setEjbRefType("Entity");
        }
        ref.setLocal(this.dd.getLocal());
        if (this.dd.getLocalHome() != null) {
            ref.setLocalHome(this.dd.getLocalHome());
        }
        String jarName = "";
        if (this.getClientJarTarget() != null) {
            String[] names = this.getClientJarTarget().getArtifactLocations()[0].getPath().split("/");
            jarName = names[names.length - 1] + "#";
        }
        ref.setEjbLink(jarName + this.dd.getEjbName());
    }

    public Feature generateServiceLocatorLookup(JavaClass target, EjbRef ref, String serviceLocatorName, boolean throwExceptions) {
        return this.generateServiceLocatorJNDI(target, ref.getHome(), ref.getEjbRefName(), true, ref.getRemote(), throwExceptions, serviceLocatorName);
    }

    public Feature generateServiceLocatorLookup(JavaClass target, EjbLocalRef ref, String serviceLocatorName, boolean throwExceptions) {
        return this.generateServiceLocatorJNDI(target, ref.getLocalHome(), ref.getEjbRefName(), false, ref.getLocal(), throwExceptions, serviceLocatorName);
    }

    public Feature generateReferenceCode(JavaClass target, EjbRef ref, boolean throwExceptions) {
        boolean isInjectionTarget = InjectionTargetQuery.isInjectionTarget((JavaClass)target);
        if (isInjectionTarget) {
            return this.generateInjection(target, ref.getEjbRefName(), ref.getRemote());
        }
        return this.generateJNDI(target, ref.getHome(), ref.getEjbRefName(), true, ref.getRemote(), throwExceptions);
    }

    public Feature generateReferenceCode(JavaClass target, EjbLocalRef ref, boolean throwExceptions) {
        boolean isInjectionTarget = InjectionTargetQuery.isInjectionTarget((JavaClass)target);
        if (isInjectionTarget) {
            return this.generateInjection(target, ref.getEjbRefName(), ref.getLocal());
        }
        return this.generateJNDI(target, ref.getLocalHome(), ref.getEjbRefName(), false, ref.getLocal(), throwExceptions);
    }

    private Feature generateInjection(JavaClass target, String refName, String componentName) {
        String name = refName.substring(refName.lastIndexOf(47) + 1);
        name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        int modifier = InjectionTargetQuery.isStaticReferenceRequired((JavaClass)target) ? 10 : 2;
        Field f = JMIGenerationUtil.createField((Element)target, (String)JMIUtils.uniqueMemberName((JavaClass)target, (String)name, (String)"ejb"), (int)modifier, (String)componentName);
        Annotation a = JMIGenerationUtil.createAnnotation((Element)target, (String)"javax.ejb.EJB", (List)Collections.EMPTY_LIST);
        f.getAnnotations().add(a);
        target.getContents().add(0, f);
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method generateJNDI(JavaClass target, String homeName, String refName, boolean narrow, String componentName, boolean throwCheckedExceptions) {
        boolean rollback = true;
        JMIUtils.beginJmiTransaction((boolean)true);
        try {
            JavaClass ejbClass = JMIUtils.findClass((String)this.dd.getEjbClass());
            if (ejbClass == null) {
                JavaModel.setClassPath((FileObject)this.precursor.getProject().getProjectDirectory());
                ejbClass = JMIUtils.findClass((String)this.dd.getEjbClass());
            }
            String name = "lookup" + refName.substring(refName.lastIndexOf(47) + 1);
            Method me = JMIGenerationUtil.createMethod((Element)target, (String)JMIUtils.uniqueMemberName((JavaClass)ejbClass, (String)name, (String)"ejb"), (int)2, (String)(this.isSimplified ? componentName : homeName));
            String body = null;
            ArrayList<String> exceptions = new ArrayList<String>(3);
            exceptions.add(NamingException.class.getName());
            String sessionCreate = "";
            if (this.isSession()) {
                me.setType((Type)JMIUtils.findClass((String)componentName));
                sessionCreate = ".create()";
                if (!this.isSimplified) {
                    exceptions.add("javax.ejb.CreateException");
                }
                if (narrow && !this.isSimplified) {
                    exceptions.add("java.rmi.RemoteException");
                }
            }
            boolean isTargetJavaSE = Utils.isTargetJavaSE(target);
            body = this.isSimplified && isTargetJavaSE ? MessageFormat.format(JNDI_LOOKUP_EJB3_JAVASE, ejbClass.getName(), componentName) : (this.isSimplified ? MessageFormat.format(JNDI_LOOKUP_EJB3, refName, componentName) : (isTargetJavaSE ? MessageFormat.format(JNDI_LOOKUP_REMOTE_JAVASE, homeName, homeName, sessionCreate) : (narrow ? MessageFormat.format(JNDI_LOOKUP_REMOTE, refName, homeName, sessionCreate) : MessageFormat.format(JNDI_LOOKUP_LOCAL, refName, homeName, sessionCreate))));
            if (throwCheckedExceptions) {
                me.setBodyText(body);
                JMIUtils.addExceptions((Method)me, exceptions);
            } else {
                Iterator exIt = exceptions.iterator();
                StringBuffer catchBody = new StringBuffer("try {\n" + body + "}\n");
                while (exIt.hasNext()) {
                    String exceptionName = (String)exIt.next();
                    catchBody.append("catch(");
                    catchBody.append(exceptionName);
                    catchBody.append(' ');
                    String id = this.extractAllCapitalLetters(exceptionName);
                    catchBody.append(id);
                    catchBody.append(") {\n");
                    catchBody.append(MessageFormat.format(LOG_STATEMENT, id));
                    catchBody.append("throw new RuntimeException(" + id + ");\n");
                    catchBody.append("}\n");
                }
                me.setBodyText(catchBody.toString());
            }
            target.getFeatures().add(me);
            rollback = false;
            Method method = me;
            return method;
        }
        finally {
            JMIUtils.endJmiTransaction((boolean)rollback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Feature generateServiceLocatorJNDI(JavaClass target, String homeName, String refName, boolean narrow, String componentName, boolean throwCheckedExceptions, String serviceLocatorName) {
        boolean rollback = true;
        JMIUtils.beginJmiTransaction((boolean)true);
        try {
            String name = "lookup" + refName.substring(refName.lastIndexOf(47) + 1);
            Method me = JMIGenerationUtil.createMethod((Element)target, (String)JMIUtils.uniqueMemberName((JavaClass)target, (String)name, (String)"ejb"), (int)2, (String)(this.isSimplified ? componentName : homeName));
            String body = null;
            ArrayList<String> exceptions = new ArrayList<String>(3);
            exceptions.add(NamingException.class.getName());
            boolean genCreate = this.isSession();
            if (genCreate) {
                me.setType((Type)JMIUtils.findClass((String)componentName));
                exceptions.add("javax.ejb.CreateException");
                if (narrow) {
                    exceptions.add("java.rmi.RemoteException");
                }
            }
            FileObject srcFile = JavaModel.getFileObject((Resource)target.getResource());
            Project enterpriseProject = FileOwnerQuery.getOwner((FileObject)srcFile);
            ServiceLocatorStrategy sls = ServiceLocatorStrategy.create(enterpriseProject, srcFile, serviceLocatorName);
            body = narrow ? sls.genRemoteEjbStringLookup(refName, homeName, target, genCreate) : sls.genLocalEjbStringLookup(refName, homeName, target, genCreate);
            if (throwCheckedExceptions) {
                me.setBodyText(body);
                JMIUtils.addExceptions((Method)me, exceptions);
            } else {
                Iterator exIt = exceptions.iterator();
                StringBuffer catchBody = new StringBuffer("try {\n" + body + "\n}");
                while (exIt.hasNext()) {
                    String exceptionName = (String)exIt.next();
                    catchBody.append(" catch(");
                    catchBody.append(exceptionName);
                    catchBody.append(' ');
                    String id = this.extractAllCapitalLetters(exceptionName);
                    catchBody.append(id);
                    catchBody.append(") {\n");
                    catchBody.append(MessageFormat.format(LOG_STATEMENT, id));
                    catchBody.append("throw new RuntimeException(" + id + ");\n");
                    catchBody.append("}");
                }
                me.setBodyText(catchBody.toString());
            }
            target.getFeatures().add(me);
            rollback = false;
            Method method = me;
            return method;
        }
        finally {
            JMIUtils.endJmiTransaction((boolean)rollback);
        }
    }

    private String extractAllCapitalLetters(String word) {
        StringBuffer caps = new StringBuffer(4);
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            caps.append(Character.toLowerCase(c));
        }
        return caps.toString();
    }

    private boolean isSession() {
        return this.dd instanceof Session;
    }
}

