/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.api.codegeneration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.jmi.reflect.JmiException;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestination;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.ActivationConfig;
import org.netbeans.modules.j2ee.dd.api.ejb.ActivationConfigProperty;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.ContainerTransaction;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.Method;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.api.codegeneration.EjbGenerationUtil;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.gen.Bean;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb.MessageEJBWizardPanel;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public class MessageGenerator {
    private EjbGenerationUtil genUtil = new EjbGenerationUtil();
    private static final String MESSAGE_TEMPLATE = "/org/netbeans/modules/j2ee/ejbcore/ejb/wizard/xsl/MessageBean.xml";

    public FileObject generate(String ejbName, FileObject pkg, MessageEJBWizardPanel wizardPanel, Project project) throws IOException, VersionNotSupportedException {
        boolean ejb30 = false;
        try {
            EjbJar ejbModule = EjbJar.getEjbJar((FileObject)pkg);
            ejb30 = "3.0".equals(DDProvider.getDefault().getMergedDDRoot(ejbModule.getMetadataUnit()).getVersion().toString());
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        if (ejb30) {
            return this.generateEjb3(ejbName, pkg, wizardPanel.isQueue(), project);
        }
        return this.generateEjb21(ejbName, pkg, wizardPanel.isQueue(), project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject generateEjb21(String ejbName, FileObject pkg, boolean isQueue, Project project) throws IOException, VersionNotSupportedException {
        EjbJar ejbModule = EjbJar.getEjbJar((FileObject)pkg);
        org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar = DDProvider.getDefault().getMergedDDRoot(ejbModule.getMetadataUnit());
        ejbName = EjbGenerationUtil.uniqueSingleEjbName(ejbName, ejbJar);
        String pkgName = EjbGenerationUtil.getSelectedPackageName(pkg, project);
        Bean b = this.genUtil.getDefaultBean();
        b.setCommentDataEjbName(ejbName + "Bean");
        b.setClassname(true);
        b.setClassnameName(EjbGenerationUtil.getBeanClassName(ejbName));
        if (pkgName != null) {
            b.setClassnamePackage(pkgName);
        }
        String beanClass = this.genUtil.generateBeanClass(MESSAGE_TEMPLATE, b, pkgName, pkg);
        J2eeModuleProvider pwm = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        pwm.getConfigSupport().ensureConfigurationReady();
        EnterpriseBeans beans = ejbJar.getEnterpriseBeans();
        MessageDriven mb = null;
        if (beans == null) {
            beans = ejbJar.newEnterpriseBeans();
            ejbJar.setEnterpriseBeans(beans);
        }
        mb = beans.newMessageDriven();
        ActivationConfig config = mb.newActivationConfig();
        ActivationConfigProperty destProp = config.newActivationConfigProperty();
        destProp.setActivationConfigPropertyName("destinationType");
        ActivationConfigProperty ackProp = config.newActivationConfigProperty();
        ackProp.setActivationConfigPropertyName("acknowledgeMode");
        ackProp.setActivationConfigPropertyValue("Auto-acknowledge");
        config.addActivationConfigProperty(ackProp);
        if (isQueue) {
            String queue = "javax.jms.Queue";
            mb.setMessageDestinationType(queue);
            destProp.setActivationConfigPropertyValue(queue);
        } else {
            String topic = "javax.jms.Topic";
            mb.setMessageDestinationType(topic);
            destProp.setActivationConfigPropertyValue(topic);
            ActivationConfigProperty durabilityProp = config.newActivationConfigProperty();
            durabilityProp.setActivationConfigPropertyName("subscriptionDurability");
            durabilityProp.setActivationConfigPropertyValue("Durable");
            config.addActivationConfigProperty(durabilityProp);
            ActivationConfigProperty clientIdProp = config.newActivationConfigProperty();
            clientIdProp.setActivationConfigPropertyName("clientId");
            clientIdProp.setActivationConfigPropertyValue(ejbName + "Bean");
            config.addActivationConfigProperty(clientIdProp);
            ActivationConfigProperty subscriptionNameProp = config.newActivationConfigProperty();
            subscriptionNameProp.setActivationConfigPropertyName("subscriptionName");
            subscriptionNameProp.setActivationConfigPropertyValue(ejbName + "Bean");
            config.addActivationConfigProperty(subscriptionNameProp);
        }
        config.addActivationConfigProperty(destProp);
        mb.setActivationConfig(config);
        mb.setEjbName(ejbName + "Bean");
        mb.setDisplayName(ejbName + "MDB");
        mb.setEjbClass(beanClass);
        mb.setTransactionType("Container");
        beans.addMessageDriven(mb);
        AssemblyDescriptor ad = ejbJar.getSingleAssemblyDescriptor();
        if (ad == null) {
            ad = ejbJar.newAssemblyDescriptor();
            ejbJar.setAssemblyDescriptor(ad);
        }
        MessageDestination md = ad.newMessageDestination();
        String ejbNameBase = EjbGenerationUtil.getEjbNameBase(mb.getEjbName());
        String destinationLink = ejbNameBase + "Destination";
        md.setDisplayName("Destination for " + ejbNameBase);
        md.setMessageDestinationName(destinationLink);
        ad.addMessageDestination(md);
        mb.setMessageDestinationLink(destinationLink);
        ContainerTransaction ct = ad.newContainerTransaction();
        ct.setTransAttribute("Required");
        Method m = ct.newMethod();
        m.setEjbName(ejbName + "Bean");
        m.setMethodName("*");
        ct.addMethod(m);
        ad.addContainerTransaction(ct);
        ejbJar.write(ejbModule.getDeploymentDescriptor());
        pwm.getConfigSupport().ensureResourceDefinedForEjb(ejbName + "Bean", "message-driven");
        FileObject beanFO = pkg.getFileObject(EjbGenerationUtil.getBaseName(mb.getEjbClass()), "java");
        boolean rollback = true;
        JMIUtils.beginJmiTransaction((boolean)true);
        try {
            JavaMetamodel.getManager().setClassPath(beanFO);
            JMIUtils.fixImports((String)mb.getEjbClass());
            rollback = false;
        }
        finally {
            JMIUtils.endJmiTransaction((boolean)rollback);
        }
        JMIUtils.saveClass((String)mb.getEjbClass(), (FileObject)beanFO);
        return beanFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject generateEjb3(String name, FileObject pkg, boolean isQueue, Project project) {
        JavaClass javaClass = null;
        boolean rollback = true;
        JMIUtils.beginJmiTransaction((boolean)true);
        try {
            javaClass = JMIGenerationUtil.createEntityClass((FileObject)pkg, (String)name);
            JMIGenerationUtil.addInterface((JavaClass)javaClass, (String)"javax.jms.MessageListener");
            AttributeValue mappedNameAttibuteValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"mappedName", (String)("jms/" + name));
            ArrayList<Annotation> activationConfigSubAnnotations = new ArrayList<Annotation>();
            AttributeValue[] attributes = new AttributeValue[]{JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"propertyName", (String)"acknowledgeMode"), JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"propertyValue", (String)"Auto-acknowledge")};
            activationConfigSubAnnotations.add(JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.ejb.ActivationConfigProperty", Arrays.asList(attributes)));
            if (isQueue) {
                attributes = new AttributeValue[]{JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"propertyName", (String)"destinationType"), JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"propertyValue", (String)"javax.jms.Queue")};
                activationConfigSubAnnotations.add(JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.ejb.ActivationConfigProperty", Arrays.asList(attributes)));
            } else {
                attributes = new AttributeValue[]{JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"propertyName", (String)"destinationType"), JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"propertyValue", (String)"javax.jms.Topic")};
                activationConfigSubAnnotations.add(JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.ejb.ActivationConfigProperty", Arrays.asList(attributes)));
                attributes = new AttributeValue[]{JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"propertyName", (String)"subscriptionDurability"), JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"propertyValue", (String)"Durable")};
                activationConfigSubAnnotations.add(JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.ejb.ActivationConfigProperty", Arrays.asList(attributes)));
                attributes = new AttributeValue[]{JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"propertyName", (String)"clientId"), JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"propertyValue", (String)name)};
                activationConfigSubAnnotations.add(JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.ejb.ActivationConfigProperty", Arrays.asList(attributes)));
                attributes = new AttributeValue[]{JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"propertyName", (String)"subscriptionName"), JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"propertyValue", (String)name)};
                activationConfigSubAnnotations.add(JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.ejb.ActivationConfigProperty", Arrays.asList(attributes)));
            }
            AttributeValue activationConfigAttributeValue = JMIGenerationUtil.createAttributeValue((Element)javaClass, (String)"activationConfig", activationConfigSubAnnotations);
            ArrayList<AttributeValue> messageDrivenAttributes = new ArrayList<AttributeValue>(2);
            messageDrivenAttributes.add(mappedNameAttibuteValue);
            messageDrivenAttributes.add(activationConfigAttributeValue);
            Annotation messageDrivenAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, (String)"javax.ejb.MessageDriven", messageDrivenAttributes);
            javaClass.getAnnotations().add(messageDrivenAnnotation);
            org.netbeans.jmi.javamodel.Method onMessageMethod = JMIGenerationUtil.createMethod((Element)javaClass, (String)"onMessage", (int)1, (String)"void");
            Parameter messageParameter = JMIGenerationUtil.createParameter((Element)javaClass, (String)"message", (String)"javax.jms.Message");
            onMessageMethod.getParameters().add(messageParameter);
            javaClass.getFeatures().add(onMessageMethod);
            rollback = false;
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
        }
        catch (JmiException jmie) {
            ErrorManager.getDefault().notify((Throwable)jmie);
        }
        finally {
            JMIUtils.endJmiTransaction((boolean)rollback);
        }
        if (!rollback) {
            final J2eeModuleProvider pwm = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            final String ejbName = name;
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    if (pwm != null) {
                        pwm.getConfigSupport().ensureResourceDefinedForEjb(ejbName, "message-driven");
                    }
                }
            }, 2000);
        }
        return javaClass == null ? null : JavaModel.getFileObject((Resource)javaClass.getResource());
    }
}

