/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.clazz;

import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.clazz.ClassDataObject;
import org.netbeans.modules.clazz.ClassElementImpl;
import org.netbeans.modules.clazz.MemberElementImpl;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.ElementProperties;
import org.openide.src.Identifier;
import org.openide.src.Import;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.util.Task;
import org.openide.util.TaskListener;

final class SourceElementImpl
extends MemberElementImpl
implements SourceElement.Impl,
ElementProperties,
TaskListener {
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap(0));
    static final Import[] EMPTY_IMPORTS = new Import[0];
    static final ClassElement[] NO_CLASSES = new ClassElement[0];
    private SoftReference topClass;
    private SoftReference allClasses;
    private Identifier packg;
    private ClassDataObject cdo;
    private ClassLoader loader;
    Task loadingTask;
    int status = -1;
    private transient boolean attached;
    private boolean isEmpty = false;
    private ClassPath classPath = null;
    static final long serialVersionUID = -4870331896218546842L;

    SourceElementImpl(ClassDataObject cdo) {
        this(null, cdo);
    }

    public SourceElementImpl(Resource res, ClassDataObject cdo) {
        super(res);
        this.cdo = cdo;
        FileObject fo = cdo.getPrimaryFile();
        this.classPath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/execute");
    }

    public void attachedToElement(Element element) {
        super.attachedToElement(element);
        this.initializeData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeData() {
        JavaMetamodel model = JavaMetamodel.getManager();
        FileObject fo = this.cdo.getPrimaryFile();
        JavaMetamodel.getManager();
        MDRepository repo = JavaMetamodel.getDefaultRepository();
        repo.beginTrans(false);
        try {
            Resource resource = model.getResource(fo);
            if (resource == null || !resource.isValid()) {
                return;
            }
            this.data = resource;
            this.getPackage();
            ClassElement elem = this.getClassElement();
            if (elem != null) {
                ClassElementImpl impl = (ClassElementImpl)elem.getCookie(Element.Impl.class);
                impl.initializeData();
            }
        }
        finally {
            repo.endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshData() {
        boolean fireChange = false;
        JavaMetamodel.getManager();
        MDRepository repo = JavaMetamodel.getDefaultRepository();
        repo.beginTrans(false);
        try {
            Object oldData = this.data;
            FileObject fo = this.cdo.getPrimaryFile();
            this.data = JavaMetamodel.getManager().getResource(fo);
            if (this.data != null && ((Resource)this.data).isValid()) {
                ClassElementImpl impl;
                this.topClass = null;
                this.allClasses = null;
                fireChange = true;
                ClassElement cls = this.getClassElement();
                if (cls != null && (impl = (ClassElementImpl)cls.getCookie(Element.Impl.class)) != null) {
                    impl.refreshData();
                }
            }
        }
        finally {
            repo.endTrans();
        }
        if (fireChange) {
            this.firePropertyChange("classes", null, null);
            this.firePropertyChange("allClasses", null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResource(Resource data) {
        int newStatus;
        int oldStatus;
        SourceElementImpl sourceElementImpl = this;
        synchronized (sourceElementImpl) {
            oldStatus = this.getStatus();
            this.data = data;
            this.topClass = null;
            this.allClasses = null;
            newStatus = this.getStatus();
            this.loadingTask = null;
        }
        this.initializeData();
        if (oldStatus != 0) {
            this.firePropertyChange("classes", null, null);
            this.firePropertyChange("allClasses", null, null);
        }
        this.firePropertyChange("status", new Integer(oldStatus), new Integer(newStatus));
    }

    public void setPackage(Identifier id) throws SourceException {
        this.throwReadOnlyException();
    }

    Resource getResource() {
        this.checkData();
        return (Resource)this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identifier getPackage() {
        if (this.packg != null) {
            return this.packg;
        }
        JavaMetamodel.getManager();
        MDRepository repo = JavaMetamodel.getDefaultRepository();
        repo.beginTrans(false);
        try {
            if (this.getResource() == null || !this.isValid()) {
                Identifier identifier = null;
                return identifier;
            }
            JavaPackage p = (JavaPackage)this.getResource().refImmediateComposite();
            if (p == null) {
                Identifier identifier = null;
                return identifier;
            }
            Identifier identifier = this.packg = Identifier.create((String)p.getName());
            return identifier;
        }
        finally {
            repo.endTrans();
        }
    }

    public Import[] getImports() {
        return EMPTY_IMPORTS;
    }

    public void changeImports(Import[] elems, int action) throws SourceException {
        this.throwReadOnlyException();
    }

    public void changeClasses(ClassElement[] elems, int action) throws SourceException {
        this.throwReadOnlyException();
    }

    public ClassElement[] getClasses() {
        this.checkData();
        if (this.data == null) {
            return NO_CLASSES;
        }
        ClassElement clsElem = this.getClassElement();
        if (clsElem == null) {
            return NO_CLASSES;
        }
        return new ClassElement[]{clsElem};
    }

    public ClassElement getClass(Identifier name) {
        ClassElement el = this.getClassElement();
        if (el != null) {
            String srcName = name.getSourceName();
            String fullName = name.getFullName();
            Identifier idEl = el.getName();
            String srcEl = idEl.getSourceName();
            String fullEl = idEl.getFullName();
            if (srcEl.equals(srcName)) {
                if (srcName.equals(fullName) || fullEl.equals(fullName)) {
                    return el;
                }
                return null;
            }
            if (fullEl.equals(fullName)) {
                return el;
            }
        }
        return null;
    }

    public ClassElement[] getAllClasses() {
        if (this.isEmpty) {
            return new ClassElement[0];
        }
        return this.getAllClassesMap().values().toArray(new ClassElement[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStatus() {
        int s;
        if (this.status != -1) {
            return this.status;
        }
        if (this.data != null) {
            s = 3;
        } else {
            Task t = this.prepare();
            if (t.isFinished()) {
                this.checkData();
                s = this.data == null ? 1 : 3;
            } else {
                SourceElementImpl sourceElementImpl = this;
                synchronized (sourceElementImpl) {
                    if (!this.attached) {
                        this.attached = true;
                        t.addTaskListener((TaskListener)this);
                    }
                }
                s = 0;
            }
        }
        this.setStatus(s);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStatus(int newStatus) {
        int old;
        SourceElementImpl sourceElementImpl = this;
        synchronized (sourceElementImpl) {
            if (this.status == newStatus) {
                return;
            }
            old = this.status;
            this.status = newStatus;
        }
        if (old != -1) {
            this.firePropertyChange("status", new Integer(old), new Integer(newStatus));
        }
    }

    void checkData() {
        if (this.data == null) {
            FileObject fo = this.cdo.getPrimaryFile();
            this.data = JavaMetamodel.getManager().getResource(fo);
        }
    }

    public Task prepare() {
        return Task.EMPTY;
    }

    public boolean isReadOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassElement getClassElement() {
        ClassElement result;
        if (this.isEmpty) {
            return null;
        }
        ClassElement classElement = result = this.topClass == null ? null : (ClassElement)this.topClass.get();
        if (result == null) {
            JavaMetamodel.getManager();
            MDRepository repo = JavaMetamodel.getDefaultRepository();
            repo.beginTrans(false);
            try {
                if (!this.isValid()) {
                    ClassElement classElement2 = null;
                    return classElement2;
                }
                if (this.getResource() == null) {
                    ClassElement classElement3 = null;
                    return classElement3;
                }
                JavaClass[] c = this.getResource().getClassifiers().toArray(new JavaClass[0]);
                if (c.length != 1) {
                    ClassElement classElement4 = null;
                    return classElement4;
                }
                result = new ClassElement((ClassElement.Impl)new ClassElementImpl(c[0]), (SourceElement)this.element);
                this.topClass = new SoftReference<ClassElement>(result);
            }
            finally {
                repo.endTrans();
            }
        }
        return result;
    }

    private Map getAllClassesMap() {
        Map allClassesMap;
        Map map = allClassesMap = this.allClasses == null ? null : (Map)this.allClasses.get();
        if (allClassesMap == null) {
            this.checkData();
            if (this.data != null) {
                allClassesMap = this.createClassesMap();
                this.allClasses = new SoftReference<Map>(allClassesMap);
            } else {
                return EMPTY_MAP;
            }
        }
        return allClassesMap;
    }

    private Map createClassesMap() {
        HashMap result = new HashMap(15);
        ClassElement clsElem = this.getClassElement();
        if (clsElem != null) {
            this.addClassElement(result, clsElem);
        }
        return result;
    }

    private void addClassElement(Map map, ClassElement outer) {
        map.put(outer.getName(), outer);
        ClassElement[] inners = null;
        try {
            inners = outer.getClasses();
        }
        catch (Throwable exc) {
            if (exc instanceof ThreadDeath) {
                throw (ThreadDeath)exc;
            }
            return;
        }
        for (int i = 0; i < inners.length; ++i) {
            this.addClassElement(map, inners[i]);
        }
    }

    public void runAtomic(Runnable run) {
        run.run();
    }

    public void runAtomicAsUser(Runnable run) {
        run.run();
    }

    public Node.Cookie getCookie(Class type) {
        if (type.equals(DataObject.class) || type.equals(MultiDataObject.class) || ClassDataObject.class.isAssignableFrom(type)) {
            return this.cdo;
        }
        if (type == SourceElement.Impl.class || type == Element.Impl.class) {
            return this;
        }
        return null;
    }

    public Object readResolve() {
        return new SourceElement((SourceElement.Impl)this);
    }

    public void run() {
        if (this.cdo == null) {
            throw new IllegalStateException("Cannot load classfile without the DataObject");
        }
        this.setResource(null);
    }

    public void taskFinished(Task task) {
        this.checkData();
        this.attached = false;
        task.removeTaskListener((TaskListener)this);
        this.setStatus(this.data == null ? 1 : 3);
    }
}

