/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.generator;

import java.util.Iterator;
import org.netbeans.modules.xml.tools.generator.ElementBindings;
import org.netbeans.modules.xml.tools.generator.ParsletBindings;
import org.netbeans.modules.xml.tools.generator.SAXGeneratorModel;

final class SAXBindingsGenerator {
    SAXBindingsGenerator() {
    }

    public static String toXML(SAXGeneratorModel model) {
        StringBuffer s = new StringBuffer();
        s.append("<?xml version='1.0' encoding='UTF-8'?>\n");
        s.append("<!DOCTYPE SAX-bindings PUBLIC \"-//XML Module//DTD SAX Bindings 1.0//EN\" \"\">\n");
        s.append("<SAX-bindings version='1'>\n");
        s.append(SAXBindingsGenerator.elementBindings(model));
        s.append(SAXBindingsGenerator.parsletBindings(model));
        s.append("</SAX-bindings>");
        return s.toString();
    }

    private static String elementBindings(SAXGeneratorModel model) {
        StringBuffer s = new StringBuffer();
        Iterator it = model.getElementBindings().values().iterator();
        while (it.hasNext()) {
            ElementBindings.Entry next = (ElementBindings.Entry)it.next();
            s.append("\t<bind element='" + next.getElement() + "' method='" + next.getMethod() + "' ");
            s.append("type='" + next.getType() + "' ");
            if (next.getParslet() != null) {
                s.append("parslet='" + next.getParslet() + "' ");
            }
            s.append("></bind>\n");
        }
        return s.toString();
    }

    private static String parsletBindings(SAXGeneratorModel model) {
        StringBuffer s = new StringBuffer();
        Iterator it = model.getParsletBindings().values().iterator();
        while (it.hasNext()) {
            ParsletBindings.Entry next = (ParsletBindings.Entry)it.next();
            s.append("\t<parslet parslet='" + next.getId() + "' return='" + next.getType() + "' />\n");
        }
        return s.toString();
    }
}

